/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.config.classpath;

import java.io.File;
import java.io.IOException;
import javax.swing.tree.DefaultTreeModel;
import org.gjt.jclasslib.browser.config.classpath.ClassTreeNode;
import org.gjt.jclasslib.browser.config.classpath.ClasspathChangeListener;
import org.gjt.jclasslib.browser.config.classpath.ClasspathComponent;

public abstract class ClasspathEntry
implements ClasspathComponent {
    protected static final String CLASSFILE_SUFFIX = ".class";
    private String fileName;
    private File file;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
        this.file = new File(string);
        try {
            this.file = this.file.getCanonicalFile();
        }
        catch (IOException iOException) {
            this.file = null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        return this.fileName.equals(((ClasspathEntry)object).fileName);
    }

    public int hashCode() {
        return this.fileName.hashCode();
    }

    public void addClasspathChangeListener(ClasspathChangeListener classpathChangeListener) {
    }

    public void removeClasspathChangeListener(ClasspathChangeListener classpathChangeListener) {
    }

    protected File getFile() {
        return this.file;
    }

    protected ClassTreeNode addOrFindNode(String string, ClassTreeNode classTreeNode, boolean bl, DefaultTreeModel defaultTreeModel, boolean bl2) {
        int n = classTreeNode.getChildCount();
        ClassTreeNode classTreeNode2 = new ClassTreeNode(string, bl);
        int n2 = 0;
        while (n2 < n) {
            ClassTreeNode classTreeNode3 = (ClassTreeNode)classTreeNode.getChildAt(n2);
            String string2 = classTreeNode3.toString();
            if (classTreeNode3.getChildCount() <= 0 || bl) {
                if (classTreeNode3.getChildCount() == 0 && bl) {
                    this.insertNode(classTreeNode2, classTreeNode, n2, defaultTreeModel, bl2);
                    return classTreeNode2;
                }
                if (string.equals(string2)) {
                    return classTreeNode3;
                }
                if (string.compareTo(string2) < 0) {
                    this.insertNode(classTreeNode2, classTreeNode, n2, defaultTreeModel, bl2);
                    return classTreeNode2;
                }
            }
            ++n2;
        }
        this.insertNode(classTreeNode2, classTreeNode, n, defaultTreeModel, bl2);
        return classTreeNode2;
    }

    protected String stripClassSuffix(String string) {
        return string.substring(0, string.length() - CLASSFILE_SUFFIX.length());
    }

    private void insertNode(ClassTreeNode classTreeNode, ClassTreeNode classTreeNode2, int n, DefaultTreeModel defaultTreeModel, boolean bl) {
        classTreeNode2.insert(classTreeNode, n);
        if (!bl) {
            defaultTreeModel.nodesWereInserted(classTreeNode2, new int[]{n});
        }
    }
}

