#ifndef __LYXCODECONV_H__
#define __LYXCODECONV_H__
#ifdef I18N
#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xlocale.h>
#include <X11/Xutil.h>

#include <fstream>
#include <iomanip>
using std::ofstream;
using std::ifstream;
using std::fstream;
using std::ios;
using std::setw;

#include "support/lyxstring.h"
#include "LString.h"

class LyXCodeConv
{
  public:
//    wchar_t * lyxmbstowcs(char const *cs,int n);
    size_t lyxmbstowcs(wchar_t *wcs, const char *cs, size_t n);
    size_t lyxmbstowcs(wchar_t *wcs, string const *cs);
//    wchar_t * lyxmbstowcs(LString const *cs);
    int lyxwclen(wchar_t const * wcs);
//    char * lyxwcstombs(wchar_t const *ws);
    size_t lyxwcstombs(char *cs, const wchar_t *wcs, size_t n);
//    char * lyxwcstombs(wchar_t const *ws,int);
    size_t lyxwctomb(char *cs, wchar_t wc);
    void lyxos(ostream & os, wchar_t);
    void lyxofs(ofstream & ofs, wchar_t);
    void lyxprintf (FILE *, wchar_t);
    bool lyxIsLineSeparatorChar(wchar_t c);
    
};

inline bool LyXCodeConv::lyxIsLineSeparatorChar(wchar_t c)
{
        /* How about (c > 0xa258) for BIG5, and
           (c > 0xff && c < 0xa1a1) || (c > 0xa1fe) for WanSung?*/
    if ((unsigned long)c > 0x00ff)	/* Japanese EUC */
        return True;
    else
        return 0;
}

#endif    
#endif










