/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.TransformerFactoryImpl;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.tree.AttributeCollection;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.TransformerHandler;

abstract class XSLGeneralOutput
extends StyleElement {
    Expression href = null;
    Expression userData = null;
    Expression method = null;
    Expression version = null;
    Expression indent = null;
    Expression encoding = null;
    Expression mediaType = null;
    Expression doctypeSystem = null;
    Expression doctypePublic = null;
    Expression omitDeclaration = null;
    Expression standalone = null;
    Expression cdataElements = null;
    Expression omitMetaTag = null;
    Expression nextInChain = null;
    Expression representation = null;
    Expression indentSpaces = null;
    Hashtable userAttributes = null;
    Emitter handler = null;

    XSLGeneralOutput() {
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.HREF) {
                this.href = this.makeAttributeValueTemplate(attributeCollection.getValue(n));
            } else if (n3 == standardNames.METHOD) {
                this.method = this.makeAttributeValueTemplate(attributeCollection.getValue(n));
            } else if (n3 == standardNames.VERSION) {
                this.version = this.makeAttributeValueTemplate(attributeCollection.getValue(n));
            } else if (n3 == standardNames.ENCODING) {
                this.encoding = this.makeAttributeValueTemplate(attributeCollection.getValue(n));
            } else if (n3 == standardNames.OMIT_XML_DECLARATION) {
                this.omitDeclaration = this.makeAttributeValueTemplate(attributeCollection.getValue(n));
            } else if (n3 == standardNames.STANDALONE) {
                this.standalone = this.makeAttributeValueTemplate(attributeCollection.getValue(n));
            } else if (n3 == standardNames.DOCTYPE_PUBLIC) {
                this.doctypePublic = this.makeAttributeValueTemplate(attributeCollection.getValue(n));
            } else if (n3 == standardNames.DOCTYPE_SYSTEM) {
                this.doctypeSystem = this.makeAttributeValueTemplate(attributeCollection.getValue(n));
            } else if (n3 == standardNames.CDATA_SECTION_ELEMENTS) {
                this.cdataElements = this.makeAttributeValueTemplate(attributeCollection.getValue(n));
            } else if (n3 == standardNames.INDENT) {
                this.indent = this.makeAttributeValueTemplate(attributeCollection.getValue(n));
            } else if (n3 == standardNames.MEDIA_TYPE) {
                this.mediaType = this.makeAttributeValueTemplate(attributeCollection.getValue(n));
            } else if (n3 == standardNames.SAXON_OMIT_META_TAG) {
                this.omitMetaTag = this.makeAttributeValueTemplate(attributeCollection.getValue(n));
            } else if (n3 == standardNames.SAXON_CHARACTER_REPRESENTATION) {
                this.representation = this.makeAttributeValueTemplate(attributeCollection.getValue(n));
            } else if (n3 == standardNames.SAXON_INDENT_SPACES) {
                this.indentSpaces = this.makeAttributeValueTemplate(attributeCollection.getValue(n));
            } else if (n3 == standardNames.SAXON_NEXT_IN_CHAIN) {
                this.nextInChain = this.makeAttributeValueTemplate(attributeCollection.getValue(n));
            } else {
                String string = this.getNamePool().getURI(n2);
                if ("".equals(string) || "http://www.w3.org/1999/XSL/Transform".equals(string) || "http://icl.com/saxon".equals(string)) {
                    this.checkUnknownAttribute(n2);
                } else {
                    String string2 = "{" + string + "}" + attributeCollection.getLocalName(n);
                    Expression expression = this.makeAttributeValueTemplate(attributeCollection.getValue(n));
                    if (this.userAttributes == null) {
                        this.userAttributes = new Hashtable(5);
                    }
                    this.userAttributes.put(string2, expression);
                }
            }
            ++n;
        }
    }

    protected Properties updateOutputProperties(Properties properties, Context context) throws TransformerException {
        Object object;
        int n;
        Object object2;
        Object object3;
        if (this.method != null) {
            object3 = this.method.evaluateAsString(context);
            if (((String)object3).equals("xml") || ((String)object3).equals("html") || ((String)object3).equals("text")) {
                ((Hashtable)properties).put("method", object3);
            } else {
                object2 = this.getNamePool();
                try {
                    n = this.makeNameCode((String)object3, false);
                }
                catch (NamespaceException namespaceException) {
                    throw this.styleError(namespaceException.getMessage());
                }
                if (((NamePool)object2).getURICode(n) == 0) {
                    throw this.styleError("method must be xml, html, or text, or a prefixed name");
                }
                ((Hashtable)properties).put("method", "{" + ((NamePool)object2).getURI(n) + "}" + ((NamePool)object2).getLocalName(n));
            }
        }
        if (this.version != null) {
            object3 = this.version.evaluateAsString(context);
            ((Hashtable)properties).put("version", object3);
        }
        if (this.indent != null) {
            object3 = this.indent.evaluateAsString(context);
            if (object3 == null || ((String)object3).equals("yes") || ((String)object3).equals("no")) {
                ((Hashtable)properties).put("indent", object3);
            } else {
                throw this.styleError("indent must be yes or no or an integer");
            }
        }
        if (this.indentSpaces != null) {
            object3 = this.indentSpaces.evaluateAsString(context);
            try {
                n = Integer.parseInt((String)object3);
                ((Hashtable)properties).put("indent", "yes");
                ((Hashtable)properties).put("{http://icl.com/saxon}indent-spaces", object3);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.styleError("indent-spaces must be an integer");
            }
        }
        if (this.encoding != null) {
            object3 = this.encoding.evaluateAsString(context);
            ((Hashtable)properties).put("encoding", object3);
        }
        if (this.mediaType != null) {
            object3 = this.mediaType.evaluateAsString(context);
            ((Hashtable)properties).put("media-type", object3);
        }
        if (this.doctypeSystem != null) {
            object3 = this.doctypeSystem.evaluateAsString(context);
            ((Hashtable)properties).put("doctype-system", object3);
        }
        if (this.doctypePublic != null) {
            object3 = this.doctypePublic.evaluateAsString(context);
            ((Hashtable)properties).put("doctype-public", object3);
        }
        if (this.omitDeclaration != null) {
            object3 = this.omitDeclaration.evaluateAsString(context);
            if (((String)object3).equals("yes") || ((String)object3).equals("no")) {
                ((Hashtable)properties).put("omit-xml-declaration", object3);
            } else {
                throw this.styleError("omit-xml-declaration attribute must be yes or no");
            }
        }
        if (this.standalone != null) {
            object3 = this.standalone.evaluateAsString(context);
            if (((String)object3).equals("yes") || ((String)object3).equals("no")) {
                ((Hashtable)properties).put("standalone", object3);
            } else {
                throw this.styleError("standalone attribute must be yes or no");
            }
        }
        if (this.cdataElements != null) {
            object3 = this.cdataElements.evaluateAsString(context);
            String string = properties.getProperty("cdata-section-elements");
            object2 = " ";
            object = new StringTokenizer((String)object3);
            NamePool namePool = context.getController().getNamePool();
            while (((StringTokenizer)object).hasMoreTokens()) {
                int n2;
                String string2 = ((StringTokenizer)object).nextToken();
                if (!Name.isQName(string2)) {
                    throw this.styleError("CDATA element " + string2 + " is not a valid QName");
                }
                try {
                    n2 = this.makeNameCode(string2, true);
                }
                catch (NamespaceException namespaceException) {
                    throw this.styleError(namespaceException.getMessage());
                }
                object2 = (String)object2 + " {" + namePool.getURI(n2) + '}' + namePool.getLocalName(n2);
                ((Hashtable)properties).put("cdata-section-elements", string + (String)object2);
            }
        }
        if (this.representation != null) {
            object3 = this.representation.evaluateAsString(context);
            ((Hashtable)properties).put("{http://icl.com/saxon}character-representation", object3);
        }
        if (this.omitMetaTag != null) {
            object3 = this.omitMetaTag.evaluateAsString(context);
            if (((String)object3).equals("yes") || ((String)object3).equals("no")) {
                ((Hashtable)properties).put("{http://icl.com/saxon}omit-meta-tag", object3);
            } else {
                throw this.styleError("saxon:omit-meta-tag attribute must be yes or no");
            }
        }
        if (this.nextInChain != null) {
            object3 = this.nextInChain.evaluateAsString(context);
            ((Hashtable)properties).put("{http://icl.com/saxon}next-in-chain", object3);
            ((Hashtable)properties).put("{http://icl.com/saxon}next-in-chain-base-uri", this.getSystemId());
        }
        if (this.userAttributes != null) {
            object3 = this.userAttributes.keys();
            while (object3.hasMoreElements()) {
                String string = (String)object3.nextElement();
                object2 = (Expression)this.userAttributes.get(string);
                object = ((Expression)object2).evaluateAsString(context);
                ((Hashtable)properties).put(string, object);
            }
        }
        return properties;
    }

    protected TransformerHandler prepareNextStylesheet(String string, Context context) throws TransformerException {
        TransformerFactoryImpl transformerFactoryImpl = this.getPreparedStyleSheet().getTransformerFactory();
        URIResolver uRIResolver = context.getController().getURIResolver();
        Source source = uRIResolver.resolve(string, this.getSystemId());
        SAXSource sAXSource = transformerFactoryImpl.getSAXSource(source, true);
        Templates templates = transformerFactoryImpl.newTemplates(source);
        TransformerHandler transformerHandler = transformerFactoryImpl.newTransformerHandler(templates);
        return transformerHandler;
    }
}

