/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.swing.autospell;

import com.swabunga.spell.engine.Configuration;
import com.swabunga.spell.engine.Word;
import com.swabunga.spell.event.DocumentWordTokenizer;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.swing.autospell.AutoSpellConstants;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;

public class AutoSpellCheckHandler
extends MouseAdapter
implements DocumentListener,
AutoSpellConstants {
    private SpellChecker sCheck = null;
    private Configuration config = Configuration.getConfiguration();
    private ResourceBundle messages = null;

    public AutoSpellCheckHandler(SpellChecker spellChecker) {
        this.sCheck = spellChecker;
    }

    public AutoSpellCheckHandler(SpellChecker spellChecker, ResourceBundle resourceBundle) {
        this(spellChecker);
        this.messages = resourceBundle;
    }

    public void addJEditorPane(JEditorPane jEditorPane) {
        StyledDocument styledDocument = (StyledDocument)jEditorPane.getDocument();
        this.markupSpelling(styledDocument, 0, styledDocument.getLength() - 1);
        styledDocument.addDocumentListener(this);
        jEditorPane.addMouseListener(this);
    }

    public void removeJEditorPane(JEditorPane jEditorPane) {
        Document document = jEditorPane.getDocument();
        jEditorPane.removeMouseListener(this);
        document.removeDocumentListener(this);
    }

    private void markupSpelling(StyledDocument styledDocument, int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        Segment segment = new Segment();
        DocumentWordTokenizer documentWordTokenizer = new DocumentWordTokenizer(styledDocument);
        if (n > 0) {
            documentWordTokenizer.posStartFullWordFrom(n);
        }
        while (documentWordTokenizer.hasMoreWords() && documentWordTokenizer.getCurrentWordPosition() <= n2) {
            String string = documentWordTokenizer.nextWord();
            n3 = documentWordTokenizer.getCurrentWordPosition();
            if (n4 != -1) {
                this.markAsCorrect(styledDocument, n4, n3);
            }
            if ((n4 = documentWordTokenizer.getCurrentWordEnd()) > styledDocument.getLength()) {
                n4 = styledDocument.getLength() - 1;
            }
            if (n3 >= n4) continue;
            if (this.sCheck.isCorrect(string) || this.sCheck.isIgnored(string)) {
                this.markAsCorrect(styledDocument, n3, n4);
                continue;
            }
            this.markAsMisspelled(styledDocument, n3, n4);
        }
        if (n4 < n2 && n4 != -1) {
            this.markAsCorrect(styledDocument, n4, n2);
        }
    }

    private void markAsMisspelled(StyledDocument styledDocument, int n, int n2) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        simpleAttributeSet.addAttribute("misspelled", AutoSpellConstants.wordMisspelledTrue);
        styledDocument.setCharacterAttributes(n, n2 - n, simpleAttributeSet, false);
    }

    private void markAsCorrect(StyledDocument styledDocument, int n, int n2) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(styledDocument.getCharacterElement((n + n2) / 2).getAttributes());
        simpleAttributeSet.removeAttribute("misspelled");
        if (n2 >= n) {
            styledDocument.setCharacterAttributes(n, n2 - n, simpleAttributeSet, true);
        }
    }

    private void handleDocumentChange(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() instanceof StyledDocument) {
            int n;
            int n2;
            StyledDocument styledDocument = (StyledDocument)documentEvent.getDocument();
            Element element = styledDocument.getCharacterElement(documentEvent.getOffset());
            Element element2 = element.getParentElement();
            if (element2 != null) {
                n2 = element2.getStartOffset();
                n = element2.getEndOffset();
            } else {
                n2 = element.getStartOffset();
                n = element.getEndOffset();
            }
            this.markupSpelling(styledDocument, n2, n);
        }
    }

    private void showSuggestionPopup(JEditorPane jEditorPane, Point point) {
        StyledDocument styledDocument;
        AttributeSet attributeSet;
        int n = jEditorPane.viewToModel(point);
        if (n >= 0 && (attributeSet = (styledDocument = (StyledDocument)jEditorPane.getDocument()).getCharacterElement(n).getAttributes()).containsAttribute("misspelled", AutoSpellConstants.wordMisspelledTrue)) {
            JMenuItem jMenuItem;
            DocumentWordTokenizer documentWordTokenizer = new DocumentWordTokenizer(styledDocument);
            documentWordTokenizer.posStartFullWordFrom(n);
            String string = documentWordTokenizer.nextWord();
            List list = this.sCheck.getSuggestions(string, this.config.getInteger("SPELL_THRESHOLD"));
            JPopupMenu jPopupMenu = new JPopupMenu();
            ReplaceListener replaceListener = new ReplaceListener(documentWordTokenizer);
            for (int i = 0; i < list.size(); ++i) {
                Word word = (Word)list.get(i);
                jMenuItem = new JMenuItem(word.getWord());
                jMenuItem.setActionCommand(word.getWord());
                jMenuItem.addActionListener(replaceListener);
                jPopupMenu.add(jMenuItem);
            }
            jPopupMenu.addSeparator();
            jMenuItem = new JMenuItem();
            if (this.messages != null) {
                jMenuItem.setText(this.messages.getString("IGNOREALL"));
            } else {
                jMenuItem.setText("Ignore All");
            }
            jMenuItem.setActionCommand(string);
            jMenuItem.addActionListener(new IgnoreAllListener(styledDocument));
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem();
            if (this.messages != null) {
                jMenuItem.setText(this.messages.getString("ADD"));
            } else {
                jMenuItem.setText("Add word to wordlist");
            }
            jMenuItem.setActionCommand(string);
            jMenuItem.addActionListener(new AddToDictListener(styledDocument));
            jPopupMenu.add(jMenuItem);
            jPopupMenu.show(jEditorPane, point.x, point.y);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        SpellCheckChange spellCheckChange = new SpellCheckChange(documentEvent);
        SwingUtilities.invokeLater(spellCheckChange);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        SpellCheckChange spellCheckChange = new SpellCheckChange(documentEvent);
        SwingUtilities.invokeLater(spellCheckChange);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        JEditorPane jEditorPane;
        if (!(mouseEvent.getComponent() instanceof JEditorPane)) {
            return;
        }
        if (mouseEvent.isPopupTrigger() && (jEditorPane = (JEditorPane)mouseEvent.getComponent()).isEditable()) {
            this.showSuggestionPopup(jEditorPane, new Point(mouseEvent.getX(), mouseEvent.getY()));
        }
    }

    private class MarkUpSpellingAll
    implements Runnable {
        private StyledDocument doc;

        public MarkUpSpellingAll(StyledDocument styledDocument) {
            this.doc = styledDocument;
        }

        public void run() {
            AutoSpellCheckHandler.this.markupSpelling(this.doc, 0, this.doc.getLength());
        }
    }

    private class IgnoreAllListener
    implements ActionListener {
        private StyledDocument doc;

        public IgnoreAllListener(StyledDocument styledDocument) {
            this.doc = styledDocument;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AutoSpellCheckHandler.this.sCheck.ignoreAll(actionEvent.getActionCommand());
            MarkUpSpellingAll markUpSpellingAll = new MarkUpSpellingAll(this.doc);
            SwingUtilities.invokeLater(markUpSpellingAll);
        }
    }

    private class AddToDictListener
    implements ActionListener {
        private StyledDocument doc;

        public AddToDictListener(StyledDocument styledDocument) {
            this.doc = styledDocument;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AutoSpellCheckHandler.this.sCheck.addToDictionary(actionEvent.getActionCommand());
            MarkUpSpellingAll markUpSpellingAll = new MarkUpSpellingAll(this.doc);
            SwingUtilities.invokeLater(markUpSpellingAll);
        }
    }

    private class ReplaceListener
    implements ActionListener {
        DocumentWordTokenizer tok;

        public ReplaceListener(DocumentWordTokenizer documentWordTokenizer) {
            this.tok = documentWordTokenizer;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.tok.replaceWord(actionEvent.getActionCommand());
        }
    }

    private class SpellCheckChange
    implements Runnable {
        private DocumentEvent evt;

        public SpellCheckChange(DocumentEvent documentEvent) {
            this.evt = documentEvent;
        }

        public void run() {
            AutoSpellCheckHandler.this.handleDocumentChange(this.evt);
        }
    }
}

