/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class Filter
extends Task {
    private String token;
    private String value;
    private File filtersFile;

    public void execute() throws BuildException {
        boolean isSingleFilter;
        boolean isFiltersFromFile = this.filtersFile != null && this.token == null && this.value == null;
        boolean bl = isSingleFilter = this.filtersFile == null && this.token != null && this.value != null;
        if (!isFiltersFromFile && !isSingleFilter) {
            throw new BuildException("both token and value parameters, or only a filtersFile parameter is required", this.location);
        }
        if (isSingleFilter) {
            this.project.addFilter(this.token, this.value);
        }
        if (isFiltersFromFile) {
            this.readFilters();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readFilters() throws BuildException {
        this.log("Reading filters from " + this.filtersFile, 3);
        FileInputStream in = null;
        try {
            try {
                Properties props = new Properties();
                in = new FileInputStream(this.filtersFile);
                props.load(in);
                Project proj = this.getProject();
                Enumeration<?> enumeration = props.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String strPropName = (String)enumeration.nextElement();
                    String strValue = props.getProperty(strPropName);
                    proj.addFilter(strPropName, strValue);
                }
            }
            catch (Exception exception) {
                throw new BuildException("Could not read filters from file: " + this.filtersFile);
            }
            Object var3_7 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void setFiltersfile(File filtersFile) {
        this.filtersFile = filtersFile;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

