/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Examples {
    public static void exampleAsSerializer(String string, String string2) throws TransformerException, TransformerConfigurationException, SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Document document2 = documentBuilder.parse(new InputSource(string));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        Properties properties = new Properties();
        ((Hashtable)properties).put("method", "html");
        ((Hashtable)properties).put("indent-amount", "2");
        transformer.setOutputProperties(properties);
        transformer.transform(new DOMSource(document2), new StreamResult(System.out));
    }

    public static void exampleContentHandler2DOM(String string, String string2) throws TransformerException, TransformerConfigurationException, SAXException, IOException, ParserConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (transformerFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") && transformerFactory.getFeature("http://javax.xml.transform.dom.DOMSource/feature")) {
            SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)transformerFactory;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler(new StreamSource(string2));
            transformerHandler.setResult(new DOMResult(document));
            XMLReader xMLReader = null;
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(true);
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                xMLReader = sAXParser.getXMLReader();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new SAXException(parserConfigurationException);
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                throw new SAXException(factoryConfigurationError.toString());
            }
            catch (NoSuchMethodError noSuchMethodError) {}
            if (xMLReader == null) {
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            xMLReader.setContentHandler(transformerHandler);
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", transformerHandler);
            xMLReader.parse(string);
            Examples.exampleSerializeNode(document);
        } else {
            System.out.println("Can't do exampleContentHandlerToContentHandler because tfactory is not a SAXTransformerFactory");
        }
    }

    public static void exampleContentHandlerToContentHandler(String string, String string2) throws TransformerException, TransformerConfigurationException, SAXException, IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (transformerFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature")) {
            SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)transformerFactory;
            TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler(new StreamSource(string2));
            SAXResult sAXResult = new SAXResult(new ExampleContentHandler());
            transformerHandler.setResult(sAXResult);
            XMLReader xMLReader = null;
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(true);
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                xMLReader = sAXParser.getXMLReader();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new SAXException(parserConfigurationException);
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                throw new SAXException(factoryConfigurationError.toString());
            }
            catch (NoSuchMethodError noSuchMethodError) {}
            if (xMLReader == null) {
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            xMLReader.setContentHandler(transformerHandler);
            xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", transformerHandler);
            xMLReader.parse(string);
        } else {
            System.out.println("Can't do exampleContentHandlerToContentHandler because tfactory is not a SAXTransformerFactory");
        }
    }

    public static Node exampleDOM2DOM(String string, String string2) throws TransformerException, TransformerConfigurationException, SAXException, IOException, ParserConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (transformerFactory.getFeature("http://javax.xml.transform.dom.DOMSource/feature")) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Document document2 = documentBuilder.parse(new InputSource(string2));
            DOMSource dOMSource = new DOMSource(document2);
            dOMSource.setSystemId(string2);
            Templates templates = transformerFactory.newTemplates(dOMSource);
            Transformer transformer = templates.newTransformer();
            DocumentBuilderFactory documentBuilderFactory2 = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder2 = documentBuilderFactory2.newDocumentBuilder();
            Document document3 = documentBuilder2.newDocument();
            Document document4 = documentBuilder2.parse(new InputSource(string));
            transformer.transform(new DOMSource(document4), new DOMResult(document3));
            Transformer transformer2 = transformerFactory.newTransformer();
            transformer2.transform(new DOMSource(document3), new StreamResult(System.out));
            return document3;
        }
        throw new SAXNotSupportedException("DOM node processing not supported!");
    }

    public static void exampleFromReader(String string, String string2) throws TransformerException, TransformerConfigurationException, FileNotFoundException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
        StreamSource streamSource = new StreamSource(bufferedReader);
        streamSource.setSystemId(string2);
        Transformer transformer = transformerFactory.newTransformer(streamSource);
        BufferedReader bufferedReader2 = new BufferedReader(new FileReader(string));
        StreamSource streamSource2 = new StreamSource(bufferedReader2);
        streamSource2.setSystemId(string);
        transformer.transform(streamSource2, new StreamResult(System.out));
    }

    public static void exampleFromStream(String string, String string2) throws TransformerException, TransformerConfigurationException, FileNotFoundException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
        StreamSource streamSource = new StreamSource(bufferedInputStream);
        streamSource.setSystemId(string2);
        Transformer transformer = transformerFactory.newTransformer(streamSource);
        BufferedInputStream bufferedInputStream2 = new BufferedInputStream(new FileInputStream(string));
        StreamSource streamSource2 = new StreamSource(bufferedInputStream2);
        streamSource2.setSystemId(string);
        transformer.transform(streamSource2, new StreamResult(System.out));
    }

    public static void exampleOutputProperties(String string, String string2) throws TransformerException, TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Templates templates = transformerFactory.newTemplates(new StreamSource(string2));
        Properties properties = templates.getOutputProperties();
        ((Hashtable)properties).put("indent", "yes");
        Transformer transformer = templates.newTransformer();
        transformer.setOutputProperties(properties);
        transformer.transform(new StreamSource(string), new StreamResult(System.out));
    }

    public static void exampleParam(String string, String string2) throws TransformerException, TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Templates templates = transformerFactory.newTemplates(new StreamSource(string2));
        Transformer transformer = templates.newTransformer();
        Transformer transformer2 = templates.newTransformer();
        transformer.setParameter("a-param", "hello to you!");
        transformer.transform(new StreamSource(string), new StreamResult(System.out));
        System.out.println("\n=========");
        transformer2.setOutputProperty("indent", "yes");
        transformer2.transform(new StreamSource(string), new StreamResult(System.out));
    }

    public static void exampleSerializeNode(Node node) throws TransformerException, TransformerConfigurationException, SAXException, IOException, ParserConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(node), new StreamResult(System.out));
    }

    public static void exampleSimple1(String string, String string2) throws TransformerException, TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(string2));
        transformer.transform(new StreamSource(string), new StreamResult(System.out));
    }

    public static void exampleSimple2(String string, String string2) throws TransformerException, TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(string2));
        transformer.transform(new StreamSource(new File(string)), new StreamResult(new File("foo.out")));
    }

    public static void exampleTransformerReuse(String string, String string2) throws TransformerException, TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(new StreamSource(string2));
        transformer.setParameter("a-param", "hello to you!");
        transformer.transform(new StreamSource(string), new StreamResult(System.out));
        System.out.println("\n=========\n");
        transformer.setParameter("a-param", "hello to me!");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(new StreamSource(string), new StreamResult(System.out));
    }

    public static void exampleUseAssociated(String string) throws TransformerException, TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (transformerFactory instanceof SAXTransformerFactory) {
            SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)transformerFactory;
            Source source = sAXTransformerFactory.getAssociatedStylesheet(new StreamSource(string), null, null, null);
            if (source != null) {
                Transformer transformer = transformerFactory.newTransformer(source);
                transformer.transform(new StreamSource(string), new StreamResult(System.out));
            } else {
                System.out.println("Can't find the associated stylesheet!");
            }
        }
    }

    public static void exampleUseTemplatesObj(String string, String string2, String string3) throws TransformerException, TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Templates templates = transformerFactory.newTemplates(new StreamSource(string3));
        Transformer transformer = templates.newTransformer();
        Transformer transformer2 = templates.newTransformer();
        System.out.println("\n\n----- transform of " + string + " -----");
        transformer.transform(new StreamSource(string), new StreamResult(System.out));
        System.out.println("\n\n----- transform of " + string2 + " -----");
        transformer2.transform(new StreamSource(string2), new StreamResult(System.out));
    }

    public static void exampleXMLFilter(String string, String string2) throws TransformerException, TransformerConfigurationException, SAXException, IOException {
        Object object;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        XMLReader xMLReader = null;
        try {
            object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setNamespaceAware(true);
            SAXParser sAXParser = ((SAXParserFactory)object).newSAXParser();
            xMLReader = sAXParser.getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new SAXException(factoryConfigurationError.toString());
        }
        catch (NoSuchMethodError noSuchMethodError) {}
        if (xMLReader == null) {
            xMLReader = XMLReaderFactory.createXMLReader();
        }
        xMLReader.setContentHandler(new ExampleContentHandler());
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            xMLReader.setFeature("http://apache.org/xml/features/validation/dynamic", true);
        }
        catch (SAXException sAXException) {}
        object = ((SAXTransformerFactory)transformerFactory).newXMLFilter(new StreamSource(string2));
        object.setParent(xMLReader);
        object.parse(new InputSource(string));
    }

    public static void exampleXMLFilterChain(String string, String string2, String string3, String string4) throws TransformerException, TransformerConfigurationException, SAXException, IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Templates templates = transformerFactory.newTemplates(new StreamSource(string2));
        Transformer transformer = templates.newTransformer();
        if (transformerFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature")) {
            Object object;
            Object object2;
            SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)transformerFactory;
            XMLReader xMLReader = null;
            try {
                object2 = SAXParserFactory.newInstance();
                ((SAXParserFactory)object2).setNamespaceAware(true);
                object = ((SAXParserFactory)object2).newSAXParser();
                xMLReader = ((SAXParser)object).getXMLReader();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new SAXException(parserConfigurationException);
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                throw new SAXException(factoryConfigurationError.toString());
            }
            catch (NoSuchMethodError noSuchMethodError) {}
            if (xMLReader == null) {
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            object2 = sAXTransformerFactory.newXMLFilter(new StreamSource(string2));
            object = sAXTransformerFactory.newXMLFilter(new StreamSource(string3));
            XMLFilter xMLFilter = sAXTransformerFactory.newXMLFilter(new StreamSource(string4));
            if (object2 != null) {
                object2.setParent(xMLReader);
                object.setParent((XMLReader)object2);
                xMLFilter.setParent((XMLReader)object);
                xMLFilter.setContentHandler(new ExampleContentHandler());
                xMLFilter.parse(new InputSource(string));
            } else {
                System.out.println("Can't do exampleXMLFilter because tfactory doesn't support asXMLFilter()");
            }
        } else {
            System.out.println("Can't do exampleXMLFilter because tfactory is not a SAXTransformerFactory");
        }
    }

    public static void exampleXMLReader(String string, String string2) throws TransformerException, TransformerConfigurationException, SAXException, IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (transformerFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature")) {
            XMLFilter xMLFilter = ((SAXTransformerFactory)transformerFactory).newXMLFilter(new StreamSource(string2));
            xMLFilter.setContentHandler(new ExampleContentHandler());
            xMLFilter.parse(new InputSource(string));
        } else {
            System.out.println("tfactory does not support SAX features!");
        }
    }

    private static void handleException(Exception exception) {
        System.out.println("EXCEPTION: ");
        exception.printStackTrace();
        if (exception instanceof TransformerConfigurationException) {
            System.out.println();
            System.out.println("Internal exception: ");
            Throwable throwable = ((TransformerConfigurationException)exception).getException();
            throwable.printStackTrace();
            if (throwable instanceof SAXException) {
                Exception exception2 = ((SAXException)throwable).getException();
                System.out.println("Internal sub-exception: ");
                exception2.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) throws TransformerException, TransformerConfigurationException, IOException, SAXException, ParserConfigurationException, FileNotFoundException {
        System.out.println("\n\n==== exampleSimple ====");
        try {
            Examples.exampleSimple1("xml/foo.xml", "xsl/foo.xsl");
        }
        catch (Exception exception) {
            Examples.handleException(exception);
        }
        System.out.println("\n\n==== exampleSimple2 ====");
        try {
            Examples.exampleSimple2("xml/foo.xml", "xsl/foo.xsl");
        }
        catch (Exception exception) {
            Examples.handleException(exception);
        }
        System.out.println("\n\n==== exampleFromStream ====");
        try {
            Examples.exampleFromStream("xml/foo.xml", "xsl/foo.xsl");
        }
        catch (Exception exception) {
            Examples.handleException(exception);
        }
        System.out.println("\n\n==== exampleFromReader ====");
        try {
            Examples.exampleFromReader("xml/foo.xml", "xsl/foo.xsl");
        }
        catch (Exception exception) {
            Examples.handleException(exception);
        }
        System.out.println("\n\n==== exampleUseTemplatesObj ====");
        try {
            Examples.exampleUseTemplatesObj("xml/foo.xml", "xml/baz.xml", "xsl/foo.xsl");
        }
        catch (Exception exception) {
            Examples.handleException(exception);
        }
        System.out.println("\n\n==== exampleContentHandlerToContentHandler ====");
        try {
            Examples.exampleContentHandlerToContentHandler("xml/foo.xml", "xsl/foo.xsl");
        }
        catch (Exception exception) {
            Examples.handleException(exception);
        }
        System.out.println("\n\n==== exampleXMLReader ====");
        try {
            Examples.exampleXMLReader("xml/foo.xml", "xsl/foo.xsl");
        }
        catch (Exception exception) {
            Examples.handleException(exception);
        }
        System.out.println("\n\n==== exampleXMLFilter ====");
        try {
            Examples.exampleXMLFilter("xml/foo.xml", "xsl/foo.xsl");
        }
        catch (Exception exception) {
            Examples.handleException(exception);
        }
        System.out.println("\n\n==== exampleXMLFilterChain ====");
        try {
            Examples.exampleXMLFilterChain("xml/foo.xml", "xsl/foo.xsl", "xsl/foo2.xsl", "xsl/foo3.xsl");
        }
        catch (Exception exception) {
            Examples.handleException(exception);
        }
        System.out.println("\n\n==== exampleDOM2DOM ====");
        try {
            Examples.exampleDOM2DOM("xml/foo.xml", "xsl/foo.xsl");
        }
        catch (Exception exception) {
            Examples.handleException(exception);
        }
        System.out.println("\n\n==== exampleParam ====");
        try {
            Examples.exampleParam("xml/foo.xml", "xsl/foo.xsl");
        }
        catch (Exception exception) {
            Examples.handleException(exception);
        }
        System.out.println("\n\n==== exampleTransformerReuse ====");
        try {
            Examples.exampleTransformerReuse("xml/foo.xml", "xsl/foo.xsl");
        }
        catch (Exception exception) {
            Examples.handleException(exception);
        }
        System.out.println("\n\n==== exampleOutputProperties ====");
        try {
            Examples.exampleOutputProperties("xml/foo.xml", "xsl/foo.xsl");
        }
        catch (Exception exception) {
            Examples.handleException(exception);
        }
        System.out.println("\n\n==== exampleUseAssociated ====");
        try {
            Examples.exampleUseAssociated("xml/foo.xml");
        }
        catch (Exception exception) {
            Examples.handleException(exception);
        }
        System.out.println("\n\n==== exampleContentHandler2DOM ====");
        try {
            Examples.exampleContentHandler2DOM("xml/foo.xml", "xsl/foo.xsl");
        }
        catch (Exception exception) {
            Examples.handleException(exception);
        }
        System.out.println("\n\n==== exampleAsSerializer ====");
        try {
            Examples.exampleAsSerializer("xml/foo.xml", "xsl/foo.xsl");
        }
        catch (Exception exception) {
            Examples.handleException(exception);
        }
        System.out.println("\n\n==== exampleContentHandler2DOM ====");
        try {
            Examples.exampleContentHandler2DOM("xml/foo.xml", "xsl/foo.xsl");
        }
        catch (Exception exception) {
            Examples.handleException(exception);
        }
        System.out.println("\n==== done! ====");
    }
}

