/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.db;

class BitMap {
    private static int BITS_PER_BLOCK = 32;
    private int[] bits;
    private int[] masks = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000, Integer.MIN_VALUE};

    BitMap(int n) {
        this.bits = new int[n / BITS_PER_BLOCK + 1];
    }

    void clearAll() {
        int n = 0;
        while (n < this.bits.length) {
            this.bits[n] = 0;
            ++n;
        }
    }

    void clearBit(int n) {
        int n2 = n / BITS_PER_BLOCK;
        int n3 = n % BITS_PER_BLOCK;
        this.bits[n2] = this.bits[n2] & ~this.masks[n3];
    }

    boolean isSet(int n) {
        int n2 = n / BITS_PER_BLOCK;
        if (this.bits[n2] == 0) {
            return false;
        }
        int n3 = n % BITS_PER_BLOCK;
        return (this.bits[n2] & this.masks[n3]) != 0;
    }

    int nextBitClear(int n) {
        int n2 = ++n / BITS_PER_BLOCK;
        int n3 = n % BITS_PER_BLOCK;
        while (n2 < this.bits.length) {
            if (this.bits[n2] != -1) {
                int n4 = n3;
                while (n4 < BITS_PER_BLOCK) {
                    if ((this.bits[n2] & this.masks[n4]) == 0) {
                        return n2 * BITS_PER_BLOCK + n4;
                    }
                    ++n4;
                }
            }
            ++n2;
            n3 = 0;
        }
        return -1;
    }

    int nextBitSet(int n) {
        int n2 = ++n / BITS_PER_BLOCK;
        int n3 = n % BITS_PER_BLOCK;
        while (n2 < this.bits.length) {
            if (this.bits[n2] != 0) {
                int n4 = n3;
                while (n4 < BITS_PER_BLOCK) {
                    if ((this.bits[n2] & this.masks[n4]) != 0) {
                        return n2 * BITS_PER_BLOCK + n4;
                    }
                    ++n4;
                }
            }
            ++n2;
            n3 = 0;
        }
        return -1;
    }

    void setBit(int n) {
        int n2 = n / BITS_PER_BLOCK;
        int n3 = n % BITS_PER_BLOCK;
        this.bits[n2] = this.bits[n2] | this.masks[n3];
    }

    boolean test() {
        int n = this.bits.length * BITS_PER_BLOCK;
        int n2 = 0;
        while (n2 < n) {
            if (this.isSet(n2)) {
                return false;
            }
            this.setBit(n2);
            if (!this.isSet(n2)) {
                return false;
            }
            this.clearBit(n2);
            if (this.isSet(n2)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

