/* 
 *   MOL adaption of BootX, 11/01/2201
 *
 *   Samuel Rydh, <samuel@ibrium.se>
 *
 */
/*
 * Copyright (c) 2000 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * The contents of this file constitute Original Code as defined in and
 * are subject to the Apple Public Source License Version 1.1 (the
 * "License").  You may not use this file except in compliance with the
 * License.  Please obtain a copy of the License at
 * http://www.apple.com/publicsource and read it before using this file.
 * 
 * This Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
 *  device_tree.c - Functions for flattening the Device Tree.
 *
 *  Copyright (c) 1998-2000 Apple Computer, Inc.
 *
 *  DRI: Josh de Cesare
 */

#include "mol_config.h"

#include "bootx.h"
#include "sl.h"
#include "device_tree.h"
#include "promif.h"
#include "debugger.h"

typedef mol_device_node_t *CICell;

static void FlatenNode(mol_device_node_t *dn, long nodeAddr, long *nodeSize);
static void FlatenProps(mol_device_node_t *ph, long propAddr, long *propSize,
			long *numProps);

// Public Functions

void 
FlattenDeviceTree(void)
{
	gBootX.deviceTreeAddr = AllocateKernelMemory(0);
	
	FlatenNode(prom_get_root(), gBootX.deviceTreeAddr, &gBootX.deviceTreeSize);
	
	AllocateKernelMemory(gBootX.deviceTreeSize);
}


#if 0
CICell 
SearchForNode(CICell ph, long top, char *prop, char *value)
{
	CICell curChild, result;
	
	if (ph == 0) ph = Peer(0);
	
	if (top == 0) {
		// Look for it in the current node.
		if (GetProp(ph, prop, gTempStr, 4095) != -1) {
			if (strcmp(value, gTempStr) == 0) {
				return ph;
			}
		}
	}
	
	// Look for it in the children.
	curChild = Child(ph);
	
	while (curChild != 0) {
		result = SearchForNode(curChild, 0, prop, value);
		if (result != 0) return result;
		curChild = Peer(curChild);
	}
	
	if (top != 0) {
		while (ph != 0) {
			curChild = Peer(ph);
			while (curChild != 0) {
				result = SearchForNode(curChild, 0, prop, value);
				if (result != 0) return result;
				curChild = Peer(curChild);
			}
			
			ph = Parent(ph);
		}
	}
	
	return 0;
}


CICell
SearchForNodeMatching(CICell ph, long top, char *value)
{
	CICell curChild, result;
	
	if (ph == 0) ph = Peer(0);
	
	if (top == 0) {
		// Look for it in the current node.
		if (MatchThis(ph, value) == 0) return ph;
	}
	
	// Look for it in the children.
	curChild = Child(ph);
	
	while (curChild != 0) {
		result = SearchForNodeMatching(curChild, 0, value);
		if (result != 0) return result;
		curChild = Peer(curChild);
	}
	
	if (top != 0) {
		while (ph != 0) {
			curChild = Peer(ph);
			while (curChild != 0) {
				result = SearchForNodeMatching(curChild, 0, value);
				if (result != 0) return result;
				curChild = Peer(curChild);
			}
			
			ph = Parent(ph);
		}
	}
	
	return 0;
}
#endif

// Private Functions

void
FlatenNode(mol_device_node_t *dn, long nodeAddr, long *nodeSize)
{
	DTNodePtr node;
	CICell    childDN;
	long      curAddr;
	long      propSize, numProps, childSize, numChildren;
	
	node = (DTNodePtr)nodeAddr;
	curAddr = nodeAddr + sizeof(DTNode);
	numProps = 0;
	numChildren = 0;
	
	FlatenProps(dn, curAddr, &propSize, &numProps);
	
	curAddr += propSize;
	node->nProperties = numProps;
	
	childDN = dn->child;
	while( childDN != 0) {
		FlatenNode(childDN, curAddr, &childSize);
		curAddr += childSize;
		numChildren++;
		
		childDN = childDN->sibling;
	}
	
	node->nChildren = numChildren;
	*nodeSize = curAddr - nodeAddr;
}


void 
FlatenProps(mol_device_node_t *dn, long propAddr, long *propSize, long *numProps)
{
	DTPropertyPtr prop;
	long          ret, cnt, curAddr, valueAddr, nProps;
	p_property_t  *p;
	
	curAddr = propAddr;
	nProps = 0;
	
	// make the first property the phandle
	prop = (DTPropertyPtr)curAddr;
	valueAddr = curAddr + sizeof(DTProperty);
	strcpy(prop->name, "AAPL,phandle");
	*((long *)valueAddr) = prom_dn_to_phandle(dn);
	prop->length = 4;
	curAddr = valueAddr + 4;
	nProps++;
	
	// Make the AAPL,unit-string property.

	ret = strlen(dn->full_name)+1;
	// ret = PackageToPath(ph, gTmpStr, 4095);
	if (ret > 0) {
		cnt = ret - 1;
		while( cnt && (dn->full_name[cnt - 1] != '@') && (dn->full_name[cnt - 1] != '/'))
			cnt--;
		
		if( dn->full_name[cnt - 1] == '@') {
			prop = (DTPropertyPtr)curAddr;
			valueAddr = curAddr + sizeof(DTProperty);
			strcpy(prop->name, "AAPL,unit-string");
			strcpy((char *)valueAddr, &dn->full_name[cnt]);
			prop->length = ret - cnt;
			curAddr = valueAddr + ((prop->length + 3) & ~3);
			nProps++;
		}
	}
	
	for( p=dn->properties; p; p=p->next ) {
		prop = (DTPropertyPtr)curAddr;
		strncpy( prop->name, p->name, sizeof(prop->name) );
		prop->length = p->length;
		valueAddr = curAddr + sizeof(DTProperty);
		memcpy( (char*)valueAddr, p->value, prop->length );
		
		// Save the address of the value if this is
		// the memory map property for the device tree.
		if( (prom_dn_to_phandle(dn) == gBootX.memoryMapPH) && !strcmp(prop->name, "DeviceTree")) {
			gBootX.deviceTreeMMTmp = (long *)valueAddr;
		}

		nProps++;
		curAddr = valueAddr + ((prop->length + 3) & ~3);
	};
	
	*numProps = nProps;
	*propSize = curAddr - propAddr;
}


