/* 
 *   Creation Date: <2000/10/24 00:29:26 samuel>
 *   Time-stamp: <2000/12/29 00:59:06 samuel>
 *   
 *	<usb.c>
 *	
 *	Hack needed by certain NewWorld ROMs
 *   
 *   Copyright (C) 2000 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#include "mol_config.h"
#include "pci.h"
#include "booter.h"
#include "driver_mgr.h"
#include "promif.h"
#include "debugger.h"

#define VENDOR		0x6666
#define DEVICE_ID	0x1234
#define CLASS_CODE	0x0

pci_dev_info_t usb_pci_config = {
	/* vendor, device ID, revision, class */
	VENDOR, DEVICE_ID, 0x00, CLASS_CODE
};

static int usb_init( void );
static void usb_cleanup( void );

driver_interface_t usb_driver = {
	"usb_hack", usb_init, usb_cleanup
};

static int 
usb_init( void )
{
	int bus, devfn;
	mol_device_node_t *dn;

	if( !is_newworld_boot() )
		return 0;

	if( !(dn = prom_find_devices( "usb" )) )
		return 0;
	if( pci_device_loc( dn, &bus, &devfn ) ){
		printm("Could not get devfn of usb device!\n");
		return 0;
	}
	add_pci_device( bus, devfn, &usb_pci_config, NULL );

	// printm("USB hack (%d %d)\n", bus, devfn>>3);
	return 1;
}

static void
usb_cleanup( void )
{
}
