/*   -*- asm -*- 
 *
 *   Creation Date: <2001/02/03 19:38:07 samuel>
 *   Time-stamp: <2001/03/31 13:42:27 samuel>
 *   
 *	<asmdefs.h>
 *	
 *	Common assembly definitions
 *   
 *   Copyright (C) 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_ASMDEFS
#define _H_ASMDEFS

#ifndef __ASSEMBLY__
#error	This file is only to be included from assembler code!
#endif

/* GPR register names */
#define	r0	0
#define	r1	1
#define	r2	2
#define	r3	3
#define	r4	4
#define	r5	5
#define	r6	6
#define	r7	7
#define	r8	8
#define	r9	9
#define	r10	10
#define	r11	11
#define	r12	12
#define	r13	13
#define	r14	14
#define	r15	15
#define	r16	16
#define	r17	17
#define	r18	18
#define	r19	19
#define	r20	20
#define	r21	21
#define	r22	22
#define	r23	23
#define	r24	24
#define	r25	25
#define	r26	26
#define	r27	27
#define	r28	28
#define	r29	29
#define	r30	30
#define	r31	31

/* FPU register names */
#define	fr0	0
#define	fr1	1
#define	fr2	2
#define	fr3	3
#define	fr4	4
#define	fr5	5
#define	fr6	6
#define	fr7	7
#define	fr8	8
#define	fr9	9
#define	fr10	10
#define	fr11	11
#define	fr12	12
#define	fr13	13
#define	fr14	14
#define	fr15	15
#define	fr16	16
#define	fr17	17
#define	fr18	18
#define	fr19	19
#define	fr20	20
#define	fr21	21
#define	fr22	22
#define	fr23	23
#define	fr24	24
#define	fr25	25
#define	fr26	26
#define	fr27	27
#define	fr28	28
#define	fr29	29
#define	fr30	30
#define	fr31	31

/* Altivec register name */
#define	v0	0
#define	v1	1
#define	v2	2
#define	v3	3
#define	v4	4
#define	v5	5
#define	v6	6
#define	v7	7
#define	v8	8
#define	v9	9
#define	v10	10
#define	v11	11
#define	v12	12
#define	v13	13
#define	v14	14
#define	v15	15
#define	v16	16
#define	v17	17
#define	v18	18
#define	v19	19
#define	v20	20
#define	v21	21
#define	v22	22
#define	v23	23
#define	v24	24
#define	v25	25
#define	v26	26
#define	v27	27
#define	v28	28
#define	v29	29
#define	v30	30
#define	v31	31

/************************************************************************/
/*	MISC								*/
/************************************************************************/

#define GLOBL( name )	.globl name ; name

#define	BIT(n)		(1<<(31-(n)))
	
.macro LOADI, dreg, addr
        lis     \dreg,\addr@ha
        addi    \dreg,\dreg,\addr@l
.endm

.macro STORE_GPR_RANGE from, to, gproffs, basereg
	stw	\from,\gproffs+\from*4(\basereg)
	.if	\to-\from
	STORE_GPR_RANGE "(\from+1)",\to,\gproffs,\basereg
	.endif
.endm

.macro LOAD_GPR_RANGE from, to, gproffs, basereg
	lwz	\from,\gproffs+\from*4(\basereg)
        .if	\to-\from
	LOAD_GPR_RANGE "(\from+1)",\to,"\gproffs",\basereg
        .endif
.endm

.macro STORE_FPR_RANGE from, to, fproffs, basereg
	stfd	\from,\fproffs+\from*8(\basereg)
	.if	\to-\from
	STORE_FPR_RANGE "(\from+1)",\to,\fproffs,\basereg
	.endif
.endm
.macro LOAD_FPR_RANGE from, to, fproffs, basereg
	lfd	\from,\fproffs+\from*8(\basereg)
	.if	\to-\from
	LOAD_FPR_RANGE "(\from+1)",\to,\fproffs,\basereg
	.endif
.endm	
		
/************************************************************************/
/*	FPU load/save macros						*/
/************************************************************************/

	// The FPU macros are used both in the kernel and in
	// mainloop_asm.h.
	
.macro xFPR_LOAD_RANGE from, to, mbase
	LOAD_FPR_RANGE \from,\to,xFPR_BASE,\mbase
.endm	
.macro xFPR_SAVE_RANGE from, to, mbase
	STORE_FPR_RANGE \from,\to,xFPR_BASE,\mbase
.endm	

	// The low half of the fpu is fr0-fr12. I.e. the FPU registers 
	// that might be overwritten when a function call is taken
	// (fr13 and fpscr are treated specially).

.macro xLOAD_LOW_FPU mbase
	xFPR_LOAD_RANGE fr0,fr12,\mbase
.endm
.macro xLOAD_TOPHALF_FPU mbase
	xFPR_LOAD_RANGE fr14,fr31,\mbase
.endm
.macro xLOAD_FULL_FPU mbase
	xLOAD_LOW_FPU \mbase
	xLOAD_TOPHALF_FPU \mbase
.endm

.macro xSAVE_LOW_FPU mbase
	xFPR_SAVE_RANGE fr0,fr12,\mbase
.endm
.macro xSAVE_TOPHALF_FPU mbase
	xFPR_SAVE_RANGE fr14,fr31,\mbase
.endm
.macro xSAVE_FULL_FPU mbase
	xSAVE_LOW_FPU \mbase
	xSAVE_TOPHALF_FPU \mbase	
.endm

/************************************************************************/
/*	GPR load/save macros						*/
/************************************************************************/

.macro xGPR_SAVE_RANGE from, to, mbase=1
	STORE_GPR_RANGE \from, \to, xGPR0, \mbase
.endm

.macro xGPR_LOAD_RANGE from, to, mbase=1
	LOAD_GPR_RANGE \from, \to, xGPR0, \mbase
.endm

/************************************************************************/
/*	AltiVec Macros							*/
/************************************************************************/

#define VEC_OPCODE( op1,op2,A,B,C ) \
	.long	(((op1) << (32-6)) | (op2) | ((A) << (32-11)) | ((B) << (32-16)) | ((C) << (32-21))) ;	

#define __stvx( vS,rA,rB)	VEC_OPCODE( 31,0x1ce,vS,rA,rB )
#define __lvx( vD,rA,rB )	VEC_OPCODE( 31,0xce, vD,rA,rB )
#define __mfvscr( vD )		VEC_OPCODE( 4,1540,vD,0,0 )
#define __mtvscr( vB )		VEC_OPCODE( 4,1604,0,0,vB )
#define __stvewx( vS,rA,rB)	VEC_OPCODE( 31,(199<<1), vS,rA,rB )


.macro _stvx vS,rA,rB
	__stvx( \vS,\rA,\rB )
.endm
.macro _lvx vD,rA,rB
	__lvx( \vD,\rA,\rB )
.endm
.macro _mfvscr vD
	__mfvscr( \vD )
.endm
.macro _mtvscr vB
	__mtvscr( \vB )
.endm
.macro _stvewx vS,rA,rB
	__stvewx( \vS,\rA,\rB )
.endm

	
.macro VEC_SAVE_HELPER from,to,reg
	_stvx	\from,0,\reg
	addi	\reg,\reg,16
	.if	\to-\from
	VEC_SAVE_HELPER "(\from+1)",\to,\reg
	.endif
.endm

.macro VEC_LOAD_HELPER from,to,reg
	_lvx	\from,0,\reg
	addi	\reg,\reg,16
	.if	\to-\from
	VEC_LOAD_HELPER "(\from+1)",\to,\reg
	.endif
.endm

// NOTE: Writing to VSCR won't cause exceptions (this
// is different compared to FPSCR).

.macro xVEC_SAVE mbase, scr
	addi	\scr,\mbase,xVEC_BASE
	VEC_SAVE_HELPER 0,31,\scr
	addi	\scr,\mbase,xVSCR-12
	_mfvscr	v0
	_stvx	v0,0,\scr
	addi	\scr,\mbase,xVEC0
	_lvx	v0,0,\scr
	mfspr	\scr,SPRN_VRSAVE
	stw	\scr,xVRSAVE(\mbase)
.endm
	
.macro xVEC_LOAD mbase, scr
	addi	\scr,\mbase,xVSCR-12
	_lvx	v0,0,\scr
	_mtvscr	v0
	addi	\scr,\mbase,xVEC_BASE
	VEC_LOAD_HELPER 0,31,\scr
	lwz	\scr,xVRSAVE(\mbase)
	mtspr	SPRN_VRSAVE,\scr
.endm


#endif   /* _H_ASMDEFS */
