/**************************************************************
*   
*   Creation Date: <97/07/14 15:53:06 samuel>
*   Time-stamp: <2001/06/23 13:03:28 samuel>
*   
*	<kernel_vars.h>
*	
*	Variables used by the kernel
*   
*   Copyright (C) 1997, 1999, 2000, 2001 Samuel Rydh
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation;
*
**************************************************************/

#ifndef H_KERNEL_VARS
#define H_KERNEL_VARS

#define MAX_NUM_SESSIONS	8

#include "mac_registers.h"

#ifndef __ASSEMBLY__
#include "mmu_mappings.h"

#ifdef __KERNEL__
#include <asm/mmu.h>

#endif  /* __KERNEL__ */

typedef union _bat {
#ifdef __KERNEL__
	P601_BAT	bat_601;
	BAT		bat;
#endif
	ulong		word[2];	/* upper, lower */
} bat;


typedef struct mac_bat {
	int	valid;		/* record in use */
	ulong	base;
	ulong	mbase;
	ulong	size;

	ulong	wimg:4;		/* WIMG-bits */
	ulong	vs:1;		/* valid supervisor mode */
	ulong	vp:1;		/* valid user mode */
	ulong	ks:1;		/* key superuser */
	ulong	ku:1;		/* key user */
	ulong	pp:2;		/* page protection */

	/* possibly we should track inserted PTEs here... */
} mac_bat_t;


struct lvhash;

typedef struct {
	bat	dbat0;			/* loaded to DBAT0 (used in splitmode) */
	bat	transl_dbat0;		/* DBAT0 mapping the framebuffer */

	ulong	emulator_sr[16];	/* segment registers used by the emulator */	
	ulong	emulator_context;	/* context of emulator (equals VSID >> 4) in Linux */

	ulong	user_sr[16];		/* segment registers for user, mapped */
	ulong	sv_sr[16];		/* segment registers for sv, mapped */
	ulong	unmapped_sr[16];	/* unmapped segment registers */
	ulong	split_sr[16];		/* segment registers used in split mode */
	ulong	illegal_sr;		/* segment registers without PTEs */

	ulong	cur_sr_base;		/* (physical) pointer to user_sr or sv_sr */
	ulong	sr_inst;		/* (physical) pointer to us user_sr or sv_sr */
	ulong	sr_data;		/* (physical) pointer to us user_sr or sv_sr */

	ulong	mac_ram_base;		/* macram, mac-virtual base */
	char	*linux_ram_base;	/* linux-virtual base */
	size_t	ram_size;

	int	splitmode_algorithm;	/* splitmode algorithm to use (1=normal, 2=601-compatible) */

	mac_bat_t bats[8];		/* 4 IBAT + 4 DBAT */
	ulong	bat_hack_count;		/* HACK to speed up MacOS 9.1 */

	/* PTE hash */
	ulong	hash_mbase;		/* mac physical base address of hash */
	ulong	*hash_base;		/* linux virtual base address of hash */
	ulong	hash_mask;		/* hash mask (0x000fffff etc) */

	ulong	pthash_sr;		/* segment register corresponding to */ 
	ulong	pthash_ea_base;		/* pthash_ea_base */

	/* various tables */
	struct lvhash		*lvhash;		/* lvptr -> PTE hash */
	struct io_data 		*io_data;		/* translation info */
	struct tlbie_table 	*tlbie_table;		/* ea -> PTE table */
	struct vsid_data 	*vsid_data;		/* ea -> PTE table */
	struct fb_data		*fb_data;		/* ea -> PTE table */
	struct tracker_data	*tracker_data;		/* Keeps track of modified pages */
} mmu_vars_t;


/* variables which are private to the low level assembly code */
typedef struct {
	/* saved kernel/emulator registers */
	ulong	emulator_nip;
	ulong	emulator_msr;
	ulong	emulator_sprg2;
	ulong	emulator_sprg3;
	ulong	emulator_kcall_nip;
	ulong 	emulator_stack;
	ulong 	emulator_toc;		/* == r2 on certain systems */

	bat	ibat_save[4];		/* kernel values of the BAT-registers */
	bat	dbat_save[4];

	/* DEC and timebase */
	ulong	dec_stamp;		/* linux DEC = dec_stamp - tbl */
	ulong	int_stamp;		/* next DEC event = int_stamp - tbl */

	/* splitmode */
	int	in_splitmode;		/* non-zero if in splitmode (equals splitmode_algorithm) */
	int	prepare_splitmode;	/* non-zero if splitmode segment registers need update */
	int	split_nip_segment;	/* segment (top 4) used for inst. fetches */

	/* various */
	int	reload_sr;		/* force a reload of segment registers/dbat0 on exception return */

	/* spr register hooks */
	ulong	spr_hooks[NUM_SPRS];	/* hooks */

	/* segment register offset table */
	ulong	msr_sr_table[ 4*8 ];	/* see emulation.S */

	ulong	tmp_scratch[4];		/* temporary storage */
} base_private_t;


typedef struct kernel_vars {
	struct mac_regs		mregs;			/* must go first */
	char page_filler[0x1000 - (sizeof(mac_regs_t)&0xfff) ];

	base_private_t	 	_bp;
	mmu_vars_t		mmu;

	struct kernel_vars	*kernel_vars;		/* Address of this struct */
	int			break_flags;
} kernel_vars_t;


#define NUM_KVARS_PAGES	((sizeof( kernel_vars_t )+0xfff)/0x1000)

typedef struct {
	ulong	 		kvars_ph[MAX_NUM_SESSIONS];
	ulong			entry_magic[MAX_NUM_SESSIONS];
	
	kernel_vars_t		*kvars[MAX_NUM_SESSIONS];
} session_table_t;

extern session_table_t *g_sesstab;

#endif /* __ASSEMBLY__ */
#endif
