/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.generator.bcm;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.webservice.generator.bcm.AnnotationCollectorFieldVisitor;
import it.imolinfo.jbi4corba.webservice.generator.bcm.AnnotationCollectorMethodVisitor;
import it.imolinfo.jbi4corba.webservice.generator.bcm.AnnotationCollectorVisitor;
import it.imolinfo.jbi4corba.webservice.generator.bcm.AnnotationVisibleAndValue;
import it.imolinfo.jbi4corba.webservice.generator.bcm.AnnotationsMaps;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class AnnotationCollectorAdapter
extends ClassAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationCollectorAdapter.class);
    protected ClassWriter classWriter = null;
    protected String className = null;
    protected String javaClassName = null;
    protected AnnotationsMaps tracer = null;

    public AnnotationCollectorAdapter(ClassVisitor cv, ClassWriter cw, String cn, AnnotationsMaps tracer, String javaClassName) {
        super(cv);
        this.classWriter = cw;
        this.className = cn;
        this.javaClassName = javaClassName;
        this.tracer = tracer == null ? new AnnotationsMaps() : tracer;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        LOG.info("===== ANNOTATION. desc=" + desc + "; visible=" + visible);
        AnnotationCollectorVisitor visitor = new AnnotationCollectorVisitor();
        AnnotationCollectorVisitor av = (AnnotationCollectorVisitor)visitor.visitAnnotation(desc, visible);
        AnnotationVisibleAndValue avv = new AnnotationVisibleAndValue(visible, av.list);
        this.tracer.annotationOnClass.put(desc, avv);
        return av;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        AnnotationCollectorMethodVisitor mv = new AnnotationCollectorMethodVisitor(this.tracer, name);
        return mv.visitMethod(access, name, desc, signature, exceptions);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        LOG.debug(">>>>> visitField - begin");
        AnnotationCollectorFieldVisitor fv = new AnnotationCollectorFieldVisitor(this.tracer, name);
        LOG.debug(">>>>> visitField - end");
        return fv.visitField(access, name, desc, signature, value);
    }
}

