/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.webservice.generator.bcm;

import it.imolinfo.jbi4corba.Logger;
import it.imolinfo.jbi4corba.LoggerFactory;
import it.imolinfo.jbi4corba.webservice.generator.ClassMetaInfo;
import java.util.HashSet;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;

public class SerializableInspectorAdapter
extends ClassAdapter {
    public static final String INTERNAL_NAME_OF_SERIALIZABLE = "java/io/Serializable";
    public static final String FIELDNAME_SERIAL_VERSION_UID = "serialVersionUID";
    private static final Logger LOG = LoggerFactory.getLogger(SerializableInspectorAdapter.class);
    protected ClassMetaInfo classMetaInfo = new ClassMetaInfo();

    public SerializableInspectorAdapter(ClassVisitor cv) {
        super(cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        LOG.debug("visit. version=" + version + "; access=" + access + "; name" + name + "; superName=" + superName);
        if (this.implementsSerializable(interfaces)) {
            LOG.debug("The class " + name + " implements Serializable.");
            this.classMetaInfo.setSerializable(true);
        } else {
            LOG.debug("The class " + name + " does not implement Serializable.");
            this.classMetaInfo.setSerializable(false);
        }
        this.classMetaInfo.setClassName(name.replace('/', '.'));
        this.classMetaInfo.setSuperClassName(superName.replace('/', '.'));
        HashSet<String> set = new HashSet<String>();
        if (interfaces != null) {
            for (String current : interfaces) {
                set.add(current.replace('/', '.'));
            }
        }
        this.classMetaInfo.setInterfaces(set);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        LOG.debug("visitField. access=" + access + "; name=" + name + "; desc=" + desc + "; signature=" + signature + "; value=" + value);
        if (this.hasSerialVersionUIDField(name, desc)) {
            LOG.debug("The class " + name + " has a serial version UID:" + value);
            this.classMetaInfo.setClassSerialVersionUid((Long)value);
        }
        return super.visitField(access, name, desc, signature, value);
    }

    protected boolean hasSerialVersionUIDField(String name, String desc) {
        if (FIELDNAME_SERIAL_VERSION_UID.equals(name) && Type.LONG_TYPE.getDescriptor().equals(desc)) {
            LOG.debug("serialVersionUID found.");
            return true;
        }
        return false;
    }

    protected boolean implementsSerializable(String[] interfaces) {
        if (interfaces == null || interfaces.length == 0) {
            return false;
        }
        for (String current : interfaces) {
            if (!INTERNAL_NAME_OF_SERIALIZABLE.equals(current)) continue;
            return true;
        }
        return false;
    }

    public ClassMetaInfo getClassMetaInfo() {
        return this.classMetaInfo;
    }

    public void setClassMetaInfo(ClassMetaInfo classMetaInfo) {
        this.classMetaInfo = classMetaInfo;
    }
}

