/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGo3DRect;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoNode;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoText;
import java.awt.Insets;

public class JGoTextNode
extends JGoNode {
    public static final int ChangedLabel = 2301;
    public static final int ChangedBackground = 2302;
    public static final int ChangedTopPort = 2303;
    public static final int ChangedRightPort = 2304;
    public static final int ChangedBottomPort = 2305;
    public static final int ChangedLeftPort = 2306;
    public static final int ChangedInsets = 2307;
    public static final int ChangedAutoResize = 2308;
    private static final int flagAutoResize = 65536;
    private JGoText myLabel = null;
    private JGoObject myBack = null;
    private JGoPort myTopPort = null;
    private JGoPort myRightPort = null;
    private JGoPort myBottomPort = null;
    private JGoPort myLeftPort = null;
    private Insets myInsets = new Insets(3, 3, 2, 2);

    public JGoTextNode() {
        this.initCommon();
    }

    public JGoTextNode(String s) {
        this.initCommon();
        this.init(s);
    }

    private void initCommon() {
        this.setInternalFlags(this.getInternalFlags() & 0xFFFFFFEF | 0x10000);
    }

    private void init(String s) {
        this.setInitializing(true);
        this.myBack = this.createBackground();
        this.myLabel = this.createLabel(s);
        this.myTopPort = this.createPort(2);
        this.myRightPort = this.createPort(4);
        this.myBottomPort = this.createPort(6);
        this.myLeftPort = this.createPort(8);
        this.addObjectAtHead(this.myBack);
        this.addObjectAtTail(this.myLabel);
        this.addObjectAtTail(this.myTopPort);
        this.addObjectAtTail(this.myRightPort);
        this.addObjectAtTail(this.myBottomPort);
        this.addObjectAtTail(this.myLeftPort);
        this.setInitializing(false);
        this.layoutChildren(null);
    }

    public JGoObject createBackground() {
        JGo3DRect b = new JGo3DRect();
        b.setSelectable(false);
        return b;
    }

    public JGoText createLabel(String s) {
        JGoText l = new JGoText();
        l.setSelectable(false);
        l.setResizable(false);
        l.setDraggable(false);
        l.setMultiline(true);
        l.setEditable(false);
        l.setEditOnSingleClick(true);
        l.setTransparent(true);
        l.setText(s);
        return l;
    }

    public JGoPort createPort(int spot) {
        JGoPort p = new JGoPort();
        p.setStyle(0);
        p.setSize(3, 3);
        p.setFromSpot(spot);
        p.setToSpot(spot);
        p.setAutoRescale(false);
        return p;
    }

    protected void copyChildren(JGoArea newarea, JGoCopyEnvironment env) {
        JGoTextNode newobj = (JGoTextNode)newarea;
        newobj.myInsets.top = this.myInsets.top;
        newobj.myInsets.left = this.myInsets.left;
        newobj.myInsets.bottom = this.myInsets.bottom;
        newobj.myInsets.right = this.myInsets.right;
        super.copyChildren(newarea, env);
        newobj.myBack = (JGoObject)env.get(this.myBack);
        newobj.myLabel = (JGoText)env.get(this.myLabel);
        newobj.myTopPort = (JGoPort)env.get(this.myTopPort);
        newobj.myRightPort = (JGoPort)env.get(this.myRightPort);
        newobj.myBottomPort = (JGoPort)env.get(this.myBottomPort);
        newobj.myLeftPort = (JGoPort)env.get(this.myLeftPort);
    }

    public JGoObject removeObjectAtPos(JGoListPosition pos) {
        JGoObject child = super.removeObjectAtPos(pos);
        if (child == this.myBack) {
            this.myBack = null;
        } else if (child == this.myLabel) {
            this.myLabel = null;
        } else if (child == this.myTopPort) {
            this.myTopPort = null;
        } else if (child == this.myRightPort) {
            this.myRightPort = null;
        } else if (child == this.myBottomPort) {
            this.myBottomPort = null;
        } else if (child == this.myLeftPort) {
            this.myLeftPort = null;
        }
        return child;
    }

    public void layoutChildren(JGoObject childchanged) {
        if (this.isInitializing()) {
            return;
        }
        JGoText label = this.getLabel();
        if (label == null) {
            return;
        }
        JGoObject back = this.getBackground();
        if (back != null) {
            Insets insets = this.getInsets();
            if (this.isAutoResize()) {
                back.setBoundingRect(label.getLeft() - insets.left, label.getTop() - insets.top, label.getWidth() + insets.left + insets.right, label.getHeight() + insets.top + insets.bottom);
            } else {
                int maxLabelWidth = Math.max(back.getWidth() - (insets.left + insets.right), 0);
                int maxLabelHeight = Math.max(back.getHeight() - (insets.top + insets.bottom), 0);
                label.setWidth(maxLabelWidth);
                label.setWrappingWidth(maxLabelWidth);
                label.recalcBoundingRect();
                int labelHeight = Math.min(label.getHeight(), maxLabelHeight);
                int labelLeft = back.getLeft() + insets.left;
                int labelTop = back.getTop() + insets.top + (maxLabelHeight - labelHeight) / 2;
                label.setBoundingRect(labelLeft, labelTop, maxLabelWidth, labelHeight);
            }
            if (this.getTopPort() != null) {
                this.getTopPort().setSpotLocation(6, back, 2);
            }
            if (this.getRightPort() != null) {
                this.getRightPort().setSpotLocation(8, back, 4);
            }
            if (this.getBottomPort() != null) {
                this.getBottomPort().setSpotLocation(2, back, 6);
            }
            if (this.getLeftPort() != null) {
                this.getLeftPort().setSpotLocation(4, back, 8);
            }
        }
    }

    public JGoText getLabel() {
        return this.myLabel;
    }

    public void setLabel(JGoText lab) {
        JGoText oldLabel = this.myLabel;
        if (oldLabel != lab) {
            JGoTextNode.copyProperties(oldLabel, lab);
            if (oldLabel != null) {
                this.removeObject(oldLabel);
            }
            this.myLabel = lab;
            if (lab != null) {
                this.addObjectAtTail(lab);
            }
            this.update(2301, 0, oldLabel);
        }
    }

    public JGoObject getBackground() {
        return this.myBack;
    }

    public void setBackground(JGoObject back) {
        JGoObject oldBack = this.myBack;
        if (oldBack != back) {
            if (oldBack != null) {
                this.removeObject(oldBack);
            }
            this.myBack = back;
            if (back != null) {
                this.addObjectAtHead(back);
            }
            this.update(2302, 0, oldBack);
        }
    }

    public JGoPort getTopPort() {
        return this.myTopPort;
    }

    public void setTopPort(JGoPort p) {
        JGoPort oldPort = this.myTopPort;
        if (oldPort != p) {
            if (oldPort != null) {
                this.removeObject(oldPort);
            }
            this.myTopPort = p;
            if (p != null) {
                this.addObjectAtTail(p);
            }
            this.update(2303, 0, oldPort);
        }
    }

    public JGoPort getRightPort() {
        return this.myRightPort;
    }

    public void setRightPort(JGoPort p) {
        JGoPort oldPort = this.myRightPort;
        if (oldPort != p) {
            if (oldPort != null) {
                this.removeObject(oldPort);
            }
            this.myRightPort = p;
            if (p != null) {
                this.addObjectAtTail(p);
            }
            this.update(2304, 0, oldPort);
        }
    }

    public JGoPort getBottomPort() {
        return this.myBottomPort;
    }

    public void setBottomPort(JGoPort p) {
        JGoPort oldPort = this.myBottomPort;
        if (oldPort != p) {
            if (oldPort != null) {
                this.removeObject(oldPort);
            }
            this.myBottomPort = p;
            if (p != null) {
                this.addObjectAtTail(p);
            }
            this.update(2305, 0, oldPort);
        }
    }

    public JGoPort getLeftPort() {
        return this.myLeftPort;
    }

    public void setLeftPort(JGoPort p) {
        JGoPort oldPort = this.myLeftPort;
        if (oldPort != p) {
            if (oldPort != null) {
                this.removeObject(oldPort);
            }
            this.myLeftPort = p;
            if (p != null) {
                this.addObjectAtTail(p);
            }
            this.update(2306, 0, oldPort);
        }
    }

    public Insets getInsets() {
        return this.myInsets;
    }

    public void setInsets(Insets x) {
        this.internalSetInsets(x, false);
    }

    private void internalSetInsets(Insets x, boolean undoing) {
        Insets s = this.myInsets;
        if (!s.equals(x)) {
            Insets oldInsets = new Insets(s.top, s.left, s.bottom, s.right);
            this.myInsets.top = x.top;
            this.myInsets.left = x.left;
            this.myInsets.bottom = x.bottom;
            this.myInsets.right = x.right;
            this.update(2307, 0, oldInsets);
            if (!undoing) {
                this.layoutChildren(null);
            }
        }
    }

    public void setAutoResize(boolean bFlag) {
        this.internalSetAutoResize(bFlag, false);
    }

    private void internalSetAutoResize(boolean bFlag, boolean undoing) {
        boolean old;
        boolean bl = old = (this.getInternalFlags() & 0x10000) != 0;
        if (old != bFlag) {
            if (bFlag) {
                this.setInternalFlags(this.getInternalFlags() | 0x10000);
            } else {
                this.setInternalFlags(this.getInternalFlags() & 0xFFFEFFFF);
            }
            this.update(2308, old ? 1 : 0, null);
            if (!undoing) {
                this.onAutoResizeChanged(old);
            }
        }
    }

    public boolean isAutoResize() {
        return (this.getInternalFlags() & 0x10000) != 0;
    }

    public void onAutoResizeChanged(boolean old) {
        JGoText l = this.getLabel();
        if (l != null) {
            l.setMultiline(old);
            l.setWrapping(old);
            l.setClipping(old);
        }
    }

    public JGoPen getPen() {
        JGoObject back = this.getBackground();
        if (back != null && back instanceof JGoDrawable) {
            return ((JGoDrawable)back).getPen();
        }
        return null;
    }

    public void setPen(JGoPen p) {
        JGoObject back = this.getBackground();
        if (back != null && back instanceof JGoDrawable) {
            ((JGoDrawable)back).setPen(p);
        }
    }

    public JGoBrush getBrush() {
        JGoObject back = this.getBackground();
        if (back != null && back instanceof JGoDrawable) {
            return ((JGoDrawable)back).getBrush();
        }
        return null;
    }

    public void setBrush(JGoBrush b) {
        JGoObject back = this.getBackground();
        if (back != null && back instanceof JGoDrawable) {
            ((JGoDrawable)back).setBrush(b);
        }
    }

    public String getText() {
        if (this.myLabel != null) {
            return this.myLabel.getText();
        }
        return "";
    }

    public void setText(String s) {
        if (s == null) {
            return;
        }
        JGoText lab = this.getLabel();
        if (lab == null) {
            this.myLabel = this.createLabel(s);
            this.addObjectAtTail(this.myLabel);
        } else {
            lab.setText(s);
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 2301: {
                e.setNewValue(this.getLabel());
                return;
            }
            case 2302: {
                e.setNewValue(this.getBackground());
                return;
            }
            case 2303: {
                e.setNewValue(this.getTopPort());
                return;
            }
            case 2304: {
                e.setNewValue(this.getRightPort());
                return;
            }
            case 2305: {
                e.setNewValue(this.getBottomPort());
                return;
            }
            case 2306: {
                e.setNewValue(this.getLeftPort());
                return;
            }
            case 2307: {
                Insets s = this.getInsets();
                e.setNewValue(new Insets(s.top, s.left, s.bottom, s.right));
                return;
            }
            case 2308: {
                e.setNewValueBoolean(this.isAutoResize());
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 2301: {
                this.setLabel((JGoText)e.getValue(undo));
                return;
            }
            case 2302: {
                this.setBackground((JGoObject)e.getValue(undo));
                return;
            }
            case 2303: {
                this.setTopPort((JGoPort)e.getValue(undo));
                return;
            }
            case 2304: {
                this.setRightPort((JGoPort)e.getValue(undo));
                return;
            }
            case 2305: {
                this.setBottomPort((JGoPort)e.getValue(undo));
                return;
            }
            case 2306: {
                this.setLeftPort((JGoPort)e.getValue(undo));
                return;
            }
            case 2307: {
                this.internalSetInsets((Insets)e.getValue(undo), true);
                return;
            }
            case 2308: {
                this.internalSetAutoResize(e.getValueBoolean(undo), true);
                return;
            }
        }
        super.changeValue(e, undo);
    }

    public void SVGUpdateReference(String attr, Object referencedObject) {
        super.SVGUpdateReference(attr, referencedObject);
        if (attr.equals("textlabel")) {
            this.myLabel = (JGoText)referencedObject;
        } else if (attr.equals("backdraw")) {
            this.myBack = (JGoObject)referencedObject;
        } else if (attr.equals("topport")) {
            this.myTopPort = (JGoPort)referencedObject;
        } else if (attr.equals("rightport")) {
            this.myRightPort = (JGoPort)referencedObject;
        } else if (attr.equals("bottomport")) {
            this.myBottomPort = (JGoPort)referencedObject;
        } else if (attr.equals("leftport")) {
            this.myLeftPort = (JGoPort)referencedObject;
        }
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jJGoTextNode = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoTextNode", jGoElementGroup);
            jJGoTextNode.setAttribute("insetleft", Integer.toString(this.myInsets.left));
            jJGoTextNode.setAttribute("insetright", Integer.toString(this.myInsets.right));
            jJGoTextNode.setAttribute("insettop", Integer.toString(this.myInsets.top));
            jJGoTextNode.setAttribute("insetbottom", Integer.toString(this.myInsets.bottom));
            if (this.myLabel != null) {
                svgDoc.registerReferencingNode(jJGoTextNode, "textlabel", this.myLabel);
            }
            if (this.myBack != null) {
                svgDoc.registerReferencingNode(jJGoTextNode, "backdraw", this.myBack);
            }
            if (this.myTopPort != null) {
                svgDoc.registerReferencingNode(jJGoTextNode, "topport", this.myTopPort);
            }
            if (this.myRightPort != null) {
                svgDoc.registerReferencingNode(jJGoTextNode, "rightport", this.myRightPort);
            }
            if (this.myBottomPort != null) {
                svgDoc.registerReferencingNode(jJGoTextNode, "bottomport", this.myBottomPort);
            }
            if (this.myLeftPort != null) {
                svgDoc.registerReferencingNode(jJGoTextNode, "leftport", this.myLeftPort);
            }
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            this.myInsets.left = Integer.parseInt(jGoChildElement.getAttribute("insetleft"));
            this.myInsets.right = Integer.parseInt(jGoChildElement.getAttribute("insetright"));
            this.myInsets.top = Integer.parseInt(jGoChildElement.getAttribute("insettop"));
            this.myInsets.bottom = Integer.parseInt(jGoChildElement.getAttribute("insetbottom"));
            String textlabel = jGoChildElement.getAttribute("textlabel");
            svgDoc.registerReferencingObject(this, "textlabel", textlabel);
            String backdraw = jGoChildElement.getAttribute("backdraw");
            svgDoc.registerReferencingObject(this, "backdraw", backdraw);
            String topport = jGoChildElement.getAttribute("topport");
            svgDoc.registerReferencingObject(this, "topport", topport);
            String rightport = jGoChildElement.getAttribute("rightport");
            svgDoc.registerReferencingObject(this, "rightport", rightport);
            String bottomport = jGoChildElement.getAttribute("bottomport");
            svgDoc.registerReferencingObject(this, "bottomport", bottomport);
            String leftport = jGoChildElement.getAttribute("leftport");
            svgDoc.registerReferencingObject(this, "leftport", leftport);
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
        }
        return svgElement.getNextSibling();
    }
}

