/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.hl7;

import com.sun.encoder.Encoder;
import com.sun.encoder.EncoderConfigurationException;
import com.sun.encoder.EncoderException;
import com.sun.encoder.EncoderProperties;
import com.sun.encoder.EncoderType;
import com.sun.encoder.MetaRef;
import com.sun.encoder.hl7.appinfo.Hl7Encoding;
import com.sun.encoder.hl7.runtime.provider.MarshalHandler;
import com.sun.encoder.hl7.runtime.provider.UnmarshalAdaptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.apache.xmlbeans.SchemaAnnotation;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.xb.xsdschema.SchemaDocument;
import org.xml.sax.InputSource;

class HL7Encoder
implements Encoder {
    public static final QName APPINFO_SOURCE_ATTR = new QName("source");
    public static final String ENCODER_NAMESPACE = "urn:com.sun:encoder";
    private final EncoderType mType;
    private final EncoderProperties mProperties;
    private Transformer mTransformer;
    private SchemaGlobalElement mRootElement;
    private String mPreDecodeCharCoding;
    private String mPostEncodeCharCoding;
    private URL mSchemaLocation;

    HL7Encoder(EncoderType type, EncoderProperties properties) {
        this.mType = type;
        this.mProperties = properties.immutable() ? properties : properties.cloneImmutable();
    }

    public Source decodeFromString(String input) throws EncoderException {
        return this.decodeFromString(input, null);
    }

    public String encodeToString(Source xmlSource) throws EncoderException {
        return this.encodeToString(xmlSource, null);
    }

    public Source decodeFromBytes(byte[] input) throws EncoderException {
        return this.decodeFromBytes(input, null);
    }

    public byte[] encodeToBytes(Source xmlSource) throws EncoderException {
        return this.encodeToBytes(xmlSource, null);
    }

    public boolean dispose() {
        this.mRootElement = null;
        return true;
    }

    public void setMeta(MetaRef xsd) throws EncoderConfigurationException {
        try {
            SchemaTypeSystem schemaTS;
            SchemaTypeLoader typeLoader = XmlBeans.typeLoaderForClassLoader((ClassLoader)HL7Encoder.class.getClassLoader());
            if (xsd.getURL() != null) {
                XmlOptions options = new XmlOptions();
                options.put((Object)"COMPILE_DOWNLOAD_URLS", (Object)Boolean.TRUE);
                SchemaDocument schemaXmlObj = SchemaDocument.Factory.parse((URL)xsd.getURL());
                schemaTS = XmlBeans.compileXsd((XmlObject[])new XmlObject[]{schemaXmlObj}, (SchemaTypeLoader)SchemaDocument.type.getTypeSystem(), (XmlOptions)options);
            } else {
                SchemaDocument schemaXmlObj = SchemaDocument.Factory.parse((File)new File(xsd.getPath()));
                schemaXmlObj.validate();
                schemaTS = XmlBeans.compileXsd((XmlObject[])new XmlObject[]{schemaXmlObj}, (SchemaTypeLoader)SchemaDocument.type.getTypeSystem(), null);
            }
            typeLoader = XmlBeans.typeLoaderUnion((SchemaTypeLoader[])new SchemaTypeLoader[]{typeLoader, schemaTS});
            QName qName = xsd.getRootElemName();
            if (qName == null) {
                throw new EncoderConfigurationException("Root element name cannot be null. path='" + xsd.getPath() + "'");
            }
            this.mRootElement = typeLoader.findElement(qName);
            if (this.mRootElement == null) {
                throw new EncoderConfigurationException("Unable to find global element '" + qName + "'");
            }
            this.mTransformer = TransformerFactory.newInstance().newTransformer();
            this.mSchemaLocation = xsd.getURL() != null ? xsd.getURL() : new File(xsd.getPath()).toURL();
            this.initCodings();
        }
        catch (XmlException e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
        catch (IOException e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
    }

    public void setMeta(URL schemaLocation, SchemaGlobalElement rootElemName) throws EncoderConfigurationException {
        try {
            this.mRootElement = rootElemName;
            this.mTransformer = TransformerFactory.newInstance().newTransformer();
            this.mSchemaLocation = schemaLocation;
            this.initCodings();
        }
        catch (TransformerConfigurationException e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
        catch (XmlException e) {
            throw new EncoderConfigurationException((Throwable)e);
        }
    }

    public Source decodeFromBytes(byte[] input, EncoderProperties properties) throws EncoderException {
        return this.decodeFromStream(new ByteArrayInputStream(input), properties);
    }

    public Source decodeFromReader(Reader input) throws EncoderException {
        return this.decodeFromReader(input, null);
    }

    public Source decodeFromReader(Reader input, EncoderProperties properties) throws EncoderException {
        InputSource inputSource = new InputSource(input);
        inputSource.setPublicId("character sequence data");
        UnmarshalAdaptor adaptor = new UnmarshalAdaptor(this.mSchemaLocation, this.mRootElement);
        return new SAXSource(adaptor, inputSource);
    }

    public Source decodeFromStream(InputStream input) throws EncoderException {
        return this.decodeFromStream(input, null);
    }

    public Source decodeFromStream(InputStream input, EncoderProperties properties) throws EncoderException {
        InputSource inputSource = new InputSource(input);
        inputSource.setPublicId("byte sequence data");
        inputSource.setEncoding(properties != null ? properties.getPreDecodeCharCoding() : null);
        if (inputSource.getEncoding() == null) {
            inputSource.setEncoding(this.mProperties.getPreDecodeCharCoding());
            if (inputSource.getEncoding() == null) {
                inputSource.setEncoding(this.mPreDecodeCharCoding);
                if (inputSource.getEncoding() == null) {
                    inputSource.setEncoding("ASCII");
                }
            }
        }
        UnmarshalAdaptor adaptor = new UnmarshalAdaptor(this.mSchemaLocation, this.mRootElement);
        return new SAXSource(adaptor, inputSource);
    }

    public Source decodeFromString(String input, EncoderProperties properties) throws EncoderException {
        return this.decodeFromReader(new StringReader(input), properties);
    }

    public byte[] encodeToBytes(Source src, EncoderProperties properties) throws EncoderException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.encodeToStream(src, out, properties);
        return out.toByteArray();
    }

    public void encodeToStream(Source in, OutputStream out) throws EncoderException {
        this.encodeToStream(in, out, null);
    }

    public void encodeToStream(Source in, OutputStream out, EncoderProperties properties) throws EncoderException {
        String coding;
        String string = coding = properties != null ? properties.getPostEncodeCharCoding() : null;
        if (coding == null && (coding = this.mProperties.getPostEncodeCharCoding()) == null && (coding = this.mPostEncodeCharCoding) == null) {
            coding = "ASCII";
        }
        SAXResult result = new SAXResult(new MarshalHandler(this.mRootElement, out, coding));
        try {
            this.mTransformer.transform(in, result);
            out.flush();
        }
        catch (TransformerException e) {
            throw new EncoderException((Throwable)e);
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    public String encodeToString(Source src, EncoderProperties properties) throws EncoderException {
        StringWriter writer = new StringWriter();
        this.encodeToWriter(src, writer, properties);
        return writer.toString();
    }

    public void encodeToWriter(Source in, Writer out) throws EncoderException {
        this.encodeToWriter(in, out, null);
    }

    public void encodeToWriter(Source in, Writer out, EncoderProperties properties) throws EncoderException {
        SAXResult result = new SAXResult(new MarshalHandler(this.mRootElement, out));
        try {
            this.mTransformer.transform(in, result);
            out.flush();
        }
        catch (TransformerException e) {
            throw new EncoderException((Throwable)e);
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    public EncoderProperties getProperties() {
        return this.mProperties;
    }

    public EncoderType getType() {
        return this.mType;
    }

    private void initCodings() throws XmlException {
        SchemaAnnotation anno = this.mRootElement.getAnnotation();
        if (anno == null) {
            return;
        }
        XmlObject[] xmlObjs = anno.getApplicationInformation();
        if (xmlObjs == null || xmlObjs.length == 0) {
            return;
        }
        Hl7Encoding hl7Encoding = null;
        for (int i = 0; i < xmlObjs.length; ++i) {
            XmlCursor cursor = xmlObjs[i].newCursor();
            String source = cursor.getAttributeText(APPINFO_SOURCE_ATTR);
            cursor.dispose();
            if (!ENCODER_NAMESPACE.equals(source)) continue;
            hl7Encoding = xmlObjs[i] instanceof Hl7Encoding ? (Hl7Encoding)xmlObjs[i] : Hl7Encoding.Factory.parse((String)xmlObjs[i].xmlText());
        }
        if (hl7Encoding == null) {
            return;
        }
        if (hl7Encoding.isSetPreDecodeCharCoding()) {
            this.mPreDecodeCharCoding = hl7Encoding.getPreDecodeCharCoding();
        }
        if (hl7Encoding.isSetPostEncodeCharCoding()) {
            this.mPostEncodeCharCoding = hl7Encoding.getPostEncodeCharCoding();
        }
    }
}

