/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.hl7.runtime.provider;

import com.sun.encoder.hl7.runtime.LexicalException;
import com.sun.encoder.hl7.runtime.provider.HL7CharEscapeCoder;
import com.sun.encoder.tools.xml.SchemaLocationAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.QNameSetBuilder;
import org.apache.xmlbeans.QNameSetSpecification;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class UnmarshalAdaptor
implements XMLReader {
    public static final String NS_URI_FOR_EXTENSIONS = "urn:com.sun.encoder.hl7.ns.extentions";
    private static final int DOCUMENT = 0;
    private static final int SEGMENT = 1;
    private static final int FIELD = 2;
    private static final int COMPONENT = 3;
    private static final int SUBCOMPONENT = 4;
    private static final int MAX_SEMANTIC_LEVELS = 5;
    private static final int MAX_MODEL_LEVELS = 50;
    private static final int KIND_SIMPLE = 1;
    private static final int KIND_ESCAPE = 2;
    private static final int KIND_VARIES = 4;
    private static final int KIND_COMPLEX = 8;
    private static final int KIND_ELEMENTARY = 7;
    private static final int DEFAULT_BUF_CAPACITY = 1024;
    private static final int MINIMUM_BUF_CAPACITY = 12;
    private static final int MAXIMUM_BUF_CAPACITY = 131072;
    private static final EmptyAttributes mEmptyAttributes = new EmptyAttributes();
    private static QNameSet mQNameSetForExtensions;
    private static int[] mDelimQualiMask;
    private static int[] mDelimEndMask;
    private static int[] mDelimType2Level;
    private final URL mSchemaLocation;
    private final SchemaGlobalElement mElement;
    private final int mBufferCapacity;
    private String mGroupNamePrefix;
    private EntityResolver mEntityResolver;
    private DTDHandler mDTDHandler;
    private ContentHandler mContentHandler;
    private ErrorHandler mErrorHandler;

    public UnmarshalAdaptor(URL schemaLocation, SchemaGlobalElement element) {
        this(schemaLocation, element, 1024);
    }

    public UnmarshalAdaptor(URL schemaLocation, SchemaGlobalElement element, int bufferCapacity) {
        if (element == null) {
            throw new NullPointerException("no global element.");
        }
        this.mSchemaLocation = schemaLocation;
        this.mElement = element;
        this.mBufferCapacity = bufferCapacity;
        this.mGroupNamePrefix = element.getName().getLocalPart() + ".";
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            return true;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            return false;
        }
        throw new SAXNotRecognizedException();
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/namespaces".equals(name)) {
            if (!value) {
                throw new SAXNotSupportedException("Feature '" + name + "' with value " + value + " is not supported.");
            }
            return;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(name)) {
            if (value) {
                throw new SAXNotSupportedException("Feature '" + name + "' with value " + value + " is not supported.");
            }
            return;
        }
        throw new SAXNotRecognizedException();
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.mEntityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this.mEntityResolver;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.mDTDHandler = handler;
    }

    public DTDHandler getDTDHandler() {
        return this.mDTDHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        this.mContentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this.mContentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.mErrorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this.mErrorHandler;
    }

    public String getGroupNamePrefix() {
        return this.mGroupNamePrefix;
    }

    public void setGroupNamePrefix(String groupNamePrefix) {
        this.mGroupNamePrefix = groupNamePrefix;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        if (this.mContentHandler == null) {
            throw new NullPointerException("Missing content handler.");
        }
        Lexer lexer = new Lexer(input, this.mBufferCapacity);
        this.mContentHandler.startDocument();
        this.mContentHandler.startPrefixMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.mContentHandler.startElement(this.mElement.getName().getNamespaceURI(), this.mElement.getName().getLocalPart(), this.mElement.getName().getLocalPart(), (Attributes)new SchemaLocationAttributes(this.mElement.getName().getNamespaceURI(), this.mSchemaLocation));
        ParsingState state = new ParsingState(this.mElement, this.mContentHandler, lexer, this.mGroupNamePrefix);
        state.mPublicId = input.getPublicId();
        state.mSystemId = input.getSystemId();
        state.mSemanticLevel = 0;
        state.mModelLevel = 0;
        state.mQNamePath[0] = this.mElement.getName();
        state.mPendingStartTagAt = -1;
        state.mMinFactor[state.mModelLevel] = 1;
        lexer.fillNextToken(state.mToken);
        if (state.mToken.mTokenType == 1) {
            state.mSegName = new String(state.mToken.mChars, state.mToken.mOffset, state.mToken.mCount);
        }
        UnmarshalAdaptor.parseParticle(this.mElement.getType().getContentModel(), state, 1);
        this.mContentHandler.endElement(this.mElement.getName().getNamespaceURI(), this.mElement.getName().getLocalPart(), this.mElement.getName().getLocalPart());
        this.mContentHandler.endPrefixMapping("xsi");
        this.mContentHandler.endDocument();
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean parseParticle(SchemaParticle particle, ParsingState state, int sequence) throws IOException, SAXException {
        if (state.mToken.mTokenType == 3) {
            return false;
        }
        switch (particle.getParticleType()) {
            case 4: {
                int i;
                if (state.mSemanticLevel > 1) {
                    int kind = UnmarshalAdaptor.whatKind(particle.getType());
                    if ((kind & 7) != 0) {
                        if (!state.mToken.mIsConsumed) {
                            int max = particle.getMaxOccurs() != null ? particle.getIntMaxOccurs() : Integer.MAX_VALUE;
                            int semLevel = state.mSemanticLevel;
                            int nonQualiConsumed = 0;
                            while (i < max && state.mToken.mTokenType == 2) {
                                if (nonQualiConsumed > 0) {
                                    if (state.mToken.mTokenType == 2 && state.mToken.mDelimType == 1) {
                                        state.mLexer.fillNextToken(state.mToken);
                                        continue;
                                    }
                                    if ((state.mToken.mDelimType & mDelimQualiMask[semLevel]) != 0) {
                                        nonQualiConsumed = 0;
                                        state.mToken.mIsConsumed = true;
                                    }
                                    if ((state.mToken.mDelimType & mDelimEndMask[semLevel]) != 0) break;
                                    UnmarshalAdaptor.forwardToken(state, semLevel);
                                    continue;
                                }
                                if ((state.mToken.mDelimType & mDelimQualiMask[semLevel]) == 0) {
                                    ++nonQualiConsumed;
                                }
                                if (state.mToken.mDelimType == 1 && state.mToken.mCount == 0) {
                                    state.mLexer.fillNextToken(state.mToken);
                                    if (state.mToken.mTokenType != 2 || (state.mToken.mDelimType & mDelimQualiMask[semLevel]) == 0) break;
                                    if (state.mToken.mDelimType == 1 && state.mToken.mCount == 0) {
                                        UnmarshalAdaptor.throwException("Consecutively no data read.", null, state);
                                    }
                                }
                                if (state.mToken.mCount > 0) {
                                    QName qName;
                                    if (state.mPendingStartTagAt >= 0) {
                                        for (int j = state.mPendingStartTagAt; j < state.mModelLevel; ++j) {
                                            qName = state.mQNamePath[j];
                                            state.mContentHandler.startElement(qName.getNamespaceURI(), qName.getLocalPart(), qName.getLocalPart(), mEmptyAttributes);
                                        }
                                        state.mPendingStartTagAt = -1;
                                    }
                                    qName = particle.getName();
                                    state.mContentHandler.startElement(qName.getNamespaceURI(), qName.getLocalPart(), qName.getLocalPart(), mEmptyAttributes);
                                    UnmarshalAdaptor.fireCharacters(state, false);
                                    state.mToken.mIsConsumed = true;
                                    while (state.mToken.mTokenType == 2 && state.mToken.mDelimType == 1) {
                                        state.mLexer.fillNextToken(state.mToken);
                                        if (state.mToken.mTokenType == 2) {
                                            UnmarshalAdaptor.fireCharacters(state, false);
                                        }
                                        state.mToken.mIsConsumed = true;
                                    }
                                    state.mContentHandler.endElement(qName.getNamespaceURI(), qName.getLocalPart(), qName.getLocalPart());
                                    ++i;
                                } else {
                                    state.mToken.mIsConsumed = true;
                                }
                                if ((state.mToken.mDelimType & mDelimEndMask[semLevel]) != 0) break;
                                UnmarshalAdaptor.forwardToken(state, semLevel);
                            }
                        }
                        if (i < particle.getIntMinOccurs() && state.mMinFactor[state.mModelLevel] > 0) {
                            UnmarshalAdaptor.throwException("Element: '" + particle.getName().getLocalPart() + "' must occur at least " + particle.getIntMinOccurs() + " time(s).", null, state);
                        }
                        while ((state.mToken.mDelimType & mDelimEndMask[state.mSemanticLevel]) == 0) {
                            UnmarshalAdaptor.forwardToken(state, state.mSemanticLevel);
                        }
                        UnmarshalAdaptor.forwardToken(state, state.mSemanticLevel);
                        if (i <= 0) return false;
                        return true;
                    }
                    if (state.mSemanticLevel != 4) return UnmarshalAdaptor.parsePseudoGroup(particle, state, sequence);
                    UnmarshalAdaptor.throwException("Sub component must have simple content.", null, state);
                } else {
                    int max;
                    if (state.mSemanticLevel != 0) throw new IllegalStateException("Illegal semantic level: " + state.mSemanticLevel);
                    if (particle.getName().getLocalPart().startsWith(state.mGroupPrefix)) {
                        return UnmarshalAdaptor.parsePseudoGroup(particle, state, sequence);
                    }
                    ++state.mSemanticLevel;
                    int n = max = particle.getMaxOccurs() != null ? particle.getIntMaxOccurs() : Integer.MAX_VALUE;
                    for (i = 0; i < max && state.mToken.mTokenType == 1 && particle.getName().getLocalPart().equals(state.mSegName); ++i) {
                        QName qName;
                        state.mMinFactor[state.mModelLevel] = 1;
                        if (state.mPendingStartTagAt >= 0) {
                            for (int j = state.mPendingStartTagAt; j < state.mModelLevel; ++j) {
                                qName = state.mQNamePath[j];
                                state.mContentHandler.startElement(qName.getNamespaceURI(), qName.getLocalPart(), qName.getLocalPart(), mEmptyAttributes);
                            }
                            state.mPendingStartTagAt = -1;
                        }
                        qName = particle.getName();
                        state.mContentHandler.startElement(qName.getNamespaceURI(), qName.getLocalPart(), qName.getLocalPart(), mEmptyAttributes);
                        state.mLexer.fillNextToken(state.mToken);
                        UnmarshalAdaptor.parseParticle(particle.getType().getContentModel(), state, sequence);
                        state.mContentHandler.endElement(qName.getNamespaceURI(), qName.getLocalPart(), qName.getLocalPart());
                        UnmarshalAdaptor.skipToNextSegment(state);
                    }
                    if (i < particle.getIntMinOccurs() && state.mMinFactor[state.mModelLevel] > 0) {
                        UnmarshalAdaptor.throwException("Segment: '" + particle.getName().getLocalPart() + "' must occur at least " + particle.getIntMinOccurs() + " time(s).", null, state);
                    }
                    --state.mSemanticLevel;
                    if (i <= 0) return false;
                    return true;
                }
            }
            case 3: {
                int seqChildCount = particle.countOfParticleChild();
                boolean seqResult = false;
                if (seqChildCount <= 0) return seqResult;
                boolean mSemanticLevelIncreased = false;
                if (state.mSemanticLevel != 0) {
                    ++state.mSemanticLevel;
                    mSemanticLevelIncreased = true;
                }
                ++state.mModelLevel;
                for (int j = 0; j < seqChildCount; ++j) {
                    state.mMinFactor[state.mModelLevel] = !seqResult && state.mMinFactor[state.mModelLevel - 1] == 0 ? 0 : 1;
                    boolean bl = seqResult = UnmarshalAdaptor.parseParticle(particle.getParticleChild(j), state, j + 1) || seqResult;
                    if (state.mToken.mIsConsumed) break;
                }
                --state.mModelLevel;
                if (!mSemanticLevelIncreased) return seqResult;
                --state.mSemanticLevel;
                return seqResult;
            }
            case 2: {
                int choiceChildCount = particle.countOfParticleChild();
                boolean choiceResult = false;
                if (choiceChildCount <= 0) return choiceResult;
                boolean mSemanticLevelIncreased = false;
                if (state.mSemanticLevel != 0) {
                    ++state.mSemanticLevel;
                    mSemanticLevelIncreased = true;
                }
                ++state.mModelLevel;
                state.mMinFactor[state.mModelLevel] = 0;
                for (int j = 0; j < choiceChildCount; ++j) {
                    if (UnmarshalAdaptor.parseParticle(particle.getParticleChild(j), state, j + 1)) {
                        choiceResult = true;
                        break;
                    }
                    if (state.mToken.mIsConsumed) break;
                }
                --state.mModelLevel;
                if (!mSemanticLevelIncreased) return choiceResult;
                --state.mSemanticLevel;
                return choiceResult;
            }
            case 1: {
                int j;
                int allChildCount = particle.countOfParticleChild();
                boolean allResult = false;
                if (allChildCount <= 0) return allResult;
                boolean mSemanticLevelIncreased = false;
                if (state.mSemanticLevel != 0) {
                    ++state.mSemanticLevel;
                    mSemanticLevelIncreased = true;
                }
                ++state.mModelLevel;
                state.mMinFactor[state.mModelLevel] = 0;
                boolean continueLoop = true;
                boolean[] found = new boolean[allChildCount];
                Arrays.fill(found, false);
                block15: for (j = 0; continueLoop && j < allChildCount; ++j) {
                    continueLoop = false;
                    for (int k = 0; k < allChildCount; ++k) {
                        if (UnmarshalAdaptor.parseParticle(particle.getParticleChild(k), state, k + 1)) {
                            if (found[k]) {
                                UnmarshalAdaptor.throwException("Token not expected.", null, state);
                            } else {
                                found[k] = true;
                            }
                            allResult = true;
                            continueLoop = true;
                            continue block15;
                        }
                        if (state.mToken.mIsConsumed) continue block15;
                    }
                }
                for (j = 0; j < allChildCount; ++j) {
                    if (!allResult || particle.getParticleChild(j).getIntMinOccurs() <= 0 || found[j]) continue;
                    UnmarshalAdaptor.throwException("Expected particle missing.", null, state);
                }
                --state.mModelLevel;
                if (!mSemanticLevelIncreased) return allResult;
                --state.mSemanticLevel;
                return allResult;
            }
            case 5: {
                return UnmarshalAdaptor.parseWildcard(particle, state, sequence);
            }
        }
        throw new IllegalStateException("Illegal particle type: " + particle.getParticleType());
    }

    private static boolean parsePseudoGroup(SchemaParticle element, ParsingState state, int sequence) throws IOException, SAXException {
        int i;
        int min = element.getIntMinOccurs();
        if (element.getMaxOccurs() != null) {
            int max = element.getIntMaxOccurs();
            for (i = 0; i < max; ++i) {
                if (state.mPendingStartTagAt == -1 || state.mPendingStartTagAt > state.mModelLevel) {
                    state.mPendingStartTagAt = state.mModelLevel;
                }
                state.mQNamePath[state.mModelLevel] = element.getName();
                if (i >= min) {
                    state.mMinFactor[state.mModelLevel] = 0;
                }
                SchemaParticle subModel = element.getType().getContentModel();
                boolean levelIncreased = false;
                if (subModel.getParticleType() == 4 || subModel.getParticleType() == 5) {
                    ++state.mModelLevel;
                    levelIncreased = true;
                }
                boolean result = UnmarshalAdaptor.parseParticle(subModel, state, sequence);
                if (levelIncreased) {
                    --state.mModelLevel;
                }
                if (!result) break;
                state.mContentHandler.endElement(element.getName().getNamespaceURI(), element.getName().getLocalPart(), element.getName().getLocalPart());
                if (state.mSemanticLevel <= 1) continue;
                if ((state.mToken.mDelimType & mDelimEndMask[state.mSemanticLevel]) == 0) {
                    UnmarshalAdaptor.forwardToken(state, state.mSemanticLevel);
                    continue;
                }
                break;
            }
        } else {
            while (true) {
                if (state.mPendingStartTagAt == -1 || state.mPendingStartTagAt > state.mModelLevel) {
                    state.mPendingStartTagAt = state.mModelLevel;
                }
                state.mQNamePath[state.mModelLevel] = element.getName();
                if (i >= min) {
                    state.mMinFactor[state.mModelLevel] = 0;
                }
                SchemaParticle subModel = element.getType().getContentModel();
                boolean levelIncreased = false;
                if (subModel.getParticleType() == 4 || subModel.getParticleType() == 5) {
                    ++state.mModelLevel;
                    levelIncreased = true;
                }
                boolean result = UnmarshalAdaptor.parseParticle(subModel, state, sequence);
                if (levelIncreased) {
                    --state.mModelLevel;
                }
                if (!result) break;
                state.mContentHandler.endElement(element.getName().getNamespaceURI(), element.getName().getLocalPart(), element.getName().getLocalPart());
                ++i;
                if (state.mSemanticLevel <= 1) continue;
                if ((state.mToken.mDelimType & mDelimEndMask[state.mSemanticLevel]) != 0) break;
                UnmarshalAdaptor.forwardToken(state, state.mSemanticLevel);
            }
        }
        if (i < element.getIntMinOccurs() && state.mMinFactor[state.mModelLevel] > 0) {
            UnmarshalAdaptor.throwException("'" + element.getName().getLocalPart() + "' must occur at least " + element.getIntMinOccurs() + " time(s).", null, state);
        }
        UnmarshalAdaptor.forwardToken(state, state.mSemanticLevel);
        return i > 0;
    }

    private static void forwardToken(ParsingState state, int semanticLevel) throws IOException, LexicalException {
        if (state.mToken.mTokenType == 2 && mDelimType2Level[state.mToken.mDelimType] >= semanticLevel) {
            state.mLexer.fillNextToken(state.mToken);
        }
    }

    private static void skipToNextSegment(ParsingState state) throws IOException, LexicalException, SAXException {
        while (state.mLexer.fillNextToken(state.mToken) && state.mToken.mTokenType != 3 && state.mToken.mTokenType != 1) {
        }
        if (state.mToken.mTokenType == 1) {
            if (state.mToken.mDelimType == 1) {
                state.mStringBuffer.setLength(0);
                state.mStringBuffer.append(state.mToken.mChars, state.mToken.mOffset, state.mToken.mCount);
                state.mLexer.fillNextToken(state.mToken);
                if (state.mToken.mTokenType != 1 || state.mToken.mDelimType != 4) {
                    UnmarshalAdaptor.throwException("Failed to read segment name", null, state);
                }
                state.mStringBuffer.append(state.mToken.mChars, state.mToken.mOffset, state.mToken.mCount);
                state.mSegName = state.mStringBuffer.toString();
            } else {
                state.mSegName = new String(state.mToken.mChars, state.mToken.mOffset, state.mToken.mCount);
            }
        }
    }

    private static boolean parseWildcard(SchemaParticle wildcard, ParsingState state, int sequence) throws IOException, SAXException {
        switch (state.mSemanticLevel) {
            case 0: {
                int i = 0;
                while (state.mToken.mTokenType == 1) {
                    if (state.mPendingStartTagAt >= 0) {
                        for (int j = state.mPendingStartTagAt; j < state.mModelLevel; ++j) {
                            state.mContentHandler.startElement(state.mQNamePath[j].getNamespaceURI(), state.mQNamePath[j].getLocalPart(), state.mQNamePath[j].getLocalPart(), mEmptyAttributes);
                        }
                        state.mPendingStartTagAt = -1;
                    }
                    SchemaGlobalElement[] element = new SchemaGlobalElement[1];
                    QName qName = UnmarshalAdaptor.crackOutWildcardElement(wildcard, state.mSegName, state.mRootElement.getTypeSystem(), element);
                    if (qName == null) {
                        UnmarshalAdaptor.throwException("Unable to construct a qualified name for: '" + state.mSegName + "'", null, state);
                    }
                    state.mLexer.fillNextToken(state.mToken);
                    state.mContentHandler.startElement(qName.getNamespaceURI(), qName.getLocalPart(), qName.getLocalPart(), mEmptyAttributes);
                    ++state.mSemanticLevel;
                    if (element[0] != null) {
                        UnmarshalAdaptor.parseParticle(element[0].getType().getContentModel(), state, sequence);
                    } else {
                        UnmarshalAdaptor.processWildcardFields(state, sequence);
                    }
                    --state.mSemanticLevel;
                    state.mContentHandler.endElement(qName.getNamespaceURI(), qName.getLocalPart(), qName.getLocalPart());
                    UnmarshalAdaptor.skipToNextSegment(state);
                    ++i;
                }
                if (i < wildcard.getIntMinOccurs() && state.mMinFactor[state.mModelLevel] > 0) {
                    UnmarshalAdaptor.throwException("Wildcard segment must occur at least " + wildcard.getIntMinOccurs() + " time(s).", null, state);
                }
                return i > 0;
            }
            case 2: 
            case 3: 
            case 4: {
                return UnmarshalAdaptor.processWildcardFields(state, sequence);
            }
        }
        throw new IllegalStateException("Illegal semantic level: " + state.mSemanticLevel);
    }

    private static boolean processWildcardFields(ParsingState state, int sequence) throws IOException, SAXException {
        if (state.mToken.mTokenType != 2 || state.mToken.mIsConsumed) {
            return false;
        }
        Object[] pendingEndTag = new QName[5];
        Arrays.fill(pendingEndTag, null);
        int curLevel = state.mSemanticLevel;
        if (curLevel < 2) {
            curLevel = 2;
        }
        int seenLevel = -1;
        int fieldIndex = 0;
        int fieldRepetIndex = -1;
        int compoIndex = 0;
        int subCompoIndex = 0;
        switch (state.mSemanticLevel) {
            case 1: {
                fieldIndex = 0;
                compoIndex = 0;
                subCompoIndex = 0;
                break;
            }
            case 2: {
                fieldIndex = sequence - 1;
                compoIndex = 0;
                subCompoIndex = 0;
                break;
            }
            case 3: {
                compoIndex = sequence - 1;
                subCompoIndex = 0;
                break;
            }
            case 4: {
                subCompoIndex = sequence - 1;
            }
        }
        while (state.mToken.mTokenType == 2) {
            int j;
            boolean useBuffer = false;
            state.mStringBuffer.setLength(0);
            while (state.mToken.mDelimType == 1 && state.mToken.mTokenType == 2) {
                state.mStringBuffer.append(state.mToken.mChars, state.mToken.mOffset, state.mToken.mCount);
                state.mLexer.fillNextToken(state.mToken);
                useBuffer = true;
            }
            if (state.mToken.mTokenType != 2) break;
            if (state.mToken.mDelimType == 4 && fieldRepetIndex == -1) {
                fieldRepetIndex = 0;
            }
            if (curLevel <= (seenLevel = mDelimType2Level[state.mToken.mDelimType])) {
                for (j = curLevel; j <= seenLevel; ++j) {
                    switch (j) {
                        case 2: {
                            if (state.mToken.mDelimType == 8) {
                                fieldRepetIndex = fieldRepetIndex == -1 ? 1 : ++fieldRepetIndex;
                            }
                            state.mStringBuffer2.setLength(0);
                            state.mStringBuffer2.append("fld");
                            state.mStringBuffer2.append(++fieldIndex);
                            if (fieldRepetIndex == -1) break;
                            state.mStringBuffer2.append('_');
                            state.mStringBuffer2.append(++fieldRepetIndex);
                            break;
                        }
                        case 3: {
                            state.mStringBuffer2.setLength(0);
                            state.mStringBuffer2.append("com");
                            state.mStringBuffer2.append(++compoIndex);
                            break;
                        }
                        case 4: {
                            state.mStringBuffer2.setLength(0);
                            state.mStringBuffer2.append("sub");
                            state.mStringBuffer2.append(++subCompoIndex);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Illegal semantic level: " + j);
                        }
                    }
                    pendingEndTag[j] = new QName(NS_URI_FOR_EXTENSIONS, state.mStringBuffer2.toString());
                    state.mContentHandler.startElement(((QName)pendingEndTag[j]).getNamespaceURI(), ((QName)pendingEndTag[j]).getLocalPart(), ((QName)pendingEndTag[j]).getLocalPart(), mEmptyAttributes);
                }
                UnmarshalAdaptor.fireCharacters(state, useBuffer);
                state.mToken.mIsConsumed = true;
                state.mContentHandler.endElement(((QName)pendingEndTag[seenLevel]).getNamespaceURI(), ((QName)pendingEndTag[seenLevel]).getLocalPart(), ((QName)pendingEndTag[seenLevel]).getLocalPart());
                pendingEndTag[seenLevel] = null;
            } else {
                switch (curLevel) {
                    case 2: {
                        if (state.mToken.mDelimType == 8) {
                            fieldRepetIndex = fieldRepetIndex == -1 ? 1 : ++fieldRepetIndex;
                        }
                        state.mStringBuffer2.setLength(0);
                        state.mStringBuffer2.append("fld");
                        state.mStringBuffer2.append(++fieldIndex);
                        if (fieldRepetIndex == -1) break;
                        state.mStringBuffer2.append('_');
                        state.mStringBuffer2.append(++fieldRepetIndex);
                        break;
                    }
                    case 3: {
                        state.mStringBuffer2.setLength(0);
                        state.mStringBuffer2.append("com");
                        state.mStringBuffer2.append(++compoIndex);
                        break;
                    }
                    case 4: {
                        state.mStringBuffer2.setLength(0);
                        state.mStringBuffer2.append("sub");
                        state.mStringBuffer2.append(++subCompoIndex);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Illegal semantic level: " + curLevel);
                    }
                }
                if (pendingEndTag[curLevel] == null) {
                    pendingEndTag[curLevel] = new QName(NS_URI_FOR_EXTENSIONS, state.mStringBuffer2.toString());
                    state.mContentHandler.startElement(((QName)pendingEndTag[curLevel]).getNamespaceURI(), ((QName)pendingEndTag[curLevel]).getLocalPart(), ((QName)pendingEndTag[curLevel]).getLocalPart(), mEmptyAttributes);
                }
                UnmarshalAdaptor.fireCharacters(state, useBuffer);
                state.mToken.mIsConsumed = true;
                state.mContentHandler.endElement(((QName)pendingEndTag[curLevel]).getNamespaceURI(), ((QName)pendingEndTag[curLevel]).getLocalPart(), ((QName)pendingEndTag[curLevel]).getLocalPart());
                pendingEndTag[curLevel] = null;
                for (j = curLevel - 1; j >= seenLevel; --j) {
                    if (pendingEndTag[j] == null) continue;
                    state.mContentHandler.endElement(((QName)pendingEndTag[j]).getNamespaceURI(), ((QName)pendingEndTag[j]).getLocalPart(), ((QName)pendingEndTag[j]).getLocalPart());
                    pendingEndTag[j] = null;
                }
            }
            curLevel = seenLevel;
            if ((state.mToken.mDelimType & mDelimEndMask[state.mSemanticLevel]) != 0) break;
            state.mLexer.fillNextToken(state.mToken);
        }
        if (curLevel < 2) {
            curLevel = 2;
        }
        UnmarshalAdaptor.forwardToken(state, curLevel);
        return true;
    }

    private static QName crackOutWildcardElement(SchemaParticle wildcard, String localName, SchemaTypeSystem ts, SchemaGlobalElement[] matchedElement) {
        QName qName;
        QNameSet qnSet = wildcard.getWildcardSet();
        if (qnSet.containsAll((QNameSetSpecification)mQNameSetForExtensions)) {
            matchedElement[0] = null;
            return new QName(NS_URI_FOR_EXTENSIONS, localName);
        }
        if (qnSet.includedURIs() == null) {
            return null;
        }
        SchemaGlobalElement element = null;
        Iterator iter = qnSet.includedURIs().iterator();
        while (iter.hasNext() && (element = ts.findElement(qName = new QName((String)iter.next(), localName))) == null) {
        }
        if (element != null) {
            matchedElement[0] = element;
            return element.getName();
        }
        return null;
    }

    private static int whatKind(SchemaType XMLType) {
        if (XMLType.isSimpleType() || XMLType.getContentType() == 2) {
            return 1;
        }
        if (XMLType.getContentType() == 4) {
            return 2;
        }
        if (XMLType.isURType()) {
            return 4;
        }
        return 8;
    }

    private static void fireCharacters(ParsingState state, boolean useBuffer) throws SAXException {
        HL7CharEscapeCoder coder = state.mLexer.mEscapeCoder;
        if (useBuffer) {
            if (state.mChars == null || state.mChars.length < state.mStringBuffer.length()) {
                state.mChars = new char[state.mStringBuffer.length()];
            }
            state.mStringBuffer.getChars(0, state.mStringBuffer.length(), state.mChars, 0);
            if (coder != null && state.mToken.mHasEscape) {
                coder.unescape(state.mChars, 0, state.mStringBuffer.length(), true);
                UnmarshalAdaptor.fireCoderResult(coder, state);
            } else {
                state.mContentHandler.characters(state.mChars, 0, state.mStringBuffer.length());
            }
        } else if (coder != null && state.mToken.mHasEscape) {
            coder.unescape(state.mToken.mChars, state.mToken.mOffset, state.mToken.mCount, state.mToken.mDelimType != 1);
            UnmarshalAdaptor.fireCoderResult(coder, state);
        } else {
            state.mContentHandler.characters(state.mToken.mChars, state.mToken.mOffset, state.mToken.mCount);
        }
    }

    private static void fireCoderResult(HL7CharEscapeCoder coder, ParsingState state) throws SAXException {
        while (coder.hasResult()) {
            HL7CharEscapeCoder.Result res = coder.getResult();
            switch (res.mType) {
                case 1: {
                    state.mContentHandler.characters(res.mData, res.mStart, res.mCount);
                    break;
                }
                case 2: {
                    if (state.mEspAttr == null) {
                        state.mEspAttr = new EscapeAttributes();
                    }
                    state.mEspAttr.setValue(0, new String(res.mData, res.mStart, res.mCount));
                    state.mContentHandler.startPrefixMapping("", "");
                    state.mContentHandler.startElement("", "escape", "escape", state.mEspAttr);
                    state.mContentHandler.endElement("", "escape", "escape");
                    state.mContentHandler.endPrefixMapping("");
                }
            }
        }
    }

    private static void throwException(String msg, Exception cause, ParsingState state) throws SAXException {
        throw new SAXParseException(msg, new LocatorImpl(state), cause);
    }

    static {
        QNameSetBuilder qnSetBuilder = new QNameSetBuilder();
        qnSetBuilder.addNamespace(NS_URI_FOR_EXTENSIONS);
        mQNameSetForExtensions = qnSetBuilder.toQNameSet();
        mDelimQualiMask = new int[5];
        mDelimEndMask = new int[5];
        UnmarshalAdaptor.mDelimEndMask[1] = 2;
        UnmarshalAdaptor.mDelimQualiMask[2] = 15;
        UnmarshalAdaptor.mDelimEndMask[2] = 6;
        UnmarshalAdaptor.mDelimQualiMask[3] = 31;
        UnmarshalAdaptor.mDelimEndMask[3] = 30;
        UnmarshalAdaptor.mDelimQualiMask[4] = 63;
        UnmarshalAdaptor.mDelimEndMask[4] = 62;
        mDelimType2Level = new int[33];
        Arrays.fill(mDelimType2Level, -1);
        UnmarshalAdaptor.mDelimType2Level[2] = 1;
        UnmarshalAdaptor.mDelimType2Level[4] = 2;
        UnmarshalAdaptor.mDelimType2Level[8] = 2;
        UnmarshalAdaptor.mDelimType2Level[16] = 3;
        UnmarshalAdaptor.mDelimType2Level[32] = 4;
    }

    static final class Lexer {
        private static final int MSH_FIELD_SEP = 1;
        private static final int MSH_ENCODING_CHAR = 2;
        private static final int NOT_STARTED = 0;
        private static final int SEG_END = 1;
        private static final int SEG_NAME_READ = 2;
        private static final int SEG_NAME_READ_EOF = 3;
        private static final int EOF = 4;
        private static final int MSH_SEG = 0;
        private static final int NORM_SEG = 1;
        private static final int DELIM_UNKNOWN = -1;
        private static final int MULTIPLE_HIT = -2;
        private static final int SEG_NAME_SIZE = 3;
        private final Reader mReader;
        private final int mBufCapacity;
        private final char[] mRawCharBuf;
        public HL7CharEscapeCoder mEscapeCoder;
        private char mSegDelim = (char)13;
        private char mFieldSep = (char)124;
        private char mCompoSep = (char)94;
        private char mRepetSep = (char)126;
        private char mEscape = (char)92;
        private char mSubCompoSep = (char)38;
        private int[] mDelimChar = new int[256];
        private int mState = 0;
        private int mFieldSequence = -1;
        private int mSegType = -1;
        private int mRawPos = 0;
        private int mBufLimit = -1;
        private int mLine = 1;
        private int mCol = 1;
        private boolean mLoadBuf;

        public Lexer(InputSource input) throws IOException {
            this(input, 1024);
        }

        public Lexer(InputSource input, int bufCapacity) throws IOException {
            if (bufCapacity < 12 || bufCapacity > 131072) {
                throw new IllegalArgumentException("Buffer capacity must be in range of [12, 131072] bytes.");
            }
            this.mBufCapacity = bufCapacity;
            this.mRawCharBuf = new char[this.mBufCapacity];
            if (input.getCharacterStream() == null) {
                InputStream stream = input.getByteStream();
                if (stream == null) {
                    throw new IllegalArgumentException("No reader and no input stream.");
                }
                this.mReader = input.getEncoding() != null ? new InputStreamReader(stream, input.getEncoding()) : new InputStreamReader(stream, "ASCII");
            } else {
                this.mReader = input.getCharacterStream();
            }
            Arrays.fill(this.mDelimChar, 0);
            this.mBufLimit = this.mReader.read(this.mRawCharBuf);
            if (this.mBufLimit == -1) {
                this.mState = 4;
            }
            this.mLoadBuf = false;
        }

        /*
         * Enabled aggressive block sorting
         */
        public final boolean fillNextToken(Token token) throws IOException, LexicalException {
            token.mIsConsumed = false;
            token.mHasEscape = false;
            if (this.mState == 4) {
                token.mTokenType = 3;
                token.mDelimType = 2;
                return false;
            }
            if (this.mRawPos > this.mBufLimit) {
                throw new IllegalStateException("mRawPos (" + this.mRawPos + ") cannot be greater than mBufLimit (" + this.mBufLimit);
            }
            if (!this.mLoadBuf && this.mRawPos == this.mBufLimit) {
                this.mLoadBuf = true;
            }
            if (this.mLoadBuf) {
                this.mLoadBuf = false;
                int remain = this.mBufLimit - this.mRawPos;
                if (remain != 0) {
                    System.arraycopy(this.mRawCharBuf, this.mRawPos, this.mRawCharBuf, 0, remain);
                    this.mBufLimit = this.mReader.read(this.mRawCharBuf, remain, this.mBufCapacity - remain);
                    if (this.mBufLimit == -1) {
                        this.mState = 3;
                        this.mBufLimit = remain;
                    } else {
                        this.mBufLimit += remain;
                    }
                } else {
                    this.mBufLimit = this.mReader.read(this.mRawCharBuf);
                    if (this.mBufLimit == -1) {
                        this.mState = 4;
                        token.mTokenType = 3;
                        token.mDelimType = 2;
                        return false;
                    }
                }
                this.mRawPos = 0;
            }
            switch (this.mState) {
                case 2: 
                case 3: {
                    char c;
                    int nextRawPos;
                    int nextCol;
                    if (this.mSegType == 0) {
                        switch (this.mFieldSequence) {
                            case 1: {
                                this.mFieldSep = this.mRawCharBuf[this.mRawPos];
                                token.mChars = this.mRawCharBuf;
                                token.mOffset = this.mRawPos;
                                token.mCount = 1;
                                token.mDelimType = 4;
                                token.mLexerPos = this.mRawPos++;
                                token.mTokenType = 2;
                                token.mLine = this.mLine;
                                token.mCol = this.mCol++;
                                token.mToBeContinued = false;
                                ++this.mFieldSequence;
                                return true;
                            }
                            case 2: {
                                nextCol = this.mCol;
                                int i = 0;
                                block24: for (nextRawPos = this.mRawPos; nextRawPos < this.mBufLimit && (c = this.mRawCharBuf[nextRawPos]) != this.mFieldSep; ++nextRawPos, ++i, ++nextCol) {
                                    switch (i) {
                                        case 0: {
                                            this.mCompoSep = c;
                                            continue block24;
                                        }
                                        case 1: {
                                            this.mRepetSep = c;
                                            continue block24;
                                        }
                                        case 2: {
                                            this.mEscape = c;
                                            continue block24;
                                        }
                                        case 3: {
                                            this.mSubCompoSep = c;
                                            continue block24;
                                        }
                                    }
                                }
                                if (nextRawPos < this.mBufLimit) {
                                    this.mDelimChar[this.mSegDelim & 0xFF] = 2;
                                    this.mDelimChar[this.mFieldSep & 0xFF] = this.mDelimChar[this.mFieldSep & 0xFF] != 0 ? -2 : 4;
                                    this.mDelimChar[this.mCompoSep & 0xFF] = this.mDelimChar[this.mCompoSep & 0xFF] != 0 ? -2 : 16;
                                    this.mDelimChar[this.mRepetSep & 0xFF] = this.mDelimChar[this.mRepetSep & 0xFF] != 0 ? -2 : 8;
                                    this.mDelimChar[this.mSubCompoSep & 0xFF] = this.mDelimChar[this.mSubCompoSep & 0xFF] != 0 ? -2 : 32;
                                    this.mDelimChar[this.mEscape & 0xFF] = this.mDelimChar[this.mEscape & 0xFF] != 0 ? -2 : 64;
                                    this.mEscapeCoder = new HL7CharEscapeCoder(this.mFieldSep, this.mCompoSep, this.mSubCompoSep, this.mRepetSep, this.mEscape);
                                    token.mChars = this.mRawCharBuf;
                                    token.mOffset = this.mRawPos;
                                    token.mCount = i;
                                    token.mDelimType = 4;
                                    token.mLexerPos = this.mRawPos;
                                    token.mTokenType = 2;
                                    token.mLine = this.mLine;
                                    token.mCol = this.mCol;
                                    token.mToBeContinued = false;
                                    this.mRawPos = nextRawPos + 1;
                                    this.mCol = nextCol + 1;
                                    ++this.mFieldSequence;
                                    return true;
                                }
                                this.throwLexException("Missing field separator.", this.mLine, this.mCol + 4, 1, this.mRawPos + 4);
                                break;
                            }
                        }
                    }
                    nextRawPos = this.mRawPos;
                    nextCol = this.mCol;
                    int delimType = -1;
                    block25: while (nextRawPos < this.mBufLimit) {
                        int ci = this.mRawCharBuf[nextRawPos] & 0xFF;
                        if (this.mDelimChar[ci] != 0) {
                            delimType = this.mDelimChar[ci];
                            switch (delimType) {
                                case 4: {
                                    if (this.mRawCharBuf[nextRawPos] != this.mFieldSep) break;
                                    break block25;
                                }
                                case 16: {
                                    if (this.mRawCharBuf[nextRawPos] != this.mCompoSep) break;
                                    break block25;
                                }
                                case 8: {
                                    if (this.mRawCharBuf[nextRawPos] != this.mRepetSep) break;
                                    break block25;
                                }
                                case 32: {
                                    if (this.mRawCharBuf[nextRawPos] != this.mSubCompoSep) break;
                                    break block25;
                                }
                                case 2: {
                                    if (this.mRawCharBuf[nextRawPos] != this.mSegDelim) break;
                                    break block25;
                                }
                                case 64: {
                                    if (this.mRawCharBuf[nextRawPos] == this.mEscape) {
                                        token.mHasEscape = true;
                                    }
                                    ++nextRawPos;
                                    ++nextCol;
                                    continue block25;
                                }
                                case -2: {
                                    c = this.mRawCharBuf[nextRawPos];
                                    if (c == this.mFieldSep) {
                                        delimType = 4;
                                        break block25;
                                    }
                                    if (c == this.mCompoSep) {
                                        delimType = 16;
                                        break block25;
                                    }
                                    if (c == this.mRepetSep) {
                                        delimType = 8;
                                        break block25;
                                    }
                                    if (c == this.mSubCompoSep) {
                                        delimType = 32;
                                        break block25;
                                    }
                                    if (c != this.mSegDelim) break;
                                    delimType = 2;
                                    break block25;
                                }
                            }
                        }
                        ++nextRawPos;
                        ++nextCol;
                    }
                    if (nextRawPos < this.mBufLimit) {
                        if (!$assertionsDisabled) {
                            if (delimType == -1) throw new AssertionError();
                            if (delimType == -2) throw new AssertionError();
                            if (delimType == 1) {
                                throw new AssertionError();
                            }
                        }
                        token.mChars = this.mRawCharBuf;
                        token.mOffset = this.mRawPos;
                        token.mCount = nextRawPos - this.mRawPos;
                        token.mDelimType = delimType;
                        token.mLexerPos = this.mRawPos;
                        token.mTokenType = 2;
                        token.mLine = this.mLine++;
                        token.mCol = this.mCol;
                        token.mToBeContinued = false;
                        this.mRawPos = nextRawPos + 1;
                        if (delimType == 2) {
                            this.mCol = 1;
                            this.mFieldSequence = 1;
                            this.mState = 1;
                            return true;
                        }
                        if (delimType == 4) {
                            ++this.mFieldSequence;
                        }
                        this.mCol = nextCol + 1;
                        return true;
                    }
                    token.mChars = this.mRawCharBuf;
                    token.mOffset = this.mRawPos;
                    token.mCount = nextRawPos - this.mRawPos;
                    if (this.mState == 3) {
                        token.mDelimType = 2;
                        this.mState = 4;
                    } else {
                        token.mDelimType = 1;
                    }
                    token.mLexerPos = this.mRawPos;
                    token.mTokenType = 2;
                    token.mLine = this.mLine;
                    token.mCol = this.mCol;
                    token.mToBeContinued = true;
                    this.mRawPos = nextRawPos;
                    this.mCol = nextCol;
                    return true;
                }
                case 1: {
                    char c;
                    int i;
                    int nextRawPos = this.mRawPos;
                    int nextCol = this.mCol;
                    for (i = 0; nextRawPos < this.mBufLimit && i <= 3 && (c = this.mRawCharBuf[nextRawPos]) != this.mFieldSep; ++nextRawPos, ++i, ++nextCol) {
                    }
                    if (i > 3) {
                        this.throwLexException("Segment name cannot be more than 3 characters.", this.mLine, this.mCol, 4, this.mRawPos);
                    }
                    token.mChars = this.mRawCharBuf;
                    token.mOffset = this.mRawPos;
                    token.mCount = i;
                    token.mLexerPos = this.mRawPos;
                    token.mTokenType = 1;
                    token.mLine = this.mLine;
                    token.mCol = this.mCol;
                    if (nextRawPos < this.mBufLimit) {
                        token.mDelimType = 4;
                        token.mToBeContinued = false;
                        this.mState = 2;
                        this.mSegType = 1;
                        this.mRawPos = nextRawPos + 1;
                        this.mCol = nextCol + 1;
                        return true;
                    }
                    this.mLoadBuf = true;
                    token.mDelimType = 1;
                    token.mToBeContinued = true;
                    this.mRawPos = nextRawPos;
                    this.mCol = nextCol;
                    return true;
                }
                case 0: {
                    int nextRawPos = this.mRawPos + 3;
                    if (nextRawPos > this.mBufLimit) {
                        this.throwLexException("Incomplete segment name: '" + new String(this.mRawCharBuf, 0, this.mBufLimit) + "'", this.mLine, this.mCol, this.mBufLimit, this.mBufLimit);
                    }
                    token.mChars = this.mRawCharBuf;
                    token.mOffset = 0;
                    token.mCount = 3;
                    token.mDelimType = 4;
                    token.mLexerPos = 0;
                    token.mTokenType = 1;
                    token.mLine = this.mLine;
                    token.mCol = this.mCol;
                    token.mToBeContinued = false;
                    this.mFieldSequence = 1;
                    this.mSegType = 0;
                    this.mState = 2;
                    this.mRawPos += 3;
                    this.mCol += 3;
                    return true;
                }
            }
            throw new IllegalStateException("Illegal State = " + this.mState);
        }

        private void throwLexException(String msg, int line, int col, int count, int pos) throws LexicalException {
            throw new LexicalException(msg, line, col, count);
        }
    }

    public static final class Token {
        public static final int SEG_NAME = 1;
        public static final int VALUE = 2;
        public static final int EOF = 3;
        public static final int DELIM_NOT_READ = 1;
        public static final int SEG_TERM = 2;
        public static final int FIELD_SEP = 4;
        public static final int REPET_SEP = 8;
        public static final int COMPO_SEP = 16;
        public static final int SUBCOMPO_SEP = 32;
        public static final int ESCAPE_CHAR = 64;
        public int mTokenType;
        public char[] mChars;
        public int mOffset;
        public int mCount;
        public int mDelimType;
        public int mLine;
        public int mCol;
        public int mLexerPos;
        public boolean mToBeContinued;
        public boolean mHasEscape;
        public boolean mIsConsumed;
    }

    private static final class EmptyAttributes
    implements Attributes {
        private EmptyAttributes() {
        }

        public int getLength() {
            return 0;
        }

        public String getURI(int index) {
            return null;
        }

        public String getLocalName(int index) {
            return null;
        }

        public String getQName(int index) {
            return null;
        }

        public String getType(int index) {
            return null;
        }

        public String getValue(int index) {
            return null;
        }

        public int getIndex(String uri, String localName) {
            return -1;
        }

        public int getIndex(String qName) {
            return -1;
        }

        public String getType(String uri, String localName) {
            return null;
        }

        public String getType(String qName) {
            return null;
        }

        public String getValue(String uri, String localName) {
            return null;
        }

        public String getValue(String qName) {
            return null;
        }
    }

    private static final class EscapeAttributes
    implements Attributes {
        private String mValue;

        private EscapeAttributes() {
        }

        public int getLength() {
            return 1;
        }

        public String getURI(int index) {
            if (index == 0) {
                return "";
            }
            return null;
        }

        public String getLocalName(int index) {
            if (index == 0) {
                return "V";
            }
            return null;
        }

        public String getQName(int index) {
            if (index == 0) {
                return "V";
            }
            return null;
        }

        public String getType(int index) {
            if (index == 0) {
                return "CDATA";
            }
            return null;
        }

        public String getValue(int index) {
            if (index == 0) {
                return this.mValue;
            }
            return null;
        }

        public int getIndex(String uri, String localName) {
            if (uri == null && "V".equals(localName)) {
                return 0;
            }
            return -1;
        }

        public int getIndex(String qName) {
            if ("V".equals(qName)) {
                return 0;
            }
            return -1;
        }

        public String getType(String uri, String localName) {
            if (uri == null && "V".equals(localName)) {
                return "CDATA";
            }
            return null;
        }

        public String getType(String qName) {
            if ("V".equals(qName)) {
                return "CDATA";
            }
            return null;
        }

        public String getValue(String uri, String localName) {
            if (uri == null && "V".equals(localName)) {
                return this.mValue;
            }
            return null;
        }

        public String getValue(String qName) {
            if ("V".equals(qName)) {
                return this.mValue;
            }
            return null;
        }

        public void setValue(int index, String value) {
            if (index == 0) {
                this.mValue = value;
            }
        }
    }

    private static class LocatorImpl
    implements Locator {
        private final ParsingState mState;

        public LocatorImpl(ParsingState state) {
            this.mState = state;
        }

        public String getPublicId() {
            return this.mState.mPublicId;
        }

        public String getSystemId() {
            return this.mState.mSystemId;
        }

        public int getLineNumber() {
            return this.mState.mToken != null ? this.mState.mToken.mLine : -1;
        }

        public int getColumnNumber() {
            return this.mState.mToken != null ? this.mState.mToken.mCol : -1;
        }
    }

    private static class ParsingState {
        public final SchemaGlobalElement mRootElement;
        public final Token mToken;
        public final Lexer mLexer;
        public final ContentHandler mContentHandler;
        public final StringBuffer mStringBuffer = new StringBuffer();
        public final StringBuffer mStringBuffer2 = new StringBuffer();
        public final String mGroupPrefix;
        public int mModelLevel;
        public QName[] mQNamePath = new QName[50];
        public int mSemanticLevel;
        public int[] mMinFactor = new int[50];
        public int mPendingStartTagAt;
        public String mPublicId;
        public String mSystemId;
        public String mSegName;
        public char[] mChars;
        public EscapeAttributes mEspAttr;

        public ParsingState(SchemaGlobalElement root, ContentHandler handler, Lexer lexer, String groupPrefix) {
            this.mRootElement = root;
            this.mToken = new Token();
            this.mContentHandler = handler;
            this.mLexer = lexer;
            this.mGroupPrefix = groupPrefix;
        }
    }
}

