/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.instruments;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoView;
import com.nwoods.jgo.instruments.AbstractGraduatedScale;
import com.nwoods.jgo.instruments.AbstractIndicator;
import com.nwoods.jgo.instruments.GraduatedScale;
import com.nwoods.jgo.instruments.Phase;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class IndicatorBar
extends AbstractIndicator {
    public static final int ChangedThickness = 13400;
    public static final int ChangedStartOffset = 13401;
    public static final int InsertedPhase = 13402;
    public static final int RemovedPhase = 13403;
    public static final int ReplacedPhase = 13404;
    private static final float g = 3.0f;
    private float e = 10.0f;
    private Dimension f = new Dimension(0, 0);
    private ArrayList d = null;

    public JGoObject copyObject(JGoCopyEnvironment jGoCopyEnvironment) {
        IndicatorBar indicatorBar = (IndicatorBar)super.copyObject(jGoCopyEnvironment);
        indicatorBar.e = this.e;
        indicatorBar.f.width = this.f.width;
        indicatorBar.f.height = this.f.height;
        if (this.d != null) {
            indicatorBar.d = new ArrayList();
            for (int i = 0; i < this.d.size(); ++i) {
                Phase phase = (Phase)this.d.get(i);
                indicatorBar.d.add(new Phase(phase.getMin(), phase.getMax(), phase.getColor()));
            }
        }
        return indicatorBar;
    }

    public float getThickness() {
        return this.e;
    }

    public void setThickness(float f) {
        float f2 = this.e;
        if (f2 != f && f > 0.0f) {
            this.resetPath();
            this.e = f;
            this.update(13400, 0, new Double(f2));
        }
    }

    public Dimension getStartOffset() {
        return this.f;
    }

    public void setStartOffset(Dimension dimension) {
        int n = this.f.width;
        int n2 = this.f.height;
        if (n != dimension.width || n2 != dimension.height && dimension.width > 0 && dimension.height > 0) {
            this.f.width = dimension.width;
            this.f.height = dimension.height;
            this.resetPath();
            this.update(13401, 0, new Dimension(n, n2));
        }
    }

    public boolean isPointInObj(Point point) {
        float f;
        float f2;
        float f3;
        float f4;
        GraduatedScale graduatedScale = this.getScale();
        if (graduatedScale == null) {
            return super.isPointInObj(point);
        }
        float f5 = this.getThickness() / 2.0f;
        Point2D.Float float_ = graduatedScale.getPointForValue(graduatedScale.getMinimum());
        Point2D.Float float_2 = graduatedScale.getPointForValue(this.getValue());
        Dimension dimension = this.getStartOffset();
        float f6 = float_.x + (float)dimension.width;
        float f7 = float_.y + (float)dimension.height;
        float f8 = float_2.x + (float)dimension.width;
        float f9 = float_2.y + (float)dimension.height;
        if (f9 == f7) {
            f4 = f8;
            f3 = f9 - f5;
            f2 = f8;
            f = f9 + f5;
        } else if (f8 == f6) {
            f4 = f8 - f5;
            f3 = f9;
            f2 = f8 + f5;
            f = f9;
        } else {
            float f10 = -(f6 - f8) / (f7 - f9);
            float f11 = (float)Math.sqrt(f5 * f5 * f10 * f10 / (1.0f + f10 * f10));
            float f12 = f11 / f10;
            f4 = f8 + f12;
            f3 = f9 + f11;
            f2 = f8 - f12;
            f = f9 - f11;
        }
        Point2D.Float float_3 = new Point2D.Float();
        AbstractGraduatedScale.getNearestPointOnLine(f4, f3, f2, f, point.x, point.y, float_3);
        return ((float)point.x - float_3.x) * ((float)point.x - float_3.x) + ((float)point.y - float_3.y) * ((float)point.y - float_3.y) <= 9.0f;
    }

    public void getPhasePath(GeneralPath generalPath, double d, double d2) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        GraduatedScale graduatedScale = this.getScale();
        if (graduatedScale == null) {
            return;
        }
        float f9 = this.getThickness() / 2.0f;
        Point2D.Float float_ = graduatedScale.getPointForValue(graduatedScale.getMinimum());
        Point2D.Float float_2 = graduatedScale.getPointForValue(d);
        Point2D.Float float_3 = graduatedScale.getPointForValue(d2);
        Dimension dimension = this.getStartOffset();
        float f10 = float_2.x + (float)dimension.width;
        float f11 = float_2.y + (float)dimension.height;
        float f12 = float_3.x + (float)dimension.width;
        float f13 = float_3.y + (float)dimension.height;
        if (f11 == f13) {
            f8 = Math.min(f10, f12);
            f7 = f11 - f9;
            f6 = f8 + Math.abs(f10 - f12);
            f5 = f7;
            f4 = f6;
            f3 = f7 + 2.0f * f9;
            f2 = f8;
            f = f3;
            if (f10 == f12) {
                f7 = f11;
                f5 = f11;
                f3 = f11;
                f = f11;
            }
        } else if (f10 == f12) {
            f8 = f10 - f9;
            f7 = Math.min(f11, f13);
            f6 = f8 + 2.0f * f9;
            f5 = f7;
            f4 = f6;
            f3 = f7 + Math.abs(f11 - f13);
            f2 = f8;
            f = f3;
        } else {
            float f14 = -(f10 - f12) / (f11 - f13);
            float f15 = (float)Math.sqrt(f9 * f9 * f14 * f14 / (1.0f + f14 * f14));
            float f16 = f15 / f14;
            f8 = f10 - f16;
            f7 = f11 - f15;
            f6 = f12 - f16;
            f5 = f13 - f15;
            f4 = f12 + f16;
            f3 = f13 + f15;
            f2 = f10 + f16;
            f = f11 + f15;
        }
        generalPath.moveTo(f8, f7);
        generalPath.lineTo(f6, f5);
        generalPath.lineTo(f4, f3);
        generalPath.lineTo(f2, f);
        generalPath.lineTo(f8, f7);
    }

    protected void computePath(GeneralPath generalPath) {
        if (this.getScale() != null) {
            this.getPhasePath(generalPath, this.getScale().getMinimum(), this.getValue());
        }
    }

    public void paint(Graphics2D graphics2D, JGoView jGoView) {
        super.paint(graphics2D, jGoView);
        if (this.d == null) {
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < this.d.size(); ++i) {
            generalPath.reset();
            Phase phase = (Phase)this.d.get(i);
            this.paintPhase(graphics2D, jGoView, phase, generalPath);
        }
    }

    public void paintPhase(Graphics2D graphics2D, JGoView jGoView, Phase phase, GeneralPath generalPath) {
        if (phase.getMin() > this.getValue()) {
            return;
        }
        this.getPhasePath(generalPath, phase.getMin(), Math.min(phase.getMax(), this.getValue()));
        if (phase.getColor() != null) {
            graphics2D.setPaint(phase.getColor());
            graphics2D.fill(generalPath);
        }
        if (this.getPen() != null) {
            JGoDrawable.drawPath((Graphics2D)graphics2D, (JGoPen)this.getPen(), null, (GeneralPath)generalPath);
        }
    }

    public void addPhase(Phase phase) {
        this.insertPhase(this.getPhaseCount(), phase);
    }

    public void removePhase(Phase phase) {
        if (this.d == null) {
            return;
        }
        int n = this.d.indexOf(phase);
        if (n >= 0) {
            this.d.remove(n);
            this.update(13403, n, phase);
        }
    }

    public void removePhase(int n) {
        if (n < 0 || n >= this.getPhaseCount()) {
            throw new IndexOutOfBoundsException("IndicatorBar.removePhase given an invalid index");
        }
        if (this.d == null) {
            return;
        }
        Phase phase = (Phase)this.d.get(n);
        this.removePhase(phase);
    }

    public void insertPhase(int n, Phase phase) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("IndicatorBar.InsertPhaseAt given an invalid index");
        }
        if (this.d == null) {
            this.d = new ArrayList();
        }
        if (n < this.getPhaseCount()) {
            this.d.add(n, phase);
        } else {
            this.d.add(phase);
        }
        this.update(13402, n, null);
    }

    public void setPhase(int n, Phase phase) {
        Phase phase2;
        if (this.d == null) {
            this.d = new ArrayList();
        }
        if ((phase2 = this.getPhase(n)) != phase) {
            this.d.set(n, phase);
            this.update(13404, n, phase2);
        }
    }

    public Phase getPhase(int n) {
        if (n < 0 || n >= this.getPhaseCount() || this.d == null) {
            throw new IndexOutOfBoundsException("IndicatorBar.GetPhaseAt given an invalid index");
        }
        return (Phase)this.d.get(n);
    }

    public int getPhaseCount() {
        if (this.d == null) {
            return 0;
        }
        return this.d.size();
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit jGoDocumentChangedEdit) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 13400: {
                jGoDocumentChangedEdit.setNewValue((Object)new Double(this.getThickness()));
                return;
            }
            case 13401: {
                jGoDocumentChangedEdit.setNewValue((Object)new Dimension(this.getStartOffset()));
                return;
            }
            case 13403: {
                return;
            }
            case 13402: 
            case 13404: {
                jGoDocumentChangedEdit.setNewValue((Object)this.getPhase(jGoDocumentChangedEdit.getOldValueInt()));
                return;
            }
        }
        super.copyNewValueForRedo(jGoDocumentChangedEdit);
    }

    public void changeValue(JGoDocumentChangedEdit jGoDocumentChangedEdit, boolean bl) {
        switch (jGoDocumentChangedEdit.getFlags()) {
            case 13400: {
                this.setThickness((float)jGoDocumentChangedEdit.getValueDouble(bl));
                return;
            }
            case 13401: {
                this.setStartOffset((Dimension)jGoDocumentChangedEdit.getValue(bl));
                return;
            }
            case 13402: {
                int n = jGoDocumentChangedEdit.getOldValueInt();
                if (bl) {
                    if (n < this.getPhaseCount()) {
                        this.d.remove(n);
                    }
                } else if (n < this.getPhaseCount()) {
                    this.d.add(n, jGoDocumentChangedEdit.getOldValue());
                } else {
                    this.d.add(jGoDocumentChangedEdit.getOldValue());
                }
                return;
            }
            case 13403: {
                int n = jGoDocumentChangedEdit.getOldValueInt();
                if (bl) {
                    if (n < this.getPhaseCount()) {
                        this.d.add(n, jGoDocumentChangedEdit.getOldValue());
                    } else {
                        this.d.add(jGoDocumentChangedEdit.getOldValue());
                    }
                } else if (n < this.getPhaseCount()) {
                    this.d.remove(n);
                }
                return;
            }
            case 13404: {
                int n = jGoDocumentChangedEdit.getOldValueInt();
                if (n < this.getPhaseCount()) {
                    this.d.set(n, jGoDocumentChangedEdit.getValue(bl));
                }
                return;
            }
        }
        super.changeValue(jGoDocumentChangedEdit, bl);
    }

    public void SVGWriteObject(DomDoc domDoc, DomElement domElement) {
        if (domDoc.JGoXMLOutputEnabled()) {
            DomElement domElement2 = domDoc.createJGoClassElement("com.nwoods.jgo.instruments.IndicatorBar", domElement);
            domElement2.setAttribute("thickness", Float.toString(this.e));
            domElement2.setAttribute("startoffsetwidth", Integer.toString(this.f.width));
            domElement2.setAttribute("startoffsetheight", Integer.toString(this.f.height));
            if (this.d != null) {
                DomElement domElement3 = null;
                Object e = this.d.get(0);
                for (int i = 0; i < this.d.size(); ++i) {
                    if (domDoc.isRegisteredReference(this.d.get(i))) continue;
                    domDoc.registerReferencingNode(domElement2, "phases", this.d.get(i));
                    if (domElement3 == null) {
                        domElement2.setAttribute("embeddedphases", "true");
                    }
                    domElement3 = domDoc.createElement("g");
                    domElement2.appendChild((DomNode)domElement3);
                    ((Phase)this.d.get(i)).SVGWriteObject(domDoc, domElement3);
                }
            }
        }
        if (domDoc.SVGOutputEnabled()) {
            this.generateSVGOutput(domDoc, domElement);
        }
        super.SVGWriteObject(domDoc, domElement);
    }

    public void generateSVGOutput(DomDoc domDoc, DomElement domElement) {
        super.generateSVGOutput(domDoc, domElement);
        if (this.d != null) {
            GeneralPath generalPath = new GeneralPath();
            for (int i = 0; i < this.d.size(); ++i) {
                generalPath.reset();
                Phase phase = (Phase)this.d.get(i);
                if (!(phase.getMin() <= this.getValue())) continue;
                this.getPhasePath(generalPath, phase.getMin(), Math.min(phase.getMax(), this.getValue()));
                if (phase.getColor() == null) continue;
                DomElement domElement2 = domDoc.createElement("path");
                IndicatorBar.SVGAddPathArgs((DomElement)domElement2, (GeneralPath)generalPath);
                JGoBrush.make((int)65535, (Color)phase.getColor()).SVGWriteAttributes(domElement2);
                domElement.appendChild((DomNode)domElement2);
            }
        }
    }

    public DomNode SVGReadObject(DomDoc domDoc, JGoDocument jGoDocument, DomElement domElement, DomElement domElement2) {
        if (domElement2 != null) {
            this.e = Float.parseFloat(domElement2.getAttribute("thickness"));
            String string = domElement2.getAttribute("startoffsetwidth");
            String string2 = domElement2.getAttribute("startoffsetheight");
            this.f.width = Integer.parseInt(string);
            this.f.height = Integer.parseInt(string2);
            if (domElement2.getAttribute("embeddedphases").equals("true")) {
                domDoc.SVGTraverseChildren(jGoDocument, (DomNode)domElement2, null, false);
            }
            String string3 = domElement2.getAttribute("phases");
            while (string3.length() > 0) {
                int n = string3.indexOf(" ");
                if (n == -1) {
                    n = string3.length();
                }
                String string4 = string3.substring(0, n);
                string3 = n >= string3.length() ? "" : string3.substring(n + 1);
                domDoc.registerReferencingObject((Object)this, "phases", string4);
            }
            super.SVGReadObject(domDoc, jGoDocument, domElement, domElement2.getNextSiblingJGoClassElement());
        }
        return domElement.getNextSibling();
    }

    public void SVGUpdateReference(String string, Object object) {
        super.SVGUpdateReference(string, object);
        if (string.equals("phases")) {
            this.addPhase((Phase)object);
        }
    }
}

