/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.remote.cascading.proxy;

import com.sun.jdmk.defaults.Utils;
import com.sun.jdmk.internal.ClassLogger;
import com.sun.jdmk.remote.cascading.CascadingAgent;
import com.sun.jdmk.remote.cascading.MBeanServerConnectionFactory;
import com.sun.jdmk.remote.cascading.MBeanServerConnectionWrapper;
import com.sun.jdmk.remote.cascading.proxy.CascadingProxy;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.remote.JMXConnectionNotification;

public class ProxyCascadingAgent
extends CascadingAgent {
    private final NotificationListener mbsNotifHandler = new NotificationListener(){

        public void handleNotification(Notification notification, Object object) {
            ProxyCascadingAgent.this.handleMBeanServerNotification(notification, object);
        }
    };
    private final HashMap mbeanList = new HashMap();
    private final MBeanServerConnectionWrapper wrapper = new MBeanServerConnectionWrapper(){

        protected MBeanServerConnection getMBeanServerConnection() throws IOException {
            return ProxyCascadingAgent.this.getConnectionFactory().getMBeanServerConnection();
        }
    };
    private final String description;
    private String state = "Stopped";
    private long sequenceNumber = 0L;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.cascading", "ProxyCascadingAgent");

    public ProxyCascadingAgent(MBeanServerConnectionFactory mBeanServerConnectionFactory, ObjectName objectName, QueryExp queryExp, String string, MBeanServer mBeanServer, String string2) {
        super(mBeanServerConnectionFactory, objectName, queryExp, string, mBeanServer);
        this.description = string2;
    }

    public ProxyCascadingAgent(MBeanServerConnectionFactory mBeanServerConnectionFactory, ObjectName objectName, QueryExp queryExp, String string) {
        this(mBeanServerConnectionFactory, objectName, queryExp, null, null, string);
    }

    public synchronized void start() throws IOException {
        try {
            this.start(true);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw new UndeclaredThrowableException(instanceAlreadyExistsException);
        }
    }

    public synchronized void start(boolean bl) throws IOException, InstanceAlreadyExistsException {
        Object object;
        if (!this.state.equals("Stopped")) {
            throw new IllegalStateException("Can't start when state is: " + this.state);
        }
        MBeanServer mBeanServer = this.getTargetMBeanServer();
        if (mBeanServer == null) {
            throw new IllegalStateException("Can't start with no MBeanServer");
        }
        this.state = "Starting";
        if (logger.fineOn()) {
            logger.fine("start", this.state);
        }
        try {
            this.getConnectionFactory().getMBeanServerConnection().addNotificationListener(MBSDelegateObjectName, this.mbsNotifHandler, null, null);
            this.enableConnectionNotifications();
        }
        catch (IOException iOException) {
            this.state = "Stopped";
            this.unexpectedException("start", MBSDelegateObjectName, iOException);
            throw iOException;
        }
        catch (Exception exception) {
            this.unexpectedException("start", MBSDelegateObjectName, exception);
            IOException iOException = new IOException("failed to start: " + exception);
            Utils.initCause(iOException, exception);
            this.state = "Stopped";
            throw iOException;
        }
        catch (Error error) {
            this.state = "Stopped";
            if (logger.finerOn()) {
                logger.finer("start", "failed to start: " + error);
            }
            throw error;
        }
        Throwable throwable = null;
        try {
            Set<ObjectName> set = this.getConnectionFactory().getMBeanServerConnection().queryNames(this.getPattern(), this.getQuery());
            object = new ObjectName[set.size()];
            int n = 0;
            Iterator<ObjectName> iterator = set.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName = iterator.next();
                ObjectName objectName2 = this.getTargetName(objectName);
                if (mBeanServer.isRegistered(objectName2) && !bl) {
                    this.nameConflictDetected("start", objectName2);
                    throw new InstanceAlreadyExistsException(String.valueOf(objectName2));
                }
                object[n++] = objectName;
            }
            for (int i = 0; i < n; ++i) {
                this.showMBean("start", object[i]);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (throwable != null) {
            try {
                try {
                    this.state = "ShuttingDown";
                    if (logger.fineOn()) {
                        logger.fine("start", "Failed to start: " + this.state);
                    }
                    this.cleanup(false);
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                    throw instanceAlreadyExistsException;
                }
                catch (Error error) {
                    throw error;
                }
                catch (Throwable throwable3) {
                    object = new IOException("Failed to start: " + throwable3);
                    Utils.initCause((Throwable)object, throwable3);
                    throw object;
                }
            }
            catch (Throwable throwable4) {
                Object var11_21 = null;
                this.state = "Stopped";
                if (logger.fineOn()) {
                    logger.fine("start", "Not started: " + this.state);
                }
                throw throwable4;
            }
        }
        this.state = "Started";
        if (logger.fineOn()) {
            logger.fine("start", this.state);
        }
    }

    public void stop() throws IOException {
        this.stop(false);
    }

    public int getCascadedMBeanCount() {
        return this.getLinkedCount();
    }

    public Set getCascadedMBeans() {
        HashSet<ObjectInstance> hashSet = new HashSet<ObjectInstance>();
        try {
            Set<ObjectInstance> set = this.getConnectionFactory().getMBeanServerConnection().queryMBeans(this.getPattern(), this.getQuery());
            Iterator<ObjectInstance> iterator = set.iterator();
            while (iterator.hasNext()) {
                ObjectInstance objectInstance = iterator.next();
                if (!this.isLinked(objectInstance.getObjectName())) continue;
                hashSet.add(objectInstance);
            }
        }
        catch (Exception exception) {
            this.unexpectedException("getCascadedMBeans", this.getPattern(), exception);
        }
        return hashSet;
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized boolean isActive() {
        return this.state.equals("Started");
    }

    public synchronized void update() throws IOException {
        if (!this.state.equals("Started")) {
            if (logger.finerOn()) {
                logger.finer("update", "CascadingAgent " + this.state);
            }
            return;
        }
        if (logger.finerOn()) {
            logger.finer("update", "CascadingAgent " + this.state);
        }
        ObjectName[] objectNameArray = this.getLinkedSourceNames();
        HashSet<ObjectName> hashSet = new HashSet<ObjectName>(this.getConnectionFactory().getMBeanServerConnection().queryNames(this.getPattern(), this.getQuery()));
        int n = objectNameArray.length;
        MBeanServer mBeanServer = this.getTargetMBeanServer();
        if (mBeanServer == null) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            ObjectName objectName = this.getTargetName(objectNameArray[i]);
            if (hashSet.remove(objectNameArray[i])) {
                this.showMBean("update", objectNameArray[i]);
                continue;
            }
            this.hideMBean("update", objectNameArray[i]);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.showMBean("update", (ObjectName)iterator.next());
        }
        if (logger.finerOn()) {
            logger.finer("update", "CascadingAgent updated");
        }
    }

    public synchronized void preDeregister() throws Exception {
        if (!this.state.equals("Stopped")) {
            throw new IllegalStateException("ProxyCascadingAgent is still active.");
        }
    }

    protected Object createProxy(ObjectName objectName, MBeanServerConnectionFactory mBeanServerConnectionFactory) {
        return new CascadingProxy(objectName, mBeanServerConnectionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleJMXConnectionNotification(Notification notification, Object object) {
        Object object2;
        String string = notification.getType();
        try {
            object2 = this;
            synchronized (object2) {
                if (!this.state.equals("Started")) {
                    return;
                }
                if ("jmx.remote.connection.opened".equals(string) || "jmx.remote.connection.notifs.lost".equals(string)) {
                    this.update();
                } else if ("jmx.remote.connection.closed".equals(string)) {
                    this.stopIfClosed();
                } else if ("jmx.remote.connection.failed".equals(string)) {
                    this.stop(true);
                }
            }
        }
        catch (Exception exception) {
            this.unexpectedException(string, null, exception);
        }
        object2 = ((JMXConnectionNotification)notification).getConnectionId();
        JMXConnectionNotification jMXConnectionNotification = new JMXConnectionNotification(string, this, (String)object2, this.newSequenceNumber(), notification.getMessage(), notification.getUserData());
        this.sendNotification(jMXConnectionNotification);
    }

    protected void handleMBeanServerNotification(Notification notification, Object object) {
        if (notification instanceof MBeanServerNotification) {
            MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
            String string = notification.getType();
            ObjectName objectName = mBeanServerNotification.getMBeanName();
            if ("JMX.mbean.registered".equals(string)) {
                if (this.mustCascade(objectName)) {
                    this.showMBean(string, objectName);
                }
            } else if ("JMX.mbean.unregistered".equals(string) && this.isLinked(objectName)) {
                this.hideMBean(string, objectName);
            }
        }
    }

    protected boolean mustCascade(ObjectName objectName) {
        return this.isIncluded(objectName, this.getPattern(), this.getQuery());
    }

    synchronized void showMBean(String string, ObjectName objectName) {
        if (this.state.equals("Stopped")) {
            return;
        }
        if (this.state.equals("ShuttingDown")) {
            return;
        }
        MBeanServer mBeanServer = this.getTargetMBeanServer();
        if (mBeanServer == null) {
            return;
        }
        try {
            ObjectName objectName2 = this.getTargetName(objectName);
            if (this.isLinked(objectName) && mBeanServer.isRegistered(objectName2)) {
                return;
            }
            Object object = this.getProxy(objectName, this.getConnectionFactory());
            this.link(objectName, object);
            try {
                mBeanServer.registerMBean(object, objectName2);
                if (logger.finestOn()) {
                    logger.finest(string, "Registered proxy: " + objectName2 + " for: " + objectName);
                }
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                this.unlink(objectName);
                this.nameConflictDetected(string, objectName2);
                return;
            }
            catch (Exception exception) {
                this.unlink(objectName);
                this.unexpectedException(string, objectName, exception);
                return;
            }
        }
        catch (Exception exception) {
            this.unexpectedException(string, objectName, exception);
        }
    }

    synchronized void hideMBean(String string, ObjectName objectName) {
        MBeanServer mBeanServer = this.getTargetMBeanServer();
        if (mBeanServer == null) {
            return;
        }
        if (this.state.equals("Stopped")) {
            return;
        }
        if (this.state.equals("ShuttingDown")) {
            return;
        }
        try {
            if (this.isLinked(objectName)) {
                ObjectName objectName2 = this.getTargetName(objectName);
                mBeanServer.unregisterMBean(objectName2);
                if (logger.finestOn()) {
                    logger.finest(string, "Unregistered proxy: " + objectName2 + " for: " + objectName);
                }
                this.unlink(objectName);
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            return;
        }
        catch (Exception exception) {
            this.unexpectedException(string, objectName, exception);
            return;
        }
    }

    void unexpectedException(String string, ObjectName objectName, Exception exception) {
        logger.fine(string, "Unexpected exception while handling " + objectName + ": " + exception);
        logger.finest(string, exception);
    }

    void unexpectedCleanupException(ObjectName objectName, Exception exception) {
        logger.finer("cleanup", "Unexpected exception while handling " + objectName + ": " + exception);
        logger.finest("cleanup", exception);
    }

    void nameConflictDetected(String string, ObjectName objectName) {
        logger.fine(string, "Name conflict detected for " + objectName);
    }

    protected final synchronized long newSequenceNumber() {
        return this.sequenceNumber++;
    }

    ObjectName getTargetName(ObjectName objectName) {
        String string = this.getTargetPath();
        if (string == null || string.length() == 0) {
            return objectName;
        }
        try {
            String string2 = objectName.getDomain();
            String string3 = objectName.getKeyPropertyListString();
            String string4 = string + "/" + string2 + ":" + string3;
            return ObjectName.getInstance(string4);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            return objectName;
        }
    }

    private Object getProxy(ObjectName objectName, MBeanServerConnectionFactory mBeanServerConnectionFactory) {
        Object object = this.getLinked(objectName);
        if (object != null) {
            return object;
        }
        if (logger.finestOn()) {
            logger.finest("getProxy", "create proxy for: " + objectName);
        }
        return this.createProxy(objectName, mBeanServerConnectionFactory);
    }

    private void stopIfClosed() throws IOException {
        if (!this.state.equals("Started")) {
            return;
        }
        try {
            this.getConnectionFactory().getMBeanServerConnection().getDefaultDomain();
            return;
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void stop(boolean bl) throws IOException {
        if (this.state.equals("Stopped")) {
            if (logger.fineOn()) {
                logger.fine("stop", "Already " + this.state);
            }
            return;
        }
        if (!this.state.equals("Started")) {
            throw new IllegalStateException("Can't stop when state is: " + this.state);
        }
        this.state = "ShuttingDown";
        if (logger.fineOn()) {
            logger.fine("stop", this.state);
        }
        try {
            this.cleanup(bl);
            Object var3_2 = null;
            this.state = "Stopped";
            if (logger.fineOn()) {
                logger.fine("stop", this.state);
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.state = "Stopped";
            if (logger.fineOn()) {
                logger.fine("stop", this.state);
            }
            throw throwable;
        }
    }

    private synchronized void cleanup(boolean bl) {
        try {
            try {
                if (!bl) {
                    this.getConnectionFactory().getMBeanServerConnection().removeNotificationListener(MBSDelegateObjectName, this.mbsNotifHandler, null, null);
                }
            }
            catch (Exception exception) {
                this.unexpectedCleanupException(MBSDelegateObjectName, exception);
            }
            try {
                this.disableConnectionNotifications();
            }
            catch (Exception exception) {
                this.unexpectedCleanupException(null, exception);
            }
            this.clearProxies();
        }
        catch (Exception exception) {
            this.unexpectedCleanupException(null, exception);
        }
    }

    private synchronized void clearProxies() {
        try {
            ObjectName[] objectNameArray = this.clearLinks();
            MBeanServer mBeanServer = this.getTargetMBeanServer();
            if (mBeanServer == null) {
                return;
            }
            for (int i = 0; i < objectNameArray.length; ++i) {
                try {
                    mBeanServer.unregisterMBean(objectNameArray[i]);
                    if (!logger.finestOn()) continue;
                    logger.finest("clearProxies", "Unregistered target proxy: " + objectNameArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    this.unexpectedCleanupException(objectNameArray[i], exception);
                }
            }
        }
        catch (Exception exception) {
            this.unexpectedCleanupException(null, exception);
        }
    }

    private synchronized void link(ObjectName objectName, Object object) {
        this.mbeanList.put(objectName, object);
    }

    private synchronized void unlink(ObjectName objectName) {
        this.mbeanList.remove(objectName);
    }

    private synchronized ObjectName[] clearLinks() {
        ObjectName[] objectNameArray = this.getLinkedSourceNames();
        for (int i = 0; i < objectNameArray.length; ++i) {
            objectNameArray[i] = this.getTargetName(objectNameArray[i]);
        }
        this.mbeanList.clear();
        return objectNameArray;
    }

    private synchronized boolean isLinked(ObjectName objectName) {
        return this.mbeanList.get(objectName) != null;
    }

    private synchronized Object getLinked(ObjectName objectName) {
        return this.mbeanList.get(objectName);
    }

    private synchronized int getLinkedCount() {
        return this.mbeanList.size();
    }

    private synchronized ObjectName[] getLinkedSourceNames() {
        ObjectName[] objectNameArray = new ObjectName[this.mbeanList.size()];
        this.mbeanList.keySet().toArray(objectNameArray);
        return objectNameArray;
    }

    private boolean isIncluded(ObjectName objectName, ObjectName objectName2, QueryExp queryExp) {
        try {
            if (objectName2 != null && !objectName2.apply(objectName)) {
                return false;
            }
            return this.wrapper.queryNames(objectName, queryExp).size() == 1;
        }
        catch (Exception exception) {
            this.unexpectedException("mustCascade", objectName, exception);
            return false;
        }
    }

    static final class State {
        public static final String STARTING = "Starting";
        public static final String STARTED = "Started";
        public static final String SHUTTING_DOWN = "ShuttingDown";
        public static final String STOPPED = "Stopped";

        State() {
        }
    }
}

