/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.SnmpInformRequest;
import com.sun.management.comm.SnmpQManager;
import java.util.Enumeration;
import java.util.Vector;

final class SnmpSendServer
extends Thread {
    private int intervalRange = 5000;
    private Vector readyPool;
    SnmpQManager snmpq = null;
    String dbgTag = "SnmpSendServer";
    boolean isBeingDestroyed = false;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "SnmpSendServer");

    public SnmpSendServer(ThreadGroup threadGroup, SnmpQManager snmpQManager) {
        super(threadGroup, "SnmpSendServer");
        this.snmpq = snmpQManager;
        this.start();
    }

    public synchronized void stopSendServer() {
        if (this.isAlive()) {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        Thread.currentThread().setPriority(5);
        if (logger.finerOn()) {
            logger.finer("run", "Thread Started");
        }
        while (true) {
            try {
                do {
                    this.prepareAndSendRequest();
                } while (!this.isBeingDestroyed);
            }
            catch (Exception exception) {
                if (!logger.finestOn()) continue;
                logger.finest("run", "Exception in send server");
                logger.finest("run", exception);
                continue;
            }
            catch (ThreadDeath threadDeath) {
                if (logger.finestOn()) {
                    logger.finest("run", "Exiting... Fatal error");
                }
                throw threadDeath;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (!logger.finestOn()) continue;
                logger.finest("run", "Out of memory");
                continue;
            }
            catch (Error error) {
                if (logger.finestOn()) {
                    logger.finest("run", error);
                }
                throw error;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAndSendRequest() {
        if (this.readyPool == null || this.readyPool.isEmpty()) {
            if (logger.finerOn()) {
                logger.finer("prepareAndSendRequest", "Blocking for inform requests");
            }
            this.readyPool = this.snmpq.getAllOutstandingRequest(this.intervalRange);
            if (this.isBeingDestroyed) {
                return;
            }
        } else if (logger.finestOn()) {
            logger.finest("prepareAndSendRequest", "Inform requests from a previous block left unprocessed. Will try again");
        }
        if (logger.finerOn()) {
            logger.finer("prepareAndSendRequest", "List of inform requests to send : " + this.reqListToString(this.readyPool));
        }
        SnmpSendServer snmpSendServer = this;
        synchronized (snmpSendServer) {
            if (this.readyPool.size() < 2) {
                this.fireRequestList(this.readyPool);
                return;
            }
            while (!this.readyPool.isEmpty()) {
                SnmpInformRequest snmpInformRequest = (SnmpInformRequest)this.readyPool.lastElement();
                if (snmpInformRequest != null && snmpInformRequest.inProgress()) {
                    this.fireRequest(snmpInformRequest);
                }
                this.readyPool.removeElementAt(this.readyPool.size() - 1);
            }
            this.readyPool.removeAllElements();
        }
    }

    void fireRequest(SnmpInformRequest snmpInformRequest) {
        if (snmpInformRequest != null && snmpInformRequest.inProgress()) {
            if (logger.finerOn()) {
                logger.finer("fireRequest", "Firing inform request directly. -> " + snmpInformRequest.getRequestId());
            }
            snmpInformRequest.action();
        }
    }

    void fireRequestList(Vector vector) {
        while (!vector.isEmpty()) {
            SnmpInformRequest snmpInformRequest = (SnmpInformRequest)vector.lastElement();
            if (snmpInformRequest != null && snmpInformRequest.inProgress()) {
                this.fireRequest(snmpInformRequest);
            }
            vector.removeElementAt(vector.size() - 1);
        }
    }

    final String reqListToString(Vector vector) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(vector.size() * 100);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (SnmpInformRequest)enumeration.nextElement();
            stringBuffer.append("InformRequestId -> ");
            stringBuffer.append(((SnmpInformRequest)object).getRequestId());
            stringBuffer.append(" / Destination -> ");
            stringBuffer.append(((SnmpInformRequest)object).getAddress());
            stringBuffer.append(". ");
        }
        object = stringBuffer.toString();
        stringBuffer = null;
        return object;
    }
}

