/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpAccessControlModel;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpUnknownModelException;
import com.sun.management.snmp.agent.LongList;
import com.sun.management.snmp.agent.SnmpMibRequest;

class AcmChecker {
    SnmpAccessControlModel model;
    String principal;
    int securityLevel;
    int version;
    int pduType;
    int securityModel;
    byte[] contextName;
    SnmpEngineImpl engine;
    LongList l;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "AcmChecker");

    AcmChecker(SnmpMibRequest snmpMibRequest) {
        block5: {
            this.model = null;
            this.principal = null;
            this.securityLevel = -1;
            this.version = -1;
            this.pduType = -1;
            this.securityModel = -1;
            this.contextName = null;
            this.engine = null;
            this.l = null;
            this.engine = (SnmpEngineImpl)snmpMibRequest.getEngine();
            if (this.engine != null && this.engine.isCheckOidActivated()) {
                try {
                    if (logger.finestOn()) {
                        logger.finest("AcmChecker", " SNMP V3 Access Control to be done.");
                    }
                    this.model = (SnmpAccessControlModel)this.engine.getAccessControlSubSystem().getModel(3);
                    this.principal = snmpMibRequest.getPrincipal();
                    this.securityLevel = snmpMibRequest.getSecurityLevel();
                    this.pduType = snmpMibRequest.getPdu().type;
                    this.version = snmpMibRequest.getRequestPduVersion();
                    this.securityModel = snmpMibRequest.getSecurityModel();
                    this.contextName = snmpMibRequest.getAccessContextName();
                    this.l = new LongList();
                    if (logger.finestOn()) {
                        logger.finest("AcmChecker", "Will check oid for : principal : " + this.principal + ";securityLevel : " + this.securityLevel + ";pduType : " + this.pduType + ";version : " + this.version + ";securityModel : " + this.securityModel + ";contextName : " + (this.contextName == null ? null : new String(this.contextName)));
                    }
                }
                catch (SnmpUnknownModelException snmpUnknownModelException) {
                    if (!logger.finestOn()) break block5;
                    logger.finest("AcmChecker", " Unknown Model, no ACM check.");
                }
            }
        }
    }

    void add(int n, long l) {
        if (this.model != null) {
            this.l.add(n, l);
        }
    }

    void remove(int n) {
        if (this.model != null) {
            this.l.remove(n);
        }
    }

    void add(int n, long[] lArray, int n2, int n3) {
        if (this.model != null) {
            this.l.add(n, lArray, n2, n3);
        }
    }

    void remove(int n, int n2) {
        if (this.model != null) {
            this.l.remove(n, n2);
        }
    }

    void checkCurrentOid() throws SnmpStatusException {
        if (this.model != null) {
            SnmpOid snmpOid = new SnmpOid(this.l.toArray());
            if (logger.finestOn()) {
                logger.finest("check", " Checking access for : " + snmpOid);
            }
            this.model.checkAccess(this.version, this.principal, this.securityLevel, this.pduType, this.securityModel, this.contextName, snmpOid);
        }
    }
}

