/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.internal.snmp.SnmpOutgoingRequest;
import com.sun.management.internal.snmp.SnmpSecurityCache;
import com.sun.management.snmp.SnmpBadSecurityLevelException;
import com.sun.management.snmp.SnmpDefinitions;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpMsg;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduBulkType;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpPduRequestType;
import com.sun.management.snmp.SnmpScopedPduPacket;
import com.sun.management.snmp.SnmpSecurityException;
import com.sun.management.snmp.SnmpSecurityParameters;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.SnmpValue;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.Timestamp;
import com.sun.management.snmp.manager.ReqRedirectSrv;
import com.sun.management.snmp.manager.RequestCounter;
import com.sun.management.snmp.manager.SnmpParams;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpPollRequest;
import com.sun.management.snmp.manager.SnmpQManager;
import com.sun.management.snmp.manager.SnmpRequestHandler;
import com.sun.management.snmp.manager.SnmpSession;
import com.sun.management.snmp.manager.SnmpSocket;
import com.sun.management.snmp.manager.SnmpTooBig;
import com.sun.management.snmp.manager.usm.SnmpUsmPeer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public class SnmpRequest
implements Serializable,
SnmpDefinitions {
    private static final long serialVersionUID = 3370753936166629014L;
    private static final int stBase = 1;
    public static final int stInProgress = 1;
    public static final int stWaitingToSend = 3;
    public static final int stWaitingForReply = 5;
    public static final int stReceivedReply = 9;
    public static final int stAborted = 16;
    public static final int stTimeout = 32;
    public static final int stInternalError = 64;
    public static final int stResultsAvailable = 128;
    public static final int stNeverUsed = 256;
    private static RequestCounter requestCounter = new RequestCounter();
    private SnmpPeer thePeer;
    private SnmpSession session;
    private SnmpRequestHandler callback = null;
    private int nonRepeaters = 0;
    private int maxRepetitions = 0;
    private ReqRedirectSrv proxy;
    private SnmpPdu requestPdu;
    private SnmpPdu responsePdu;
    private SnmpVarBind[] internalVarBind = null;
    private String reason = null;
    private int options = 7;
    private static final int CREATED_BY_USER = 1;
    private static final int CREATED_INTERNALLY = 2;
    private int mode = 1;
    private int numTries = 0;
    private int timeout = 5000;
    private int reqState = 256;
    private long prevPollTime = 0L;
    private long nextPollTime = 0L;
    private long waitTimeForResponse;
    private Date debugDate = new Date();
    private int requestId = 0;
    private SnmpEngine engine = null;
    SnmpVarBindList varBindList = null;
    SnmpVarBindList reportVarBindList = null;
    Timestamp responseTimestamp = null;
    int errorStatus = 0;
    int errorIndex = 0;
    int command = 0;
    String dbgTag = "SnmpRequest";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpRequest");
    private transient int responseType;
    private SnmpSecurityCache securityCache = null;
    private SnmpSecurityParameters securityParams = null;

    SnmpRequest(SnmpSession snmpSession, SnmpPeer snmpPeer, SnmpRequestHandler snmpRequestHandler, int n) throws SnmpStatusException {
        if (snmpPeer instanceof SnmpUsmPeer && ((SnmpUsmPeer)snmpPeer).isAuthoritative()) {
            if (logger.finestOn()) {
                logger.finest("SnmpRequest", "Provided peer is not usuable for request");
            }
            throw new SnmpStatusException("SnmpUsmPeer is an authoritative one. Not usable for requests.");
        }
        this.session = snmpSession;
        this.thePeer = snmpPeer;
        this.callback = snmpRequestHandler;
        switch (n) {
            case 160: 
            case 161: 
            case 163: 
            case 165: 
            case 166: {
                this.command = n;
                break;
            }
            case 253: {
                this.command = 161;
                break;
            }
            default: {
                throw new SnmpStatusException("Unsupported Command. " + n);
            }
        }
        this.session.addRequest(this);
        this.setTimeout(this.thePeer.getTimeout());
    }

    SnmpRequest(SnmpSession snmpSession, SnmpPeer snmpPeer, SnmpRequestHandler snmpRequestHandler, int n, int n2) throws SnmpStatusException {
        this(snmpSession, snmpPeer, snmpRequestHandler, 165);
        this.nonRepeaters = n;
        this.maxRepetitions = n2;
    }

    public final synchronized int getNumTries() {
        return this.numTries;
    }

    public final synchronized int getRequestId() {
        return this.requestId;
    }

    public final synchronized int getRequestStatus() {
        return this.reqState;
    }

    final synchronized void setTimeout(int n) {
        this.timeout = n;
    }

    public final synchronized boolean isAborted() {
        return (this.reqState & 0x10) == 16;
    }

    public final synchronized boolean inProgress() {
        return (this.reqState & 1) == 1;
    }

    public final synchronized boolean isResultAvailable() {
        return this.reqState == 128;
    }

    public final synchronized long getAbsNextPollTime() {
        return this.nextPollTime;
    }

    public final synchronized long getAbsMaxTimeToWait() {
        if (this.prevPollTime == 0L) {
            return System.currentTimeMillis();
        }
        return this.waitTimeForResponse;
    }

    public final synchronized long getPollTimestamp() {
        return this.prevPollTime;
    }

    public final SnmpSession getSnmpSession() {
        return this.session;
    }

    public final SnmpPeer getPeer() {
        return this.thePeer;
    }

    public final SnmpParams getParams() {
        return this.thePeer.getParams();
    }

    public final int getCommand() {
        return this.command;
    }

    public final synchronized int getErrorStatus() {
        return this.errorStatus;
    }

    public final synchronized int getErrorIndex() {
        return this.errorIndex;
    }

    public final int getMaxTries() {
        if (this.command == 163) {
            return 1;
        }
        return this.getPeer().getMaxTries();
    }

    public final int getOptions() {
        return this.options;
    }

    public final synchronized void setOptions(int n) {
        if (!this.inProgress()) {
            this.options = n;
            if (!this.fixPduOnError() || !this.fixTooBigError()) {
                this.options &= 0xFFFFFFFE;
            }
        }
    }

    public final synchronized SnmpVarBindList getRequestVarBindList() {
        return this.varBindList;
    }

    public final synchronized SnmpVarBindList getReportVarBindList() {
        return this.reportVarBindList;
    }

    public final synchronized SnmpVarBindList getResponseVarBindList() {
        if (this.inProgress()) {
            return null;
        }
        return this.varBindList;
    }

    public boolean fixTooBigError() {
        return (this.options & 4) == 4 && this.command != 165;
    }

    public boolean fixPduOnError() {
        return (this.options & 2) == 2 && this.command != 165;
    }

    public final boolean allowMultiplex() {
        return (this.options & 1) == 1;
    }

    public boolean isInternalRequest() {
        return this.mode == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitForCompletion(long l) throws SnmpStatusException {
        if (!this.inProgress()) {
            return true;
        }
        if (this instanceof SnmpPollRequest) {
            throw new SnmpStatusException("Not supported for SnmpPollRequest objects");
        }
        if (this.session.thisSessionContext()) {
            SnmpRequestHandler snmpRequestHandler = this.callback;
            this.callback = null;
            this.session.waitForResponse(this, l);
            this.callback = snmpRequestHandler;
        } else {
            SnmpRequest snmpRequest = this;
            synchronized (snmpRequest) {
                if (!this.inProgress()) {
                    return true;
                }
                SnmpRequestHandler snmpRequestHandler = this.callback;
                try {
                    this.callback = null;
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.callback = snmpRequestHandler;
            }
        }
        return !this.inProgress();
    }

    public final void cancelRequest() {
        if (this.proxy != null) {
            ReqRedirectSrv reqRedirectSrv = this.proxy;
            this.proxy = null;
            reqRedirectSrv.cancel(this);
        }
        this.errorStatus = 225;
        this.stopRequest();
        this.deleteRequest();
        this.notifyClient();
    }

    public final synchronized void notifyClient() {
        this.notifyAll();
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append(this.tostring() + " " + this.getRequestCreationType());
        if (logger.finerOn()) {
            stringBuffer.append("\n" + this.thePeer.toString());
        }
        stringBuffer.append(" SnmpCmd = " + SnmpPdu.pduTypeToString(this.command));
        stringBuffer.append("  RequestOptions = " + this.options);
        return stringBuffer.toString();
    }

    public static String snmpErrorToString(int n) {
        switch (n) {
            case 0: {
                return "noError";
            }
            case 1: {
                return "tooBig";
            }
            case 2: {
                return "noSuchName";
            }
            case 3: {
                return "badValue";
            }
            case 4: {
                return "readOnly";
            }
            case 5: {
                return "genErr";
            }
            case 6: {
                return "noAccess";
            }
            case 7: {
                return "wrongType";
            }
            case 8: {
                return "wrongLength";
            }
            case 9: {
                return "wrongEncoding";
            }
            case 10: {
                return "wrongValue";
            }
            case 11: {
                return "noCreation";
            }
            case 12: {
                return "inconsistentValue";
            }
            case 13: {
                return "resourceUnavailable";
            }
            case 14: {
                return "commitFailed";
            }
            case 15: {
                return "undoFailed";
            }
            case 16: {
                return "authorizationError";
            }
            case 17: {
                return "notWritable";
            }
            case 18: {
                return "inconsistentName";
            }
            case 224: {
                return "reqTimeout";
            }
            case 225: {
                return "reqAborted";
            }
            case 226: {
                return "rspDecodingError";
            }
            case 227: {
                return "reqEncodingError";
            }
            case 228: {
                return "reqPacketOverflow";
            }
            case 229: {
                return "rspEndOfTable";
            }
            case 230: {
                return "reqRefireAfterVbFix";
            }
            case 231: {
                return "reqHandleTooBig";
            }
            case 232: {
                return "reqTooBigImpossible";
            }
            case 240: {
                return "reqInternalError";
            }
            case 241: {
                return "reqSocketIOError";
            }
            case 242: {
                return "reqUnknownError";
            }
            case 243: {
                return "wrongSnmpVersion";
            }
            case 244: {
                return "snmpUnknownPrincipal";
            }
            case 245: {
                return "snmpAuthNotSupported";
            }
            case 246: {
                return "snmpPrivNotSupported";
            }
            case 249: {
                return "snmpBadSecurityLevel";
            }
            case 247: {
                return "snmpUsmBadEngineId";
            }
            case 248: {
                return "snmpUsmInvalidTimeliness";
            }
        }
        return "Unknown Error = " + n;
    }

    public synchronized boolean isReport() {
        return this.responseType == 168;
    }

    public synchronized boolean isResponse() {
        return this.responseType == 162;
    }

    final void setResponseSecurityParameters(SnmpSecurityParameters snmpSecurityParameters) {
        this.securityParams = snmpSecurityParameters;
    }

    final SnmpSecurityCache getSecurityCache() {
        return this.securityCache;
    }

    public final SnmpSecurityParameters getResponseSecurityParameters() {
        return this.securityParams;
    }

    private synchronized String tostring() {
        StringBuffer stringBuffer = new StringBuffer("RequestId = " + this.requestId);
        stringBuffer.append("   Status = " + SnmpRequest.statusDescription(this.reqState));
        stringBuffer.append("  Timeout/MaxTries/NumTries = " + this.timeout * this.numTries + "/" + this.getMaxTries() + "/" + this.numTries);
        if (this.prevPollTime > 0L) {
            this.debugDate.setTime(this.prevPollTime);
            stringBuffer.append("\nPrevPolled = " + this.debugDate.toString());
        } else {
            stringBuffer.append("\nNeverPolled");
        }
        stringBuffer.append(" / RemainingTime(millis) = " + this.timeRemainingForAction(System.currentTimeMillis()));
        return stringBuffer.toString();
    }

    private synchronized void initializeAndFire(long l) {
        this.responsePdu = null;
        this.requestPdu = null;
        this.reason = null;
        this.proxy = null;
        if (l == 0L) {
            this.startRequest(System.currentTimeMillis());
        } else {
            this.startRequest(l);
        }
        this.setErrorStatusAndIndex(0, 0);
    }

    private void handleTimeout() {
        this.setRequestStatus(32);
        if (logger.finestOn()) {
            logger.finest("handleTimeout", "Snmp error/index = " + SnmpRequest.snmpErrorToString(this.errorStatus) + "/" + this.errorIndex + ". Invoking timeout user defined callback...");
        }
        this.deleteRequest();
        this.notifyClient();
        this.responsePdu = null;
        this.requestPdu = null;
        this.internalVarBind = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpPollTimeout(this);
            }
        }
        catch (Exception exception) {
            if (logger.finestOn()) {
                logger.finest("handleTimeout", "Exception generated by user callback");
                logger.finest("handleTimeout", exception);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (logger.finestOn()) {
                logger.finest("handleTimeout", "OutOfMemory Error generated by user callback");
                logger.finest("handleTimeout", outOfMemoryError);
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    private void handleError(String string) {
        this.setRequestStatus(128);
        if (logger.finestOn()) {
            logger.finest("handleError", "Snmp error/index = " + SnmpRequest.snmpErrorToString(this.errorStatus) + "/" + this.errorIndex + ". Invoking error user defined callback...\n" + this.getVarBindList().varBindListToString());
        }
        this.deleteRequest();
        this.notifyClient();
        this.responsePdu = null;
        this.requestPdu = null;
        this.internalVarBind = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpPollData(this, this.getErrorStatus(), this.getErrorIndex(), this.getVarBindList());
            }
        }
        catch (Exception exception) {
            if (logger.finestOn()) {
                logger.finest("handleError", "Exception generated by user callback");
                logger.finest("handleError", exception);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (logger.finestOn()) {
                logger.finest("handleError", "OutOfMemory Error generated by user callback");
                logger.finest("handleError", outOfMemoryError);
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    private final synchronized SnmpPdu constructPdu() {
        SnmpPdu snmpPdu = null;
        Exception exception = null;
        try {
            SnmpEngineImpl snmpEngineImpl = (SnmpEngineImpl)this.session.getEngine();
            SnmpParams snmpParams = this.thePeer.getParams();
            SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem = snmpEngineImpl.getMsgProcessingSubSystem();
            snmpPdu = snmpMsgProcessingSubSystem.getRequestPdu(snmpParams.getProtocolVersion(), snmpParams, this.command);
            snmpPdu.requestId = this.getRequestId();
            if (snmpPdu instanceof SnmpScopedPduPacket) {
                ((SnmpScopedPduPacket)snmpPdu).msgId = snmpPdu.requestId;
                ((SnmpScopedPduPacket)snmpPdu).msgFlags = (byte)(((SnmpScopedPduPacket)snmpPdu).msgFlags | 4);
            }
            snmpPdu.varBindList = this.internalVarBind;
            if (this.command == 165) {
                SnmpPduBulkType snmpPduBulkType = (SnmpPduBulkType)((Object)snmpPdu);
                snmpPduBulkType.setNonRepeaters(this.nonRepeaters);
                snmpPduBulkType.setMaxRepetitions(this.maxRepetitions);
            }
        }
        catch (SnmpStatusException snmpStatusException) {
            exception = snmpStatusException;
            this.errorStatus = 227;
            this.reason = snmpStatusException.getMessage();
        }
        catch (Exception exception2) {
            exception = exception2;
            this.errorStatus = 242;
            this.reason = exception2.getMessage();
        }
        if (exception != null) {
            if (logger.finestOn()) {
                logger.finest("constructPdu", exception);
            }
            snmpPdu = null;
            this.queueResponse();
        }
        return snmpPdu;
    }

    private final synchronized void parsePduPacket(SnmpPdu snmpPdu) throws SnmpStatusException {
        if (snmpPdu == null) {
            return;
        }
        SnmpPduRequestType snmpPduRequestType = (SnmpPduRequestType)((Object)snmpPdu);
        this.errorStatus = snmpPduRequestType.getErrorStatus();
        this.errorIndex = snmpPduRequestType.getErrorIndex();
        if (this.errorStatus == 0) {
            if (snmpPdu.type == 168) {
                this.updateReportVarBindList(snmpPdu.varBindList);
            } else if (this.command == 165) {
                this.updateVarBindList(snmpPdu.varBindList);
            } else {
                this.updateInternalVarBindWithResult(this.command, snmpPdu.varBindList, snmpPdu.version);
            }
            this.responseTimestamp = new Timestamp();
            this.getVarBindList().setTimestamp(this.responseTimestamp);
            return;
        }
        if (this.errorStatus != 0) {
            --this.errorIndex;
        }
        switch (this.errorStatus) {
            case 2: {
                if (!this.fixPduOnError() || this.command != 160 && this.command != 161) break;
                if (this.fixVarBindList(this.internalVarBind, this.errorIndex)) {
                    if (this.getVarBindList().checkForUnspecifiedValue()) {
                        this.setErrorStatusAndIndex(230, 0);
                        break;
                    }
                    this.setErrorStatusAndIndex(0, 0);
                    break;
                }
                this.setErrorStatusAndIndex(240, 0);
                break;
            }
            case 1: {
                if (!this.fixTooBigError() || this.varBindList.size() <= 1) break;
                this.setErrorStatusAndIndex(231, 0);
            }
        }
        if (logger.finerOn()) {
            logger.finer("parsePduPacket", "received response. ErrorStatus/ErrorIndex = " + this.errorStatus + "/" + this.errorIndex);
        }
    }

    private boolean handleTooBigError() {
        this.responsePdu = null;
        if (!this.fixTooBigError()) {
            return false;
        }
        if (this.varBindList.size() < 2) {
            this.setErrorStatusAndIndex(232, 0);
            return false;
        }
        try {
            if (logger.finerOn()) {
                logger.finer("handleTooBigError", "Handling Too big error");
            }
            this.proxy = new SnmpTooBig(this, this.getVarBindList());
            return true;
        }
        catch (Exception exception) {
            this.reason = exception.getMessage();
            this.setErrorStatusAndIndex(240, 0);
            return false;
        }
    }

    private boolean sendPdu() {
        try {
            this.responseTimestamp = null;
            this.responsePdu = null;
            SnmpEngineImpl snmpEngineImpl = (SnmpEngineImpl)this.session.getEngine();
            SnmpParams snmpParams = this.thePeer.getParams();
            SnmpMsgProcessingSubSystem snmpMsgProcessingSubSystem = snmpEngineImpl.getMsgProcessingSubSystem();
            SnmpPduFactory snmpPduFactory = this.session.getPduFactory();
            SnmpOutgoingRequest snmpOutgoingRequest = snmpMsgProcessingSubSystem.getOutgoingRequest(snmpParams.getProtocolVersion(), snmpPduFactory);
            SnmpMsg snmpMsg = snmpOutgoingRequest.encodeSnmpPdu(this.requestPdu, this.thePeer.getMaxSnmpPktSize());
            if (snmpMsg == null) {
                if (logger.finestOn()) {
                    logger.finest("sendPdu", "pdu factory returned a null value");
                }
                throw new SnmpStatusException(242);
            }
            int n = this.thePeer.getMaxSnmpPktSize();
            byte[] byArray = new byte[n];
            int n2 = snmpOutgoingRequest.encodeMessage(byArray);
            this.securityCache = snmpOutgoingRequest.getSecurityCache();
            if (logger.finerOn()) {
                logger.finer("sendPdu", "Dump : \n" + snmpOutgoingRequest.printMessage());
            }
            this.sendPduPacket(byArray, n2);
            return true;
        }
        catch (SnmpTooBigException snmpTooBigException) {
            if (logger.finestOn()) {
                logger.finest("sendPdu", snmpTooBigException);
            }
            this.setErrorStatusAndIndex(228, snmpTooBigException.getVarBindCount());
            this.requestPdu = null;
            this.reason = snmpTooBigException.getMessage();
            if (logger.finestOn()) {
                logger.finest("sendPdu", "Packet Overflow while building Request");
            }
            return this.handleTooBigError();
        }
        catch (IOException iOException) {
            this.setErrorStatusAndIndex(241, 0);
            this.reason = iOException.getMessage();
        }
        catch (SnmpSecurityException snmpSecurityException) {
            if (logger.finestOn()) {
                logger.finest("sendPdu", snmpSecurityException.toString() + " . status : + " + snmpSecurityException.status);
            }
            this.setErrorStatusAndIndex(snmpSecurityException.status, 0);
            this.reason = snmpSecurityException.getMessage();
        }
        catch (SnmpBadSecurityLevelException snmpBadSecurityLevelException) {
            if (logger.finestOn()) {
                logger.finest("sendPdu", snmpBadSecurityLevelException.toString());
            }
            this.setErrorStatusAndIndex(249, 0);
            this.reason = snmpBadSecurityLevelException.getMessage();
        }
        catch (Exception exception) {
            if (logger.finestOn()) {
                logger.finest("sendPdu", exception);
            }
            this.setErrorStatusAndIndex(242, 0);
            this.reason = exception.getMessage();
        }
        return false;
    }

    private final void invokeOnReady() {
        if (this.requestPdu == null) {
            if (this.varBindList.size() > this.getPeer().getVarBindLimit()) {
                if (logger.finestOn()) {
                    logger.finest("invokeOnReady", "Attempt too big. varBindList exceeds max allowed for peer. Actual = " + this.varBindList.size() + " Allowed = " + this.getPeer().getVarBindLimit());
                }
                this.setErrorStatusAndIndex(231, 0);
                if (!this.handleTooBigError()) {
                    this.queueResponse();
                }
                return;
            }
            this.requestPdu = this.constructPdu();
        }
        if (this.requestPdu != null && !this.sendPdu()) {
            this.queueResponse();
        }
    }

    private final void invokeOnRetry() {
        this.invokeOnReady();
    }

    private final void invokeOnTimeout() {
        this.errorStatus = 224;
        this.queueResponse();
    }

    private final void queueResponse() {
        this.getSnmpSession().addResponse(this);
    }

    private void updateInternalVarBindWithResult(int n, SnmpVarBind[] snmpVarBindArray, int n2) {
        if (snmpVarBindArray == null || snmpVarBindArray.length == 0) {
            return;
        }
        int n3 = 0;
        switch (n) {
            case 160: 
            case 163: 
            case 166: {
                for (int i = 0; i < this.internalVarBind.length && n3 < snmpVarBindArray.length; ++i) {
                    SnmpVarBind snmpVarBind = this.internalVarBind[i];
                    if (snmpVarBind == null) continue;
                    SnmpVarBind snmpVarBind2 = snmpVarBindArray[n3];
                    snmpVarBind.setSnmpValue(snmpVarBind2.getSnmpValue());
                    if (n2 == 1 || n2 == 3) {
                        SnmpValue snmpValue = snmpVarBind.getSnmpValue();
                        if (snmpValue != null && snmpValue.isNoSuchObjectValue()) {
                            snmpVarBind.status = 3;
                        } else if (snmpValue != null && snmpValue.isNoSuchInstanceValue()) {
                            snmpVarBind.status = 4;
                        } else if (snmpValue != null && snmpValue.isEndOfMibViewValue()) {
                            snmpVarBind.status = 5;
                        }
                    }
                    ++n3;
                }
                break;
            }
            case 161: {
                for (int i = 0; i < this.internalVarBind.length && n3 < snmpVarBindArray.length; ++i) {
                    SnmpVarBind snmpVarBind = this.internalVarBind[i];
                    if (snmpVarBind == null) continue;
                    SnmpVarBind snmpVarBind3 = snmpVarBindArray[n3];
                    snmpVarBind.setOid(snmpVarBind3.getOid(), false);
                    snmpVarBind.setSnmpValue(snmpVarBind3.getSnmpValue());
                    if (n2 == 1 || n2 == 3) {
                        SnmpValue snmpValue = snmpVarBind.getSnmpValue();
                        if (snmpValue != null && snmpValue.isNoSuchObjectValue()) {
                            snmpVarBind.status = 3;
                        } else if (snmpValue != null && snmpValue.isNoSuchInstanceValue()) {
                            snmpVarBind.status = 4;
                        } else if (snmpValue != null && snmpValue.isEndOfMibViewValue()) {
                            snmpVarBind.status = 5;
                        }
                    }
                    ++n3;
                }
                break;
            }
        }
    }

    private void updateVarBindList(SnmpVarBind[] snmpVarBindArray) {
        this.varBindList = new SnmpVarBindList();
        for (int i = 0; i < snmpVarBindArray.length; ++i) {
            SnmpVarBind snmpVarBind = snmpVarBindArray[i];
            SnmpVarBind snmpVarBind2 = new SnmpVarBind(snmpVarBind.getOid(), snmpVarBind.getSnmpValue());
            this.varBindList.addVarBind(snmpVarBind2);
        }
    }

    private void updateReportVarBindList(SnmpVarBind[] snmpVarBindArray) {
        this.reportVarBindList = new SnmpVarBindList();
        for (int i = 0; i < snmpVarBindArray.length; ++i) {
            SnmpVarBind snmpVarBind = snmpVarBindArray[i];
            SnmpVarBind snmpVarBind2 = new SnmpVarBind(snmpVarBind.getOid(), snmpVarBind.getSnmpValue());
            this.reportVarBindList.addVarBind(snmpVarBind2);
        }
    }

    private synchronized void startRequest(long l) {
        this.nextPollTime = l;
        this.prevPollTime = 0L;
        this.schedulePoll();
    }

    private void schedulePoll() {
        this.numTries = 0;
        this.initNewRequest();
        this.setRequestStatus(3);
        SnmpQManager.getTheInstance().addRequest(this);
    }

    final void setInternalRequest() {
        this.mode = 2;
    }

    final void setProxyObject(ReqRedirectSrv reqRedirectSrv) {
        this.proxy = reqRedirectSrv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopRequest() {
        SnmpRequest snmpRequest = this;
        synchronized (snmpRequest) {
            this.setRequestStatus(16);
        }
        SnmpQManager.getTheInstance().removeRequest(this);
        snmpRequest = this;
        synchronized (snmpRequest) {
            this.requestId = 0;
        }
    }

    void action() {
        if (!this.inProgress()) {
            return;
        }
        while (true) {
            try {
                if (this.numTries == 0) {
                    this.invokeOnReady();
                } else if (this.numTries < this.getMaxTries()) {
                    this.invokeOnRetry();
                } else {
                    this.invokeOnTimeout();
                }
                return;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                ++this.numTries;
                if (logger.finestOn()) {
                    logger.finest("action", "Request hit out of memory situation...");
                }
                Thread.currentThread();
                Thread.yield();
                continue;
            }
            break;
        }
    }

    synchronized void start(SnmpVarBindList snmpVarBindList, long l) throws SnmpStatusException {
        this.start(snmpVarBindList, true, l);
    }

    synchronized void start(SnmpVarBindList snmpVarBindList, boolean bl, long l) throws SnmpStatusException {
        if (this.inProgress()) {
            throw new SnmpStatusException("Request already in progress.");
        }
        switch (this.getCommand()) {
            case 163: {
                if (this.getParams().getProtocolVersion() == 1 || this.getParams().getProtocolVersion() == 3) {
                    this.options = 0;
                }
                if (bl) {
                    this.setVarBindList((SnmpVarBindList)snmpVarBindList.clone());
                    break;
                }
                this.setVarBindList(snmpVarBindList);
                break;
            }
            case 160: 
            case 161: 
            case 165: {
                if (bl) {
                    this.setVarBindList(snmpVarBindList.cloneWithoutValue());
                    break;
                }
                this.setVarBindList(snmpVarBindList);
                break;
            }
            case 166: {
                this.setVarBindList(snmpVarBindList);
                break;
            }
            default: {
                throw new SnmpStatusException("Unsupported Command.  Should never happen. ??!! " + this.getCommand());
            }
        }
        this.initializeAndFire(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleSuccess() {
        SnmpRequest snmpRequest = this;
        synchronized (snmpRequest) {
            if (this.responsePdu != null) {
                this.responseType = this.responsePdu.type;
            }
        }
        this.setRequestStatus(128);
        if (logger.finerOn()) {
            logger.finer("handleSuccess", "Invoking user defined callback...");
        }
        if (!(this instanceof SnmpPollRequest)) {
            this.deleteRequest();
        }
        this.notifyClient();
        this.responsePdu = null;
        this.requestPdu = null;
        this.internalVarBind = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpPollData(this, this.errorStatus, this.errorIndex, this.getVarBindList());
            }
        }
        catch (Exception exception) {
            if (logger.finestOn()) {
                logger.finest("handleSuccess", "Exception generated by user callback");
                logger.finest("handleSuccess", exception);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (logger.finestOn()) {
                logger.finest("handleSuccess", "OutOfMemory Error generated by user callback");
                logger.finest("handleSuccess", outOfMemoryError);
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    void handleInternalError(String string) {
        this.setRequestStatus(64);
        if (this.reason == null) {
            this.reason = string;
        }
        if (logger.finestOn()) {
            logger.finest("handleInternalError", "Snmp error/index = " + SnmpRequest.snmpErrorToString(this.errorStatus) + "/" + this.errorIndex + ". Invoking internal error user defined callback...\n" + this.getVarBindList().varBindListToString());
        }
        this.deleteRequest();
        this.notifyClient();
        this.responsePdu = null;
        this.requestPdu = null;
        this.internalVarBind = null;
        try {
            if (this.callback != null) {
                this.callback.processSnmpInternalError(this, this.reason);
            }
        }
        catch (Exception exception) {
            if (logger.finestOn()) {
                logger.finest("handleInternalError", "Exception generated by user callback");
                logger.finest("handleInternalError", exception);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (logger.finestOn()) {
                logger.finest("handleInternalError", "OutOfMemory Error generated by user callback");
                logger.finest("handleInternalError", outOfMemoryError);
            }
            Thread.currentThread();
            Thread.yield();
        }
    }

    final synchronized void setVarBindList(SnmpVarBindList snmpVarBindList) {
        this.varBindList = snmpVarBindList;
        if (this.internalVarBind == null || this.internalVarBind.length != this.varBindList.size()) {
            this.internalVarBind = new SnmpVarBind[this.varBindList.size()];
        }
        this.varBindList.copyInto(this.internalVarBind);
    }

    final synchronized boolean fixVarBindList(SnmpVarBind[] snmpVarBindArray, int n) {
        int n2;
        int n3 = n;
        SnmpVarBind snmpVarBind = null;
        if (logger.finerOn()) {
            logger.finer("fixVarBindList", "Fix Pdu at index " + n);
        }
        for (n2 = 0; n2 < snmpVarBindArray.length && (snmpVarBindArray[n2] == null || --n >= 0); ++n2) {
        }
        if (n2 >= snmpVarBindArray.length) {
            this.reason = "Can't find variable binding with idx = " + n3;
            if (logger.finestOn()) {
                logger.finest("fixVarBindList", this.reason);
            }
            return false;
        }
        snmpVarBind = snmpVarBindArray[n2];
        snmpVarBindArray[n2] = null;
        switch (this.getCommand()) {
            case 160: {
                snmpVarBind.status = 4;
                break;
            }
            case 161: {
                snmpVarBind.status = 5;
            }
        }
        return true;
    }

    final void processResponse() throws SnmpStatusException {
        if (!this.inProgress()) {
            this.responsePdu = null;
            return;
        }
        if (this.errorStatus >= 240) {
            this.handleInternalError("Internal Error...");
            return;
        }
        try {
            this.parsePduPacket(this.responsePdu);
            if (logger.finerOn()) {
                logger.finer("processResponse", "errstatus = " + this.errorStatus);
            }
            switch (this.errorStatus) {
                case 0: {
                    this.handleSuccess();
                    return;
                }
                case 224: {
                    this.handleTimeout();
                    return;
                }
                case 240: {
                    this.handleInternalError("Unknown internal error.  deal with it later!");
                    return;
                }
                case 231: {
                    this.setErrorStatusAndIndex(1, 0);
                    if (this.handleTooBigError()) {
                        return;
                    }
                    this.handleError("Cannot handle too-big situation...");
                    return;
                }
                case 230: {
                    this.initializeAndFire(0L);
                    return;
                }
            }
            if (this.command != 163 && this.command != 165) {
                this.translateErrorIndex();
            }
            this.handleError("Error status set in packet...!!");
            return;
        }
        catch (SnmpStatusException snmpStatusException) {
            this.errorStatus = 226;
            this.reason = snmpStatusException.getMessage();
        }
        catch (Exception exception) {
            if (logger.finestOn()) {
                logger.finest("processResponse", exception);
            }
            this.reason = exception.getMessage();
        }
        this.handleInternalError(this.reason);
    }

    final synchronized void setErrorStatusAndIndex(int n, int n2) {
        this.errorStatus = n;
        this.errorIndex = n2;
    }

    final void invokeOnResponse(Object object) {
        if (object != null) {
            if (object instanceof SnmpPduRequestType) {
                this.responsePdu = (SnmpPdu)object;
            } else {
                return;
            }
        }
        this.setRequestStatus(9);
        this.queueResponse();
    }

    final synchronized void deleteRequest() {
        this.session.deleteRequest(this);
    }

    final synchronized SnmpVarBindList getVarBindList() {
        return this.varBindList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendPduPacket(byte[] byArray, int n) throws IOException {
        SnmpSocket snmpSocket;
        if (logger.finerOn()) {
            logger.finer("sendPduPacket", "Send to peer. " + this.thePeer.toString() + "Length = " + n + "\nDump : \n" + SnmpMsg.dumpHexBuffer(byArray, 0, n));
        }
        SnmpSocket snmpSocket2 = snmpSocket = this.getSnmpSession().getSocket();
        synchronized (snmpSocket2) {
            snmpSocket.sendPacket(byArray, n, this.thePeer.getDestAddr(), this.thePeer.getDestPort());
            this.setRequestSentTime(System.currentTimeMillis());
        }
    }

    final synchronized String getRequestCreationType() {
        switch (this.mode) {
            case 1: {
                return "UserCreated.";
            }
            case 2: {
                return "Internal_" + this.callback.getClass().getName();
            }
        }
        return "UnknownRequest????";
    }

    final void translateErrorIndex() {
        if (!this.fixPduOnError()) {
            return;
        }
        SnmpVarBindList snmpVarBindList = this.getVarBindList();
        int n = snmpVarBindList.size();
        for (int i = 0; i < n; ++i) {
            if (snmpVarBindList.getVarBindAt(i).hasVarBindException()) continue;
            --this.errorIndex;
            if (this.errorIndex != 0) continue;
            this.errorIndex = i;
            return;
        }
    }

    final synchronized void setPreviousPollTimestamp(long l) {
        this.prevPollTime = l;
    }

    final void setRequestSentTime(long l) {
        ++this.numTries;
        this.setPreviousPollTimestamp(l);
        this.waitTimeForResponse = this.prevPollTime + (long)this.timeout;
        this.setRequestStatus(5);
        if (logger.finerOn()) {
            logger.finer("setRequestSentTime", "Request Successfully sent");
        }
        SnmpQManager.getTheInstance().addWaiting(this);
    }

    final synchronized void initNewRequest() {
        this.requestId = requestCounter.getNewId();
    }

    long timeRemainingForAction(long l) {
        switch (this.reqState) {
            case 3: {
                return this.nextPollTime - l;
            }
            case 5: {
                return this.waitTimeForResponse - l;
            }
        }
        return -1L;
    }

    public static final String statusDescription(int n) {
        switch (n) {
            case 3: {
                return "Waiting to send.";
            }
            case 5: {
                return "Waiting for reply.";
            }
            case 9: {
                return "Response arrived.";
            }
            case 16: {
                return "Aborted by user.";
            }
            case 32: {
                return "Timeout Occurred.";
            }
            case 64: {
                return "Internal error.";
            }
            case 128: {
                return "Results available";
            }
            case 256: {
                return "Request in createAndWait state";
            }
        }
        return "Unknown Request state.";
    }

    final synchronized void setRequestStatus(int n) {
        this.reqState = n;
    }
}

