/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.runtime.ejbproxy;

import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.descriptor.ProviderServiceDescriptor;
import it.imolinfo.jbi4ejb.exception.EJBDeployException;
import it.imolinfo.jbi4ejb.exception.EJBWSDLGenerationException;
import it.imolinfo.jbi4ejb.runtime.ejbproxy.EJBClasses;
import it.imolinfo.jbi4ejb.runtime.ejbproxy.EJBProxyUtils;
import it.imolinfo.jbi4ejb.runtime.ejbproxy.StatelessEJBProxy;
import it.imolinfo.jbi4ejb.webservice.generator.Util;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Properties;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatelessEJBProxyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(StatelessEJBProxyFactory.class);

    private StatelessEJBProxyFactory() {
    }

    public static StatelessEJBProxy createEJBProxy(File wsdl, ProviderServiceDescriptor serviceDescriptor, File tempDir, List<String> jarFilesName) throws EJBDeployException {
        URLClassLoader ejbInvokeClassLoader;
        String portTypeName = serviceDescriptor.getPortTypeName().getLocalPart();
        EJBClasses ejbClasses = EJBProxyUtils.createEJBClasses(wsdl, serviceDescriptor.getSerialVersionUID(), tempDir, jarFilesName, null, portTypeName);
        try {
            ejbInvokeClassLoader = Util.getURLClassLoader(ejbClasses.getEjbClassesPath());
        }
        catch (MalformedURLException e) {
            LOG.error(e.getMessage());
            throw new EJBDeployException(e);
        }
        ORB orb = ORB.init((String[])new String[0], (Properties)serviceDescriptor.getOrbProperties());
        java.lang.Object remoteBean = EJBProxyUtils.createStatelessEJBFromCorbaName(serviceDescriptor.getName(), ejbClasses.getRemoteInterfaceClassName(), ejbInvokeClassLoader, orb);
        StatelessEJBProxy ejbProxy = new StatelessEJBProxy(ejbClasses.getRemoteInterfaceClassName(), remoteBean, ejbInvokeClassLoader, orb);
        try {
            Class<?> myRemoteInterface = ejbInvokeClassLoader.loadClass(ejbClasses.getRemoteInterfaceClassName());
            ejbProxy.setRemoteInterfaceClass(myRemoteInterface);
        }
        catch (ClassNotFoundException e) {
            String msg = "Error in getting the remote interface class from the EJB client class loader:" + e.getMessage();
            LOG.error(msg);
            throw new EJBDeployException(msg);
        }
        return ejbProxy;
    }

    public static StatelessEJBProxy getEJBFromCorbaname(String wsdlPath, String remoteInterfaceClassName, String corbaName, Properties classesId, List<String> jarFilesName, Properties orbParams) throws EJBWSDLGenerationException {
        return StatelessEJBProxyFactory.getEJBFromCorbaname(wsdlPath, remoteInterfaceClassName, corbaName, classesId, jarFilesName, orbParams, false);
    }

    public static StatelessEJBProxy getEJBFromCorbanameUsingRMIClassloader(String wsdlPath, String remoteInterfaceClassName, String corbaName, Properties classesId, List<String> jarFilesName, Properties orbParams) throws EJBWSDLGenerationException {
        return StatelessEJBProxyFactory.getEJBFromCorbaname(wsdlPath, remoteInterfaceClassName, corbaName, classesId, jarFilesName, orbParams, true);
    }

    public static StatelessEJBProxy getEJBFromJNDIName(String wsdlPath, String remoteInterfaceClassName, String jndiName, Properties jndiParams, Properties orbProperties, Properties classesId, List<String> jarFilesName) throws EJBWSDLGenerationException {
        URLClassLoader ejbInvokeClassLoader = null;
        java.lang.Object remoteBean = null;
        try {
            String classesDir = EJBProxyUtils.createEJBClasses(wsdlPath, remoteInterfaceClassName, null, classesId, jarFilesName);
            LOG.debug("The classes are in the directory:" + classesDir);
            ejbInvokeClassLoader = Util.getURLClassLoader(classesDir);
            ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(ejbInvokeClassLoader);
            ObjectImpl remoteHome = EJBProxyUtils.createStatelessHomeFromJNDI(jndiName, jndiParams, remoteInterfaceClassName, ejbInvokeClassLoader);
            ORB orb = remoteHome._orb();
            LOG.info("ORB found: " + orb);
            remoteBean = EJBProxyUtils.getEJBFromCorbaHomeObject((Object)remoteHome, orb, remoteInterfaceClassName, ejbInvokeClassLoader);
            Thread.currentThread().setContextClassLoader(previousClassLoader);
            StatelessEJBProxy ejbProxy = new StatelessEJBProxy(remoteInterfaceClassName, remoteBean, ejbInvokeClassLoader, orb);
            return ejbProxy;
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
            throw new EJBWSDLGenerationException(ex);
        }
    }

    public static StatelessEJBProxy getEJBFromCorbaname(String wsdlPath, String remoteInterfaceClassName, String corbaName, Properties classesId, List<String> jarFilesName, Properties orbParams, boolean dynamicClassLoading) throws EJBWSDLGenerationException {
        URLClassLoader ejbInvokeClassLoader = null;
        java.lang.Object remoteBean = null;
        try {
            ORB orb = null;
            orb = orbParams != null ? ORB.init((String[])new String[0], (Properties)orbParams) : ORB.init((String[])new String[0], (Properties)new Properties());
            if (!dynamicClassLoading) {
                String classesDir = EJBProxyUtils.createEJBClasses(wsdlPath, remoteInterfaceClassName, null, classesId, jarFilesName);
                LOG.debug("The ejb client classes are in the directory:" + classesDir);
                ejbInvokeClassLoader = Util.getURLClassLoader(classesDir);
                remoteBean = EJBProxyUtils.createStatelessEJBFromCorbaName(corbaName, remoteInterfaceClassName, ejbInvokeClassLoader, orb);
            } else {
                LOG.debug("Dynamic invocation, classes loaded using RMI");
                Class myRemoteInterfaceClass = EJBProxyUtils.getInterfaceClass(remoteInterfaceClassName, wsdlPath, jarFilesName);
                LOG.debug("Loaded remote interface: " + myRemoteInterfaceClass);
                remoteBean = EJBProxyUtils.createStatelessEJBUsingRMIClassLoader(corbaName, remoteInterfaceClassName, myRemoteInterfaceClass, orb);
            }
            StatelessEJBProxy ejbProxy = new StatelessEJBProxy(remoteInterfaceClassName, remoteBean, ejbInvokeClassLoader, orb);
            return ejbProxy;
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
            throw new EJBWSDLGenerationException(ex);
        }
    }
}

