/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.webservice.generator.bcm;

import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.exception.ClassGenerationException;
import it.imolinfo.jbi4ejb.webservice.generator.EJBUtils;
import java.util.ArrayList;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class RemoveEJBInterfaceAdapter
extends ClassAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveEJBInterfaceAdapter.class);
    private String classesDirName = null;

    public RemoveEJBInterfaceAdapter(ClassVisitor arg0, String classesDirName) {
        super(arg0);
        this.classesDirName = classesDirName;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        int i;
        LOG.debug("Removing java/rmi/Remote from the class: " + name);
        ArrayList<String> newInterfaces = new ArrayList<String>();
        if (interfaces != null) {
            for (i = 0; i < interfaces.length; ++i) {
                String newInterface = interfaces[i];
                if (newInterface.equals("java/rmi/Remote") || newInterface.equals("javax/ejb/EJBObject")) continue;
                newInterfaces.add(interfaces[i]);
            }
        }
        for (i = 0; i < newInterfaces.size(); ++i) {
            String interfaceClassname = ((String)newInterfaces.get(i)).replace('/', '.');
            try {
                EJBUtils.removeEJBRemoteInterface(interfaceClassname, this.classesDirName);
                continue;
            }
            catch (ClassGenerationException e) {
                String msg = "Error in removing java.rmi.Remote from interface " + e.getMessage();
                LOG.warn(msg, e);
            }
        }
        String[] newInterfacesArray = newInterfaces.toArray(new String[0]);
        super.visit(version, access, name, signature, superName, newInterfacesArray);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        ArrayList<String> newExceptions = new ArrayList<String>();
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                String exception = exceptions[i];
                if (!exception.equals("java/rmi/RemoteException") && !exception.equals("javax/ejb/EJBException")) {
                    newExceptions.add(exceptions[i]);
                    continue;
                }
                LOG.debug("Removing java/rmi/RemoteException from the method: " + name);
            }
        }
        String[] newExceptionsArray = newExceptions.toArray(new String[0]);
        return super.visitMethod(access, name, desc, signature, newExceptionsArray);
    }
}

