/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.engine;

import com.sun.etl.engine.ETLPersistableMessage;
import com.sun.sql.framework.utils.StringUtil;
import com.sun.sql.framework.utils.XmlUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ETLPersistableMessageImpl
implements ETLPersistableMessage {
    private static final int CURRENT_VERSION = 1;
    private static final String ELEMENT_PART = "part";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    private String etlWSMessage;
    private Map parts = new HashMap();
    private int version = 1;

    public void addPart(String partName, Object partValue) {
        this.parts.put(partName, partValue);
    }

    public Object getPart(String partName) {
        return this.parts.get(partName);
    }

    public Map getParts() {
        return this.parts;
    }

    public void persist(DataOutputStream dos) throws Exception {
        switch (this.version) {
            case 1: {
                dos.writeInt(this.version);
                this.etlWSMessage = this.toXMLString();
                dos.write(this.etlWSMessage.getBytes("UTF-8"));
                break;
            }
            default: {
                throw new Exception("Unsupported version: " + this.version);
            }
        }
    }

    public void restore(DataInputStream dis) throws Exception {
        int tmpVersion = dis.readInt();
        switch (tmpVersion) {
            case 1: {
                byte[] wsMessageBytes = this.getContentsAsBytes(dis);
                this.etlWSMessage = new String(wsMessageBytes, "UTF-8");
                this.setParts(this.parseXML(this.etlWSMessage));
                break;
            }
            default: {
                throw new Exception("Unsupported version: " + tmpVersion);
            }
        }
        this.version = tmpVersion;
    }

    public void setParts(Map newParts) {
        this.parts.clear();
        this.parts.putAll(newParts);
    }

    private byte[] getContentsAsBytes(DataInputStream dis) throws IOException {
        int bytesRead;
        byte[] chunk = new byte[1024];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((bytesRead = dis.read(chunk)) != -1) {
            bos.write(chunk, 0, bytesRead);
        }
        bos.close();
        return bos.toByteArray();
    }

    private String toXMLString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n");
        buffer.append("<eTLWSMessage>\n");
        for (Object key : this.parts.keySet()) {
            Object value = this.parts.get(key);
            if (value == null) continue;
            buffer.append("\t<").append(ELEMENT_PART).append(" ").append(ATTR_NAME).append("=");
            buffer.append("\"").append(key).append("\" ");
            buffer.append(ATTR_VALUE).append("=").append("\"").append(XmlUtil.escapeXML(value.toString().trim())).append("\"");
            buffer.append("/>\n");
        }
        buffer.append("</eTLWSMessage>");
        return buffer.toString();
    }

    private Map parseXML(String messageXml) {
        Map msgMap = Collections.EMPTY_MAP;
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbFactory.newDocumentBuilder();
            Document doc = db.parse(new InputSource(new StringReader(messageXml)));
            Element root = doc.getDocumentElement();
            if (root != null) {
                msgMap = this.parseParts(root.getChildNodes());
            }
        }
        catch (ParserConfigurationException ignore) {
            ignore.printStackTrace();
        }
        catch (SAXException ignore) {
            ignore.printStackTrace();
        }
        catch (IOException ignore) {
            ignore.printStackTrace();
        }
        return msgMap;
    }

    private Map parseParts(NodeList childNodes) {
        HashMap<String, String> msgMap = new HashMap<String, String>(childNodes.getLength());
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1 || !ELEMENT_PART.equals(((Element)node).getNodeName())) continue;
            Element part = (Element)node;
            String name = part.getAttribute(ATTR_NAME);
            String value = part.getAttribute(ATTR_VALUE);
            if (StringUtil.isNullString(name) || value == null) continue;
            msgMap.put(name, value);
        }
        return msgMap;
    }
}

