/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.engine.impl;

import com.sun.etl.engine.ETLEngine;
import com.sun.etl.engine.ETLTaskNode;
import com.sun.etl.engine.impl.SimpleTask;
import com.sun.etl.engine.utils.ETLException;
import com.sun.etl.runtime.RuntimeUtil;
import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.jdbc.DBConnectionFactory;
import com.sun.sql.framework.jdbc.SQLPart;
import com.sun.sql.framework.utils.Logger;
import com.sun.sql.framework.utils.ScEncrypt;
import com.sun.sql.framework.utils.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InitTask
extends SimpleTask {
    private static final String LOG_CATEGORY = InitTask.class.getName();
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("PASSWORD\\ *=\\ *'([^']*)'");
    private static final Pattern USERNAME_PATTERN = Pattern.compile("USERNAME\\ *=\\ *'([^']*)'");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String process(ETLTaskNode node) throws ETLException {
        if (node == null) {
            throw new ETLException(this.DN + "Init task node is null....");
        }
        ETLEngine engine = node.getParent();
        if (!StringUtil.isNullString(node.getDisplayName())) {
            this.DN = this.DN + " <" + node.getDisplayName().trim() + ">";
        }
        List conDefList = engine.getConnectionDefList();
        Logger.print(10000, LOG_CATEGORY, this.DN + "Processing init task...");
        try {
            boolean isInitDone = false;
            Class<InitTask> clazz = InitTask.class;
            synchronized (InitTask.class) {
                isInitDone = this.doesSummaryTableExists(node);
                if (!isInitDone) {
                    super.createSummaryTable(node);
                }
                // ** MonitorExit[var5_6] (shouldn't be in output)
                List sqlParts = node.getOptionalTasks();
                if (sqlParts.size() != 0) {
                    Map rtAttributes = node.getParent().getInputAttributes();
                    this.execute(sqlParts, rtAttributes, conDefList, isInitDone);
                } else {
                    Logger.print(10000, LOG_CATEGORY, "No initialization required.");
                }
            }
        }
        catch (Exception e) {
            Logger.print(40000, LOG_CATEGORY, (Object)(this.DN + "Failed to execute InitTask"), e);
            throw new ETLException(this.DN + "Failed to execute InitTask.", e);
        }
        return "Success";
    }

    private boolean doesSummaryTableExists(ETLTaskNode node) throws ETLException {
        Iterator iter;
        List sqlParts = node.getOptionalTasks();
        Connection conn = null;
        boolean tableExists = false;
        if (sqlParts.size() != 0 && (iter = sqlParts.iterator()).hasNext()) {
            SQLPart part = (SQLPart)iter.next();
            String sql = part.getSQL();
            String poolName = part.getConnectionPoolName();
            try {
                conn = this.getConnection(poolName, node.getParent().getConnectionDefList());
                tableExists = super.isTableExists(conn, "SELECT 1 FROM SUMMARY", node);
                DBConnectionFactory.getInstance().closeConnection(conn);
            }
            catch (BaseException e) {
                try {
                    Logger.print(40000, LOG_CATEGORY, (Object)(this.DN + "Failed to execute InitTask:doesSummaryTableExists"), e);
                    throw new ETLException(this.DN + "Failed to execute InitTask:doesSummaryTableExists", e);
                }
                catch (Throwable throwable) {
                    DBConnectionFactory.getInstance().closeConnection(conn);
                    throw throwable;
                }
            }
        }
        return tableExists;
    }

    private String associateDynamicFileWithTable(SQLPart sqlPart, Map inputAttrs) throws Exception {
        Iterator iter = inputAttrs.entrySet().iterator();
        String rawSQL = sqlPart.getSQL();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            String keyName = (String)e.getKey();
            String value = (String)e.getValue();
            if (StringUtil.isNullString(value)) {
                value = sqlPart.getDefaultValue();
            }
            value = StringUtil.escapeJavaLiteral(value);
            rawSQL = StringUtil.replaceAll(rawSQL, value, "\\$" + keyName);
        }
        return rawSQL;
    }

    private String decryptDbLinkSql(String rawSql) {
        String processedSql = rawSql;
        String userName = null;
        String encryptedPassword = null;
        String password = null;
        Matcher matcher = USERNAME_PATTERN.matcher(rawSql);
        if (matcher.find() && !StringUtil.isNullString(userName = matcher.group(1)) && (matcher = PASSWORD_PATTERN.matcher(rawSql)).find()) {
            encryptedPassword = matcher.group(1);
            try {
                Map resolved = RuntimeUtil.getLDAPResolvedParameters(userName, encryptedPassword);
                userName = (String)resolved.get("userName");
                encryptedPassword = (String)resolved.get("password");
                if (!StringUtil.isNullString(encryptedPassword)) {
                    password = ScEncrypt.decrypt(userName, encryptedPassword);
                    processedSql = matcher.replaceFirst("PASSWORD='" + StringUtil.escapeJavaRegexpChars(password) + "'");
                }
                if (!StringUtil.isNullString(userName)) {
                    matcher = USERNAME_PATTERN.matcher(processedSql);
                    processedSql = matcher.replaceFirst("USERNAME='" + StringUtil.escapeJavaRegexpChars(userName) + "'");
                }
            }
            catch (Exception ex) {
                Logger.printThrowable(40000, LOG_CATEGORY, this, this.DN + "InitTask:decryptDbLinkSql", ex);
            }
        }
        return processedSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doExecute(SQLPart sqlPart, List connDefs, boolean useAutoCommit) throws SQLException, BaseException {
        Connection conn = null;
        Statement stmt = null;
        boolean oldCommitType = false;
        String sql = sqlPart.getSQL();
        String poolName = sqlPart.getConnectionPoolName();
        try {
            if (sql != null) {
                conn = this.getConnection(poolName, connDefs);
                if (useAutoCommit) {
                    oldCommitType = conn.getAutoCommit();
                    conn.setAutoCommit(true);
                }
                stmt = conn.createStatement();
                Logger.print(10000, LOG_CATEGORY, sql);
                stmt.executeUpdate(sql);
            }
        }
        finally {
            if (useAutoCommit) {
                conn.setAutoCommit(oldCommitType);
            }
            this.closeStatement(stmt);
            DBConnectionFactory.getInstance().closeConnection(conn);
        }
    }

    private void execute(List sqlParts, Map rtAttributes, List conDefList, boolean isInitDone) throws SQLException, Exception {
        for (SQLPart part : sqlParts) {
            String sql = part.getSQL();
            String poolName = part.getConnectionPoolName();
            if (StringUtil.isNullString(sql)) continue;
            sql = sql.trim();
            Logger.print(10000, LOG_CATEGORY, sql);
            if (sql.startsWith("CREATE DATABASE LINK") && !isInitDone) {
                SQLPart processedSqlPart = new SQLPart(this.decryptDbLinkSql(sql), part.getType(), poolName);
                this.doExecute(processedSqlPart, conDefList, true);
                continue;
            }
            if (sql.startsWith("DROP") && !isInitDone) {
                this.doExecute(part, conDefList, true);
                continue;
            }
            if (sql.startsWith("CREATE")) {
                if (rtAttributes != null && rtAttributes.size() != 0) {
                    sql = this.associateDynamicFileWithTable(part, rtAttributes);
                    part.setSQL(sql);
                }
                this.doExecute(part, conDefList, true);
                continue;
            }
            if (!"initializeStatements".equals(part.getType())) continue;
            this.doExecute(part, conDefList, true);
        }
    }
}

