/*
 * Decompiled with CFR 0.152.
 */
package com.sun.etl.engine.impl;

import com.sun.etl.engine.ETLTaskNode;
import com.sun.etl.engine.impl.SimpleTask;
import com.sun.etl.engine.utils.ETLException;
import com.sun.etl.engine.utils.MessageManager;
import com.sun.sql.framework.utils.Logger;
import com.sun.sql.framework.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class WaitTask
extends SimpleTask {
    private Set mDependentTasks;
    private Set mFailedTasks;
    private Set mSuccessfulTasks = new HashSet();

    public WaitTask() {
        this.mFailedTasks = new HashSet();
        this.mDependentTasks = new HashSet();
    }

    public boolean hasActiveDependencies() {
        Logger.print(10000, WaitTask.class.getName(), "Active dependency count: " + this.mDependentTasks.size());
        return this.mDependentTasks.size() != 0;
    }

    public void markAsFailure(String nodeId) {
        if (this.mDependentTasks.remove(nodeId)) {
            Logger.print(10000, WaitTask.class.getName(), nodeId + " marked as failed." + NL + "Remaining dependencies: " + this.mDependentTasks.size());
            this.mFailedTasks.add(nodeId);
        }
    }

    public void markAsSuccess(String nodeId) {
        if (this.mDependentTasks.remove(nodeId)) {
            Logger.print(10000, WaitTask.class.getName(), nodeId + " marked as successful." + NL + "Remaining dependencies: " + this.mDependentTasks.size());
            this.mSuccessfulTasks.add(nodeId);
        }
    }

    public String process(ETLTaskNode node) throws ETLException {
        boolean dependentTasksSucceeded;
        if (!StringUtil.isNullString(node.getDisplayName())) {
            this.DN = this.DN + " <" + node.getDisplayName().trim() + ">";
        }
        boolean bl = dependentTasksSucceeded = this.mDependentTasks.isEmpty() && this.mFailedTasks.isEmpty();
        if (!dependentTasksSucceeded) {
            ArrayList idList = new ArrayList(this.mFailedTasks);
            Collections.sort(idList);
            String failedTaskIds = StringUtil.createDelimitedStringFrom(idList);
            MessageManager msgMgr = MessageManager.getManager(WaitTask.class);
            if (failedTaskIds.trim().length() == 0) {
                failedTaskIds = msgMgr.getString("MSG_common_unknown");
            }
            String msg = msgMgr.getString("MSG_wait_failed_dependencies", failedTaskIds);
            Logger.print(10000, WaitTask.class.getName(), this.DN + msg);
            node.fireETLEngineLogEvent(msg);
        }
        return dependentTasksSucceeded ? "Success" : "Exception";
    }

    public void setDependentTaskIds(Collection taskIds) {
        this.mDependentTasks = new HashSet(taskIds);
    }

    public void setDependentTaskIds(String csvIds) {
        this.setDependentTaskIds(StringUtil.createStringListFrom(csvIds));
    }
}

