/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sql.framework.utils;

import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.utils.StringUtil;
import com.sun.sql.framework.utils.XmlUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;

public class Attribute
implements Cloneable {
    public static final String TAG_ATTR = "attr";
    static final String LOG_CATEGORY = Attribute.class.getName();
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_VALUE = "value";
    private static final List LEGAL_TYPES = Arrays.asList(String.class.getName(), Integer.class.getName(), Boolean.class.getName(), List.class.getName(), ArrayList.class.getName());
    private String attributeName;
    private String attributeType;
    private Object attributeValue;

    public static boolean isValidType(String typeName) {
        return LEGAL_TYPES.contains(typeName);
    }

    public Attribute() {
    }

    public Attribute(Attribute src) throws BaseException {
        if (src == null) {
            throw new IllegalArgumentException("can not create new instance of Attribute using copy constructor for " + src);
        }
        this.copyFrom(src);
    }

    public Attribute(String name, Object value) {
        if (StringUtil.isNullString(name)) {
            throw new IllegalArgumentException("Must supply non-empty String value for name.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Must supply non-null Object ref for value.");
        }
        this.attributeType = value.getClass().getName();
        if (!Attribute.isValidType(this.attributeType)) {
            throw new IllegalArgumentException("Invalid type - Attribute cannot accept a value of type " + this.attributeType);
        }
        this.attributeName = name;
        this.attributeValue = value;
    }

    public Object clone() throws CloneNotSupportedException {
        Attribute attr;
        try {
            attr = new Attribute(this);
        }
        catch (BaseException ex) {
            throw new CloneNotSupportedException("can not create clone of " + this.toString());
        }
        return attr;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        boolean response = false;
        if (o instanceof Attribute) {
            Attribute attr = (Attribute)o;
            boolean bl = this.attributeName != null ? this.attributeName.equals(attr.attributeName) : (response = attr.attributeName == null);
            response &= this.attributeType != null ? this.attributeType.equals(attr.attributeType) : attr.attributeType == null;
            response &= this.attributeValue != null ? this.attributeValue.equals(attr.attributeValue) : attr.attributeValue != null;
        }
        return response;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    public Object getAttributeValue() {
        return this.attributeValue;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode += this.attributeName != null ? this.attributeName.hashCode() : 0;
        hashCode += this.attributeType != null ? this.attributeType.hashCode() : 0;
        return hashCode += this.attributeValue != null ? this.attributeValue.hashCode() : 0;
    }

    public void parseXMLString(Element xmlElement) throws BaseException {
        this.attributeName = xmlElement.getAttribute(ATTR_NAME);
        String value = xmlElement.getAttribute(ATTR_VALUE);
        if (value != null) {
            this.createValueFor(value, xmlElement.getAttribute(ATTR_TYPE));
        }
    }

    public void setAttributeName(String aName) {
        this.attributeName = aName;
    }

    public void setAttributeType(String aType) {
        this.attributeType = aType;
    }

    public void setAttributeValue(Object aValue) {
        this.attributeValue = aValue;
    }

    public void setAttributeValue(String aValue) {
        this.attributeValue = aValue;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(50);
        buf.append("name = " + this.getAttributeName() + "\n");
        buf.append("type = " + this.getAttributeType() + "\n");
        buf.append("value = " + this.getAttributeValue());
        return buf.toString();
    }

    public String toXMLString() {
        return this.toXMLString("");
    }

    public String toXMLString(String prefix) {
        StringBuffer xml = new StringBuffer();
        if (prefix == null) {
            prefix = "";
        }
        if (this.attributeValue != null) {
            xml.append(prefix);
            xml.append("<attr ");
            xml.append("name=\"" + this.attributeName).append("\" ");
            xml.append("type=\"" + this.attributeType).append("\" ");
            xml.append("value=\"");
            if (this.attributeType.equals(List.class.getName()) || this.attributeType.equals(ArrayList.class.getName())) {
                xml.append(StringUtil.createDelimitedStringFrom((List)this.attributeValue));
            } else {
                xml.append(this.attributeValue != null ? XmlUtil.escapeXML(this.attributeValue.toString()) : "null");
            }
            xml.append("\" />\n");
        }
        return xml.toString();
    }

    private void copyFrom(Attribute src) throws BaseException {
        this.setAttributeName(src.getAttributeName());
        this.setAttributeType(src.getAttributeType());
        if (src.getAttributeValue() != null) {
            this.createValueFor(src.getAttributeValue().toString(), src.getAttributeType());
        }
    }

    private void createValueFor(String value, String typeName) throws BaseException {
        if (StringUtil.isNullString(typeName)) {
            throw new IllegalArgumentException("Must supply non-empty String value for typeName.");
        }
        if (!Attribute.isValidType(typeName)) {
            throw new IllegalArgumentException("Invalid type - Attribute cannot accept a value of type " + typeName);
        }
        if (value == null) {
            throw new IllegalArgumentException("Must supply non-null Object ref for value.");
        }
        this.attributeType = typeName;
        if (typeName.equals(List.class.getName()) || typeName.equals(ArrayList.class.getName())) {
            this.attributeValue = StringUtil.createStringListFrom(value);
        } else if (typeName.equals("java.lang.String")) {
            this.attributeValue = value;
        } else {
            try {
                Class<?> objClass = Class.forName(typeName, true, this.getClass().getClassLoader());
                Constructor<?> constructor = objClass.getConstructor(String.class);
                this.attributeValue = constructor.newInstance(value);
            }
            catch (NoSuchMethodException e) {
                throw new BaseException("Type does not have a constructor with a single String parameter: " + typeName, e);
            }
            catch (Exception e) {
                throw new BaseException("Could not load class for type '" + this.attributeType + "'.", e);
            }
        }
    }
}

