/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sql.framework.utils;

import com.sun.sql.framework.utils.Attribute;
import com.sun.sql.framework.utils.Logger;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AttributeFactory {
    static final String LOG_CATEGORY = AttributeFactory.class.getName();
    private static HashMap tagToClassMap = new HashMap();
    private Map attributeMap = new HashMap();

    public static Object invokeGetter(Object bean, String propertyName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, IntrospectionException {
        return AttributeFactory.invokeGetter(bean, propertyName, null, null);
    }

    public static Object invokeGetter(Object obj, String propertyName, Class[] parameterTypes, Object[] params) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, IntrospectionException {
        Method readMethod;
        String base = AttributeFactory.capitalize(propertyName);
        try {
            readMethod = obj.getClass().getMethod("is" + base, parameterTypes);
        }
        catch (Exception getterExc) {
            readMethod = obj.getClass().getMethod("get" + base, parameterTypes);
        }
        return readMethod.invoke(obj, params);
    }

    public static Object invokeSetter(Object bean, String propertyName, Object val) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, IntrospectionException {
        PropertyDescriptor pd = new PropertyDescriptor(propertyName, bean.getClass());
        Method method = pd.getWriteMethod();
        return method.invoke(bean, val);
    }

    public static void invokeSetters(Object obj, Attributes attrs) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, IntrospectionException {
        for (int i = 0; i < attrs.getLength(); ++i) {
            if (attrs.getQName(i).equals("class")) continue;
            Class[] cls = new Class[]{String.class};
            String base = AttributeFactory.capitalize(attrs.getQName(i));
            Method method = obj.getClass().getMethod("set" + base, cls);
            method.invoke(obj, attrs.getValue(attrs.getQName(i)));
        }
    }

    static String capitalize(String s) {
        if (s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public void endElement(String uri, String localName, String qName) {
    }

    public Map getAttributeMap() {
        return this.attributeMap;
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        try {
            if (qName.equals("attr")) {
                Attribute attr = (Attribute)this.createObject(uri, localName, qName, attrs);
                this.attributeMap.put(attr.getAttributeName(), attr);
            }
        }
        catch (Exception ex) {
            String msg = "Error occured while parsing following :\n uri = " + uri + "\n localName = " + localName + "\n qName = " + qName;
            Logger.printThrowable(40000, LOG_CATEGORY, this, msg, ex);
            throw new SAXException(msg, ex);
        }
    }

    private Object createObject(String uri, String localName, String qName, Attributes attrs) throws NoSuchMethodException, InvocationTargetException, ClassNotFoundException, InstantiationException, IllegalAccessException, IntrospectionException {
        String className = attrs.getValue("class");
        if (className == null && (className = (String)tagToClassMap.get(qName)) == null) {
            return null;
        }
        Class<?> cl = Class.forName(className, true, this.getClass().getClassLoader());
        Object obj = cl.newInstance();
        AttributeFactory.invokeSetters(obj, attrs);
        return obj;
    }

    static {
        tagToClassMap.put("attr", "com.sun.sql.framework.utils.Attribute");
    }
}

