/*
 * Decompiled with CFR 0.152.
 */
package com.sun.axiondb.functions;

import com.sun.axiondb.functions.EViewFunctionUtil;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.StringType;

public class StandardizeFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private static final DataType RETURN_TYPE = new StringType();

    public StandardizeFunction() {
        super("Standardize");
    }

    private String convertToString(Object object) throws AxionException {
        return (String)RETURN_TYPE.convert(object);
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Object val = null;
        Selectable sel1 = this.getArgument(0);
        Object stdType = sel1.evaluate(row);
        if (null == stdType) {
            throw new AxionException("Standardization Type 'Address' or 'BusinessName' not specified");
        }
        Selectable sel2 = this.getArgument(1);
        Object partType = sel2.evaluate(row);
        if (null == partType) {
            throw new AxionException("Standardization identifier null for" + stdType + "Not supported");
        }
        Selectable sel3 = this.getArgument(2);
        Object col = sel3.evaluate(row);
        if (null == col) {
            return null;
        }
        DataType type = sel3.getDataType();
        val = type.convert(col);
        String locale = null;
        if (this.getArgumentCount() == 4) {
            Selectable sel4 = this.getArgument(3);
            locale = this.convertToString(sel4.evaluate(row));
        }
        String obj = EViewFunctionUtil.getInstance().standardize(this.convertToString(stdType), this.convertToString(val), locale).getValue(this.convertToString(partType));
        return obj;
    }

    public ConcreteFunction makeNewInstance() {
        return new StandardizeFunction();
    }

    public DataType getDataType() {
        return RETURN_TYPE;
    }

    public boolean isValid() {
        return this.getArgumentCount() >= 3;
    }
}

