/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.DatabaseLink;
import org.axiondb.Index;
import org.axiondb.IndexFactory;
import org.axiondb.Sequence;
import org.axiondb.Table;
import org.axiondb.TableFactory;
import org.axiondb.TableIdentifier;
import org.axiondb.TransactionManager;
import org.axiondb.event.DatabaseModificationListener;
import org.axiondb.functions.ConcreteFunction;

public interface Database {
    public static final String COMMIT_SIZE = "COMMITSIZE";

    public void addDatabaseModificationListener(DatabaseModificationListener var1);

    public void addIndex(Index var1, Table var2) throws AxionException;

    public void addIndex(Index var1, Table var2, boolean var3) throws AxionException;

    public void addTable(Table var1) throws AxionException;

    public void checkpoint() throws AxionException;

    public void createDatabaseLink(DatabaseLink var1) throws AxionException;

    public void createSequence(Sequence var1) throws AxionException;

    public int defragTable(String var1) throws AxionException;

    public void dropDatabaseLink(String var1) throws AxionException;

    public void dropDependentExternalDBTable(List var1) throws AxionException;

    public void dropDependentViews(List var1) throws AxionException;

    public void dropIndex(String var1) throws AxionException;

    public void dropSequence(String var1) throws AxionException;

    public void dropTable(String var1) throws AxionException;

    public DatabaseLink getDatabaseLink(String var1);

    public List getDatabaseModificationListeners();

    public DataType getDataType(String var1);

    public File getDBDirectory();

    public List getDependentExternalDBTable(String var1);

    public List getDependentViews(String var1);

    public ConcreteFunction getFunction(String var1);

    public Object getGlobalVariable(String var1);

    public IndexFactory getIndexFactory(String var1);

    public String getName();

    public Sequence getSequence(String var1);

    public Table getTable(String var1) throws AxionException;

    public Table getTable(TableIdentifier var1) throws AxionException;

    public TableFactory getTableFactory(String var1);

    public TransactionManager getTransactionManager();

    public boolean hasDatabaseLink(String var1) throws AxionException;

    public boolean hasIndex(String var1) throws AxionException;

    public boolean hasSequence(String var1) throws AxionException;

    public boolean hasTable(String var1) throws AxionException;

    public boolean hasTable(TableIdentifier var1) throws AxionException;

    public boolean isReadOnly();

    public void migrate(int var1) throws AxionException;

    public void remount(File var1) throws AxionException;

    public void renameTable(String var1, String var2) throws AxionException;

    public void renameTable(String var1, String var2, Properties var3) throws AxionException;

    public void shutdown() throws AxionException;

    public void tableAltered(Table var1) throws AxionException;
}

