/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb;

import org.axiondb.AxionException;
import org.axiondb.BaseSelectable;
import org.axiondb.DataType;
import org.axiondb.RowDecorator;
import org.axiondb.Selectable;
import org.axiondb.types.AnyType;

public class Literal
extends BaseSelectable
implements Selectable {
    private boolean _evaluated = false;
    private DataType _type;
    protected Object _value;

    public Literal(Object value) {
        this(value, AnyType.INSTANCE);
    }

    public Literal(Object value, DataType type) {
        this._value = value;
        this._type = type;
    }

    protected Literal(DataType type) {
        this(null, type);
    }

    public boolean equals(Object otherobject) {
        if (this == otherobject) {
            return true;
        }
        if (otherobject instanceof Literal) {
            Literal that = (Literal)otherobject;
            return this.getName().equals(that.getName());
        }
        return false;
    }

    public Object evaluate() throws AxionException {
        if (null == this._value && null == this._type) {
            return this._value;
        }
        if (null == this._type) {
            return this._value;
        }
        if (!this._evaluated) {
            this._value = this._type.convert(this._value);
            this._evaluated = true;
        }
        return this._value;
    }

    public final Object evaluate(RowDecorator row) throws AxionException {
        return this.evaluate();
    }

    public DataType getDataType() {
        return this._type;
    }

    public int hashCode() {
        int hashCode = this._hash;
        if (hashCode == 0) {
            this._hash = hashCode = this.getName().hashCode();
        }
        return hashCode;
    }

    public void setDataType(DataType type) {
        this._type = type;
        this._hash = 0;
    }

    public String getLabel() {
        return this.getName();
    }

    public String getName() {
        if (this.getAlias() != null) {
            return this.getAlias();
        }
        return String.valueOf(this._value);
    }

    public String toString() {
        return this.getName();
    }
}

