/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import org.axiondb.AxionException;
import org.axiondb.Database;
import org.axiondb.engine.commands.DropCommand;

public class DropIndexCommand
extends DropCommand {
    public DropIndexCommand(String indexName, boolean exists) {
        this.setObjectName(indexName);
        this.setIfExists(exists);
    }

    public boolean execute(Database db) throws AxionException {
        this.assertNotReadOnly(db);
        if (!this.isIfExists() || db.hasIndex(this.getObjectName())) {
            if (this.getObjectName().startsWith("SYS") && db.hasIndex(this.getObjectName())) {
                throw new AxionException("Cannot drop an internally-generated index.");
            }
            db.dropIndex(this.getObjectName());
        }
        return false;
    }
}

