/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.util.List;
import org.axiondb.AxionException;
import org.axiondb.Database;
import org.axiondb.Table;
import org.axiondb.engine.commands.DropCommand;

public class DropViewCommand
extends DropCommand {
    public DropViewCommand(String tableName, boolean exists, boolean cascade) {
        this.setObjectName(tableName);
        this.setIfExists(exists);
        this.setCascade(cascade);
    }

    public boolean execute(Database db) throws AxionException {
        this.assertNotReadOnly(db);
        if (!this.isIfExists() || db.hasTable(this.getObjectName())) {
            Table t = db.getTable(this.getObjectName());
            if (t != null && t.getType().equals("VIEW")) {
                this.dropDepedentViews(db);
                db.dropTable(this.getObjectName());
            } else {
                throw new AxionException("No view " + this.getObjectName() + " found");
            }
        }
        return false;
    }

    private void dropDepedentViews(Database db) throws AxionException {
        List depedentViews = db.getDependentViews(this.getObjectName());
        if (depedentViews.size() > 0) {
            if (this.isCascade()) {
                db.dropDependentViews(depedentViews);
            } else {
                throw new AxionException("Can't drop view: " + this.getObjectName() + " has reference in another View...");
            }
        }
    }
}

