/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.axiondb.AxionException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.DataType;
import org.axiondb.Database;
import org.axiondb.Row;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.Selectable;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.engine.SnapshotIsolationTransaction;
import org.axiondb.engine.commands.AxionQueryContext;
import org.axiondb.engine.commands.AxionQueryPlanner;
import org.axiondb.engine.commands.ChildTableUpdater;
import org.axiondb.engine.commands.DMLWhenClause;
import org.axiondb.engine.commands.InsertIntoClause;
import org.axiondb.engine.rowcollection.IntSet;
import org.axiondb.engine.rows.JoinedRow;
import org.axiondb.engine.rows.SimpleRow;
import org.axiondb.engine.tables.ExternalDatabaseTable;
import org.axiondb.engine.visitors.FindBindVariableVisitor;
import org.axiondb.engine.visitors.ResolveFromNodeVisitor;
import org.axiondb.jdbc.AxionResultSet;

public class UpdateCommand
extends ChildTableUpdater {
    private List _cols = new ArrayList();
    private AxionQueryContext _context;
    private RowDecorator _dec;
    private int _count;
    private ExceptionWhenClause _exceptionWhenClause;
    private AxionQueryPlanner _planner;
    private boolean _resolved = false;
    private boolean _isExternalDBTable = false;
    private Table _table;
    private TableIdentifier _tableId;
    private List _vals = new ArrayList();
    private Selectable _where;

    public void addColumn(ColumnIdentifier col) {
        this._cols.add(col);
    }

    public void addValue(Selectable val) {
        this._vals.add(val);
    }

    public boolean execute(Database database) throws AxionException {
        this.setEffectedRowCount(this.executeUpdate(database));
        return false;
    }

    public AxionResultSet executeQuery(Database database) throws AxionException {
        throw new UnsupportedOperationException("Use executeUpdate.");
    }

    public int executeUpdate(Database db) throws AxionException {
        this.assertNotReadOnly(db);
        this.preProcess(db);
        this.resolve(db);
        int updatedRows = 0;
        updatedRows = this._context != null && this._context.getFrom() != null ? this.updateUsingFromClauseTables(db) : this.updateUsingStaticValues(db);
        return updatedRows;
    }

    public int getColumnCount() {
        return this._cols.size();
    }

    public Iterator getColumnIterator() {
        return this._cols.iterator();
    }

    public ExceptionWhenClause getExceptionWhenClause() {
        return this._exceptionWhenClause;
    }

    public TableIdentifier getTable() {
        return this._tableId;
    }

    public int getValueCount() {
        return this._vals.size();
    }

    public Iterator getValueIterator() {
        return this._vals.iterator();
    }

    public Selectable getWhere() {
        return this._where;
    }

    private void preProcess(Database db) throws AxionException {
        this._count = 0;
        this._table = db.getTable(this.getTable());
        if (null == this._table) {
            throw new AxionException("Table " + this.getTable() + " not found.", 42704);
        }
        this.setDeferAllConstraintIfRequired(this._table);
        if (this._exceptionWhenClause != null) {
            this._exceptionWhenClause.preProcess(db);
        }
    }

    public void setExceptionWhenClause(DMLWhenClause w, TableIdentifier t, List cols, List vals) {
        this._exceptionWhenClause = new ExceptionWhenClause(w, t, cols, vals);
    }

    public void setQueryContext(AxionQueryContext context) {
        this._context = context;
        this._planner = new AxionQueryPlanner(context);
    }

    public void setTable(TableIdentifier table) {
        this._tableId = table;
    }

    public void setWhere(Selectable where) {
        this._where = where;
    }

    protected void buildBindVariables() {
        this.setBindVariableVisitor(new FindBindVariableVisitor());
        this.getBindVariableVisitor().visit(this);
    }

    private void commitIfRequired(Database db) throws AxionException {
        if (this.getCommitSize(db) == 0) {
            return;
        }
        if (db instanceof SnapshotIsolationTransaction && ++this._count % this.getCommitSize(db) == 0) {
            this._table = ((SnapshotIsolationTransaction)db).commit(this._tableId);
        }
    }

    private Row prepareRow(Row oldrow, RowDecorator dec, Database db) throws AxionException {
        Table targetTable = this._table;
        SimpleRow newrow = new SimpleRow(oldrow);
        Iterator colids = this.getColumnIterator();
        Iterator values = this.getValueIterator();
        while (colids.hasNext()) {
            ColumnIdentifier colid = (ColumnIdentifier)colids.next();
            Selectable sel = (Selectable)values.next();
            Object val = sel.evaluate(dec);
            DataType type = db.getTable(colid.getTableName()).getColumn(colid.getName()).getDataType();
            val = this.attemptToConvertValue(val, type, colid);
            newrow.set(targetTable.getColumnIndex(colid.getName()), val);
        }
        return newrow;
    }

    protected void resolve(Database db) throws AxionException {
        if (!this._resolved) {
            this.resolveSelectableList(this._cols, db, this.getTable());
            this.resolveGeneratedColumns(this._table, this._tableId, this._cols);
            if (this._context != null && this._context.getFrom() != null) {
                ResolveFromNodeVisitor fnVisitor = new ResolveFromNodeVisitor();
                fnVisitor.resolveFromNode(this._context.getFrom(), db);
                this._context.setTables(this._context.getFromArray());
                fnVisitor.resolveFromNode(this._context.getFrom(), db, null);
                this.resolveSelectableList(this._vals, db, this._context.getTables());
            } else {
                this.resolveSelectableList(this._vals, db, this.getTable());
            }
            if (this.getWhere() != null) {
                this.setWhere(this.resolveSelectable(this.getWhere(), db, new TableIdentifier[]{this.getTable()}));
            }
            if (this._exceptionWhenClause != null) {
                this._exceptionWhenClause.resolve(db);
            }
            this._isExternalDBTable = this._table instanceof ExternalDatabaseTable;
            this._resolved = true;
        }
    }

    private int updateUsingFromClauseTables(Database db) throws AxionException {
        IntSet rowcount = new IntSet();
        int extTblCnt = 0;
        int colId = -1;
        List list = this._context.getResolvedSelect();
        this._context.setSelected(list.toArray(new Selectable[list.size()]));
        RowIterator joinedRowIter = this._planner.makeRowIterator(db, false);
        RowDecorator dec = new RowDecorator(this._planner.getColumnIdToFieldMap());
        while (joinedRowIter.hasNext()) {
            JoinedRow joinRow = (JoinedRow)joinedRowIter.next();
            Row targetRow = joinRow.getRow(0);
            Row sourceRow = joinRow.getRow(1);
            dec.setRow(joinedRowIter.currentIndex(), joinRow);
            if (this._exceptionWhenClause != null && this._exceptionWhenClause.insertMatchingRow(db, dec, sourceRow)) continue;
            Row newrow = this.prepareRow(targetRow, dec, db);
            if (this._isExternalDBTable) {
                ((ExternalDatabaseTable)this._table).updateRow(targetRow, newrow, this._cols);
            } else {
                this.updateGeneratedValues(db, this._table, this._tableId, newrow);
                if (!((Object)targetRow).equals(newrow)) {
                    this._table.updateRow(targetRow, newrow);
                    this.updateOrSetNullChildRows(db, this._table, targetRow, newrow);
                }
            }
            colId = newrow.getIdentifier();
            if (colId == -9999999) {
                ++extTblCnt;
            } else {
                rowcount.add(colId);
            }
            this.commitIfRequired(db);
        }
        return rowcount.size() + extTblCnt;
    }

    private int updateUsingStaticValues(Database db) throws AxionException {
        int rowcount = 0;
        RowIterator iter = this.getRowIterator(db, this.getTable(), this._table, this.getWhere(), false, this.makeRowDecorator());
        RowDecorator dec = this.makeRowDecorator();
        while (iter.hasNext()) {
            this._count = 0;
            Row oldrow = iter.next();
            dec.setRow(iter.currentIndex(), oldrow);
            Row newrow = this.prepareRow(oldrow, dec, db);
            if (this._exceptionWhenClause != null && this._exceptionWhenClause.insertMatchingRow(db, dec, newrow)) continue;
            if (this._isExternalDBTable) {
                ((ExternalDatabaseTable)this._table).updateRow(oldrow, newrow, this._cols);
            } else {
                this.updateGeneratedValues(db, this._table, this._tableId, newrow);
                if (!((Object)oldrow).equals(newrow)) {
                    this._table.updateRow(oldrow, newrow);
                    this.updateOrSetNullChildRows(db, this._table, oldrow, newrow);
                }
            }
            this.commitIfRequired(db);
            ++rowcount;
        }
        return rowcount;
    }

    private final RowDecorator makeRowDecorator() {
        if (this._dec == null) {
            this._dec = this._table.makeRowDecorator();
        }
        return this._dec;
    }

    private class ExceptionWhenClause
    extends InsertIntoClause {
        private boolean _isTargetPartOfSubQuery;

        public ExceptionWhenClause(DMLWhenClause when, TableIdentifier tid, List cols, List vals) {
            super(when, tid, cols, vals);
            this._isTargetPartOfSubQuery = false;
        }

        protected boolean isTargetTablePartOfSubQuery() throws AxionException {
            return this._isTargetPartOfSubQuery;
        }

        protected void resolve(Database db) throws AxionException {
            super.resolve(db);
            if (UpdateCommand.this._context != null) {
                this._isTargetPartOfSubQuery = UpdateCommand.this._context.isTablePartOfSelect(this.getTargetTableId());
                this.getWhenClause().resolve(db, UpdateCommand.this._context.getTables());
                this.resolveSelectableList(this.getValues(), db, UpdateCommand.this._context.getTables());
            } else {
                this.getWhenClause().resolve(db, new TableIdentifier[]{UpdateCommand.this.getTable()});
                this.resolveSelectableList(this.getValues(), db, UpdateCommand.this.getTable());
            }
            this.assertRules(this.getTargetTable());
        }
    }
}

