/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowiterators;

import java.util.NoSuchElementException;
import org.axiondb.AxionException;
import org.axiondb.Row;
import org.axiondb.RowIterator;
import org.axiondb.engine.rowiterators.BaseRowIterator;
import org.axiondb.util.ExceptionConverter;

public abstract class AbstractFilteringRowIterator
extends BaseRowIterator {
    private boolean _currentAvailable = false;
    private int _currentIndex = -1;
    private Row _currentRow = null;
    private RowIterator _delegate;
    private boolean _nextAvailable = false;
    private int _nextIndex = 0;
    private Row _nextRow = null;
    private boolean _previousAvailable = false;
    private Row _previousRow = null;

    public AbstractFilteringRowIterator(RowIterator iterator) {
        this._delegate = iterator;
    }

    public Row current() {
        if (this.hasCurrent()) {
            return this._currentRow;
        }
        throw new NoSuchElementException("No current row has been set.");
    }

    public int currentIndex() {
        return this._currentIndex;
    }

    public boolean hasCurrent() {
        return this._currentAvailable;
    }

    public boolean hasNext() {
        if (this._nextAvailable) {
            return true;
        }
        try {
            return this.determineNextRow();
        }
        catch (AxionException e) {
            throw ExceptionConverter.convertToRuntimeException(e);
        }
    }

    public boolean hasPrevious() {
        if (this._previousAvailable) {
            return true;
        }
        try {
            return this.determinePreviousRow();
        }
        catch (AxionException e) {
            throw ExceptionConverter.convertToRuntimeException(e);
        }
    }

    public Row next() throws AxionException {
        if (!this._nextAvailable && !this.determineNextRow()) {
            throw new NoSuchElementException();
        }
        this._currentIndex = this._nextIndex++;
        this._currentRow = this._nextRow;
        this._currentAvailable = true;
        this.clearNextRow();
        return this._currentRow;
    }

    public int nextIndex() {
        return this._nextIndex;
    }

    public Row previous() throws AxionException {
        if (!this._previousAvailable && !this.determinePreviousRow()) {
            throw new NoSuchElementException();
        }
        --this._nextIndex;
        this._currentIndex = this._nextIndex;
        this._currentRow = this._previousRow;
        this._currentAvailable = true;
        this.clearPreviousRow();
        return this._currentRow;
    }

    public int previousIndex() {
        return this._nextIndex - 1;
    }

    public void remove() throws AxionException {
        if (!this.hasCurrent()) {
            throw new IllegalStateException("No current row.");
        }
        this.getDelegate().remove();
        --this._nextIndex;
        this._currentRow = null;
        this._currentAvailable = false;
        this._currentIndex = -1;
    }

    public void reset() throws AxionException {
        this._delegate.reset();
        this._previousRow = null;
        this._previousAvailable = false;
        this._nextRow = null;
        this._nextAvailable = false;
        this._nextIndex = 0;
        this._currentRow = null;
        this._currentAvailable = false;
        this._currentIndex = -1;
    }

    public void set(Row row) throws AxionException {
        if (!this.hasCurrent()) {
            throw new IllegalStateException("No current row.");
        }
        this.getDelegate().set(row);
        this._currentRow = row;
    }

    protected void clearNextRow() {
        this._nextRow = null;
        this._nextAvailable = false;
    }

    protected void clearPreviousRow() {
        this._previousRow = null;
        this._previousAvailable = false;
    }

    protected abstract boolean determineNextRow() throws AxionException;

    protected abstract boolean determinePreviousRow() throws AxionException;

    protected RowIterator getDelegate() {
        return this._delegate;
    }

    protected boolean isNextAvailable() {
        return this._nextAvailable;
    }

    protected boolean isPreviousAvailable() {
        return this._previousAvailable;
    }

    protected void setNext(Row row) {
        this._nextRow = row;
        this._nextAvailable = true;
    }

    protected void setPrevious(Row row) {
        this._previousRow = row;
        this._previousAvailable = true;
    }
}

