/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.rowiterators;

import java.util.List;
import java.util.NoSuchElementException;
import org.axiondb.Row;
import org.axiondb.engine.rowiterators.BaseRowIterator;

public class ListRowIterator
extends BaseRowIterator {
    private Row _current = null;
    private int _currentId = -1;
    private int _currentIndex = -1;
    private List _list = null;
    private int _nextId = 0;
    private int _nextIndex = 0;

    public ListRowIterator(List list) {
        this._list = list;
    }

    public Row current() {
        if (!this.hasCurrent()) {
            throw new NoSuchElementException("No current row.");
        }
        return this._current;
    }

    public int currentIndex() {
        return this._currentIndex;
    }

    public boolean hasCurrent() {
        return null != this._current;
    }

    public boolean hasNext() {
        return this.nextIndex() < this._list.size();
    }

    public boolean hasPrevious() {
        return this.nextIndex() > 0;
    }

    public Row last() {
        this._nextIndex = this._list.size();
        this._nextId = this._list.size();
        this.previous();
        ++this._nextIndex;
        ++this._nextId;
        return this.current();
    }

    public Row next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next row");
        }
        this._currentId = this._nextId++;
        this._current = (Row)this._list.get(this._currentId);
        this._currentIndex = this._nextIndex++;
        return this._current;
    }

    public int nextIndex() {
        return this._nextIndex;
    }

    public Row previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("No previous row");
        }
        this._currentId = --this._nextId;
        this._current = (Row)this._list.get(this._currentId);
        --this._nextIndex;
        this._currentIndex = this._nextIndex;
        return this._current;
    }

    public int previousIndex() {
        return this._nextIndex - 1;
    }

    public void reset() {
        this._current = null;
        this._nextIndex = 0;
        this._currentIndex = -1;
        this._nextId = 0;
    }

    public int size() {
        return this._list.size();
    }
}

