/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.tables;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.primitives.IntCollection;
import org.axiondb.AxionException;
import org.axiondb.Column;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Constraint;
import org.axiondb.Database;
import org.axiondb.DatabaseLink;
import org.axiondb.ExternalTable;
import org.axiondb.Index;
import org.axiondb.Row;
import org.axiondb.RowCollection;
import org.axiondb.RowDecorator;
import org.axiondb.RowIterator;
import org.axiondb.RowSource;
import org.axiondb.Selectable;
import org.axiondb.Sequence;
import org.axiondb.Table;
import org.axiondb.TransactableTable;
import org.axiondb.engine.Databases;
import org.axiondb.engine.TransactableTableImpl;
import org.axiondb.engine.tables.BaseTableOrganizationContext;
import org.axiondb.event.BaseTableModificationPublisher;
import org.axiondb.event.ColumnEvent;

public class ExternalAxionDBTable
extends BaseTableModificationPublisher
implements ExternalTable {
    private static Logger _log = Logger.getLogger(ExternalAxionDBTable.class.getName());
    private static final Set PROPERTY_KEYS = new HashSet(6);
    private static final Set REQUIRED_KEYS = new HashSet(1);
    private List _cols = new ArrayList();
    private Database _db;
    private String _dblink;
    private String _name = null;
    private Database _remoteDb;
    private Table _remoteTable;
    private String _remoteTableName;
    private String _type = null;
    private ExternalDatabaseTableOrganizationContext context;

    public ExternalAxionDBTable(String name, Database db) {
        this._name = name;
        this._type = "EXTERNAL DB TABLE";
        this._db = db;
    }

    public void addColumn(Column col) throws AxionException {
        this._cols.add(col);
        this.publishEvent(new ColumnEvent(this, col));
    }

    public void addConstraint(Constraint constraint) throws AxionException {
    }

    public void addIndex(Index index) throws AxionException {
        this._remoteTable.addIndex(index);
    }

    public void addRow(Row row) throws AxionException {
        this._remoteTable.addRow(row);
    }

    public void applyDeletes(IntCollection rowIds) throws AxionException {
        this._remoteTable.applyDeletes(rowIds);
    }

    public void applyInserts(RowCollection rows) throws AxionException {
        this._remoteTable.applyInserts(rows);
    }

    public void applyUpdates(RowCollection rows) throws AxionException {
        this._remoteTable.applyUpdates(rows);
    }

    public void checkpoint() throws AxionException {
    }

    public void deleteRow(Row row) throws AxionException {
        this._remoteTable.deleteRow(row);
    }

    public void drop() throws AxionException {
        if (this._remoteTable != null) {
            this._remoteTable.drop();
            this.cleanUp();
        }
    }

    public void freeRowId(int id) {
        this._remoteTable.freeRowId(id);
    }

    public Column getColumn(int index) {
        return this._remoteTable.getColumn(index);
    }

    public Column getColumn(String name) {
        return this._remoteTable.getColumn(name);
    }

    public int getColumnCount() {
        return this._remoteTable.getColumnCount();
    }

    public List getColumnIdentifiers() {
        return this._remoteTable.getColumnIdentifiers();
    }

    public int getColumnIndex(String name) throws AxionException {
        return this._remoteTable.getColumnIndex(name);
    }

    public Iterator getConstraints() {
        return this._remoteTable.getConstraints();
    }

    public String getDBLinkName() {
        return this._dblink;
    }

    public RowIterator getIndexedRows(RowSource source, Selectable node, boolean readOnly) throws AxionException {
        return this._remoteTable.getIndexedRows(source, node, readOnly);
    }

    public RowIterator getIndexedRows(Selectable node, boolean readOnly) throws AxionException {
        return this._remoteTable.getIndexedRows(node, readOnly);
    }

    public Index getIndexForColumn(Column column) {
        return this._remoteTable.getIndexForColumn(column);
    }

    public Iterator getIndices() {
        return this._remoteTable.getIndices();
    }

    public RowIterator getMatchingRows(List selectables, List values, boolean readOnly) throws AxionException {
        return this._remoteTable.getMatchingRows(selectables, values, readOnly);
    }

    public String getName() {
        return this._name;
    }

    public int getNextRowId() {
        return this._remoteTable.getNextRowId();
    }

    public Row getRow(int id) throws AxionException {
        return this._remoteTable.getRow(id);
    }

    public int getRowCount() {
        return this._remoteTable.getRowCount();
    }

    public RowIterator getRowIterator(boolean readOnly) throws AxionException {
        return this._remoteTable.getRowIterator(readOnly);
    }

    public Sequence getSequence() {
        return this._remoteTable.getSequence();
    }

    public Properties getTableProperties() {
        return this.context.getTableProperties();
    }

    public String getType() {
        return this._type;
    }

    public boolean hasColumn(ColumnIdentifier id) {
        boolean result = false;
        String tableName = id.getTableName();
        if (tableName == null || tableName.equals(this.getName())) {
            result = this.getColumn(id.getName()) != null;
        }
        return result;
    }

    public boolean hasIndex(String name) throws AxionException {
        return this._remoteTable.hasIndex(name);
    }

    public boolean isColumnIndexed(Column column) {
        return this._remoteTable.isColumnIndexed(column);
    }

    public boolean isPrimaryKeyConstraintExists(String columnName) {
        return this._remoteTable.isPrimaryKeyConstraintExists(columnName);
    }

    public boolean isUniqueConstraintExists(String columnName) {
        return this._remoteTable.isUniqueConstraintExists(columnName);
    }

    public boolean loadExternalTable(Properties props) throws AxionException {
        this.context = new ExternalDatabaseTableOrganizationContext();
        this.context.readOrSetDefaultProperties(props);
        this.context.updateProperties();
        return true;
    }

    public RowDecorator makeRowDecorator() {
        return this._remoteTable.makeRowDecorator();
    }

    public TransactableTable makeTransactableTable() {
        return new TransactableTableImpl(this);
    }

    public void migrate() throws AxionException {
    }

    public void populateIndex(Index index) throws AxionException {
        this._remoteTable.populateIndex(index);
    }

    public void remount() throws AxionException {
    }

    public void remount(File dir, boolean datafilesonly) throws AxionException {
    }

    public Constraint removeConstraint(String name) {
        return this._remoteTable.removeConstraint(name);
    }

    public Constraint getConstraint(String name) {
        return this._remoteTable.getConstraint(name);
    }

    public void removeIndex(Index index) throws AxionException {
        this._remoteTable.removeIndex(index);
    }

    public void rename(String oldName, String newName) throws AxionException {
        this._remoteTable.rename(oldName, newName);
    }

    public void setSequence(Sequence seq) throws AxionException {
    }

    public void shutdown() throws AxionException {
        this.cleanUp();
    }

    public String toString() {
        return this.getName();
    }

    public void truncate() throws AxionException {
        this._remoteTable.truncate();
    }

    public void updateRow(Row oldrow, Row newrow) throws AxionException {
        this._remoteTable.updateRow(oldrow, newrow);
    }

    private void assertColumns() throws AxionException {
        for (Column col : this._cols) {
            if (this.hasColumn(new ColumnIdentifier(null, col.getName(), null, col.getDataType()))) continue;
            throw new AxionException("Column " + col + "does not exist in remote table" + this._remoteTableName);
        }
    }

    private void cleanUp() throws AxionException {
        this._remoteDb = null;
        this._remoteTable = null;
    }

    private void setUp(DatabaseLink server) throws AxionException {
        if (this._remoteDb == null) {
            String name;
            String url = server.getJdbcUrl();
            File path = null;
            String prefixStripped = url.substring("jdbc:axiondb:".length());
            int colon = prefixStripped.indexOf(":");
            if (colon == -1 || prefixStripped.length() - 1 == colon) {
                name = prefixStripped;
            } else {
                name = prefixStripped.substring(0, colon);
                path = new File(prefixStripped.substring(colon + 1));
            }
            this._remoteDb = Databases.getOrCreateDatabase(name, path);
            this._remoteTable = this._remoteDb.getTable(this._remoteTableName);
        }
        if (this._remoteTable == null) {
            throw new AxionException("Initialization error for remote table " + this.getName());
        }
    }

    static {
        PROPERTY_KEYS.add("DBLINK");
        PROPERTY_KEYS.add("REMOTETABLE");
        PROPERTY_KEYS.add("VENDOR");
        REQUIRED_KEYS.add("DBLINK");
    }

    private class ExternalDatabaseTableOrganizationContext
    extends BaseTableOrganizationContext {
        private ExternalDatabaseTableOrganizationContext() {
        }

        public Set getPropertyKeys() {
            Set baseKeys = this.getBasePropertyKeys();
            HashSet keys = new HashSet(baseKeys.size() + PROPERTY_KEYS.size());
            keys.addAll(baseKeys);
            keys.addAll(PROPERTY_KEYS);
            return keys;
        }

        public Set getRequiredPropertyKeys() {
            Set baseRequiredKeys = this.getBaseRequiredPropertyKeys();
            HashSet keys = new HashSet(baseRequiredKeys.size() + REQUIRED_KEYS.size());
            keys.addAll(baseRequiredKeys);
            keys.addAll(REQUIRED_KEYS);
            return keys;
        }

        public void readOrSetDefaultProperties(Properties props) throws AxionException {
            super.assertValidPropertyKeys(props);
            ExternalAxionDBTable.this._dblink = props.getProperty("DBLINK");
            if (ExternalAxionDBTable.this._dblink == null || ExternalAxionDBTable.this._dblink.trim().length() == 0 || !ExternalAxionDBTable.this._db.hasDatabaseLink(ExternalAxionDBTable.this._dblink)) {
                throw new AxionException("Please provide a valid server name");
            }
            DatabaseLink server = ExternalAxionDBTable.this._db.getDatabaseLink(ExternalAxionDBTable.this._dblink);
            if (server == null) {
                throw new AxionException("Database link " + ExternalAxionDBTable.this._dblink + " does not exist.");
            }
            ExternalAxionDBTable.this._remoteTableName = props.getProperty("REMOTETABLE");
            ExternalAxionDBTable.this._remoteTableName = ExternalAxionDBTable.this._remoteTableName != null ? ExternalAxionDBTable.this._remoteTableName : ExternalAxionDBTable.this.getName();
            ExternalAxionDBTable.this.setUp(server);
            ExternalAxionDBTable.this.assertColumns();
            _log.log(Level.SEVERE, "External DB Table " + ExternalAxionDBTable.this._remoteTableName + " created.");
        }

        public void updateProperties() {
            super.updateProperties();
            this.setProperty("DBLINK", ExternalAxionDBTable.this._dblink);
            this.setProperty("REMOTETABLE", ExternalAxionDBTable.this._remoteTableName);
            this.setProperty("LOADTYPE", "REMOTE");
            this.setProperty("VENDOR", "AXION");
        }
    }
}

