/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.visitors;

import java.util.List;
import org.axiondb.AxionException;
import org.axiondb.ColumnIdentifier;
import org.axiondb.Selectable;
import org.axiondb.SelectableVisitor;
import org.axiondb.engine.visitors.AmbiguousColumnReferenceVisitor;
import org.axiondb.engine.visitors.FindAggregateFunctionVisitor;
import org.axiondb.functions.ScalarFunction;

public class AssertGroupByRulesVisitor
implements SelectableVisitor {
    private boolean _foundAggregateFn = false;
    private boolean _foundScalar = false;
    private List _groupByNodes;

    public boolean visit(List selectList, List groupByNodes) throws AxionException {
        this._groupByNodes = groupByNodes;
        if (groupByNodes != null && !groupByNodes.isEmpty()) {
            AmbiguousColumnReferenceVisitor ambiguityCheck = new AmbiguousColumnReferenceVisitor();
            ambiguityCheck.visit(selectList, groupByNodes);
        }
        int I = selectList.size();
        for (int i = 0; i < I; ++i) {
            Selectable sel = (Selectable)selectList.get(i);
            FindAggregateFunctionVisitor findAggr = new FindAggregateFunctionVisitor();
            findAggr.visit(sel);
            if (findAggr.foundAggregateFunction()) {
                this._foundAggregateFn = true;
                continue;
            }
            if (this._groupByNodes == null || this._groupByNodes.isEmpty()) {
                this._foundScalar = true;
                continue;
            }
            this.visit(sel);
        }
        if (this._foundScalar && this._foundAggregateFn) {
            throw new AxionException("Can't select both scalar values and aggregate functions.");
        }
        if (this._foundScalar && this._groupByNodes != null && !this._groupByNodes.isEmpty()) {
            throw new AxionException("Invalid Group By Expression...");
        }
        return this._foundScalar;
    }

    public void visit(Selectable select) {
        if (select instanceof ScalarFunction) {
            ScalarFunction fn = (ScalarFunction)select;
            int I = fn.getArgumentCount();
            for (int i = 0; i < I; ++i) {
                Selectable fnArg = fn.getArgument(i);
                this.visit(fnArg);
            }
        } else if (select instanceof ColumnIdentifier && !this._groupByNodes.contains(select)) {
            this._foundScalar = true;
        }
    }
}

