/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.visitors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.axiondb.BindVariable;
import org.axiondb.FromNode;
import org.axiondb.Function;
import org.axiondb.Selectable;
import org.axiondb.engine.commands.AxionQueryContext;
import org.axiondb.engine.commands.InsertIntoClause;
import org.axiondb.engine.commands.SelectCommand;
import org.axiondb.engine.commands.UpdateCommand;
import org.axiondb.engine.commands.UpsertCommand;

public class FindBindVariableVisitor {
    private List bvUsedInSelectable = new ArrayList(10);
    private volatile ListIterator bvUsedInSelectableIter;

    public List getBindVariables() {
        return this.bvUsedInSelectable;
    }

    public Iterator getBindVariableIterator() {
        if (this.bvUsedInSelectableIter == null) {
            this.bvUsedInSelectableIter = this.bvUsedInSelectable.listIterator();
            return this.bvUsedInSelectableIter;
        }
        while (this.bvUsedInSelectableIter.hasPrevious()) {
            this.bvUsedInSelectableIter.previous();
        }
        return this.bvUsedInSelectableIter;
    }

    public void visit(Selectable sel) {
        if (sel instanceof BindVariable) {
            this.bvUsedInSelectable.add(sel);
        } else if (sel instanceof Function) {
            this.visit((Function)sel);
        } else if (sel instanceof SelectCommand) {
            this.visit((SelectCommand)((Object)sel));
        }
    }

    public void visit(FromNode frmNd) {
        Selectable cond;
        Object left = frmNd.getLeft();
        Object right = frmNd.getRight();
        if (left instanceof FromNode) {
            this.visit((FromNode)left);
        }
        if (right instanceof FromNode) {
            this.visit((FromNode)right);
        }
        if ((cond = frmNd.getCondition()) != null) {
            this.visit(cond);
        }
    }

    public void visit(Function fn) {
        int I = fn.getArgumentCount();
        for (int i = 0; i < I; ++i) {
            this.visit(fn.getArgument(i));
        }
    }

    public void visit(SelectCommand select) {
        AxionQueryContext context = select.getQueryContext();
        int I = context.getSelectCount();
        for (int i = 0; i < I; ++i) {
            this.visit(context.getSelect(i));
        }
        if (context.getFrom() != null) {
            this.visit(context.getFrom());
        }
        this.visit(context.getWhere());
        this.visit(context.getLimit());
        this.visit(context.getOffset());
    }

    public void visit(InsertIntoClause insertInto) {
        if (insertInto.getWhenClause() != null) {
            this.visit(insertInto.getWhenClause().getCondition());
        }
        Iterator iter = insertInto.getValueIterator();
        while (iter.hasNext()) {
            this.visit((Selectable)iter.next());
        }
    }

    public void visit(UpsertCommand upsert) {
        if (upsert.getUsingSubSelectCommand() != null) {
            this.visit(upsert.getUsingSubSelectCommand());
        }
        this.visit(upsert.getCondition());
        Iterator iter = upsert.getUpdateValueIterator();
        while (iter.hasNext()) {
            this.visit((Selectable)iter.next());
        }
        iter = upsert.getInsertValueIterator();
        while (iter.hasNext()) {
            this.visit((Selectable)iter.next());
        }
        UpsertCommand.ExceptionWhenClause exceptionWhen = upsert.getExceptionWhenClause();
        if (exceptionWhen != null) {
            this.visit(exceptionWhen);
        }
    }

    public void visit(UpdateCommand update) {
        Iterator iter = update.getValueIterator();
        while (iter.hasNext()) {
            this.visit((Selectable)iter.next());
        }
        this.visit(update.getWhere());
        UpdateCommand.ExceptionWhenClause exceptionWhen = update.getExceptionWhenClause();
        if (exceptionWhen != null) {
            this.visit(exceptionWhen);
        }
    }
}

