/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.visitors;

import java.util.ArrayList;
import java.util.List;
import org.axiondb.ColumnIdentifier;
import org.axiondb.FromNode;
import org.axiondb.Function;
import org.axiondb.Selectable;
import org.axiondb.TableIdentifier;

public class MaskSelectablesForTablesVisitor {
    public List maskAliasListForTables(FromNode from, List selected) {
        if (selected == null) {
            return null;
        }
        ArrayList<Selectable> aliasList = new ArrayList<Selectable>();
        TableIdentifier[] tables = from.toTableArray();
        int I = selected.size();
        for (int i = 0; i < I; ++i) {
            Selectable sel = (Selectable)selected.get(i);
            if (!this.visit(sel, tables)) continue;
            aliasList.add(sel);
        }
        return aliasList;
    }

    public boolean visit(ColumnIdentifier col, TableIdentifier[] tables) {
        for (int i = 0; i < tables.length; ++i) {
            if ("*".equals(col.getName()) || !col.getTableName().equals(tables[i].getTableName())) continue;
            return true;
        }
        return false;
    }

    public boolean visit(Function fn, TableIdentifier[] tables) {
        int I = fn.getArgumentCount();
        for (int i = 0; i < I; ++i) {
            if (this.visit(fn.getArgument(i), tables)) continue;
            return false;
        }
        return true;
    }

    public boolean visit(Selectable sel, TableIdentifier[] tables) {
        if (sel instanceof ColumnIdentifier && !this.visit((ColumnIdentifier)sel, tables)) {
            return false;
        }
        return !(sel instanceof Function) || this.visit((Function)sel, tables);
    }
}

