/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.engine.visitors;

import java.util.List;
import org.axiondb.AxionException;
import org.axiondb.Database;
import org.axiondb.FromNode;
import org.axiondb.Table;
import org.axiondb.TableIdentifier;
import org.axiondb.engine.commands.SelectCommand;
import org.axiondb.engine.commands.SubSelectCommand;
import org.axiondb.engine.visitors.MaskSelectablesForTablesVisitor;
import org.axiondb.engine.visitors.ResolveSelectableVisitor;

public class ResolveFromNodeVisitor {
    public void resolveFromNode(FromNode from, Database db) throws AxionException {
        if (from == null) {
            return;
        }
        this.resolveFromNode(from, from.getLeft(), db, 2);
        this.resolveFromNode(from, from.getRight(), db, 3);
    }

    private void resolveFromNode(FromNode from, Object child, Database db, int type) throws AxionException {
        if (child instanceof SelectCommand) {
            SubSelectCommand selCmd = (SubSelectCommand)child;
            Table view = selCmd.getTableView(db, null, true);
            TableIdentifier tid = new TableIdentifier(view.getName(), selCmd.getAlias());
            if (type == 2) {
                from.setLeft(tid);
            } else {
                from.setRight(tid);
            }
        } else if (child instanceof FromNode) {
            this.resolveFromNode((FromNode)child, db);
        }
    }

    public void resolveFromNode(FromNode node, Database db, List selected) throws AxionException {
        Object right;
        if (node == null) {
            return;
        }
        ResolveSelectableVisitor resolveSel = new ResolveSelectableVisitor(db);
        node.setCondition(resolveSel.visit(node.getCondition(), selected, node.toTableArray()));
        MaskSelectablesForTablesVisitor filter = new MaskSelectablesForTablesVisitor();
        Object left = node.getLeft();
        if (left instanceof FromNode) {
            FromNode childNode = (FromNode)left;
            this.resolveFromNode(childNode, db, filter.maskAliasListForTables(childNode, selected));
        }
        if ((right = node.getRight()) instanceof FromNode) {
            FromNode childNode = (FromNode)right;
            this.resolveFromNode(childNode, db, filter.maskAliasListForTables(childNode, selected));
        }
    }
}

