/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.functions;

import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.FunctionFactory;
import org.axiondb.RowDecorator;
import org.axiondb.functions.BaseFunction;
import org.axiondb.functions.ConcreteFunction;
import org.axiondb.functions.ScalarFunction;
import org.axiondb.types.AnyType;
import org.axiondb.types.CharacterType;
import org.axiondb.types.CharacterVaryingType;

public class CastAsFunction
extends BaseFunction
implements ScalarFunction,
FunctionFactory {
    private DataType _targetType = null;
    private static final DataType ANY_TYPE = new AnyType();

    public CastAsFunction() {
        super("CASTAS");
    }

    public Object evaluate(RowDecorator row) throws AxionException {
        Object val = this.getArgument(0).evaluate(row);
        this._targetType = this.getArgument(1).getDataType();
        if (null == val) {
            return null;
        }
        if (this._targetType instanceof CharacterType || this._targetType instanceof CharacterVaryingType) {
            String sourceStr = val.toString();
            if (sourceStr.length() > this._targetType.getPrecision()) {
                sourceStr = sourceStr.substring(0, this._targetType.getPrecision());
            }
            return this._targetType.convert(sourceStr);
        }
        return this._targetType.convert(val);
    }

    public DataType getDataType() {
        return this._targetType == null ? ANY_TYPE : this._targetType;
    }

    public boolean isValid() {
        return this.getArgumentCount() == 2;
    }

    public ConcreteFunction makeNewInstance() {
        return new CastAsFunction();
    }
}

