/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Comparator;
import org.axiondb.AxionException;
import org.axiondb.DataType;
import org.axiondb.types.BaseDataType;
import org.axiondb.types.CLOBType;

public class StringType
extends BaseDataType {
    private static final StringType INSTANCE = new StringType();
    private static final long serialVersionUID = -2663968706274343425L;

    public int getJdbcType() {
        return 12;
    }

    public String getPreferredValueClassName() {
        return "java.lang.String";
    }

    public int getColumnDisplaySize() {
        return 32766;
    }

    public int getPrecision() {
        return Integer.MAX_VALUE;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public String toString() {
        return "string";
    }

    public byte[] toByteArray(Object value) throws AxionException {
        return this.toString(value).getBytes();
    }

    public boolean accepts(Object value) {
        return true;
    }

    public Object convert(Object value) throws AxionException {
        if (null == value) {
            return null;
        }
        if (value instanceof Clob) {
            return new CLOBType().toString(value);
        }
        if (value instanceof Blob) {
            try {
                return new String(((Blob)value).getBytes(1L, (int)((Blob)value).length()));
            }
            catch (Exception e) {
                throw new AxionException(e);
            }
        }
        if (value instanceof byte[]) {
            return new String((byte[])value);
        }
        return value.toString();
    }

    public boolean supportsSuccessor() {
        return true;
    }

    public Object successor(Object value) throws IllegalArgumentException {
        String v = (String)value;
        return v + "\u0000";
    }

    public Object read(DataInput in) throws IOException {
        String val = in.readUTF();
        if ("null".equals(val) && !in.readBoolean()) {
            return null;
        }
        return val;
    }

    public void write(Object value, DataOutput out) throws IOException {
        if (null == value) {
            out.writeUTF("null");
            out.writeBoolean(false);
        } else if ("null".equals(value)) {
            out.writeUTF("null");
            out.writeBoolean(true);
        } else {
            out.writeUTF(value.toString());
        }
    }

    public DataType makeNewInstance() {
        return new StringType();
    }

    public String getLiteralPrefix() {
        return "'";
    }

    public String getLiteralSuffix() {
        return "'";
    }

    public short getSearchableCode() {
        return 3;
    }

    public int compare(Object a, Object b) {
        return ((String)a).compareTo((String)b);
    }

    protected Comparator getComparator() {
        return this;
    }

    public static final StringType instance() {
        return INSTANCE;
    }
}

