/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.axiondb.AxionException;
import org.axiondb.AxionRuntimeException;

public class ExceptionConverter {
    private static final Logger _log = Logger.getLogger(ExceptionConverter.class.getName());

    public static SQLException convert(AxionException e) {
        ExceptionConverter.logConversion("AxionException", "SQLException", e);
        if (e.getNestedThrowable() instanceof SQLException) {
            return (SQLException)e.getNestedThrowable();
        }
        SQLException sqe = new SQLException(e.getMessage(), e.getSQLState(), e.getVendorCode());
        if (e.getNestedThrowable() instanceof AxionException) {
            sqe.setNextException(ExceptionConverter.convert((AxionException)e.getNestedThrowable()));
        }
        return sqe;
    }

    public static SQLException convert(RuntimeException e) {
        return ExceptionConverter.convert(null, e);
    }

    public static SQLException convert(String message, RuntimeException e) {
        ExceptionConverter.logConversion("RuntimeException", "SQLException", e);
        String string = message = message == null ? "" : message + ": ";
        if (e instanceof AxionRuntimeException) {
            return new SQLException(message + e.toString(), ((AxionRuntimeException)e).getSQLState());
        }
        return new SQLException(message + e.toString());
    }

    public static SQLException convert(IOException e) {
        ExceptionConverter.logConversion("IOException", "SQLException", e);
        return new SQLException(e.toString());
    }

    public static IOException convertToIOException(Exception e) {
        if (e instanceof IOException) {
            return (IOException)e;
        }
        ExceptionConverter.logConversion("Exception", "IOException", e);
        return new IOException(e.toString());
    }

    public static RuntimeException convertToRuntimeException(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (e instanceof AxionException) {
            return new AxionRuntimeException((AxionException)e);
        }
        ExceptionConverter.logConversion("Exception", "RuntimeException", e);
        return new RuntimeException(e.toString());
    }

    private static final void logConversion(String from, String to, Throwable t) {
        _log.log(Level.FINE, "Converting " + from + " to " + to, t);
    }
}

