/*
 * Decompiled with CFR 0.152.
 */
package org.axiondb.util;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Comparator;
import org.axiondb.io.AxionFileSystem;
import org.axiondb.util.BTreeMetaData;
import org.axiondb.util.NullObject;
import org.axiondb.util.ObjectBTree;

public class StringBTree
extends ObjectBTree {
    public StringBTree(File idxDir, String idxName, int minimizationFactor, Comparator comp) throws IOException, ClassNotFoundException {
        super(idxDir, idxName, minimizationFactor, comp);
    }

    private StringBTree(BTreeMetaData meta, Comparator comp) throws IOException, ClassNotFoundException {
        super(meta, comp);
    }

    private StringBTree(BTreeMetaData meta, Comparator comp, int fileId) throws IOException, ClassNotFoundException {
        super(meta, comp, fileId);
    }

    protected ObjectBTree createNode(BTreeMetaData meta, Comparator comp) throws IOException, ClassNotFoundException {
        return new StringBTree(meta, comp);
    }

    protected ObjectBTree loadNode(BTreeMetaData meta, Comparator comp, int fileId) throws IOException, ClassNotFoundException {
        return new StringBTree(meta, comp, fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read() throws IOException, ClassNotFoundException {
        ObjectInputStream in = null;
        AxionFileSystem fs = new AxionFileSystem();
        try {
            int i;
            in = fs.openObjectInputSteam(this.getBTreeMetaData().getFileById(this.getFileId()));
            int size = in.readInt();
            for (i = 0; i < size; ++i) {
                this.addKeyValuePair(in.readUTF(), in.readInt(), false);
            }
            size = in.readInt();
            for (i = 0; i < size; ++i) {
                this.getChildIds().add(in.readInt());
            }
            fs.closeInputStream(in);
        }
        catch (Throwable throwable) {
            fs.closeInputStream(in);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write() throws IOException {
        ObjectOutputStream out = null;
        AxionFileSystem fs = new AxionFileSystem();
        try {
            int i;
            out = fs.createObjectOutputSteam(this.getBTreeMetaData().getFileById(this.getFileId()));
            int size = this.size();
            out.writeInt(size);
            for (i = 0; i < size; ++i) {
                out.writeUTF((String)this.getKey(i));
                out.writeInt(this.getValue(i));
            }
            size = this.getChildIds().size();
            out.writeInt(size);
            for (i = 0; i < size; ++i) {
                out.writeInt(this.getChildIds().get(i));
            }
            fs.closeOutputStream(out);
        }
        catch (Throwable throwable) {
            fs.closeOutputStream(out);
            throw throwable;
        }
    }

    protected Object getNullKey() {
        return NullObject.INSTANCE.toString();
    }
}

