/*
 * Decompiled with CFR 0.152.
 */
package com.sap.mw.idoc.jco;

import com.sap.mw.idoc.IDoc;
import com.sap.mw.idoc.util.Int;
import com.sap.mw.idoc.util.ObjectList;
import com.sap.mw.jco.IExtendedFieldMetaData;
import com.sap.mw.jco.IFunctionTemplate;
import com.sap.mw.jco.IMetaData;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.IServerThread;
import com.sap.mw.jco.JCO;
import com.sap.mw.jco.util.CharacterEncoding;
import com.sap.mw.jco.util.SAPByteToCharConverter;
import com.sap.mw.jco.util.SAPCharToByteConverter;
import com.sap.mw.jco.util.SAPConverters;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class JCoIDoc
extends IDoc {
    private static final String REQUIRED_IDOC_VERSION = "1.0.3";
    private static final String REQUIRED_JCO_VERSION_2 = "2.1.6";
    private static final String REQUIRED_JCO_VERSION_6 = "6.50.0";
    private static JCoStaticRepository31 m_JCoStaticRepository31;
    private static JCoStaticRepository40 m_JCoStaticRepository40;
    private static JCoStaticRepository610UC m_JCoStaticRepository610UC;
    private static final char[] ZERO_CHARARRAY;
    private static final char[] SPACE_CHARARRAY;
    private static final String SPACE_STRING = "                                ";
    protected static final String HTML_CHAR_HORIZONTAL = "&#x2501;";
    protected static final String HTML_CHAR_UP_AND_RIGHT = "&#x2517;";
    protected static final String HTML_CHAR_VERTICAL = "&#x2503;";
    protected static final String HTML_CHAR_VERTICAL_AND_RIGHT = "&#x2523;";
    protected static final String JCO_VERSION = "jco.version";
    protected static final String JCO_HTML_TABLE_MAX_ROWS = "jco.html.table_max_rows";
    protected static final String JCO_HTML_BACKGROUND = "jco.html.background";
    protected static final String JCO_HTML_TABLE_HEADER_BACKGROUND1 = "jco.html.table_header_background1";
    protected static final String JCO_HTML_TABLE_HEADER_FOREGROUND1 = "jco.html.table_header_foreground1";
    protected static final String JCO_HTML_TABLE_HEADER_BACKGROUND2 = "jco.html.table_header_background2";
    protected static final String JCO_HTML_TABLE_HEADER_FOREGROUND2 = "jco.html.table_header_foreground2";
    protected static final String JCO_HTML_TABLE_HEADER_BACKGROUND3 = "jco.html.table_header_background3";
    protected static final String JCO_HTML_TABLE_BORDER = "jco.html.table_border";
    protected static final String JCO_HTML_TABLE_ROW_BACKGROUND1 = "jco.html.table_row_background1";
    protected static final String JCO_HTML_TABLE_ROW_BACKGROUND2 = "jco.html.table_row_background2";
    protected static final String JCO_HTML_FONT_FACE = "jco.html.font_face";
    protected static final String JCO_HTML_FONT_SIZE = "jco.html.font_size";

    protected JCoIDoc() {
    }

    protected static void copySegmentDataToByteArray(IDoc.Segment segment, char[] dest, int destOffset, int destLength, String charEncoding) {
        if (segment == null || dest == null || destOffset < 0 || destOffset > dest.length || destLength <= 0) {
            return;
        }
        IDoc.RecordMetaData recordMetaData = segment.getRecordMetaData();
        if (recordMetaData == null) {
            return;
        }
        int destEndOffset = destOffset + destLength;
        if (destEndOffset >= dest.length) {
            destEndOffset = dest.length - 1;
        }
        SAPCharToByteConverter converter = null;
        String field = null;
        byte[] spaces = null;
        byte[] value = null;
        int numFields = recordMetaData.getNumFields();
        int metaLength = 0;
        int metaOffset = 0;
        int offset = 0;
        int destBytes = 0;
        int numBytes = 0;
        int b = 0;
        int v = 0;
        int s = 0;
        if (charEncoding != null && !charEncoding.equals(IDoc.getSystemDefaultCharEncoding())) {
            converter = SAPConverters.getSAPCharToByteConverter(charEncoding);
            if (converter != null) {
                spaces = converter.convert(SPACE_CHARARRAY);
            } else {
                try {
                    spaces = SPACE_STRING.getBytes(charEncoding);
                }
                catch (UnsupportedEncodingException ex) {
                    charEncoding = null;
                }
            }
        }
        if (spaces == null) {
            spaces = SPACE_STRING.getBytes();
        }
        try {
            int i = 0;
            while (i < numFields) {
                field = segment.getString(recordMetaData.getName(i));
                metaLength = recordMetaData.getInternalLength(i);
                metaOffset = recordMetaData.getOffset(i);
                offset = destOffset + (metaOffset >> 1);
                b = metaOffset & 1;
                if (i + 1 < numFields) {
                    destBytes = recordMetaData.getOffset(i + 1) - metaOffset;
                    if (offset + (b + destBytes + 1 >> 1) > destEndOffset) {
                        destBytes = (destEndOffset - offset << 1) - b;
                        i = numFields;
                    }
                } else {
                    destBytes = (destEndOffset - offset << 1) - b;
                }
                if (field != null) {
                    value = converter != null ? converter.convert(field.toCharArray()) : (charEncoding == null ? field.getBytes() : field.getBytes(charEncoding));
                    numBytes = value.length;
                    if (metaLength > destBytes) {
                        metaLength = destBytes;
                    }
                    if (numBytes > metaLength) {
                        numBytes = metaLength;
                    }
                    v = 0;
                    while (v < numBytes) {
                        int n = offset + (b >> 1);
                        dest[n] = (char)(dest[n] | (char)((value[v] & 0xFF) << ((~b & 1) << 3)));
                        ++b;
                        ++v;
                    }
                } else {
                    v = 0;
                }
                while (v < destBytes) {
                    s = 0;
                    while (v < destBytes && s < spaces.length) {
                        int n = offset + (b >> 1);
                        dest[n] = (char)(dest[n] | (char)((spaces[s] & 0xFF) << ((~b & 1) << 3)));
                        ++b;
                        ++s;
                        ++v;
                    }
                }
                ++i;
            }
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            throw new InternalError();
        }
    }

    public static IDoc.Document createDocument(IDoc.Repository repository, String iDocType) {
        return new JCoDocument(repository, iDocType, null, null, null);
    }

    public static IDoc.Document createDocument(IDoc.Repository repository, String iDocType, String iDocTypeExtension) {
        return new JCoDocument(repository, iDocType, iDocTypeExtension, null, null);
    }

    public static IDoc.Document createDocument(IDoc.Repository repository, String iDocType, String iDocTypeExtension, String systemRelease) {
        return new JCoDocument(repository, iDocType, iDocTypeExtension, systemRelease, null);
    }

    public static IDoc.Document createDocument(IDoc.Repository repository, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
        return new JCoDocument(repository, iDocType, iDocTypeExtension, systemRelease, applicationRelease);
    }

    public static IDoc.Document createDocument(String controlStructName, IDoc.Repository repository, String iDocType) {
        return new JCoDocument(controlStructName, repository, iDocType, null, null, null);
    }

    public static IDoc.Document createDocument(String controlStructName, IDoc.Repository repository, String iDocType, String iDocTypeExtension) {
        return new JCoDocument(controlStructName, repository, iDocType, iDocTypeExtension, null, null);
    }

    public static IDoc.Document createDocument(String controlStructName, IDoc.Repository repository, String iDocType, String iDocTypeExtension, String systemRelease) {
        return new JCoDocument(controlStructName, repository, iDocType, iDocTypeExtension, systemRelease, null);
    }

    public static IDoc.Document createDocument(String controlStructName, IDoc.Repository repository, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
        return new JCoDocument(controlStructName, repository, iDocType, iDocTypeExtension, systemRelease, applicationRelease);
    }

    public static IDoc.DocumentList createDocumentList(IDoc.Repository repository) {
        return new JCoDocumentList(repository);
    }

    public static IDoc.Repository createRepository(String repositoryName, JCO.Client client) {
        return new SAPRepository(repositoryName, client);
    }

    public static IDoc.Repository createRepository(String repositoryName, String clientPoolName) {
        return new SAPRepository(repositoryName, clientPoolName);
    }

    public static IDoc.Repository createRepository(String repositoryName, String[] clientPoolNames) {
        return new SAPRepository(repositoryName, clientPoolNames);
    }

    private static IRepository getJCoStaticRepository(JCO.Attributes attributes) {
        return JCoIDoc.getJCoStaticRepository(attributes != null ? attributes.getPartnerRelease() : null, JCoIDoc.isPartnerSystemUnicode(attributes));
    }

    private static IRepository getJCoStaticRepository(String systemRelease, boolean unicode) {
        if (unicode) {
            if (m_JCoStaticRepository610UC == null) {
                m_JCoStaticRepository610UC = new JCoStaticRepository610UC();
            }
            return m_JCoStaticRepository610UC;
        }
        if (systemRelease == null || systemRelease.length() == 0 || IDoc.removeAllDotsFromString(systemRelease).compareTo("4") >= 0) {
            if (m_JCoStaticRepository40 == null) {
                m_JCoStaticRepository40 = new JCoStaticRepository40();
            }
            return m_JCoStaticRepository40;
        }
        if (m_JCoStaticRepository31 == null) {
            m_JCoStaticRepository31 = new JCoStaticRepository31();
        }
        return m_JCoStaticRepository31;
    }

    public static String getVersion() {
        return "1.0.6 (2006-05-17)";
    }

    private static boolean isPartnerSystemUnicode(JCO.Attributes attributes) {
        if (attributes == null) {
            return false;
        }
        String codepage = attributes.getPartnerCodepage();
        return codepage != null && codepage.length() > 0 && codepage.charAt(0) == '4';
    }

    static /* synthetic */ String access$001(String x0) {
        return IDoc.removeAllDotsFromString(x0);
    }

    static /* synthetic */ void access$301(IDoc.Segment x0, char[] x1, int x2, int x3) {
        IDoc.copySegmentDataToCharArray(x0, x1, x2, x3);
    }

    static /* synthetic */ void access$401(IDoc.Segment x0, char[] x1, int x2, int x3) {
        IDoc.copySegmentDataToCharArray(x0, x1, x2, x3);
    }

    static /* synthetic */ String access$801() {
        return IDoc.getSystemDefaultCharEncoding();
    }

    static /* synthetic */ String access$901() {
        return IDoc.getSystemDefaultCharEncoding();
    }

    static /* synthetic */ String access$1201(String x0) {
        return IDoc.removeAllDotsFromString(x0);
    }

    static /* synthetic */ String access$1301(String x0) {
        return IDoc.removeAllDotsFromString(x0);
    }

    static /* synthetic */ String access$1401(String x0) {
        return IDoc.removeAllDotsFromString(x0);
    }

    static {
        block9: {
            m_JCoStaticRepository31 = null;
            m_JCoStaticRepository40 = null;
            m_JCoStaticRepository610UC = null;
            ZERO_CHARARRAY = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};
            SPACE_CHARARRAY = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
            String version = IDoc.getVersion();
            int index = version.indexOf(32);
            if (index >= 0) {
                version = version.substring(0, index);
            }
            try {
                if (IDoc.compareVersions(version, REQUIRED_IDOC_VERSION) < 0) {
                    throw new IDoc.Exception(8, "Could not initialize SAP Java Connector IDoc Class Library. Found SAP Java Base IDoc Class Library version " + version + " but " + "version " + REQUIRED_IDOC_VERSION + " or a higher patch level is required.");
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            version = JCO.getVersion();
            index = version.indexOf(32);
            if (index >= 0) {
                version = version.substring(0, index);
            }
            try {
                if (IDoc.compareVersions(version, "3") < 0) {
                    if (IDoc.compareVersions(version, REQUIRED_JCO_VERSION_2) < 0) {
                        throw new IDoc.Exception(8, "Could not initialize SAP Java Connector IDoc Class Library. Found SAP Java Connector version " + version + " but " + "version " + REQUIRED_JCO_VERSION_2 + " or a higher patch level is required.");
                    }
                    break block9;
                }
                throw new IDoc.Exception(8, "Could not initialize SAP Java Connector IDoc Class Library. Found SAP Java Connector version " + version + " but " + "version " + REQUIRED_JCO_VERSION_2 + " or a higher patch level is required.");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static class Server
    extends JCO.Server {
        private IDoc.Repository m_idocRepository = null;

        public Server(Properties properties) {
            super(properties);
        }

        public Server(Properties properties, IRepository jcoRepository, IDoc.Repository idocRepository) {
            super(properties, jcoRepository);
            this.m_idocRepository = idocRepository;
        }

        public Server(Properties properties, IServerThread thread, IRepository jcoRepository, IDoc.Repository idocRepository) {
            super(properties, thread, jcoRepository);
            this.m_idocRepository = idocRepository;
        }

        public Server(String[][] params, IRepository jcoRepository, IDoc.Repository idocRepository) {
            super(params, jcoRepository);
            this.m_idocRepository = idocRepository;
        }

        public Server(String gwhost, String gwserv, String progid, IRepository jcoRepository, IDoc.Repository idocRepository) {
            super(gwhost, gwserv, progid, jcoRepository);
            this.m_idocRepository = idocRepository;
        }

        public Server(String gwhost, String gwserv, String progid, IServerThread thread, IRepository jcoRepository, IDoc.Repository idocRepository) {
            super(gwhost, gwserv, progid, thread, jcoRepository);
            this.m_idocRepository = idocRepository;
        }

        protected Server(String gwhost, String gwserv, String progid) {
            super(gwhost, gwserv, progid);
        }

        protected void dispatchRequest(JCO.Function function) throws Exception {
            if (this.m_idocRepository != null) {
                String functionName = function.getName();
                if ("IDOC_INBOUND_ASYNCHRONOUS".equals(functionName)) {
                    JCO.ParameterList tabParamList = function.getTableParameterList();
                    JCO.Table tabControl = tabParamList.getTable("IDOC_CONTROL_REC_40");
                    JCO.Table tabData = tabParamList.getTable("IDOC_DATA_REC_40");
                    JCoDocumentList documentList = new JCoDocumentList(this.m_idocRepository, tabControl, tabData, null);
                    this.handleRequest(documentList);
                } else if ("IDOC_INBOUND_ASYNCHRONOUS_WITH_BINARY_DATA".equals(functionName)) {
                    JCO.ParameterList tabParamList = function.getTableParameterList();
                    JCO.Table tabControl = tabParamList.getTable("IDOC_CONTROL_REC_40");
                    JCO.Table tabData = tabParamList.getTable("IDOC_DATA_REC_40");
                    String codepage = this.getAttributes().getPartnerCodepage();
                    JCoDocumentList documentList = new JCoDocumentList(this.m_idocRepository, tabControl, tabData, codepage);
                    this.handleRequest(documentList);
                } else if ("INBOUND_IDOC_PROCESS".equals(functionName)) {
                    JCO.ParameterList tabParamList = function.getTableParameterList();
                    JCO.Table tabControl = tabParamList.getTable("IDOC_CONTROL");
                    JCO.Table tabData = tabParamList.getTable("IDOC_DATA");
                    JCoDocumentList documentList = new JCoDocumentList(this.m_idocRepository, tabControl, tabData, null);
                    this.handleRequest(documentList);
                } else if ("INBOUND_IDOC_PROCESS_WITH_BINARY_DATA".equals(functionName)) {
                    JCO.ParameterList tabParamList = function.getTableParameterList();
                    JCO.Table tabControl = tabParamList.getTable("IDOC_CONTROL");
                    JCO.Table tabData = tabParamList.getTable("IDOC_DATA");
                    String codepage = this.getAttributes().getPartnerCodepage();
                    JCoDocumentList documentList = new JCoDocumentList(this.m_idocRepository, tabControl, tabData, codepage);
                    this.handleRequest(documentList);
                } else {
                    super.dispatchRequest(function);
                }
            } else {
                super.dispatchRequest(function);
            }
        }

        protected IDoc.Repository getIDocRepository() {
            return this.m_idocRepository;
        }

        protected JCO.Function getFunction(String functionName) {
            if (this.m_idocRepository != null) {
                if ("IDOC_INBOUND_ASYNCHRONOUS".equals(functionName)) {
                    JCO.Attributes attributes = this.getAttributes();
                    boolean isUnicode = JCoIDoc.isPartnerSystemUnicode(attributes);
                    IRepository jcoStaticRepository = JCoIDoc.getJCoStaticRepository(attributes.getPartnerRelease(), isUnicode);
                    if (jcoStaticRepository != null) {
                        IFunctionTemplate functionTemplate = null;
                        functionTemplate = isUnicode || attributes.getOwnBytesPerChar() <= 1 ? jcoStaticRepository.getFunctionTemplate("IDOC_INBOUND_ASYNCHRONOUS") : jcoStaticRepository.getFunctionTemplate("IDOC_INBOUND_ASYNCHRONOUS_WITH_BINARY_DATA");
                        if (functionTemplate != null) {
                            return functionTemplate.getFunction();
                        }
                    }
                } else if ("INBOUND_IDOC_PROCESS".equals(functionName)) {
                    JCO.Attributes attributes = this.getAttributes();
                    boolean isUnicode = JCoIDoc.isPartnerSystemUnicode(attributes);
                    IRepository jcoStaticRepository = JCoIDoc.getJCoStaticRepository(attributes.getPartnerRelease(), isUnicode);
                    if (jcoStaticRepository != null) {
                        IFunctionTemplate functionTemplate = null;
                        functionTemplate = isUnicode || attributes.getOwnBytesPerChar() <= 1 ? jcoStaticRepository.getFunctionTemplate("INBOUND_IDOC_PROCESS") : jcoStaticRepository.getFunctionTemplate("INBOUND_IDOC_PROCESS_WITH_BINARY_DATA");
                        if (functionTemplate != null) {
                            return functionTemplate.getFunction();
                        }
                    }
                }
            }
            return super.getFunction(functionName);
        }

        protected void handleRequest(IDoc.DocumentList documentList) throws Exception {
        }

        protected void setIDocRepository(IDoc.Repository idocRepository) {
            this.m_idocRepository = idocRepository;
        }
    }

    public static class SAPRepository
    extends IDoc.BasicRepository {
        private static final long serialVersionUID = 1000L;
        protected transient JCO.Client m_client = null;
        protected transient ObjectList m_clientPoolNameList = new ObjectList(3);
        protected transient Hashtable m_querySemaphores = new Hashtable(11);
        protected transient Object m_iDocCompoundTypeQuerySemaphore = new Object();
        protected int m_iDocCompoundTypeKeysInSegmentMetaDataCache = 0;
        protected boolean m_iDocCompoundTypesQueried = false;
        protected Hashtable m_iDocCompoundTypesCache = null;

        protected SAPRepository(String repositoryName, JCO.Client client) {
            super(repositoryName);
            this.m_client = client;
        }

        protected SAPRepository(String repositoryName, String clientPoolName) {
            super(repositoryName);
            this.m_clientPoolNameList = new ObjectList(clientPoolName);
        }

        protected SAPRepository(String repositoryName, String[] clientPoolNames) {
            super(repositoryName);
            this.m_clientPoolNameList = new ObjectList(clientPoolNames);
        }

        public void addClientPool(String clientPoolName) {
            ObjectList objectList = this.m_clientPoolNameList;
            synchronized (objectList) {
                this.m_clientPoolNameList.add(clientPoolName);
            }
        }

        public void addClientPools(String[] clientPoolNames) {
            ObjectList objectList = this.m_clientPoolNameList;
            synchronized (objectList) {
                this.m_clientPoolNameList.addAll(clientPoolNames);
            }
        }

        protected static void addFieldMetaDataValueRanges(Hashtable recordMetaDataHashtable, Hashtable fieldMetaDataIndexHashtable, JCO.Table metaFValuesTable) {
            if (metaFValuesTable.getNumRows() == 0) {
                return;
            }
            IDoc.RecordMetaData recordMetaData = null;
            IDoc.FieldMetaData fieldMetaData = null;
            Integer integer = null;
            int fieldIndex = -1;
            String type = null;
            String nextType = null;
            String fieldName = null;
            String nextFieldName = null;
            boolean nextRow = true;
            metaFValuesTable.firstRow();
            type = metaFValuesTable.getString(0);
            fieldName = metaFValuesTable.getString(1);
            do {
                recordMetaData = (IDoc.RecordMetaData)recordMetaDataHashtable.get(type);
                do {
                    fieldMetaData = null;
                    if (recordMetaData != null && (integer = (Integer)fieldMetaDataIndexHashtable.get(IDoc.FieldMetaData.createKey(type, fieldName))) != null && (fieldIndex = integer.intValue()) >= 0 && fieldIndex < recordMetaData.getNumFields()) {
                        fieldMetaData = recordMetaData.getFieldMetaData(fieldIndex);
                    }
                    do {
                        if (fieldMetaData != null) {
                            fieldMetaData.addValueRange(metaFValuesTable.getString(2), metaFValuesTable.getString(3), metaFValuesTable.getString(4));
                        }
                        if (!(nextRow = metaFValuesTable.nextRow())) continue;
                        nextType = metaFValuesTable.getString(0);
                        nextFieldName = metaFValuesTable.getString(1);
                    } while (nextRow && fieldName.equals(nextFieldName) && type.equals(nextType));
                    fieldName = nextFieldName;
                } while (nextRow && type.equals(nextType));
                type = nextType;
            } while (nextRow);
        }

        protected void addIDocCompoundTypesToCache(Hashtable iDocCompoundTypesHashtable) {
            if (iDocCompoundTypesHashtable == null || iDocCompoundTypesHashtable.size() == 0) {
                return;
            }
            if (this.m_iDocCompoundTypesCache == null) {
                SAPRepository sAPRepository = this;
                synchronized (sAPRepository) {
                    if (this.m_iDocCompoundTypesCache == null) {
                        this.m_iDocCompoundTypesCache = (Hashtable)iDocCompoundTypesHashtable.clone();
                        return;
                    }
                }
            }
            Object key = null;
            Enumeration keys = iDocCompoundTypesHashtable.keys();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                this.m_iDocCompoundTypesCache.put(key, iDocCompoundTypesHashtable.get(key));
            }
        }

        public void addIDocCompoundTypeToCache(String iDocType, String iDocTypeExtension, String iDocCompoundType) {
            if (iDocType == null || iDocType.length() == 0 || iDocCompoundType == null || iDocCompoundType.length() == 0) {
                return;
            }
            if (this.m_iDocCompoundTypesCache == null) {
                SAPRepository sAPRepository = this;
                synchronized (sAPRepository) {
                    if (this.m_iDocCompoundTypesCache == null) {
                        this.m_iDocCompoundTypesCache = new Hashtable(51);
                    }
                }
            }
            String key = SAPRepository.createIDocCompoundTypeKey(iDocType, iDocTypeExtension);
            this.m_iDocCompoundTypesCache.put(key, iDocCompoundType);
        }

        public void clear() {
            super.clear();
            if (this.m_iDocCompoundTypesCache != null) {
                SAPRepository sAPRepository = this;
                synchronized (sAPRepository) {
                    this.m_iDocCompoundTypesCache = new Hashtable(51);
                    this.m_iDocCompoundTypeKeysInSegmentMetaDataCache = 0;
                    this.m_iDocCompoundTypesQueried = false;
                }
            } else {
                this.m_iDocCompoundTypesQueried = false;
            }
        }

        protected static String createIDocCompoundTypeKey(String iDocType, String iDocTypeExtension) {
            if (iDocTypeExtension == null || iDocTypeExtension.length() == 0) {
                return iDocType;
            }
            StringBuffer key = new StringBuffer(61);
            key.append(iDocType);
            key.append('|');
            key.append(iDocTypeExtension);
            return key.toString();
        }

        protected static Hashtable createIDocCompoundTypesHashtable(JCO.Table tabEDIDOFields, JCO.Table tabEDIDOData) {
            if (tabEDIDOFields == null || tabEDIDOData == null) {
                return null;
            }
            int numRowsData = tabEDIDOData.getNumRows();
            if (numRowsData == 0 || tabEDIDOFields.getNumRows() == 0) {
                return null;
            }
            int iDocCompoundTypeOffset = -1;
            int iDocCompoundTypeEnd = 0;
            int iDocTypeOffset = -1;
            int iDocTypeEnd = 0;
            int iDocTypeExtensionOffset = -1;
            int iDocTypeExtensionEnd = 0;
            boolean complete = false;
            String fieldName = null;
            tabEDIDOFields.firstRow();
            do {
                if ("DOCTYP".equals(fieldName = tabEDIDOFields.getString(0))) {
                    iDocCompoundTypeOffset = tabEDIDOFields.getInt(1);
                    iDocCompoundTypeEnd = iDocCompoundTypeOffset + tabEDIDOFields.getInt(2);
                    if (iDocTypeOffset < 0 || iDocTypeExtensionOffset < 0) continue;
                    complete = true;
                    continue;
                }
                if ("IDOCTYP".equals(fieldName)) {
                    iDocTypeOffset = tabEDIDOFields.getInt(1);
                    iDocTypeEnd = iDocTypeOffset + tabEDIDOFields.getInt(2);
                    if (iDocCompoundTypeOffset < 0 || iDocTypeExtensionOffset < 0) continue;
                    complete = true;
                    continue;
                }
                if (!"CIMTYP".equals(fieldName)) continue;
                iDocTypeExtensionOffset = tabEDIDOFields.getInt(1);
                iDocTypeExtensionEnd = iDocTypeExtensionOffset + tabEDIDOFields.getInt(2);
                if (iDocCompoundTypeOffset < 0 || iDocTypeOffset < 0) continue;
                complete = true;
            } while (tabEDIDOFields.nextRow() && !complete);
            if (!complete) {
                return null;
            }
            Hashtable<String, String> iDocCompoundTypesHashtable = new Hashtable<String, String>(numRowsData);
            String dataRow = null;
            String iDocType = null;
            String iDocTypeExtension = null;
            String iDocCompoundType = null;
            String key = null;
            tabEDIDOData.firstRow();
            do {
                dataRow = tabEDIDOData.getString(0);
                iDocCompoundType = dataRow.substring(iDocCompoundTypeOffset, iDocCompoundTypeEnd).trim();
                iDocType = dataRow.substring(iDocTypeOffset, iDocTypeEnd).trim();
                iDocTypeExtension = dataRow.substring(iDocTypeExtensionOffset, iDocTypeExtensionEnd).trim();
                key = SAPRepository.createIDocCompoundTypeKey(iDocType, iDocTypeExtension);
                iDocCompoundTypesHashtable.put(key, iDocCompoundType);
            } while (tabEDIDOData.nextRow());
            return iDocCompoundTypesHashtable;
        }

        protected IDoc.SegmentMetaData createRootSegmentMetaData31(JCO.Client client, String iDocType, String iDocTypeExtension, String systemRelease, JCO.Table metaSegmentsTable) {
            boolean nextRow;
            JCoSegmentMetaData rootSegmentMetaData = null;
            JCoSegmentMetaData segmentMetaData = null;
            JCoSegmentMetaData parentSegmentMetaData = null;
            JCoRecordMetaData recordMetaData = null;
            Int segmentMetaDataLength = new Int();
            Hashtable<Integer, JCoSegmentMetaData> segmentMetaDataHashtable = new Hashtable<Integer, JCoSegmentMetaData>(51);
            Integer segmentMetaDataNumber = null;
            Integer parentSegmentMetaDataNumber = null;
            String segmentMetaDataType = null;
            String segmentMetaDataDefinition = null;
            String segmentMetaDataDescription = null;
            boolean segmentMetaDataIsMandatory = false;
            long segmentMetaDataMinOccurrence = 0L;
            long segmentMetaDataMaxOccurrence = 0L;
            boolean bl = nextRow = metaSegmentsTable.getNumRows() > 0;
            if (nextRow) {
                metaSegmentsTable.firstRow();
                String rootSegmentIDocCompoundTypeKey = null;
                String iDocCompoundType = metaSegmentsTable.getString(11);
                if (iDocCompoundType != null && iDocCompoundType.length() > 0) {
                    String realIDocType = metaSegmentsTable.getString(0);
                    String realIDocTypeExtension = metaSegmentsTable.getString(1);
                    if (realIDocType != null && realIDocType.length() > 0 && !realIDocType.equals(iDocType) || realIDocTypeExtension != null && realIDocTypeExtension.length() > 0 && !realIDocTypeExtension.equals(iDocTypeExtension)) {
                        rootSegmentIDocCompoundTypeKey = IDoc.SegmentMetaData.createKey(iDocType, iDocTypeExtension, systemRelease, null, "ROOT");
                        iDocType = realIDocType;
                        iDocTypeExtension = realIDocTypeExtension;
                    }
                    this.addIDocCompoundTypeToCache(iDocType, iDocTypeExtension, iDocCompoundType);
                }
                rootSegmentMetaData = new JCoSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, null, "ROOT", metaSegmentsTable.getInt(10) - 1, "General root segment");
                segmentMetaDataHashtable.put(new Integer(0), rootSegmentMetaData);
                if (rootSegmentIDocCompoundTypeKey != null && this.m_segmentMetaDataCache.put(rootSegmentIDocCompoundTypeKey, rootSegmentMetaData) == null) {
                    ++this.m_iDocCompoundTypeKeysInSegmentMetaDataCache;
                }
            } else {
                rootSegmentMetaData = new JCoSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, null, "ROOT", 0, "General root segment");
            }
            while (nextRow) {
                segmentMetaDataNumber = new Integer(metaSegmentsTable.getInt(2));
                parentSegmentMetaDataNumber = new Integer(metaSegmentsTable.getInt(5));
                segmentMetaDataType = metaSegmentsTable.getString(3);
                segmentMetaDataDefinition = SAPRepository.querySegmentDefinition31(client, segmentMetaDataType, systemRelease, segmentMetaDataLength);
                segmentMetaDataIsMandatory = metaSegmentsTable.getChar(7) == 'X';
                segmentMetaDataMinOccurrence = metaSegmentsTable.getLong(8);
                segmentMetaDataMaxOccurrence = metaSegmentsTable.getLong(9);
                segmentMetaDataDescription = SAPRepository.querySegmentDescription31(client, segmentMetaDataType);
                recordMetaData = SAPRepository.queryRecordMetaData31(client, segmentMetaDataType, segmentMetaDataLength.value());
                segmentMetaData = new JCoSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, null, segmentMetaDataType, segmentMetaDataDefinition, metaSegmentsTable.getInt(10), segmentMetaDataDescription, segmentMetaDataIsMandatory, segmentMetaDataMinOccurrence, segmentMetaDataMaxOccurrence, false, recordMetaData);
                parentSegmentMetaData = (JCoSegmentMetaData)segmentMetaDataHashtable.get(parentSegmentMetaDataNumber);
                segmentMetaDataHashtable.put(segmentMetaDataNumber, segmentMetaData);
                parentSegmentMetaData.addChild(segmentMetaData);
                nextRow = metaSegmentsTable.nextRow();
            }
            return rootSegmentMetaData;
        }

        protected static IDoc.SegmentMetaData createRootSegmentMetaData40(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, JCO.Table metaSegmentsTable, Hashtable recordMetaDataHashtable) {
            boolean nextRow;
            JCoSegmentMetaData rootSegmentMetaData = null;
            JCoSegmentMetaData segmentMetaData = null;
            JCoSegmentMetaData parentSegmentMetaData = null;
            JCoRecordMetaData recordMetaData = null;
            Hashtable<Integer, JCoSegmentMetaData> segmentMetaDataHashtable = new Hashtable<Integer, JCoSegmentMetaData>(51);
            Integer segmentMetaDataNumber = null;
            Integer parentSegmentMetaDataNumber = null;
            String segmentMetaDataType = null;
            boolean segmentMetaDataIsParent = false;
            boolean bl = nextRow = metaSegmentsTable.getNumRows() > 0;
            if (nextRow) {
                metaSegmentsTable.firstRow();
                rootSegmentMetaData = new JCoSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, "ROOT", metaSegmentsTable.getInt(11) - 1, "General root segment");
                segmentMetaDataHashtable.put(new Integer(0), rootSegmentMetaData);
            } else {
                rootSegmentMetaData = new JCoSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, "ROOT", 0, "General root segment");
            }
            while (nextRow) {
                segmentMetaDataNumber = new Integer(metaSegmentsTable.getInt(0));
                segmentMetaDataType = metaSegmentsTable.getString(1);
                parentSegmentMetaDataNumber = new Integer(metaSegmentsTable.getInt(6));
                segmentMetaDataIsParent = metaSegmentsTable.getChar(7) == 'X';
                recordMetaData = (JCoRecordMetaData)recordMetaDataHashtable.get(segmentMetaDataType);
                segmentMetaData = segmentMetaDataIsParent ? new JCoSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, segmentMetaDataType, metaSegmentsTable.getString(2), metaSegmentsTable.getInt(11), metaSegmentsTable.getString(12), metaSegmentsTable.getChar(13) == 'X', metaSegmentsTable.getLong(14), metaSegmentsTable.getLong(15), metaSegmentsTable.getChar(3) == 'X', recordMetaData) : new JCoSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, segmentMetaDataType, metaSegmentsTable.getString(2), metaSegmentsTable.getInt(11), metaSegmentsTable.getString(12), metaSegmentsTable.getChar(8) == 'X', metaSegmentsTable.getLong(9), metaSegmentsTable.getLong(10), metaSegmentsTable.getChar(3) == 'X', recordMetaData);
                parentSegmentMetaData = (JCoSegmentMetaData)segmentMetaDataHashtable.get(parentSegmentMetaDataNumber);
                segmentMetaDataHashtable.put(segmentMetaDataNumber, segmentMetaData);
                parentSegmentMetaData.addChild(segmentMetaData);
                nextRow = metaSegmentsTable.nextRow();
            }
            return rootSegmentMetaData;
        }

        protected static Hashtable createRecordMetaDataHashtable40(JCO.Table metaFieldsTable, JCO.Table metaFValuesTable) {
            if (metaFieldsTable.getNumRows() == 0) {
                return new Hashtable(0);
            }
            Hashtable<String, JCoRecordMetaData> recordMetaDataHashtable = new Hashtable<String, JCoRecordMetaData>(51);
            Hashtable<String, Integer> fieldMetaDataIndexHashtable = new Hashtable<String, Integer>(1000);
            JCoRecordMetaData recordMetaData = null;
            JCoFieldMetaData fieldMetaData = null;
            String nextType = null;
            int startOffset = 0;
            int fieldIndex = 0;
            boolean nextRow = true;
            String type = null;
            String fieldName = null;
            int internalLength = 0;
            int outputLength = 0;
            int offset = 0;
            String dataTypeName = null;
            String dataElementName = null;
            String domainName = null;
            String description = null;
            String checkTableName = null;
            boolean isISOCode = false;
            metaFieldsTable.firstRow();
            type = metaFieldsTable.getString(0);
            startOffset = metaFieldsTable.getInt(5);
            do {
                recordMetaData = new JCoRecordMetaData(type);
                fieldIndex = 0;
                do {
                    fieldName = metaFieldsTable.getString(1);
                    internalLength = metaFieldsTable.getInt(2);
                    outputLength = metaFieldsTable.getInt(3);
                    offset = metaFieldsTable.getInt(5) - startOffset;
                    dataTypeName = metaFieldsTable.getString(9);
                    dataElementName = metaFieldsTable.getString(7);
                    domainName = metaFieldsTable.getString(8);
                    description = metaFieldsTable.getString(10);
                    checkTableName = metaFieldsTable.getString(12);
                    isISOCode = metaFieldsTable.getChar(11) == 'X';
                    fieldMetaData = new JCoFieldMetaData(fieldName, internalLength, outputLength, dataTypeName, dataElementName, domainName, description, checkTableName, isISOCode);
                    recordMetaData.addInfo(fieldName, 0, outputLength, offset, 0, null, description, 0, null, fieldMetaData);
                    fieldMetaDataIndexHashtable.put(IDoc.FieldMetaData.createKey(type, fieldName), new Integer(fieldIndex));
                    nextRow = metaFieldsTable.nextRow();
                    if (!nextRow) continue;
                    nextType = metaFieldsTable.getString(0);
                    ++fieldIndex;
                } while (nextRow && type.equals(nextType));
                recordMetaData.setTabLength(offset + outputLength);
                recordMetaDataHashtable.put(type, recordMetaData);
                type = nextType;
            } while (nextRow);
            SAPRepository.addFieldMetaDataValueRanges(recordMetaDataHashtable, fieldMetaDataIndexHashtable, metaFValuesTable);
            return recordMetaDataHashtable;
        }

        protected static JCoRecordMetaData createRecordMetaData31(String recordName, int maxRecordLength, JCO.Table metaFieldInfoTable1, JCO.Table metaFieldInfoTable3) {
            JCoRecordMetaData recordMetaData = new JCoRecordMetaData(recordName);
            JCoFieldMetaData fieldMetaData = null;
            Object type = null;
            String fieldName = null;
            int internalLength = 0;
            int outputLength = 0;
            int offset = 0;
            String dataTypeName = null;
            String dataElementName = null;
            String domainName = null;
            String description = null;
            metaFieldInfoTable1.firstRow();
            if (metaFieldInfoTable3 != null) {
                metaFieldInfoTable3.firstRow();
            }
            do {
                fieldName = metaFieldInfoTable1.getString(1);
                internalLength = metaFieldInfoTable1.getInt(9);
                outputLength = metaFieldInfoTable1.getInt(8);
                offset = metaFieldInfoTable1.getInt(4);
                if (metaFieldInfoTable3 != null && fieldName.equals(metaFieldInfoTable3.getString(1))) {
                    dataTypeName = metaFieldInfoTable3.getString(12);
                    dataElementName = metaFieldInfoTable3.getString(6);
                    domainName = metaFieldInfoTable3.getString(5);
                    description = metaFieldInfoTable3.getString(27);
                } else {
                    dataTypeName = metaFieldInfoTable1.getString(12);
                    dataElementName = metaFieldInfoTable1.getString(6);
                    domainName = metaFieldInfoTable1.getString(5);
                    description = metaFieldInfoTable1.getString(27);
                }
                fieldMetaData = new JCoFieldMetaData(fieldName, internalLength, outputLength, dataTypeName, dataElementName, domainName, description, null, false);
                recordMetaData.addInfo(fieldName, 0, outputLength, offset, 0, null, description, 0, null, fieldMetaData);
                if (metaFieldInfoTable3 == null) continue;
                metaFieldInfoTable3.nextRow();
            } while (metaFieldInfoTable1.nextRow() && offset + outputLength < maxRecordLength);
            recordMetaData.setTabLength(offset + outputLength);
            return recordMetaData;
        }

        public String getCachedIDocCompoundType(String iDocType, String iDocTypeExtension) {
            if (this.m_iDocCompoundTypesCache == null) {
                return null;
            }
            String key = SAPRepository.createIDocCompoundTypeKey(iDocType, iDocTypeExtension);
            return (String)this.m_iDocCompoundTypesCache.get(key);
        }

        public JCO.Client getClient() {
            return this.m_client;
        }

        public String[] getClientPoolNames() {
            Object[] objectArray = null;
            ObjectList objectList = this.m_clientPoolNameList;
            synchronized (objectList) {
                objectArray = this.m_clientPoolNameList.toArray();
            }
            String[] stringArray = new String[objectArray.length];
            System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
            return stringArray;
        }

        public String getIDocCompoundType(String iDocType, String iDocTypeExtension) {
            return this.getIDocCompoundType(iDocType, iDocTypeExtension, null);
        }

        public String getIDocCompoundType(String iDocType, String iDocTypeExtension, Vector queriedRepositories) {
            if (queriedRepositories != null && queriedRepositories.contains(this)) {
                return null;
            }
            String iDocCompoundType = this.getCachedIDocCompoundType(iDocType, iDocTypeExtension);
            if (iDocCompoundType == null) {
                if (!this.m_iDocCompoundTypesQueried) {
                    Object object = this.m_iDocCompoundTypeQuerySemaphore;
                    synchronized (object) {
                        Hashtable iDocCompoundTypesHashtable;
                        iDocCompoundType = this.getCachedIDocCompoundType(iDocType, iDocTypeExtension);
                        if (iDocCompoundType != null) {
                            String string = iDocCompoundType;
                            return string;
                        }
                        if (!this.m_iDocCompoundTypesQueried && (iDocCompoundTypesHashtable = this.queryIDocCompoundTypes()) != null) {
                            this.addIDocCompoundTypesToCache(iDocCompoundTypesHashtable);
                            this.m_iDocCompoundTypesQueried = true;
                            iDocCompoundType = this.getCachedIDocCompoundType(iDocType, iDocTypeExtension);
                            if (iDocCompoundType != null) {
                                String string = iDocCompoundType;
                                return string;
                            }
                        }
                    }
                }
                IDoc.Repository nextRepository = this.m_nextRepository;
                while (nextRepository != null && !(nextRepository instanceof SAPRepository)) {
                    if ((nextRepository = nextRepository.getNextRepository()) != this) continue;
                    nextRepository = null;
                }
                if (nextRepository != null) {
                    if (queriedRepositories == null) {
                        queriedRepositories = new Vector<SAPRepository>(5);
                    }
                    queriedRepositories.add(this);
                    iDocCompoundType = ((SAPRepository)nextRepository).getIDocCompoundType(iDocType, iDocTypeExtension, queriedRepositories);
                }
                if (iDocCompoundType == null && iDocType != null && (iDocTypeExtension == null || iDocTypeExtension.length() == 0)) {
                    iDocCompoundType = iDocType;
                }
            }
            return iDocCompoundType;
        }

        public IDoc.SegmentMetaData getRootSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, Vector queriedRepositories) {
            if (queriedRepositories != null && queriedRepositories.contains(this)) {
                return null;
            }
            IDoc.SegmentMetaData rootSegmentMetaData = this.getCachedRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
            if (rootSegmentMetaData == null) {
                IDoc.Repository nextRepository;
                Object querySemaphore = null;
                String key = IDoc.SegmentMetaData.createKey(iDocType, iDocTypeExtension, systemRelease, applicationRelease, "ROOT");
                Hashtable hashtable = this.m_querySemaphores;
                synchronized (hashtable) {
                    querySemaphore = this.m_querySemaphores.get(key);
                    if (querySemaphore == null) {
                        querySemaphore = new Object();
                        this.m_querySemaphores.put(key, querySemaphore);
                    }
                }
                Object object = querySemaphore;
                synchronized (object) {
                    rootSegmentMetaData = this.getCachedSegmentMetaData(key);
                    if (rootSegmentMetaData == null) {
                        try {
                            rootSegmentMetaData = this.queryRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
                            if (rootSegmentMetaData != null) {
                                this.addSegmentMetaDataToCache(rootSegmentMetaData);
                            }
                            Object var12_12 = null;
                            this.m_querySemaphores.remove(key);
                        }
                        catch (Throwable throwable) {
                            Object var12_13 = null;
                            this.m_querySemaphores.remove(key);
                            throw throwable;
                        }
                        {
                        }
                    }
                }
                if (rootSegmentMetaData == null && (nextRepository = this.m_nextRepository) != null) {
                    if (queriedRepositories == null) {
                        queriedRepositories = new Vector<SAPRepository>(5);
                    }
                    queriedRepositories.add(this);
                    rootSegmentMetaData = nextRepository.getRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, queriedRepositories);
                }
            }
            return rootSegmentMetaData;
        }

        public IDoc.SegmentMetaData getSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String definition, Vector queriedRepositories) {
            if ("ROOT".equals(definition)) {
                return this.getRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, queriedRepositories);
            }
            if (queriedRepositories != null && queriedRepositories.contains(this)) {
                return null;
            }
            String key = IDoc.SegmentMetaData.createKey(iDocType, iDocTypeExtension, systemRelease, applicationRelease, definition);
            IDoc.SegmentMetaData segmentMetaData = this.getCachedSegmentMetaData(key);
            if (segmentMetaData == null) {
                IDoc.Repository nextRepository;
                IDoc.SegmentMetaData rootSegmentMetaData = this.getRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
                if (rootSegmentMetaData != null) {
                    this.addSegmentMetaDataTreeToCache(rootSegmentMetaData);
                    segmentMetaData = this.getCachedSegmentMetaData(key);
                }
                if (segmentMetaData == null && (nextRepository = this.m_nextRepository) != null) {
                    if (queriedRepositories == null) {
                        queriedRepositories = new Vector<SAPRepository>(5);
                    }
                    queriedRepositories.add(this);
                    segmentMetaData = nextRepository.getSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, definition, queriedRepositories);
                }
            }
            return segmentMetaData;
        }

        public Hashtable queryIDocCompoundTypes() {
            Hashtable iDocCompoundTypesHashtable = null;
            String[] clientPoolNames = this.getClientPoolNames();
            JCO.Client client = null;
            int i = 0;
            while (i < clientPoolNames.length && iDocCompoundTypesHashtable == null) {
                try {
                    client = JCO.getClient(clientPoolNames[i], false);
                    iDocCompoundTypesHashtable = SAPRepository.queryIDocCompoundTypes(client);
                    JCO.releaseClient(client);
                    client = null;
                }
                catch (Exception ex) {
                    try {
                        JCO.releaseClient(client);
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                }
                ++i;
            }
            if (iDocCompoundTypesHashtable == null && (client = this.m_client) != null) {
                JCO.Client client2 = client;
                synchronized (client2) {
                    iDocCompoundTypesHashtable = SAPRepository.queryIDocCompoundTypes(client);
                }
            }
            return iDocCompoundTypesHashtable;
        }

        public static Hashtable queryIDocCompoundTypes(JCO.Client client) {
            if (client == null) {
                return null;
            }
            try {
                IRepository jcoRepository = JCoIDoc.getJCoStaticRepository(client.getAttributes());
                JCO.Function metaFunction = jcoRepository.getFunctionTemplate("RFC_READ_TABLE").getFunction();
                JCO.ParameterList impParamList = metaFunction.getImportParameterList();
                JCO.ParameterList tabParamList = metaFunction.getTableParameterList();
                impParamList.setValue("EDIDO", "QUERY_TABLE");
                tabParamList.setActive(false, "OPTIONS");
                client.execute(metaFunction);
                JCO.Table tabEDIDOFields = tabParamList.getTable("FIELDS");
                JCO.Table tabEDIDOData = tabParamList.getTable("DATA");
                return SAPRepository.createIDocCompoundTypesHashtable(tabEDIDOFields, tabEDIDOData);
            }
            catch (JCO.AbapException ex) {
                return new Hashtable(0);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public IDoc.SegmentMetaData queryRootSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
            if (iDocType == null || iDocType.length() == 0) {
                return null;
            }
            IDoc.SegmentMetaData rootSegmentMetaData = null;
            String[] clientPoolNames = this.getClientPoolNames();
            JCO.Client client = null;
            int i = 0;
            while (i < clientPoolNames.length && rootSegmentMetaData == null) {
                try {
                    client = JCO.getClient(clientPoolNames[i], false);
                    rootSegmentMetaData = this.queryRootSegmentMetaData(client, iDocType, iDocTypeExtension, systemRelease, applicationRelease);
                    JCO.releaseClient(client);
                    client = null;
                }
                catch (Exception ex) {
                    try {
                        JCO.releaseClient(client);
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                }
                ++i;
            }
            if (rootSegmentMetaData == null && (client = this.m_client) != null) {
                JCO.Client client2 = client;
                synchronized (client2) {
                    rootSegmentMetaData = this.queryRootSegmentMetaData(client, iDocType, iDocTypeExtension, systemRelease, applicationRelease);
                }
            }
            return rootSegmentMetaData;
        }

        public IDoc.SegmentMetaData queryRootSegmentMetaData(JCO.Client client, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
            if (client == null || iDocType == null || iDocType.length() == 0) {
                return null;
            }
            try {
                String sapRelease = client.getAttributes().getPartnerRelease();
                if (sapRelease == null || sapRelease.length() == 0 || sapRelease.compareTo("4") >= 0) {
                    return SAPRepository.queryRootSegmentMetaData40(client, iDocType, iDocTypeExtension, systemRelease, applicationRelease);
                }
                return this.queryRootSegmentMetaData31(client, iDocType, iDocTypeExtension, systemRelease);
            }
            catch (Exception ex) {
                return null;
            }
        }

        protected final IDoc.SegmentMetaData queryRootSegmentMetaData31(JCO.Client client, String iDocType, String iDocTypeExtension, String systemRelease) {
            if (client == null || iDocType == null || iDocType.length() == 0) {
                return null;
            }
            try {
                IRepository jcoRepository = JCoIDoc.getJCoStaticRepository("31", false);
                JCO.Function metaFunction = null;
                JCO.ParameterList impParamList = null;
                JCO.ParameterList tabParamList = null;
                JCO.Table metaSegmentsTable = null;
                if (iDocTypeExtension == null || iDocTypeExtension.length() == 0) {
                    metaFunction = jcoRepository.getFunctionTemplate("EDI_IDOC_SYNTAX_GET").getFunction();
                    impParamList = metaFunction.getImportParameterList();
                    tabParamList = metaFunction.getTableParameterList();
                    impParamList.setValue(iDocType, "DOCTYP");
                    client.execute(metaFunction);
                    metaSegmentsTable = tabParamList.getTable("SYNTAX_TABLE");
                } else {
                    metaFunction = jcoRepository.getFunctionTemplate("EDI_IDOC_MERGE_WITH_EXTENSION").getFunction();
                    impParamList = metaFunction.getImportParameterList();
                    tabParamList = metaFunction.getTableParameterList();
                    impParamList.setValue(iDocType, "IDOCTYP");
                    impParamList.setValue(iDocTypeExtension, "CIMTYP");
                    tabParamList.setActive(false, "INT_IDOCSYN");
                    tabParamList.setActive(false, "INT_CIMSYN");
                    client.execute(metaFunction);
                    metaSegmentsTable = tabParamList.getTable("INT_EDISYN");
                }
                return this.createRootSegmentMetaData31(client, iDocType, iDocTypeExtension, systemRelease, metaSegmentsTable);
            }
            catch (Exception ex) {
                return null;
            }
        }

        protected static final IDoc.SegmentMetaData queryRootSegmentMetaData40(JCO.Client client, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
            if (client == null || iDocType == null || iDocType.length() == 0) {
                return null;
            }
            try {
                IRepository jcoRepository = JCoIDoc.getJCoStaticRepository(client.getAttributes());
                JCO.Function metaFunction = jcoRepository.getFunctionTemplate("IDOCTYPE_READ_COMPLETE").getFunction();
                JCO.ParameterList impParamList = metaFunction.getImportParameterList();
                JCO.ParameterList tabParamList = metaFunction.getTableParameterList();
                impParamList.setValue(iDocType, "PI_IDOCTYP");
                impParamList.setValue(iDocTypeExtension, "PI_CIMTYP");
                impParamList.setValue(JCoIDoc.access$1201(systemRelease), "PI_RELEASE");
                impParamList.setValue(JCoIDoc.access$1301(applicationRelease), "PI_APPLREL");
                tabParamList.setActive(false, "PT_MESSAGES");
                client.execute(metaFunction);
                JCO.Table metaSegmentsTable = tabParamList.getTable("PT_SEGMENTS");
                JCO.Table metaFieldsTable = tabParamList.getTable("PT_FIELDS");
                JCO.Table metaFValuesTable = tabParamList.getTable("PT_FVALUES");
                Hashtable recordMetaDataHashtable = SAPRepository.createRecordMetaDataHashtable40(metaFieldsTable, metaFValuesTable);
                return SAPRepository.createRootSegmentMetaData40(iDocType, iDocTypeExtension, systemRelease, applicationRelease, metaSegmentsTable, recordMetaDataHashtable);
            }
            catch (Exception ex) {
                return null;
            }
        }

        protected static final String querySegmentDefinition31(JCO.Client client, String segmentType, String systemRelease, Int segmentLength) {
            if (client == null || segmentType == null || segmentType.length() == 0) {
                if (segmentLength != null) {
                    segmentLength.set(0);
                }
                return null;
            }
            try {
                IRepository jcoRepository = JCoIDoc.getJCoStaticRepository("31", false);
                JCO.Function metaFunction = jcoRepository.getFunctionTemplate("EDI_SEGTYP_GET").getFunction();
                JCO.ParameterList impParamList = metaFunction.getImportParameterList();
                JCO.ParameterList expParamList = metaFunction.getExportParameterList();
                impParamList.setValue(segmentType, "SEGTYP");
                impParamList.setValue(JCoIDoc.access$1401(systemRelease), "RELEASED");
                client.execute(metaFunction);
                if (segmentLength != null) {
                    segmentLength.set(expParamList.getInt("SEGLEN"));
                }
                return expParamList.getString("SEGNAM");
            }
            catch (Exception ex) {
                if (segmentLength != null) {
                    segmentLength.set(0);
                }
                return null;
            }
        }

        protected static final String querySegmentDescription31(JCO.Client client, String segmentType) {
            if (client == null || segmentType == null || segmentType.length() == 0) {
                return null;
            }
            try {
                IRepository jcoRepository = JCoIDoc.getJCoStaticRepository("31", false);
                JCO.Function metaFunction = jcoRepository.getFunctionTemplate("EDI_SEGMENT_DESCRIPTION_GET").getFunction();
                JCO.ParameterList impParamList = metaFunction.getImportParameterList();
                JCO.ParameterList expParamList = metaFunction.getExportParameterList();
                impParamList.setValue(segmentType, "SEGTYP");
                client.execute(metaFunction);
                return expParamList.getString("DESCRP");
            }
            catch (Exception exception) {
                return null;
            }
        }

        protected static final JCoRecordMetaData queryRecordMetaData31(JCO.Client client, String recordName, int maxRecordLength) {
            if (client == null || recordName == null || recordName.length() == 0) {
                return null;
            }
            try {
                IRepository jcoRepository = JCoIDoc.getJCoStaticRepository("31", false);
                IFunctionTemplate metaFunctionTemplate = jcoRepository.getFunctionTemplate("DDIF_FIELDINFO_GET");
                JCO.Function metaFunction = metaFunctionTemplate.getFunction();
                JCO.ParameterList impParamList = metaFunction.getImportParameterList();
                JCO.ParameterList tabParamList = metaFunction.getTableParameterList();
                impParamList.setValue(recordName, "TABNAME");
                client.execute(metaFunction);
                JCO.Table metaFieldInfoTable1 = tabParamList.getTable("DFIES_TAB");
                JCO.Table metaFieldInfoTable3 = null;
                if (metaFieldInfoTable1.getNumRows() == 0) {
                    return null;
                }
                try {
                    StringBuffer recordName3 = new StringBuffer(recordName);
                    if (recordName3.length() > 1 && recordName3.charAt(1) == '1') {
                        recordName3.setCharAt(1, '3');
                        metaFunction = metaFunctionTemplate.getFunction();
                        impParamList = metaFunction.getImportParameterList();
                        tabParamList = metaFunction.getTableParameterList();
                        impParamList.setValue(recordName3.toString(), "TABNAME");
                        client.execute(metaFunction);
                        metaFieldInfoTable3 = tabParamList.getTable("DFIES_TAB");
                        if (metaFieldInfoTable3.getNumRows() != metaFieldInfoTable1.getNumRows()) {
                            metaFieldInfoTable3 = null;
                        }
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return SAPRepository.createRecordMetaData31(recordName, maxRecordLength, metaFieldInfoTable1, metaFieldInfoTable3);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void removeAllClientPools() {
            ObjectList objectList = this.m_clientPoolNameList;
            synchronized (objectList) {
                this.m_clientPoolNameList.clear();
            }
        }

        public boolean removeClientPool(String clientPoolName) {
            ObjectList objectList = this.m_clientPoolNameList;
            synchronized (objectList) {
                boolean bl = this.m_clientPoolNameList.remove(clientPoolName);
                return bl;
            }
        }

        public boolean removeClientPools(String[] clientPoolNames) {
            ObjectList objectList = this.m_clientPoolNameList;
            synchronized (objectList) {
                boolean bl = this.m_clientPoolNameList.removeAll(clientPoolNames);
                return bl;
            }
        }

        public IDoc.SegmentMetaData removeRootSegmentMetaDataFromCache(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
            IDoc.SegmentMetaData rootSegmentMetaData = super.removeRootSegmentMetaDataFromCache(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
            this.removeSecondRootSegmentMetaDataFromCache(iDocType, iDocTypeExtension, systemRelease, applicationRelease, rootSegmentMetaData);
            return rootSegmentMetaData;
        }

        public IDoc.SegmentMetaData removeRootSegmentMetaDataTreeFromCache(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
            IDoc.SegmentMetaData rootSegmentMetaData = super.removeRootSegmentMetaDataTreeFromCache(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
            this.removeSecondRootSegmentMetaDataFromCache(iDocType, iDocTypeExtension, systemRelease, applicationRelease, rootSegmentMetaData);
            return rootSegmentMetaData;
        }

        private void removeSecondRootSegmentMetaDataFromCache(IDoc.SegmentMetaData rootSegmentMetaData) {
            String key;
            String iDocCompoundType;
            if (this.m_iDocCompoundTypeKeysInSegmentMetaDataCache > 0 && rootSegmentMetaData != null && (iDocCompoundType = this.getCachedIDocCompoundType(rootSegmentMetaData.getIDocType(), rootSegmentMetaData.getIDocTypeExtension())) != null && this.m_segmentMetaDataCache.remove(key = IDoc.SegmentMetaData.createKey(iDocCompoundType, null, rootSegmentMetaData.getSystemRelease(), rootSegmentMetaData.getApplicationRelease(), "ROOT")) != null) {
                --this.m_iDocCompoundTypeKeysInSegmentMetaDataCache;
            }
        }

        private void removeSecondRootSegmentMetaDataFromCache(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, IDoc.SegmentMetaData rootSegmentMetaData) {
            if (this.m_iDocCompoundTypeKeysInSegmentMetaDataCache > 0 && rootSegmentMetaData != null) {
                String key = IDoc.SegmentMetaData.createKey(iDocType, iDocTypeExtension, systemRelease, applicationRelease, "ROOT");
                if (key.equals(rootSegmentMetaData.getKey())) {
                    String iDocCompoundType = this.getCachedIDocCompoundType(iDocType, iDocTypeExtension);
                    if (iDocCompoundType != null && this.m_segmentMetaDataCache.remove(key = IDoc.SegmentMetaData.createKey(iDocCompoundType, null, systemRelease, applicationRelease, "ROOT")) != null) {
                        --this.m_iDocCompoundTypeKeysInSegmentMetaDataCache;
                    }
                } else if (this.m_segmentMetaDataCache.remove(key) != null) {
                    --this.m_iDocCompoundTypeKeysInSegmentMetaDataCache;
                }
            }
        }

        public boolean removeSegmentMetaDataFromCache(IDoc.SegmentMetaData segmentMetaData) {
            boolean removed = super.removeSegmentMetaDataFromCache(segmentMetaData);
            if (removed && "ROOT".equals(segmentMetaData.getDefinition())) {
                this.removeSecondRootSegmentMetaDataFromCache(segmentMetaData);
            }
            return removed;
        }

        public boolean removeSegmentMetaDataTreeFromCache(IDoc.SegmentMetaData segmentMetaData) {
            boolean removed = super.removeSegmentMetaDataTreeFromCache(segmentMetaData);
            if (removed && "ROOT".equals(segmentMetaData.getDefinition())) {
                this.removeSecondRootSegmentMetaDataFromCache(segmentMetaData);
            }
            return removed;
        }

        public void setClient(JCO.Client client) {
            this.m_client = client;
        }

        public void setClientPool(String clientPoolName) {
            ObjectList objectList = this.m_clientPoolNameList;
            synchronized (objectList) {
                this.m_clientPoolNameList.clear();
                this.m_clientPoolNameList.add(clientPoolName);
            }
        }

        public void setClientPools(String[] clientPoolNames) {
            ObjectList objectList = this.m_clientPoolNameList;
            synchronized (objectList) {
                this.m_clientPoolNameList.clear();
                this.m_clientPoolNameList.addAll(clientPoolNames);
            }
        }
    }

    private static class JCoTable
    extends JCO.Table {
        private JCoTable(IMetaData metaData) {
            super(metaData);
        }

        private JCoTable(JCO.Structure structure) {
            super(structure);
        }

        private final void appendRow(char[] rowData) {
            this.appendRow();
            System.arraycopy(rowData, 0, this.getDataBuffer(), this.getDataBufferOffset(0), Math.min(rowData.length, this.getDataBufferRowLength()));
        }

        protected final char[] getDataBuffer() {
            return super.getDataBuffer();
        }

        protected final int getDataBufferRowLength() {
            return super.getDataBufferRowLength();
        }

        protected final int getDataBufferLength(int index) {
            return super.getDataBufferLength(index);
        }

        protected final int getDataBufferOffset(int index) {
            return super.getDataBufferOffset(index);
        }
    }

    public static class JCoSegmentMetaData
    extends IDoc.SegmentMetaData {
        protected JCoSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String type, int hierarchyLevel, String description) {
            super(iDocType, iDocTypeExtension, systemRelease, applicationRelease, type, type, hierarchyLevel, description, new JCoRecordMetaData(type));
        }

        protected JCoSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String type, String definition, int hierarchyLevel, String description, boolean mandatoryFlag, long minOccurrence, long maxOccurrence, boolean qualifiedFlag, JCoRecordMetaData recordMetaData) {
            super(iDocType, iDocTypeExtension, systemRelease, applicationRelease, type, definition, hierarchyLevel, description, mandatoryFlag, minOccurrence, maxOccurrence, qualifiedFlag, recordMetaData);
            if (recordMetaData != null) {
                recordMetaData.setName(definition);
            }
        }

        protected void addChild(IDoc.SegmentMetaData child) {
            super.addChild(child);
        }

        protected static void printHTML(IDoc.SegmentMetaData segmentMetaData, PrintWriter os) {
            String th = JCO.getProperty(JCoIDoc.JCO_HTML_TABLE_HEADER_BACKGROUND2);
            String hc = JCO.getProperty(JCoIDoc.JCO_HTML_TABLE_HEADER_BACKGROUND3);
            String rc = JCO.getProperty(JCoIDoc.JCO_HTML_TABLE_ROW_BACKGROUND1);
            String bdr = JCO.getProperty(JCoIDoc.JCO_HTML_TABLE_BORDER);
            String fface = JCO.getProperty(JCoIDoc.JCO_HTML_FONT_FACE);
            String fsize = JCO.getProperty(JCoIDoc.JCO_HTML_FONT_SIZE);
            int max_rows = 100;
            int numFields = 10;
            os.println("<font face='" + fface + "' size='" + fsize + "'>");
            os.println("<table border='" + bdr + "' bgcolor='" + th + "'>");
            os.println("<tr align='LEFT'>");
            os.print("<th colspan='" + numFields + "'>Segment Meta Data: " + segmentMetaData.getName() + "</th>");
            os.println("</tr>");
            os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Index:</th>");
            int i = 0;
            while (i < numFields) {
                os.print("<th>" + (i + 1) + "</th>");
                ++i;
            }
            os.println("</tr>");
            os.println("<tr align='CENTER' bgcolor='" + hc + "'><th align='left'>Attribute:</th>");
            os.print("<th>SEGMENTTYP</th>");
            os.print("<th>HLEVEL</th>");
            os.print("<th>QUALIFIER</th>");
            os.print("<th>PARFLG</th>");
            os.print("<th>MUSTFL</th>");
            os.print("<th>OCCMIN</th>");
            os.print("<th>OCCMAX</th>");
            os.println("</tr>");
            os.println("<tr bgcolor='" + rc + "' align='CENTER'><th align='left'>Value:</th>");
            os.print("<td align='center'>" + segmentMetaData.getType());
            os.print("<td align='center'>" + segmentMetaData.getHierarchyLevel());
            os.print("<td align='center'>" + segmentMetaData.isQualified());
            os.print("<td align='center'>" + segmentMetaData.isParent());
            os.print("<td align='center'>" + segmentMetaData.isMandatory());
            os.print("<td align='center'>" + segmentMetaData.getMinOccurrence());
            os.print("<td align='center'>" + segmentMetaData.getMaxOccurrence());
            os.println("</table></font>");
        }
    }

    public static class JCoSegment
    extends JCoRecord
    implements IDoc.Segment,
    Cloneable {
        private static final long serialVersionUID = 1000L;
        protected IDoc.Document m_document = null;
        protected JCoSegment m_parent = null;
        protected IDoc.SegmentMetaData m_segmentMetaData = null;
        protected IDoc.SegmentList m_childs = new IDoc.SegmentList(5);
        protected Hashtable m_childSegmentTypeCounters = new Hashtable(5);

        protected JCoSegment(IDoc.Document document, IDoc.SegmentMetaData segmentMetaData, boolean checkFieldValuesOnSet) {
            super(8, segmentMetaData.getRecordMetaData());
            this.m_document = document;
            this.m_segmentMetaData = segmentMetaData;
            this.m_checkFieldValuesOnSet = checkFieldValuesOnSet;
            char[] dataBuffer = this.getDataBuffer();
            int i = 0;
            while (i < dataBuffer.length) {
                dataBuffer[i] = 32;
                ++i;
            }
        }

        protected JCoSegment(IDoc.Document document, IDoc.SegmentMetaData segmentMetaData, boolean checkFieldValuesOnSet, byte[] sData, String sDataCharset) {
            super(8, segmentMetaData.getRecordMetaData());
            this.m_document = document;
            this.m_segmentMetaData = segmentMetaData;
            this.m_checkFieldValuesOnSet = checkFieldValuesOnSet;
            int numFields = this.getNumFields();
            if (sDataCharset != null && !sDataCharset.equals(JCoIDoc.access$801())) {
                SAPByteToCharConverter converter = SAPConverters.getSAPByteToCharConverter(sDataCharset);
                if (converter != null) {
                    char[] value = null;
                    int i = 0;
                    while (i < numFields) {
                        value = converter.convert(sData, this.getOffset(i), this.getOffset(i) + this.getInternalLength(i) - 1);
                        super.setValue(new String(value), i);
                        ++i;
                    }
                    return;
                }
                try {
                    String value = null;
                    int i = 0;
                    while (i < numFields) {
                        value = new String(sData, this.getOffset(i), this.getInternalLength(i), sDataCharset);
                        super.setValue(value, i);
                        ++i;
                    }
                    return;
                }
                catch (UnsupportedEncodingException ex) {
                    // empty catch block
                }
            }
            String value = null;
            int i = 0;
            while (i < numFields) {
                value = new String(sData, this.getOffset(i), this.getInternalLength(i));
                super.setValue(value, i);
                ++i;
            }
        }

        protected JCoSegment(IDoc.Document document, IDoc.SegmentMetaData segmentMetaData, boolean checkFieldValuesOnSet, String sData) {
            super(8, segmentMetaData.getRecordMetaData());
            this.m_document = document;
            this.m_segmentMetaData = segmentMetaData;
            this.m_checkFieldValuesOnSet = checkFieldValuesOnSet;
            char[] dataBuffer = this.getDataBuffer();
            int len = Math.min(sData.length(), dataBuffer.length);
            sData.getChars(0, len, dataBuffer, 0);
            int i = len;
            while (i < dataBuffer.length) {
                dataBuffer[i] = 32;
                ++i;
            }
        }

        public IDoc.Segment addChild(String segmentType) {
            return this.addChild(segmentType, true);
        }

        public IDoc.Segment addChild(String segmentType, boolean subsequent) {
            if (segmentType == null) {
                throw new NullPointerException("segmentType == null");
            }
            if (segmentType.length() == 0) {
                throw new IDoc.Exception(3, "Segment type \"\" is not a valid child segment type.");
            }
            JCoSegment child = null;
            IDoc.SegmentMetaData childMetaData = null;
            IDoc.Segment sibling = null;
            sibling = subsequent ? this.getLastChild(segmentType) : this.getFirstChild(segmentType);
            if (sibling != null) {
                childMetaData = sibling.getSegmentMetaData();
                if (childMetaData == null) {
                    throw new IDoc.Exception(2, "The meta data of the adjectant sibling segment is unavailable.");
                }
            } else {
                IDoc.SegmentMetaData myMetaData = this.getSegmentMetaData();
                if (myMetaData == null) {
                    throw new IDoc.Exception(2, "The meta data of this segment is unavailable.");
                }
                childMetaData = myMetaData.getChildByType(segmentType);
                int index = myMetaData.indexOfChild(childMetaData);
                while (sibling == null && index > 0) {
                    sibling = this.getLastChild(myMetaData.getChild(--index).getType());
                }
                subsequent = sibling != null;
            }
            if (childMetaData != null) {
                child = new JCoSegment(this.m_document, childMetaData, this.m_checkFieldValuesOnSet);
                if (sibling != null) {
                    if (subsequent) {
                        this.m_childs.addAfter(sibling, child);
                    } else {
                        this.m_childs.addBefore(sibling, child);
                    }
                } else if (subsequent) {
                    this.m_childs.add(child);
                } else {
                    this.m_childs.add(0, child);
                }
                child.m_parent = this;
                Int counter = (Int)this.m_childSegmentTypeCounters.get(segmentType);
                if (counter != null) {
                    counter.increment();
                } else {
                    this.m_childSegmentTypeCounters.put(segmentType, new Int(1));
                }
            } else {
                throw new IDoc.Exception(3, "Segment type \"" + segmentType + "\" is not a valid child segment type.");
            }
            return child;
        }

        protected void addChild(JCoSegment child) {
            this.m_childs.add(child);
            child.m_parent = this;
            child.m_document = this.m_document;
            String childSegmentType = child.getType();
            Int counter = (Int)this.m_childSegmentTypeCounters.get(childSegmentType);
            if (counter != null) {
                counter.increment();
            } else {
                this.m_childSegmentTypeCounters.put(childSegmentType, new Int(1));
            }
        }

        public IDoc.Segment addSibling() {
            return this.addSibling(true);
        }

        public IDoc.Segment addSibling(boolean subsequent) {
            if (this.m_parent == null) {
                throw new IDoc.Exception(4, "A root segment is not allowed to have sibling segments.");
            }
            IDoc.SegmentMetaData myMetaData = this.getSegmentMetaData();
            if (myMetaData == null) {
                throw new IDoc.Exception(2, "The meta data of this segment is unavailable.");
            }
            String mySegmentType = myMetaData.getType();
            JCoSegment sibling = new JCoSegment(this.m_document, myMetaData, this.m_checkFieldValuesOnSet);
            if (subsequent) {
                IDoc.Segment predecessor = this.m_parent.getLastChild(mySegmentType);
                this.m_parent.m_childs.addAfter(predecessor, sibling);
            } else {
                IDoc.Segment successor = this.m_parent.getFirstChild(mySegmentType);
                this.m_parent.m_childs.addBefore(successor, sibling);
            }
            sibling.m_parent = this.m_parent;
            Int counter = (Int)this.m_parent.m_childSegmentTypeCounters.get(mySegmentType);
            if (counter != null) {
                counter.increment();
            } else {
                this.m_parent.m_childSegmentTypeCounters.put(mySegmentType, new Int(1));
            }
            return sibling;
        }

        public IDoc.Segment addSibling(String segmentType) {
            if (this.m_parent == null) {
                throw new IDoc.Exception(4, "A root segment is not allowed to have sibling segments.");
            }
            if (segmentType == null) {
                throw new NullPointerException("segmentType == null");
            }
            if (segmentType.length() == 0) {
                throw new IDoc.Exception(3, "Segment type \"\" is not a valid sibling segment type.");
            }
            if (segmentType.equals(this.getType())) {
                return this.addSibling(true);
            }
            return this.m_parent.addChild(segmentType, true);
        }

        public IDoc.Segment addSibling(String segmentType, boolean subsequent) {
            if (this.m_parent == null) {
                throw new IDoc.Exception(4, "A root segment is not allowed to have sibling segments.");
            }
            if (segmentType == null) {
                throw new NullPointerException("segmentType == null");
            }
            if (segmentType.length() == 0) {
                throw new IDoc.Exception(3, "Segment type \"\" is not a valid sibling segment type.");
            }
            if (segmentType.equals(this.getType())) {
                return this.addSibling(subsequent);
            }
            return this.m_parent.addChild(segmentType, subsequent);
        }

        public void checkChildSegmentsOccurrenceLimits() {
            if (this.m_childs.size() == 0) {
                return;
            }
            IDoc.SegmentMetaData segmentMetaData = null;
            IDoc.SegmentMetaData lastSegmentMetaData = null;
            String segmentType = null;
            int numSegments = 0;
            IDoc.Segment[] childs = this.m_childs.toArray();
            int i = 0;
            while (i < childs.length) {
                segmentMetaData = childs[i].getSegmentMetaData();
                if (segmentMetaData != lastSegmentMetaData) {
                    segmentType = segmentMetaData.getType();
                    numSegments = this.getNumChildren(segmentType);
                    if ((long)numSegments < segmentMetaData.getMinOccurrence()) {
                        throw new IDoc.SyntaxException(childs[i], "Minimum number of segments not reached: " + segmentType);
                    }
                    if ((long)numSegments > segmentMetaData.getMaxOccurrence()) {
                        throw new IDoc.SyntaxException(childs[i], "Maximum number of segments exceeded: " + segmentType);
                    }
                    lastSegmentMetaData = segmentMetaData;
                }
                ++i;
            }
        }

        public void checkMandatoryChildSegments() {
            IDoc.SegmentMetaData mySegmentMetaData = this.getSegmentMetaData();
            if (mySegmentMetaData == null) {
                throw new IDoc.Exception(2, "Meta data for this segment is unavailable.");
            }
            if (mySegmentMetaData.getNumChildren() == 0) {
                return;
            }
            String segmentType = null;
            IDoc.SegmentMetaData[] childs = mySegmentMetaData.getChildren();
            int i = 0;
            while (i < childs.length) {
                if (childs[i].isMandatory() && this.getNumChildren(segmentType = childs[i].getType()) == 0) {
                    throw new IDoc.SyntaxException(this, "Missing mandatory segment: " + segmentType);
                }
                ++i;
            }
        }

        public void checkSyntax() {
            this.checkSyntax(524);
        }

        public void checkSyntax(int options) {
            if ((options & 0x200) != 0) {
                this.checkFieldValues();
            }
            if ((options & 4) != 0) {
                this.checkMandatoryChildSegments();
            }
            if ((options & 8) != 0) {
                this.checkChildSegmentsOccurrenceLimits();
            }
            if ((options & 0x10000) == 0) {
                int numChilds = this.m_childs.size();
                int i = 0;
                while (i < numChilds) {
                    this.m_childs.get(i).checkSyntax(options);
                    ++i;
                }
            }
        }

        protected void copyDataToCharArray(char[] dest, int destOffset, int destLength) {
            if (dest == null || destOffset < 0 || destOffset > dest.length || destLength <= 0) {
                return;
            }
            if (destOffset + destLength > dest.length) {
                destLength = dest.length - destOffset;
            }
            int destEndOffset = destOffset + destLength;
            char[] dataBuffer = this.getDataBuffer();
            int numChars = dataBuffer.length;
            if (numChars > destLength) {
                numChars = destLength;
            }
            System.arraycopy(dataBuffer, 0, dest, destOffset, numChars);
            destOffset += numChars;
            while (destOffset < destEndOffset) {
                dest[destOffset++] = 32;
            }
        }

        protected void copyDataToByteArray(char[] dest, int destOffset, int destLength, String charEncoding) {
            if (dest == null || destOffset < 0 || destOffset > dest.length || destLength <= 0) {
                return;
            }
            int destEndOffset = destOffset + destLength;
            if (destEndOffset >= dest.length) {
                destEndOffset = dest.length - 1;
            }
            SAPCharToByteConverter converter = null;
            String field = null;
            byte[] spaces = null;
            byte[] value = null;
            int metaLength = 0;
            int metaOffset = 0;
            int offset = 0;
            int destBytes = 0;
            int numBytes = 0;
            int b = 0;
            int v = 0;
            int s = 0;
            if (charEncoding != null && !charEncoding.equals(JCoIDoc.access$901())) {
                converter = SAPConverters.getSAPCharToByteConverter(charEncoding);
                if (converter != null) {
                    spaces = converter.convert(SPACE_CHARARRAY);
                } else {
                    try {
                        spaces = JCoIDoc.SPACE_STRING.getBytes(charEncoding);
                    }
                    catch (UnsupportedEncodingException ex) {
                        charEncoding = null;
                    }
                }
            }
            if (spaces == null) {
                spaces = JCoIDoc.SPACE_STRING.getBytes();
            }
            try {
                int numFields = this.getNumFields();
                int i = 0;
                while (i < numFields) {
                    field = this.getString(i);
                    metaLength = this.getInternalLength(i);
                    metaOffset = this.getOffset(i);
                    offset = destOffset + (metaOffset >> 1);
                    b = metaOffset & 1;
                    if (i + 1 < numFields) {
                        destBytes = this.getOffset(i + 1) - metaOffset;
                        if (offset + (b + destBytes + 1 >> 1) > destEndOffset) {
                            destBytes = (destEndOffset - offset << 1) - b;
                            i = numFields;
                        }
                    } else {
                        destBytes = (destEndOffset - offset << 1) - b;
                    }
                    if (field != null) {
                        value = converter != null ? converter.convert(field.toCharArray()) : (charEncoding == null ? field.getBytes() : field.getBytes(charEncoding));
                        numBytes = value.length;
                        if (metaLength > destBytes) {
                            metaLength = destBytes;
                        }
                        if (numBytes > metaLength) {
                            numBytes = metaLength;
                        }
                        v = 0;
                        while (v < numBytes) {
                            int n = offset + (b >> 1);
                            dest[n] = (char)(dest[n] | (char)((value[v] & 0xFF) << ((~b & 1) << 3)));
                            ++b;
                            ++v;
                        }
                    } else {
                        v = 0;
                    }
                    while (v < destBytes) {
                        s = 0;
                        while (v < destBytes && s < spaces.length) {
                            int n = offset + (b >> 1);
                            dest[n] = (char)(dest[n] | (char)((spaces[s] & 0xFF) << ((~b & 1) << 3)));
                            ++b;
                            ++s;
                            ++v;
                        }
                    }
                    ++i;
                }
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
                throw new InternalError();
            }
        }

        public void disableFieldValueChecking() {
            this.disableFieldValueChecking(true);
        }

        public void disableFieldValueChecking(boolean applyToChildren) {
            this.m_checkFieldValuesOnSet = false;
            if (applyToChildren) {
                int numChildren = this.m_childs.size();
                int i = 0;
                while (i < numChildren) {
                    this.m_childs.get(i).disableFieldValueChecking(true);
                    ++i;
                }
            }
        }

        public void enableFieldValueChecking() {
            this.enableFieldValueChecking(true);
        }

        public void enableFieldValueChecking(boolean applyToChildren) {
            this.m_checkFieldValuesOnSet = true;
            if (applyToChildren) {
                int numChildren = this.m_childs.size();
                int i = 0;
                while (i < numChildren) {
                    this.m_childs.get(i).enableFieldValueChecking(true);
                    ++i;
                }
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            return object instanceof JCoSegment;
        }

        public IDoc.Segment getChild(int index) {
            return this.m_childs.get(index);
        }

        public IDoc.Segment[] getChildren() {
            return this.m_childs.toArray();
        }

        public IDoc.Segment[] getChildren(String segmentType) {
            if (segmentType == null || this.m_childs.isEmpty()) {
                return new IDoc.Segment[0];
            }
            IDoc.SegmentList childs = new IDoc.SegmentList(this.m_childs.size());
            IDoc.Segment segment = this.getFirstChild(segmentType);
            if (segment != null) {
                do {
                    childs.add(segment);
                } while ((segment = segment.getNextSibling(segmentType)) != null);
            }
            return childs.toArray();
        }

        public IDoc.SegmentIterator getChildrenIterator() {
            return new IDoc.SegmentIterator(this, 5);
        }

        public IDoc.SegmentIterator getChildrenIterator(String segmentType) {
            return new IDoc.SegmentIterator(this, 5, segmentType);
        }

        public String getDefinition() {
            if (this.m_segmentMetaData == null) {
                return null;
            }
            return this.m_segmentMetaData.getDefinition();
        }

        public IDoc.SegmentIterator getDescendantsIterator() {
            return new IDoc.SegmentIterator(this, 6);
        }

        public String getDescription() {
            if (this.m_segmentMetaData == null) {
                return null;
            }
            return this.m_segmentMetaData.getDescription();
        }

        public IDoc.Document getDocument() {
            return this.m_document;
        }

        public IDoc.Segment getFirstChild() {
            return this.m_childs.first();
        }

        public IDoc.Segment getFirstChild(String segmentType) {
            if (segmentType == null || this.getNumChildren(segmentType) == 0) {
                return null;
            }
            IDoc.Segment segment = this.m_childs.first();
            while (segment != null && !segmentType.equals(segment.getType())) {
                segment = this.m_childs.getNext(segment);
            }
            return segment;
        }

        public IDoc.Segment getFirstChild(String segmentType, int fieldIndex, String fieldValue) {
            if (segmentType == null || this.getNumChildren(segmentType) == 0) {
                return null;
            }
            IDoc.Segment segment = this.m_childs.first();
            while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldIndex).equals(fieldValue))) {
                segment = this.m_childs.getNext(segment);
            }
            return segment;
        }

        public IDoc.Segment getFirstChild(String segmentType, String fieldName, String fieldValue) {
            if (segmentType == null || fieldName == null || this.getNumChildren(segmentType) == 0) {
                return null;
            }
            IDoc.Segment segment = this.m_childs.first();
            while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldName).equals(fieldValue))) {
                segment = this.m_childs.getNext(segment);
            }
            return segment;
        }

        public IDoc.Segment getFirstDescendant(String segmentType) {
            if (this.m_childs.isEmpty() || segmentType == null) {
                return null;
            }
            IDoc.Segment segment = this.getFirstChild(segmentType);
            if (segment == null) {
                IDoc.Segment descendant = null;
                IDoc.Segment child = this.m_childs.first();
                int childLevel = child.getHierarchyLevel();
                int segmentLevel = Integer.MAX_VALUE;
                while (child != null) {
                    descendant = child.getFirstDescendant(segmentType);
                    if (descendant != null && descendant.getHierarchyLevel() < segmentLevel && (segmentLevel = (segment = descendant).getHierarchyLevel()) - 1 <= childLevel) {
                        return segment;
                    }
                    child = this.m_childs.getNext(child);
                }
            }
            return segment;
        }

        public IDoc.Segment getFirstDescendant(String segmentType, int fieldIndex, String fieldValue) {
            if (this.m_childs.isEmpty() || segmentType == null) {
                return null;
            }
            IDoc.Segment segment = this.getFirstChild(segmentType, fieldIndex, fieldValue);
            if (segment == null) {
                IDoc.Segment descendant = null;
                IDoc.Segment child = this.m_childs.first();
                int childLevel = child.getHierarchyLevel();
                int segmentLevel = Integer.MAX_VALUE;
                while (child != null) {
                    descendant = child.getFirstDescendant(segmentType, fieldIndex, fieldValue);
                    if (descendant != null && descendant.getHierarchyLevel() < segmentLevel && (segmentLevel = (segment = descendant).getHierarchyLevel()) - 1 <= childLevel) {
                        return segment;
                    }
                    child = this.m_childs.getNext(child);
                }
            }
            return segment;
        }

        public IDoc.Segment getFirstDescendant(String segmentType, String fieldName, String fieldValue) {
            if (this.m_childs.isEmpty() || segmentType == null || fieldName == null) {
                return null;
            }
            IDoc.Segment segment = this.getFirstChild(segmentType, fieldName, fieldValue);
            if (segment == null) {
                IDoc.Segment descendant = null;
                IDoc.Segment child = this.m_childs.first();
                int childLevel = child.getHierarchyLevel();
                int segmentLevel = Integer.MAX_VALUE;
                while (child != null) {
                    descendant = child.getFirstDescendant(segmentType, fieldName, fieldValue);
                    if (descendant != null && descendant.getHierarchyLevel() < segmentLevel && (segmentLevel = (segment = descendant).getHierarchyLevel()) - 1 <= childLevel) {
                        return segment;
                    }
                    child = this.m_childs.getNext(child);
                }
            }
            return segment;
        }

        public int getHierarchyLevel() {
            if (this.m_segmentMetaData == null) {
                return -1;
            }
            return this.m_segmentMetaData.getHierarchyLevel();
        }

        public IDoc.Segment getLastChild() {
            return this.m_childs.last();
        }

        public IDoc.Segment getLastChild(String segmentType) {
            if (segmentType == null || this.getNumChildren(segmentType) == 0) {
                return null;
            }
            IDoc.Segment segment = this.m_childs.last();
            while (segment != null && !segmentType.equals(segment.getType())) {
                segment = this.m_childs.getPrevious(segment);
            }
            return segment;
        }

        public IDoc.Segment getLastChild(String segmentType, int fieldIndex, String fieldValue) {
            if (segmentType == null || this.getNumChildren(segmentType) == 0) {
                return null;
            }
            IDoc.Segment segment = this.m_childs.last();
            while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldIndex).equals(fieldValue))) {
                segment = this.m_childs.getPrevious(segment);
            }
            return segment;
        }

        public IDoc.Segment getLastChild(String segmentType, String fieldName, String fieldValue) {
            if (segmentType == null || fieldName == null || this.getNumChildren(segmentType) == 0) {
                return null;
            }
            IDoc.Segment segment = this.m_childs.last();
            while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldName).equals(fieldValue))) {
                segment = this.m_childs.getPrevious(segment);
            }
            return segment;
        }

        public IDoc.Segment getNext() {
            IDoc.Segment segment = null;
            if (this.m_childs.isEmpty()) {
                JCoSegment parent = this;
                do {
                    segment = parent.getNextSibling();
                    parent = parent.m_parent;
                } while (segment == null && parent != null);
            } else {
                segment = this.m_childs.first();
            }
            return segment;
        }

        public IDoc.Segment getNext(String segmentType) {
            if (segmentType == null) {
                return null;
            }
            IDoc.Segment segment = this.getNext();
            while (segment != null && !segmentType.equals(segment.getType())) {
                segment = segment.getNext();
            }
            return segment;
        }

        public IDoc.Segment getNext(String segmentType, int fieldIndex, String fieldValue) {
            if (segmentType == null) {
                return null;
            }
            IDoc.Segment segment = this.getNext();
            while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldIndex).equals(fieldValue))) {
                segment = segment.getNext();
            }
            return segment;
        }

        public IDoc.Segment getNext(String segmentType, String fieldName, String fieldValue) {
            if (segmentType == null || fieldName == null) {
                return null;
            }
            IDoc.Segment segment = this.getNext();
            while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldName).equals(fieldValue))) {
                segment = segment.getNext();
            }
            return segment;
        }

        public IDoc.Segment getNextDescendant(String segmentType) {
            if (segmentType == null || this.m_childs.isEmpty()) {
                return null;
            }
            IDoc.Segment segment = this.m_childs.first();
            int myLevel = this.getHierarchyLevel();
            while (segment != null && !segmentType.equals(segment.getType())) {
                if ((segment = segment.getNext()) == null || segment.getHierarchyLevel() > myLevel) continue;
                return null;
            }
            return segment;
        }

        public IDoc.Segment getNextDescendant(String segmentType, int fieldIndex, String fieldValue) {
            if (segmentType == null || this.m_childs.isEmpty()) {
                return null;
            }
            IDoc.Segment segment = this.m_childs.first();
            int myLevel = this.getHierarchyLevel();
            while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldIndex).equals(fieldValue))) {
                if ((segment = segment.getNext()) == null || segment.getHierarchyLevel() > myLevel) continue;
                return null;
            }
            return segment;
        }

        public IDoc.Segment getNextDescendant(String segmentType, String fieldName, String fieldValue) {
            if (segmentType == null || fieldName == null || this.m_childs.isEmpty()) {
                return null;
            }
            IDoc.Segment segment = this.m_childs.first();
            int myLevel = this.getHierarchyLevel();
            while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldName).equals(fieldValue))) {
                if ((segment = segment.getNext()) == null || segment.getHierarchyLevel() > myLevel) continue;
                return null;
            }
            return segment;
        }

        public IDoc.Segment getNextSibling() {
            if (this.m_parent == null) {
                return null;
            }
            return this.m_parent.m_childs.getNext(this);
        }

        public IDoc.Segment getNextSibling(String segmentType) {
            if (segmentType == null) {
                return null;
            }
            IDoc.Segment segment = this.getNextSibling();
            while (segment != null && !segmentType.equals(segment.getType())) {
                segment = segment.getNextSibling();
            }
            return segment;
        }

        public IDoc.Segment getNextSibling(String segmentType, int fieldIndex, String fieldValue) {
            if (segmentType == null) {
                return null;
            }
            IDoc.Segment segment = this.getNextSibling();
            while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldIndex).equals(fieldValue))) {
                segment = segment.getNextSibling();
            }
            return segment;
        }

        public IDoc.Segment getNextSibling(String segmentType, String fieldName, String fieldValue) {
            if (segmentType == null || fieldName == null) {
                return null;
            }
            IDoc.Segment segment = this.getNextSibling();
            while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldName).equals(fieldValue))) {
                segment = segment.getNextSibling();
            }
            return segment;
        }

        public int getNumChildren() {
            return this.m_childs.size();
        }

        public int getNumChildren(String segmentType) {
            if (segmentType == null) {
                return 0;
            }
            Int counter = (Int)this.m_childSegmentTypeCounters.get(segmentType);
            if (counter != null) {
                return counter.value();
            }
            return 0;
        }

        public int getNumDescendants() {
            int numDescendants = this.m_childs.size();
            if (numDescendants > 0) {
                IDoc.Segment[] childs = this.m_childs.toArray();
                int i = 0;
                while (i < childs.length) {
                    numDescendants += childs[i].getNumDescendants();
                    ++i;
                }
            }
            return numDescendants;
        }

        public int getNumDescendants(String segmentType) {
            int numDescendants = 0;
            if (this.m_childs.size() > 0) {
                numDescendants = this.getNumChildren(segmentType);
                IDoc.Segment[] childs = this.m_childs.toArray();
                int i = 0;
                while (i < childs.length) {
                    numDescendants += childs[i].getNumDescendants(segmentType);
                    ++i;
                }
            }
            return numDescendants;
        }

        public IDoc.Segment getParent() {
            return this.m_parent;
        }

        /*
         * Unable to fully structure code
         */
        public IDoc.Segment getPrevious() {
            block1: {
                segment = this.getPreviousSibling();
                if (segment != null) ** GOTO lbl6
                segment = this.m_parent;
                break block1;
lbl-1000:
                // 1 sources

                {
                    segment = segment.getLastChild();
lbl6:
                    // 2 sources

                    ** while (segment.getNumChildren() > 0)
                }
            }
            return segment;
        }

        public IDoc.Segment getPrevious(String segmentType) {
            if (segmentType == null) {
                return null;
            }
            IDoc.Segment segment = this.getPrevious();
            while (segment != null && !segmentType.equals(segment.getType())) {
                segment = segment.getPrevious();
            }
            return segment;
        }

        public IDoc.Segment getPrevious(String segmentType, int fieldIndex, String fieldValue) {
            if (segmentType == null) {
                return null;
            }
            IDoc.Segment segment = this.getPrevious();
            while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldIndex).equals(fieldValue))) {
                segment = segment.getPrevious();
            }
            return segment;
        }

        public IDoc.Segment getPrevious(String segmentType, String fieldName, String fieldValue) {
            if (segmentType == null || fieldName == null) {
                return null;
            }
            IDoc.Segment segment = this.getPrevious();
            while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldName).equals(fieldValue))) {
                segment = segment.getPrevious();
            }
            return segment;
        }

        public IDoc.Segment getPreviousSibling() {
            if (this.m_parent == null) {
                return null;
            }
            return this.m_parent.m_childs.getPrevious(this);
        }

        public IDoc.Segment getPreviousSibling(String segmentType) {
            if (segmentType == null) {
                return null;
            }
            IDoc.Segment segment = this.getPreviousSibling();
            while (segment != null && !segmentType.equals(segment.getType())) {
                segment = segment.getPreviousSibling();
            }
            return segment;
        }

        public IDoc.Segment getPreviousSibling(String segmentType, int fieldIndex, String fieldValue) {
            if (segmentType == null) {
                return null;
            }
            IDoc.Segment segment = this.getPreviousSibling();
            while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldIndex).equals(fieldValue))) {
                segment = segment.getPreviousSibling();
            }
            return segment;
        }

        public IDoc.Segment getPreviousSibling(String segmentType, String fieldName, String fieldValue) {
            if (segmentType == null || fieldName == null) {
                return null;
            }
            IDoc.Segment segment = this.getPreviousSibling();
            while (!(segment == null || segmentType.equals(segment.getType()) && segment.getString(fieldName).equals(fieldValue))) {
                segment = segment.getPreviousSibling();
            }
            return segment;
        }

        public IDoc.SegmentMetaData getSegmentMetaData() {
            if (this.m_segmentMetaData == null) {
                IDoc.Segment rootSegment;
                IDoc.SegmentMetaData parentSegmentMetaData = null;
                if (this.m_parent != null) {
                    parentSegmentMetaData = this.m_parent.getSegmentMetaData();
                } else if (this.m_document != null && (rootSegment = this.m_document.getRootSegment()) != this) {
                    parentSegmentMetaData = rootSegment.getSegmentMetaData();
                }
                if (parentSegmentMetaData != null) {
                    this.m_segmentMetaData = parentSegmentMetaData.getChildByDefinition(this.getName());
                }
            }
            return this.m_segmentMetaData;
        }

        public String getType() {
            if (this.m_segmentMetaData == null) {
                return null;
            }
            return this.m_segmentMetaData.getType();
        }

        public int hashCode() {
            String recName = this.getName();
            if (recName == null) {
                return 0;
            }
            return recName.hashCode();
        }

        public boolean isLeaf() {
            return this.m_childs.isEmpty();
        }

        public boolean isParent() {
            return !this.m_childs.isEmpty();
        }

        public boolean isRoot() {
            return this.m_parent == null;
        }

        protected void printHTML(PrintWriter os) {
            if (this.m_segmentMetaData != null) {
                JCoSegmentMetaData.printHTML(this.m_segmentMetaData, os);
            }
            this.printHTML(os, (String)null, 0, JCO.MetaData.PRINT_HEADER_NAME | JCO.MetaData.PRINT_HEADER_TYPE | JCO.MetaData.PRINT_HEADER_LENGTH);
        }

        public boolean remove() {
            if (this.m_parent != null) {
                return this.m_parent.removeChild(this);
            }
            return false;
        }

        public boolean removeChild(IDoc.Segment child) {
            if (child == null || this.m_childs == null) {
                return false;
            }
            boolean removed = this.m_childs.remove(child);
            if (removed) {
                Int counter = (Int)this.m_childSegmentTypeCounters.get(child.getType());
                if (counter != null) {
                    counter.decrement();
                }
                if (child instanceof JCoSegment) {
                    ((JCoSegment)child).m_parent = null;
                    ((JCoSegment)child).removeFromDocument();
                }
            }
            return removed;
        }

        protected void removeFromDocument() {
            this.m_document = null;
            IDoc.Segment[] childs = this.m_childs.toArray();
            int i = 0;
            while (i < childs.length) {
                if (childs[i] instanceof JCoSegment) {
                    ((JCoSegment)childs[i]).removeFromDocument();
                }
                ++i;
            }
        }

        public String toString() {
            StringBuffer strBuf = new StringBuffer(1000);
            strBuf.append("Name = ");
            strBuf.append(this.getName());
            strBuf.append("\nType = ");
            strBuf.append(this.getType());
            strBuf.append("\nHierarchy Level = ");
            strBuf.append(this.getHierarchyLevel());
            strBuf.append("\nDefinition = ");
            strBuf.append(this.getDefinition());
            strBuf.append("\nDescription = ");
            strBuf.append(this.getDescription());
            strBuf.append('\n');
            strBuf.append(super.toString());
            return strBuf.toString();
        }
    }

    public static class JCoRecordMetaData
    extends JCO.MetaData
    implements IDoc.RecordMetaData,
    Serializable {
        private static final long serialVersionUID = 1000L;

        protected JCoRecordMetaData(String segmentName) {
            super(segmentName);
        }

        public void addInfo(String name, int type, int length, int offset, int decimals, String sdefault, String description, int flags, Object tab_meta, IExtendedFieldMetaData extended) {
            super.addInfo(name, type, length, offset, decimals, sdefault, description, flags, tab_meta, extended);
            this.setDataBufferOffset(this.getNumFields() - 1, this.getOffset(this.getNumFields() - 1));
        }

        public IDoc.FieldMetaData getFieldMetaData(int index) {
            return (IDoc.FieldMetaData)((Object)this.getExtendedFieldMetaData(index));
        }

        public IDoc.FieldMetaData getFieldMetaData(String name) {
            return (IDoc.FieldMetaData)((Object)this.getExtendedFieldMetaData(name));
        }

        public int getLength() {
            return this.getTabLength();
        }

        protected void setName(String segmentName) {
            super.setName(segmentName);
        }
    }

    public static class JCoRecord
    extends JCO.Structure
    implements IDoc.Record,
    IDoc.RecordMetaData,
    Serializable {
        protected boolean m_checkFieldValuesOnSet = false;

        public JCoRecord(IMetaData metaData) {
            super(metaData);
        }

        protected JCoRecord(int recordType, IMetaData metaData) {
            super(recordType, metaData);
        }

        public JCoRecord(IDoc.RecordMetaData recordMetaData) {
            super((IMetaData)((Object)recordMetaData));
        }

        protected JCoRecord(int recordType, IDoc.RecordMetaData recordMetaData) {
            super(recordType, (IMetaData)((Object)recordMetaData));
        }

        protected JCoRecord(JCO.Table value) {
            super(value);
        }

        protected JCoRecord(JCO.Table value, int row) {
            super(value, row);
        }

        public void checkFieldValue(int index) {
            IDoc.FieldMetaData segmentFieldMetaData;
            if (index < 0) {
                throw new IndexOutOfBoundsException("index < 0 [" + index + "<0]");
            }
            if (index >= this.getNumFields()) {
                throw new IndexOutOfBoundsException("index >= getNumFields() [" + index + ">=" + this.getNumFields() + "]");
            }
            if (this.isInitialized(index) && (segmentFieldMetaData = (IDoc.FieldMetaData)((Object)this.getExtendedFieldMetaData(index))) != null && !segmentFieldMetaData.isValidValue(this.getString(index), true)) {
                throw new IDoc.SyntaxException(this, this.getName(index), "Invalid value for segment field: " + this.getName(index));
            }
        }

        public void checkFieldValues() {
            IDoc.FieldMetaData segmentFieldMetaData = null;
            int numFields = this.getNumFields();
            int i = 0;
            while (i < numFields) {
                if (this.isInitialized(i) && (segmentFieldMetaData = (IDoc.FieldMetaData)((Object)this.getExtendedFieldMetaData(i))) != null && !segmentFieldMetaData.isValidValue(this.getString(i), true)) {
                    throw new IDoc.SyntaxException(this, this.getName(i), "Invalid value for segment field: " + this.getName(i));
                }
                ++i;
            }
        }

        public void disableFieldValueChecking() {
            this.m_checkFieldValuesOnSet = false;
        }

        public void enableFieldValueChecking() {
            this.m_checkFieldValuesOnSet = true;
        }

        public IDoc.FieldMetaData getFieldMetaData(int index) {
            return (IDoc.FieldMetaData)((Object)this.getExtendedFieldMetaData(index));
        }

        public IDoc.FieldMetaData getFieldMetaData(String name) {
            return (IDoc.FieldMetaData)((Object)this.getExtendedFieldMetaData(name));
        }

        public int getLength() {
            return this.getTabLength();
        }

        public String getName(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index < 0 [" + index + "<0]");
            }
            if (index >= this.getNumFields()) {
                throw new IndexOutOfBoundsException("index >= getNumFields() [" + index + ">=" + this.getNumFields() + "]");
            }
            return super.getName(index);
        }

        public Object getValue(int index) {
            IDoc.FieldMetaData.Datatype fieldDatatype;
            if (index < 0) {
                throw new IndexOutOfBoundsException("index < 0 [" + index + "<0]");
            }
            if (index >= this.getNumFields()) {
                throw new IndexOutOfBoundsException("index >= getNumFields() [" + index + ">=" + this.getNumFields() + "]");
            }
            IDoc.FieldMetaData fieldMetaData = this.getFieldMetaData(index);
            if (fieldMetaData != null && (fieldDatatype = fieldMetaData.getDatatype()) != null) {
                if (fieldDatatype == IDoc.FieldMetaData.Datatype.STRING) {
                    return this.getString(index);
                }
                if (fieldDatatype == IDoc.FieldMetaData.Datatype.NUMERIC) {
                    return this.getString(index);
                }
                if (fieldDatatype == IDoc.FieldMetaData.Datatype.INTEGER) {
                    return this.getBigInteger(index);
                }
                if (fieldDatatype == IDoc.FieldMetaData.Datatype.DECIMAL) {
                    return this.getBigDecimal(index);
                }
                if (fieldDatatype == IDoc.FieldMetaData.Datatype.DATE) {
                    return this.getDate(index);
                }
                if (fieldDatatype == IDoc.FieldMetaData.Datatype.TIME) {
                    return this.getTime(index);
                }
                if (fieldDatatype == IDoc.FieldMetaData.Datatype.BINARY) {
                    return this.getByteArray(index);
                }
            }
            return this.getString(index);
        }

        public IDoc.RecordMetaData getRecordMetaData() {
            return this;
        }

        public boolean isFieldValueCheckingEnabled() {
            return this.m_checkFieldValuesOnSet;
        }

        public void setField(int index, byte[] value) {
            super.setValue(value, index);
            if (this.m_checkFieldValuesOnSet) {
                this.checkFieldValue(index);
            }
        }

        public void setField(int index, char value) {
            super.setValue(value, index);
            if (this.m_checkFieldValuesOnSet) {
                this.checkFieldValue(index);
            }
        }

        public void setField(int index, double value) {
            super.setValue(value, index);
            if (this.m_checkFieldValuesOnSet) {
                this.checkFieldValue(index);
            }
        }

        public void setField(int index, int value) {
            super.setValue(value, index);
            if (this.m_checkFieldValuesOnSet) {
                this.checkFieldValue(index);
            }
        }

        public void setField(int index, long value) {
            super.setValue(value, index);
            if (this.m_checkFieldValuesOnSet) {
                this.checkFieldValue(index);
            }
        }

        public void setField(int index, Object value) {
            super.setValue(value, index);
            if (this.m_checkFieldValuesOnSet) {
                this.checkFieldValue(index);
            }
        }

        public void setField(int index, short value) {
            super.setValue(value, index);
            if (this.m_checkFieldValuesOnSet) {
                this.checkFieldValue(index);
            }
        }

        public void setField(int index, String value) {
            super.setValue(value, index);
            if (this.m_checkFieldValuesOnSet) {
                this.checkFieldValue(index);
            }
        }

        public void setField(String name, byte[] value) {
            this.setField(this.indexOf(name), value);
        }

        public void setField(String name, char value) {
            this.setField(this.indexOf(name), value);
        }

        public void setField(String name, double value) {
            this.setField(this.indexOf(name), value);
        }

        public void setField(String name, int value) {
            this.setField(this.indexOf(name), value);
        }

        public void setField(String name, long value) {
            this.setField(this.indexOf(name), value);
        }

        public void setField(String name, Object value) {
            this.setField(this.indexOf(name), value);
        }

        public void setField(String name, short value) {
            this.setField(this.indexOf(name), value);
        }

        public void setField(String name, String value) {
            this.setField(this.indexOf(name), value);
        }

        public void setValue(byte[] value, int index) {
            super.setValue(value, index);
            if (this.m_checkFieldValuesOnSet) {
                this.checkFieldValue(index);
            }
        }

        public void setValue(char value, int index) {
            super.setValue(value, index);
            if (this.m_checkFieldValuesOnSet) {
                this.checkFieldValue(index);
            }
        }

        public void setValue(double value, int index) {
            super.setValue(value, index);
            if (this.m_checkFieldValuesOnSet) {
                this.checkFieldValue(index);
            }
        }

        public void setValue(int value, int index) {
            super.setValue(value, index);
            if (this.m_checkFieldValuesOnSet) {
                this.checkFieldValue(index);
            }
        }

        public void setValue(long value, int index) {
            super.setValue(value, index);
            if (this.m_checkFieldValuesOnSet) {
                this.checkFieldValue(index);
            }
        }

        public void setValue(Object value, int index) {
            super.setValue(value, index);
            if (this.m_checkFieldValuesOnSet) {
                this.checkFieldValue(index);
            }
        }

        public void setValue(short value, int index) {
            super.setValue(value, index);
            if (this.m_checkFieldValuesOnSet) {
                this.checkFieldValue(index);
            }
        }

        public void setValue(String value, int index) {
            super.setValue(value, index);
            if (this.m_checkFieldValuesOnSet) {
                this.checkFieldValue(index);
            }
        }

        public void setValue(JCO.Structure value, int index) {
            super.setValue(value, index);
            if (this.m_checkFieldValuesOnSet) {
                this.checkFieldValue(index);
            }
        }

        public void setValue(JCO.Table value, int index) {
            super.setValue(value, index);
            if (this.m_checkFieldValuesOnSet) {
                this.checkFieldValue(index);
            }
        }

        public String toXML() {
            throw new UnsupportedOperationException("IDoc.Record.toXML()");
        }

        public String toXML(int index) {
            throw new UnsupportedOperationException("IDoc.Record.toXML(int)");
        }

        public String toXML(String release) {
            throw new UnsupportedOperationException("IDoc.Record.toXML(String)");
        }

        public void writeHTML(String filename) {
            throw new UnsupportedOperationException("IDoc.Record.writeHTML(String)");
        }

        public void writeHTML(Writer writer) {
            throw new UnsupportedOperationException("IDoc.Record.writeHTML(Writer)");
        }

        public void writeXML(String filename) {
            throw new UnsupportedOperationException("IDoc.Record.writeXML(String)");
        }

        public void writeXML(Writer writer) {
            throw new UnsupportedOperationException("IDoc.Record.writeXML(Writer)");
        }

        public void writeXML(Writer writer, boolean withHeader) {
            throw new UnsupportedOperationException("IDoc.Record.writeXML(Writer, boolean)");
        }

        public void writeXML(Writer writer, String namespaceURN, boolean withHeader) {
            throw new UnsupportedOperationException("IDoc.Record.writeXML(Writer, String, boolean)");
        }

        protected static class XMLWriter
        extends JCO.Record.XMLWriter {
            private static final String IDOC_TAG = "IDOC";
            private static final String[] IDOC_ATTRIBS = new String[]{"BEGIN=\"1\""};
            private static final String[] CONTROL_ATTRIBS = new String[]{"SEGMENT=\"1\""};
            private static final String[] SEGMENT_ATTRIBS = new String[]{"SEGMENT=\"1\""};

            public XMLWriter() {
                this.setEscapeMode((byte)3);
            }

            public XMLWriter(Writer writer) {
                super(writer);
                this.setEscapeMode((byte)3);
            }

            public static String createXMLDocument(JCoDocument document, String release) {
                XMLWriter xmlWriter = new XMLWriter();
                if (release != null) {
                    xmlWriter.setEscapeMode(release);
                }
                try {
                    xmlWriter.encode(document);
                }
                catch (IOException ex) {
                    throw new JCO.ConversionException(ex.getMessage());
                }
                return xmlWriter.toString();
            }

            public static String createXMLDocument(IDoc.DocumentList documentList, String release) {
                XMLWriter xmlWriter = new XMLWriter();
                if (release != null) {
                    xmlWriter.setEscapeMode(release);
                }
                try {
                    xmlWriter.encode(documentList);
                }
                catch (IOException ex) {
                    throw new JCO.ConversionException(ex.getMessage());
                }
                return xmlWriter.toString();
            }

            public static String createXMLDocument(JCoSegment segment, String release) {
                XMLWriter xmlWriter = new XMLWriter();
                if (release != null) {
                    xmlWriter.setEscapeMode(release);
                }
                try {
                    xmlWriter.encode(segment);
                }
                catch (IOException ex) {
                    throw new JCO.ConversionException(ex.getMessage());
                }
                return xmlWriter.toString();
            }

            public XMLWriter encode(JCoDocument document) throws IOException {
                String custType = document.getIDocTypeExtension();
                String iDocType = this.escape(custType != null && custType.length() > 0 ? custType : document.getIDocType());
                this.stag(iDocType);
                this.encodeDocument(document);
                this.etag(iDocType);
                return this;
            }

            public XMLWriter encode(IDoc.DocumentList documentList) throws IOException {
                int numDocuments = documentList.getNumDocuments();
                if (numDocuments > 0) {
                    String iDocType;
                    JCoDocument document = (JCoDocument)documentList.get(0);
                    String custType = document.getIDocTypeExtension();
                    String lastIDocType = iDocType = this.escape(custType != null && custType.length() > 0 ? custType : document.getIDocType());
                    this.stag(iDocType);
                    this.encodeDocument(document);
                    int i = 1;
                    while (i < numDocuments) {
                        document = (JCoDocument)documentList.get(i);
                        custType = document.getIDocTypeExtension();
                        iDocType = this.escape(custType != null && custType.length() > 0 ? custType : document.getIDocType());
                        if (!iDocType.equals(lastIDocType)) {
                            throw new IDoc.Exception(4, "The document list is incompatible to the IDoc XML format: it may not contain different IDoc types.");
                        }
                        this.encodeDocument(document);
                        ++i;
                    }
                    this.etag(lastIDocType);
                }
                return this;
            }

            public XMLWriter encode(JCoSegment segment) throws IOException {
                String segmentType = this.escape(segment.getType());
                this.stag(segmentType, SEGMENT_ATTRIBS);
                this.encode(segment, null);
                int numChildren = segment.getNumChildren();
                int i = 0;
                while (i < numChildren) {
                    this.encode((JCoSegment)segment.getChild(i));
                    ++i;
                }
                this.etag(segmentType);
                return this;
            }

            private XMLWriter encodeDocument(JCoDocument document) throws IOException {
                this.stag(IDOC_TAG, IDOC_ATTRIBS);
                String controlStructName = this.escape(document.getName());
                this.stag(controlStructName, CONTROL_ATTRIBS);
                this.encode(document, null);
                this.etag(controlStructName);
                IDoc.Segment rootSegment = document.getRootSegment();
                if (rootSegment != null) {
                    int numChildren = rootSegment.getNumChildren();
                    int i = 0;
                    while (i < numChildren) {
                        this.encode((JCoSegment)rootSegment.getChild(i));
                        ++i;
                    }
                }
                this.etag(IDOC_TAG);
                return this;
            }

            public void setEscapeMode(String release) {
                if (release == null || release.length() == 0 || release.compareTo("5") >= 0) {
                    this.setEscapeMode((byte)3);
                } else {
                    this.setEscapeMode((byte)2);
                }
            }
        }
    }

    private static class JCoStaticRepository610UC
    extends JCO.BasicRepository
    implements IRepository {
        protected JCoStaticRepository610UC() {
            this("JCoIDoc.JCoStaticRepository for SAP Release 6.10 Unicode");
        }

        protected JCoStaticRepository610UC(String name) {
            super(name);
            this.add_IDOC_INBOUND_ASYNCHRONOUS();
            this.add_IDOCTYPE_READ_COMPLETE();
            this.add_INBOUND_IDOC_PROCESS();
            this.add_RFC_READ_TABLE();
        }

        protected void add_IDOC_INBOUND_ASYNCHRONOUS() {
            JCO.MetaData meta = new JCO.MetaData("IDOC_INBOUND_ASYNCHRONOUS");
            meta.addInfo("IDOC_CONTROL_REC_40", 99, 19, 19, 0, 0, null, null, 0, "EDI_DC40", null);
            meta.addInfo("IDOC_DATA_REC_40", 99, 16, 16, 19, 0, null, null, 0, "EDI_DD40", null);
            this.addFunctionInterfaceToCache(meta);
            meta = new JCO.MetaData("EDI_DC40");
            JCoFieldMetaData fieldMeta = new JCoFieldMetaData("TABNAM", 10, 10, "CHAR", "EDI4TABNAM", "EDI_TABNAM", "Name of table structure", null, false);
            meta.addInfo("TABNAM", 0, 10, 20, 0, 0, null, "Name of table structure", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MANDT", 3, 3, "CLNT", "EDI4MANDT", "MANDT", "Client", "T000", false);
            meta.addInfo("MANDT", 0, 3, 6, 20, 0, null, "Client", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("DOCNUM", 16, 16, "CHAR", "EDI4DOCNUC", "EDI_CHAR16", "IDoc number", null, false);
            meta.addInfo("DOCNUM", 0, 16, 32, 26, 0, null, "IDoc number", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("DOCREL", 4, 4, "CHAR", "EDI4DOCREL", "SAPRL", "SAP Release for IDoc", null, false);
            meta.addInfo("DOCREL", 0, 4, 8, 58, 0, null, "SAP Release for IDoc", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STATUS", 2, 2, "CHAR", "EDI4STATUS", "EDI_STATUS", "Status of IDoc", "TEDS1", false);
            meta.addInfo("STATUS", 0, 2, 4, 66, 0, null, "Status of IDoc", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("DIRECT", 1, 1, "CHAR", "EDI4DIRECT", "EDI_DIRECT", "Direction", null, false);
            meta.addInfo("DIRECT", 0, 1, 2, 70, 0, null, "Direction", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("OUTMOD", 1, 1, "CHAR", "EDI4OUTMOD", "EDI_OUTMOD", "Output mode", null, false);
            meta.addInfo("OUTMOD", 0, 1, 2, 72, 0, null, "Output mode", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("EXPRSS", 1, 1, "CHAR", "EDI4EXPRSS", "EDI_EXPRSS", "Overriding in inbound processing", null, false);
            meta.addInfo("EXPRSS", 0, 1, 2, 74, 0, null, "Overriding in inbound processing", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("TEST", 1, 1, "CHAR", "EDI4TEST", "EDI_TEST", "Test flag", null, false);
            meta.addInfo("TEST", 0, 1, 2, 76, 0, null, "Test flag", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("IDOCTYP", 30, 30, "CHAR", "EDI4IDOCTP", "EDI_IDOCTP", "Name of basic type", "EDBAS", false);
            meta.addInfo("IDOCTYP", 0, 30, 60, 78, 0, null, "Name of basic type", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("CIMTYP", 30, 30, "CHAR", "EDI4CIMTYP", "EDI_CIMTYP", "Extension (defined by customer)", "EDCIM", false);
            meta.addInfo("CIMTYP", 0, 30, 60, 138, 0, null, "Extension (defined by customer)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MESTYP", 30, 30, "CHAR", "EDI4MESTYP", "EDI_MESTYP", "Message type", "EDMSG", false);
            meta.addInfo("MESTYP", 0, 30, 60, 198, 0, null, "Message type", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MESCOD", 3, 3, "CHAR", "EDI4MESCOD", "EDI_MESCOD", "Message code", null, false);
            meta.addInfo("MESCOD", 0, 3, 6, 258, 0, null, "Message code", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MESFCT", 3, 3, "CHAR", "EDI4MESFCT", "EDI_MESFCT", "Message function", null, false);
            meta.addInfo("MESFCT", 0, 3, 6, 264, 0, null, "Message function", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STD", 1, 1, "CHAR", "EDI4STD", "EDI_STD", "EDI standard, flag", null, false);
            meta.addInfo("STD", 0, 1, 2, 270, 0, null, "EDI standard, flag", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STDVRS", 6, 6, "CHAR", "EDI4STDVRS", "EDI_STDVRS", "EDI standard, version and release", null, false);
            meta.addInfo("STDVRS", 0, 6, 12, 272, 0, null, "EDI standard, version and release", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STDMES", 6, 6, "CHAR", "EDI4STDMES", "EDI_STDMES", "EDI message type", null, false);
            meta.addInfo("STDMES", 0, 6, 12, 284, 0, null, "EDI message type", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPOR", 10, 10, "CHAR", "EDI4SNDPOR", "EDI_PORT", "Sender port (SAP System, external subsystem)", null, false);
            meta.addInfo("SNDPOR", 0, 10, 20, 296, 0, null, "Sender port (SAP System, external subsystem)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPRT", 2, 2, "CHAR", "EDI4SNDPRT", "EDI_PARTYP", "Partner type of sender", null, false);
            meta.addInfo("SNDPRT", 0, 2, 4, 316, 0, null, "Partner type of sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPFC", 2, 2, "CHAR", "EDI4SNDPFC", "EDI_PARVW", "Partner Function of Sender", null, false);
            meta.addInfo("SNDPFC", 0, 2, 4, 320, 0, null, "Partner Function of Sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPRN", 10, 10, "CHAR", "EDI4SNDPRN", "EDI_PARNUM", "Partner number of sender", null, false);
            meta.addInfo("SNDPRN", 0, 10, 20, 324, 0, null, "Partner number of sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDSAD", 21, 21, "CHAR", "EDI4SNDSAD", "CHAR21", "Sender address (SADR)", null, false);
            meta.addInfo("SNDSAD", 0, 21, 42, 344, 0, null, "Sender address (SADR)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDLAD", 70, 70, "CHAR", "EDI4SNDLAD", "EDI_LOGADR", "Logical address of sender", null, false);
            meta.addInfo("SNDLAD", 0, 70, 140, 386, 0, null, "Logical address of sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPOR", 10, 10, "CHAR", "EDI4RCVPOR", "EDI_PORT", "Receiver port", null, false);
            meta.addInfo("RCVPOR", 0, 10, 20, 526, 0, null, "Receiver port", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPRT", 2, 2, "CHAR", "EDI4RCVPRT", "EDI_PARTYP", "Partner type of recipient", null, false);
            meta.addInfo("RCVPRT", 0, 2, 4, 546, 0, null, "Partner type of recipient", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPFC", 2, 2, "CHAR", "EDI4RCVPFC", "EDI_PARVW", "Partner function of recipient", null, false);
            meta.addInfo("RCVPFC", 0, 2, 4, 550, 0, null, "Partner function of recipient", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPRN", 10, 10, "CHAR", "EDI4RCVPRN", "EDI_PARNUM", "Partner number of recipient", null, false);
            meta.addInfo("RCVPRN", 0, 10, 20, 554, 0, null, "Partner number of recipient", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVSAD", 21, 21, "CHAR", "EDI4RCVSAD", "CHAR21", "Recipient address (SADR)", null, false);
            meta.addInfo("RCVSAD", 0, 21, 42, 574, 0, null, "Recipient address (SADR)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVLAD", 70, 70, "CHAR", "EDI4RCVLAD", "EDI_LOGADR", "Logical address of recipient", null, false);
            meta.addInfo("RCVLAD", 0, 70, 140, 616, 0, null, "Logical address of recipient", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("CREDAT", 8, 8, "DATS", "EDI4CREDAT", "DATUM", "Created on", null, false);
            meta.addInfo("CREDAT", 1, 8, 16, 756, 0, null, "Created on", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("CRETIM", 6, 6, "TIMS", "EDI4CRETIM", "UZEIT", "Time created", null, false);
            meta.addInfo("CRETIM", 3, 6, 12, 772, 0, null, "Time created", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("REFINT", 14, 14, "CHAR", "EDI4REFINT", "EDI_REFNUM", "Transmission file (EDI Interchange)", null, false);
            meta.addInfo("REFINT", 0, 14, 28, 784, 0, null, "Transmission file (EDI Interchange)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("REFGRP", 14, 14, "CHAR", "EDI4REFGRP", "EDI_REFNUM", "Message group (EDI Message Group)", null, false);
            meta.addInfo("REFGRP", 0, 14, 28, 812, 0, null, "Message group (EDI Message Group)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("REFMES", 14, 14, "CHAR", "EDI4REFMES", "EDI_REFNUM", "Message (EDI Message)", null, false);
            meta.addInfo("REFMES", 0, 14, 28, 840, 0, null, "Message (EDI Message)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("ARCKEY", 70, 70, "CHAR", "EDI4ARCKEY", "EDI_ARCKEY", "Key for external message archive", null, false);
            meta.addInfo("ARCKEY", 0, 70, 140, 868, 0, null, "Key for external message archive", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SERIAL", 20, 20, "CHAR", "EDI4SERIAL", "CHAR20", "Serialization", null, false);
            meta.addInfo("SERIAL", 0, 20, 40, 1008, 0, null, "Serialization", 0, null, fieldMeta);
            meta.setTabLength(1048);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("EDI_DD40");
            meta.addInfo("SEGNAM", 0, 30, 60, 0, 0, null, "Segment (external name)", 0, null, null);
            meta.addInfo("MANDT", 0, 3, 6, 60, 0, null, "Client", 0, null, null);
            meta.addInfo("DOCNUM", 0, 16, 32, 66, 0, null, "IDoc number", 0, null, null);
            meta.addInfo("SEGNUM", 0, 6, 12, 98, 0, null, "Segment number", 0, null, null);
            meta.addInfo("PSGNUM", 6, 6, 12, 110, 0, null, "Number of superior parent segment", 0, null, null);
            meta.addInfo("HLEVEL", 0, 2, 4, 122, 0, null, "Hierarchy level of SAP segment", 0, null, null);
            meta.addInfo("SDATA", 0, 1000, 2000, 126, 0, null, "Application data", 0, null, null);
            meta.setTabLength(2126);
            this.addStructureDefinitionToCache(meta);
        }

        protected void add_IDOCTYPE_READ_COMPLETE() {
            JCO.MetaData meta = new JCO.MetaData("IDOCTYPE_READ_COMPLETE");
            meta.addInfo("PI_CIMTYP", 0, 30, 60, 0, 0, null, "Extension", 5, null, null);
            meta.addInfo("PI_IDOCTYP", 0, 30, 60, 60, 0, null, "Basic type", 1, null, null);
            meta.addInfo("PI_RELEASE", 0, 4, 8, 120, 0, "SY-SAPRL", "Release", 5, null, null);
            meta.addInfo("PI_APPLREL", 0, 10, 20, 128, 0, null, "IDoc Development: Application Release of Segment Definition", 5, null, null);
            meta.addInfo("PI_VERSION", 0, 1, 2, 148, 0, "'3'", "Version of IDoc record types", 5, null, null);
            meta.addInfo("PE_HEADER", 17, 9, 9, 0, 0, null, "Header data for IDoc type", 2, "EDI_IAPI10", null);
            meta.addInfo("PT_FIELDS", 99, 9, 9, 0, 0, null, "Structure of segments for IDoc type (fields)", 0, "EDI_IAPI12", null);
            meta.addInfo("PT_FVALUES", 99, 10, 10, 9, 0, null, "Permitted values for segment fields", 0, "EDI_IAPI14", null);
            meta.addInfo("PT_MESSAGES", 99, 11, 11, 19, 0, null, "Linked logical messages", 0, "EDI_IAPI17", null);
            meta.addInfo("PT_SEGMENTS", 99, 11, 11, 30, 0, null, "Structure of IDoc type (segments)", 0, "EDI_IAPI11", null);
            meta.addInfo("OBJECT_UNKNOWN", 98, 0, 0, -1, 0, null, "Basic type or extension does not exist", 0, null, null);
            meta.addInfo("RELATION_NOT_FOUND", 98, 0, 0, -1, 0, null, "Extension and basic type not assigned", 0, null, null);
            meta.addInfo("SEGMENT_UNKNOWN", 98, 0, 0, -1, 0, null, "Segment could not be read", 0, null, null);
            this.addFunctionInterfaceToCache(meta);
            meta = new JCO.MetaData("EDI_IAPI10");
            meta.addInfo("IDOCTYP", 0, 30, 60, 0, 0, null, "Basic type", 0, null, null);
            meta.addInfo("CIMTYP", 0, 30, 60, 60, 0, null, "Extension", 0, null, null);
            meta.addInfo("STRUCTTYPE", 0, 1, 2, 120, 0, null, "Development object type", 0, null, null);
            meta.addInfo("DESCRP", 0, 60, 120, 122, 0, null, "Short description of object", 0, null, null);
            meta.addInfo("PRETYP", 0, 30, 60, 242, 0, null, "Predecessor of basic type or extension", 0, null, null);
            meta.addInfo("RELEASED", 0, 4, 8, 302, 0, null, "Released in", 0, null, null);
            meta.addInfo("PRESP", 0, 12, 24, 310, 0, null, "Responsible person", 0, null, null);
            meta.addInfo("PWORK", 0, 12, 24, 334, 0, null, "Processing person", 0, null, null);
            meta.addInfo("PLAST", 0, 12, 24, 358, 0, null, "Last change: Person", 0, null, null);
            meta.addInfo("APPLREL", 0, 10, 20, 382, 0, null, "Application Release in which Basic Type Was Released", 0, null, null);
            meta.setTabLength(402);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("EDI_IAPI12");
            meta.addInfo("SEGMENTTYP", 0, 30, 60, 0, 0, null, "Segment type in 30-character format", 0, null, null);
            meta.addInfo("FIELDNAME", 0, 30, 60, 60, 0, null, "Field name", 0, null, null);
            meta.addInfo("INTLEN", 6, 6, 12, 120, 0, null, "Internal length in bytes", 0, null, null);
            meta.addInfo("EXTLEN", 6, 6, 12, 132, 0, null, "Output length", 0, null, null);
            meta.addInfo("FIELD_POS", 6, 6, 12, 144, 0, null, "Position number of field", 0, null, null);
            meta.addInfo("BYTE_FIRST", 6, 6, 12, 156, 0, null, "Position of first byte", 0, null, null);
            meta.addInfo("BYTE_LAST", 6, 6, 12, 168, 0, null, "Position of last byte", 0, null, null);
            meta.addInfo("ROLLNAME", 0, 30, 60, 180, 0, null, "Data element (semantic domain)", 0, null, null);
            meta.addInfo("DOMNAME", 0, 30, 60, 240, 0, null, "Domain name", 0, null, null);
            meta.addInfo("DATATYPE", 0, 4, 8, 300, 0, null, "ABAP/4 Dictionary: Screen data type for Screen Painter", 0, null, null);
            meta.addInfo("DESCRP", 0, 60, 120, 308, 0, null, "Short description of object", 0, null, null);
            meta.addInfo("ISOCODE", 0, 1, 2, 428, 0, null, "IDOC development: ISO code ID in field", 0, null, null);
            meta.addInfo("VALUETAB", 0, 30, 60, 430, 0, null, "Value table for IDoc segm. field", 0, null, null);
            meta.setTabLength(490);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("EDI_IAPI14");
            meta.addInfo("STRNAME", 0, 30, 60, 0, 0, null, "Name of internal structure", 0, null, null);
            meta.addInfo("FIELDNAME", 0, 30, 60, 60, 0, null, "Field name", 0, null, null);
            meta.addInfo("FLDVALUE_L", 0, 10, 20, 120, 0, null, "Lower value/single value", 0, null, null);
            meta.addInfo("FLDVALUE_H", 0, 10, 20, 140, 0, null, "Upper value", 0, null, null);
            meta.addInfo("DESCRP", 0, 60, 120, 160, 0, null, "Explanatory short text", 0, null, null);
            meta.setTabLength(280);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("EDI_IAPI17");
            meta.addInfo("MESTYP", 0, 30, 60, 0, 0, null, "Message type", 0, null, null);
            meta.addInfo("DESCRP", 0, 60, 120, 60, 0, null, "Short description of object", 0, null, null);
            meta.addInfo("IDOCTYP", 0, 30, 60, 180, 0, null, "Basic type", 0, null, null);
            meta.addInfo("CIMTYP", 0, 30, 60, 240, 0, null, "Extension", 0, null, null);
            meta.addInfo("RELEASED", 0, 4, 8, 300, 0, null, "Release for which message type assignment is valid", 0, null, null);
            meta.setTabLength(308);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("EDI_IAPI11");
            meta.addInfo("NR", 6, 4, 8, 0, 0, null, "Sequential Number of SegmentImpl in IDoc Type", 0, null, null);
            meta.addInfo("SEGMENTTYP", 0, 30, 60, 8, 0, null, "Segment type in 30-character format", 0, null, null);
            meta.addInfo("SEGMENTDEF", 0, 30, 60, 68, 0, null, "IDoc Development : SegmentImpl definition", 0, null, null);
            meta.addInfo("QUALIFIER", 0, 1, 2, 128, 0, null, "Flag: Qualified segment in IDoc", 0, null, null);
            meta.addInfo("SEGLEN", 6, 4, 8, 130, 0, null, "Length of a field (number of positions)", 0, null, null);
            meta.addInfo("PARSEG", 0, 30, 60, 138, 0, null, "Segment type in 30-character format", 0, null, null);
            meta.addInfo("PARPNO", 6, 4, 8, 198, 0, null, "Sequential number of parent segment", 0, null, null);
            meta.addInfo("PARFLG", 0, 1, 2, 206, 0, null, "Flag for parent segment: SegmentImpl is start of segment group", 0, null, null);
            meta.addInfo("MUSTFL", 0, 1, 2, 208, 0, null, "Flag: Mandatory entry", 0, null, null);
            meta.addInfo("OCCMIN", 6, 10, 20, 210, 0, null, "Minimum number of segments in sequence", 0, null, null);
            meta.addInfo("OCCMAX", 6, 10, 20, 230, 0, null, "Maximum number of segments in sequence", 0, null, null);
            meta.addInfo("HLEVEL", 6, 2, 4, 250, 0, null, "Hierarchy level of IDoc type segment", 0, null, null);
            meta.addInfo("DESCRP", 0, 60, 120, 254, 0, null, "Short description of object", 0, null, null);
            meta.addInfo("GRP_MUSTFL", 0, 1, 2, 374, 0, null, "Flag for groups: Mandatory", 0, null, null);
            meta.addInfo("GRP_OCCMIN", 6, 10, 20, 376, 0, null, "Minimum number of groups in sequence", 0, null, null);
            meta.addInfo("GRP_OCCMAX", 6, 10, 20, 396, 0, null, "Maximum number of groups in sequence", 0, null, null);
            meta.addInfo("REFSEGTYP", 0, 30, 60, 416, 0, null, "Segment type in 30-character format", 0, null, null);
            meta.setTabLength(476);
            this.addStructureDefinitionToCache(meta);
        }

        protected void add_INBOUND_IDOC_PROCESS() {
            JCO.MetaData meta = new JCO.MetaData("INBOUND_IDOC_PROCESS");
            meta.addInfo("IDOC_CONTROL", 99, 12, 12, 0, 0, null, "Control records for IDocs passed", 0, "EDI_DC", null);
            meta.addInfo("IDOC_DATA", 99, 9, 9, 12, 0, null, "Data records for IDocs passed", 0, "EDI_DD", null);
            this.addFunctionInterfaceToCache(meta);
            meta = new JCO.MetaData("EDI_DC");
            JCoFieldMetaData fieldMeta = new JCoFieldMetaData("TABNAM", 10, 10, "CHAR", "EDI_TABNA3", "CHAR10", "Name of external structure", null, false);
            meta.addInfo("TABNAM", 0, 10, 20, 0, 0, null, "Name of external structure", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MANDT", 3, 3, "CHAR", "EDI_MANDT3", "CHAR3", "Client", null, false);
            meta.addInfo("MANDT", 0, 3, 6, 20, 0, null, "Client", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("DOCNUM", 16, 16, "CHAR", "EDI_DOCNC3", "CHAR16", "IDoc number", null, false);
            meta.addInfo("DOCNUM", 0, 16, 32, 26, 0, null, "IDoc number", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("DOCREL", 4, 4, "CHAR", "EDI_DOCRL3", "CHAR4", "SAP Release for IDoc", null, false);
            meta.addInfo("DOCREL", 0, 4, 8, 58, 0, null, "SAP Release for IDoc", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STATUS", 2, 2, "CHAR", "EDI_STATU3", "CHAR2", "Status of IDoc", null, false);
            meta.addInfo("STATUS", 0, 2, 4, 66, 0, null, "Status of IDoc", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("DOCTYP", 8, 8, "CHAR", "EDI_DOCTP3", "CHAR8", "IDoc type", null, false);
            meta.addInfo("DOCTYP", 0, 8, 16, 70, 0, null, "IDoc type", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("DIRECT", 1, 1, "CHAR", "EDI_DIREC3", "CHAR1", "Direction for IDoc transmission", null, false);
            meta.addInfo("DIRECT", 0, 1, 2, 86, 0, null, "Direction for IDoc transmission", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPOR", 10, 10, "CHAR", "EDI_RCVPO3", "CHAR10", "Receiver port (SAP System, EDI subsystem)", null, false);
            meta.addInfo("RCVPOR", 0, 10, 20, 88, 0, null, "Receiver port (SAP System, EDI subsystem)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPRT", 2, 2, "CHAR", "EDI_RCVPT3", "CHAR2", "Partner type of recipient", null, false);
            meta.addInfo("RCVPRT", 0, 2, 4, 108, 0, null, "Partner type of recipient", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPRN", 10, 10, "CHAR", "EDI_RCVPN3", "CHAR10", "Partner number of recipient", null, false);
            meta.addInfo("RCVPRN", 0, 10, 20, 112, 0, null, "Partner number of recipient", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVSAD", 21, 21, "CHAR", "EDI_SADR3", "CHAR21", "IDoc: SADR fields in total", null, false);
            meta.addInfo("RCVSAD", 0, 21, 42, 132, 0, null, "IDoc: SADR fields in total", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVLAD", 70, 70, "CHAR", "EDI_RCVLA3", "CHAR70", "Logical address of recipient", null, false);
            meta.addInfo("RCVLAD", 0, 70, 140, 174, 0, null, "Logical address of recipient", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STD", 1, 1, "CHAR", "EDI_STAND3", "CHAR1", "EDI standard", null, false);
            meta.addInfo("STD", 0, 1, 2, 314, 0, null, "EDI standard", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STDVRS", 6, 6, "CHAR", "EDI_STDVR3", "CHAR6", "Version of EDI standard", null, false);
            meta.addInfo("STDVRS", 0, 6, 12, 316, 0, null, "Version of EDI standard", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STDMES", 6, 6, "CHAR", "EDI_STDME3", "CHAR6", "EDI message type", null, false);
            meta.addInfo("STDMES", 0, 6, 12, 328, 0, null, "EDI message type", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MESCOD", 3, 3, "CHAR", "EDI_MESCO3", "CHAR3", "Logical message code", null, false);
            meta.addInfo("MESCOD", 0, 3, 6, 340, 0, null, "Logical message code", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MESFCT", 3, 3, "CHAR", "EDI_MESFC3", "CHAR3", "Logical message function", null, false);
            meta.addInfo("MESFCT", 0, 3, 6, 346, 0, null, "Logical message function", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("OUTMOD", 1, 1, "CHAR", "EDI_OUTMO3", "CHAR1", "Output mode", null, false);
            meta.addInfo("OUTMOD", 0, 1, 2, 352, 0, null, "Output mode", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("TEST", 1, 1, "CHAR", "EDI_TEST3", "CHAR1", "Test flag", null, false);
            meta.addInfo("TEST", 0, 1, 2, 354, 0, null, "Test flag", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPOR", 10, 10, "CHAR", "EDI_SNDPO3", "CHAR10", "Sender port (SAP System, EDI subsystem)", null, false);
            meta.addInfo("SNDPOR", 0, 10, 20, 356, 0, null, "Sender port (SAP System, EDI subsystem)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPRT", 2, 2, "CHAR", "EDI_SNDPT3", "CHAR2", "Partner type of sender", null, false);
            meta.addInfo("SNDPRT", 0, 2, 4, 376, 0, null, "Partner type of sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPRN", 10, 10, "CHAR", "EDI_SNDPN3", "CHAR10", "Partner number of sender", null, false);
            meta.addInfo("SNDPRN", 0, 10, 20, 380, 0, null, "Partner number of sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDSAD", 21, 21, "CHAR", "EDI_SADR3", "CHAR21", "IDoc: SADR fields in total", null, false);
            meta.addInfo("SNDSAD", 0, 21, 42, 400, 0, null, "IDoc: SADR fields in total", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDLAD", 70, 70, "CHAR", "EDI_SNDLA3", "CHAR70", "Logical address of sender", null, false);
            meta.addInfo("SNDLAD", 0, 70, 140, 442, 0, null, "Logical address of sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("REFINT", 14, 14, "CHAR", "IDOCCRFIN3", "CHAR14", "Reference to interchange file", null, false);
            meta.addInfo("REFINT", 0, 14, 28, 582, 0, null, "Reference to interchange file", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("REFGRP", 14, 14, "CHAR", "IDOCCRFGR3", "CHAR14", "Reference to message group", null, false);
            meta.addInfo("REFGRP", 0, 14, 28, 610, 0, null, "Reference to message group", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("REFMES", 14, 14, "CHAR", "IDOCCRFME3", "CHAR14", "Reference to message", null, false);
            meta.addInfo("REFMES", 0, 14, 28, 638, 0, null, "Reference to message", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("ARCKEY", 70, 70, "CHAR", "IDOCCARKY3", "CHAR70", "EDI archive key", null, false);
            meta.addInfo("ARCKEY", 0, 70, 140, 666, 0, null, "EDI archive key", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("CREDAT", 8, 8, "DATS", "EDI_CCRDT3", "DATS", "IDoc creation date", null, false);
            meta.addInfo("CREDAT", 1, 8, 16, 806, 0, null, "IDoc creation date", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("CRETIM", 6, 6, "TIMS", "EDI_CCRTI3", "UZEIT", "IDoc creation time", null, false);
            meta.addInfo("CRETIM", 3, 6, 12, 822, 0, null, "IDoc creation time", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MESTYP", 6, 6, "CHAR", "EDI_MESTP3", "CHAR6", "Logical message type", null, false);
            meta.addInfo("MESTYP", 0, 6, 12, 834, 0, null, "Logical message type", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("IDOCTYP", 8, 8, "CHAR", "EDI_IDCTP3", "CHAR8", "Name of basic type", null, false);
            meta.addInfo("IDOCTYP", 0, 8, 16, 846, 0, null, "Name of basic type", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("CIMTYP", 8, 8, "CHAR", "EDI_CIMTP3", "CHAR8", "Extension", null, false);
            meta.addInfo("CIMTYP", 0, 8, 16, 862, 0, null, "Extension", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPFC", 2, 2, "CHAR", "EDI_RCVPF3", "CHAR2", "Partner function of recipient", null, false);
            meta.addInfo("RCVPFC", 0, 2, 4, 878, 0, null, "Partner function of recipient", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPFC", 2, 2, "CHAR", "EDI_SNDPF3", "CHAR2", "Partner function of sender", null, false);
            meta.addInfo("SNDPFC", 0, 2, 4, 882, 0, null, "Partner function of sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SERIAL", 20, 20, "CHAR", "EDI_SERIA3", "CHAR20", "EDI/ALE: Serialization field", null, false);
            meta.addInfo("SERIAL", 0, 20, 40, 886, 0, null, "EDI/ALE: Serialization field", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("EXPRSS", 1, 1, "CHAR", "EDI_EXPRS3", "CHAR1", "Overriding in inbound processing", null, false);
            meta.addInfo("EXPRSS", 0, 1, 2, 926, 0, null, "Overriding in inbound processing", 0, null, fieldMeta);
            meta.setTabLength(928);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("EDI_DD");
            meta.addInfo("TABNAM", 0, 10, 20, 0, 0, null, "Name of external structure", 0, null, null);
            meta.addInfo("MANDT", 0, 3, 6, 20, 0, null, "Client", 0, null, null);
            meta.addInfo("DOCNUM", 0, 16, 32, 26, 0, null, "IDoc number", 0, null, null);
            meta.addInfo("SEGNUM", 0, 6, 12, 58, 0, null, "Number of SAP segment", 0, null, null);
            meta.addInfo("SEGNAM", 0, 10, 20, 70, 0, null, "Name of SAP segment", 0, null, null);
            meta.addInfo("PSGNUM", 0, 6, 12, 90, 0, null, "Number of the higher-level SAP segment", 0, null, null);
            meta.addInfo("HLEVEL", 0, 2, 4, 102, 0, null, "Hierarchy level of SAP segment", 0, null, null);
            meta.addInfo("DTINT2", 0, 2, 4, 106, 0, null, "Blank field for EDI_DD", 0, null, null);
            meta.addInfo("SDATA", 0, 1000, 2000, 110, 0, null, "Application data", 0, null, null);
            meta.setTabLength(2110);
            this.addStructureDefinitionToCache(meta);
        }

        protected void add_RFC_READ_TABLE() {
            JCO.MetaData meta = new JCO.MetaData("RFC_READ_TABLE");
            meta.addInfo("DELIMITER", 0, 1, 2, 0, 0, "SPACE", "Sign for indicating field limits in DATA", 5, null, null);
            meta.addInfo("NO_DATA", 0, 1, 2, 2, 0, "SPACE", "If <> SPACE, only FIELDS is filled", 5, null, null);
            meta.addInfo("QUERY_TABLE", 0, 30, 60, 4, 0, null, "Table read", 1, null, null);
            meta.addInfo("ROWCOUNT", 8, 4, 4, 64, 0, "0", null, 5, null, null);
            meta.addInfo("ROWSKIPS", 8, 4, 4, 68, 0, "0", null, 5, null, null);
            meta.addInfo("DATA", 99, 4, 4, 0, 0, null, "Data read (out)", 0, "TAB512", null);
            meta.addInfo("FIELDS", 99, 6, 6, 4, 0, null, "Names (in) and structure (out) of fields read", 0, "RFC_DB_FLD", null);
            meta.addInfo("OPTIONS", 99, 7, 7, 10, 0, null, "Selection entries, \"WHERE clauses\" (in)", 0, "RFC_DB_OPT", null);
            meta.addInfo("DATA_BUFFER_EXCEEDED", 98, 0, 0, -1, 0, null, "Selected fields do not fit into structure DATA", 0, null, null);
            meta.addInfo("FIELD_NOT_VALID", 98, 0, 0, -1, 0, null, "Field to be read not in table", 0, null, null);
            meta.addInfo("NOT_AUTHORIZED", 98, 0, 0, -1, 0, null, "User not authorized to access QUERY_TABLE", 0, null, null);
            meta.addInfo("OPTION_NOT_VALID", 98, 0, 0, -1, 0, null, "Selection entries (e.g. syntax) incorrect", 0, null, null);
            meta.addInfo("TABLE_NOT_AVAILABLE", 98, 0, 0, -1, 0, null, "QUERY_TABLE not active in Dictionary", 0, null, null);
            meta.addInfo("TABLE_WITHOUT_DATA", 98, 0, 0, -1, 0, null, "QUERY_TABLE is name of structure", 0, null, null);
            this.addFunctionInterfaceToCache(meta);
            meta = new JCO.MetaData("TAB512");
            meta.addInfo("WA", 0, 512, 1024, 0, 0, null, "Character field length 512", 0, null, null);
            meta.setTabLength(1024);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("RFC_DB_FLD");
            meta.addInfo("FIELDNAME", 0, 30, 60, 0, 0, null, "Field name", 0, null, null);
            meta.addInfo("OFFSET", 6, 6, 12, 60, 0, null, "Offset of a field in work area", 0, null, null);
            meta.addInfo("LENGTH", 6, 6, 12, 72, 0, null, "Length (no. of characters)", 0, null, null);
            meta.addInfo("TYPE", 0, 1, 2, 84, 0, null, "ABAP data type (C,D,N,...)", 0, null, null);
            meta.addInfo("FIELDTEXT", 0, 60, 120, 86, 0, null, "Short text describing R/3 Repository objects", 0, null, null);
            meta.setTabLength(206);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("RFC_DB_OPT");
            meta.addInfo("TEXT", 0, 72, 144, 0, 0, null, "Text line of a message", 0, null, null);
            meta.setTabLength(144);
            this.addStructureDefinitionToCache(meta);
        }
    }

    private static class JCoStaticRepository40
    extends JCO.BasicRepository
    implements IRepository {
        protected JCoStaticRepository40() {
            this("JCoIDoc.JCoStaticRepository for SAP Release 4.0");
        }

        protected JCoStaticRepository40(String name) {
            super(name);
            this.add_IDOC_INBOUND_ASYNCHRONOUS();
            this.add_IDOCTYPE_READ_COMPLETE();
            this.add_INBOUND_IDOC_PROCESS();
            this.add_RFC_READ_TABLE();
        }

        protected void add_IDOC_INBOUND_ASYNCHRONOUS() {
            JCO.MetaData meta = new JCO.MetaData("IDOC_INBOUND_ASYNCHRONOUS");
            meta.addInfo("IDOC_CONTROL_REC_40", 99, 19, 0, 0, null, null, 0, "EDI_DC40", null);
            meta.addInfo("IDOC_DATA_REC_40", 99, 16, 19, 0, null, null, 0, "EDI_DD40", null);
            this.addFunctionInterfaceToCache(meta);
            meta = new JCO.MetaData("IDOC_INBOUND_ASYNCHRONOUS_WITH_BINARY_DATA");
            meta.addInfo("IDOC_CONTROL_REC_40", 99, 19, 0, 0, null, null, 0, "EDI_DC40", null);
            meta.addInfo("IDOC_DATA_REC_40", 99, 16, 19, 0, null, null, 0, "EDI_DD40_WITH_BINARY_DATA", null);
            this.addFunctionInterfaceToCache(meta);
            meta = new JCO.MetaData("EDI_DC40");
            JCoFieldMetaData fieldMeta = new JCoFieldMetaData("TABNAM", 10, 10, "CHAR", "EDI4TABNAM", "EDI_TABNAM", "Name of table structure", null, false);
            meta.addInfo("TABNAM", 0, 10, 0, 0, null, "Name of table structure", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MANDT", 3, 3, "CLNT", "EDI4MANDT", "MANDT", "Client", "T000", false);
            meta.addInfo("MANDT", 0, 3, 10, 0, null, "Client", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("DOCNUM", 16, 16, "CHAR", "EDI4DOCNUC", "EDI_CHAR16", "IDoc number", null, false);
            meta.addInfo("DOCNUM", 0, 16, 13, 0, null, "IDoc number", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("DOCREL", 4, 4, "CHAR", "EDI4DOCREL", "SAPRL", "SAP Release for IDoc", null, false);
            meta.addInfo("DOCREL", 0, 4, 29, 0, null, "SAP Release for IDoc", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STATUS", 2, 2, "CHAR", "EDI4STATUS", "EDI_STATUS", "Status of IDoc", "TEDS1", false);
            meta.addInfo("STATUS", 0, 2, 33, 0, null, "Status of IDoc", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("DIRECT", 1, 1, "CHAR", "EDI4DIRECT", "EDI_DIRECT", "Direction", null, false);
            meta.addInfo("DIRECT", 0, 1, 35, 0, null, "Direction", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("OUTMOD", 1, 1, "CHAR", "EDI4OUTMOD", "EDI_OUTMOD", "Output mode", null, false);
            meta.addInfo("OUTMOD", 0, 1, 36, 0, null, "Output mode", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("EXPRSS", 1, 1, "CHAR", "EDI4EXPRSS", "EDI_EXPRSS", "Overriding in inbound processing", null, false);
            meta.addInfo("EXPRSS", 0, 1, 37, 0, null, "Overriding in inbound processing", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("TEST", 1, 1, "CHAR", "EDI4TEST", "EDI_TEST", "Test flag", null, false);
            meta.addInfo("TEST", 0, 1, 38, 0, null, "Test flag", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("IDOCTYP", 30, 30, "CHAR", "EDI4IDOCTP", "EDI_IDOCTP", "Name of basic type", "EDBAS", false);
            meta.addInfo("IDOCTYP", 0, 30, 39, 0, null, "Name of basic type", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("CIMTYP", 30, 30, "CHAR", "EDI4CIMTYP", "EDI_CIMTYP", "Extension (defined by customer)", "EDCIM", false);
            meta.addInfo("CIMTYP", 0, 30, 69, 0, null, "Extension (defined by customer)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MESTYP", 30, 30, "CHAR", "EDI4MESTYP", "EDI_MESTYP", "Message type", "EDMSG", false);
            meta.addInfo("MESTYP", 0, 30, 99, 0, null, "Message type", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MESCOD", 3, 3, "CHAR", "EDI4MESCOD", "EDI_MESCOD", "Message code", null, false);
            meta.addInfo("MESCOD", 0, 3, 129, 0, null, "Message code", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MESFCT", 3, 3, "CHAR", "EDI4MESFCT", "EDI_MESFCT", "Message function", null, false);
            meta.addInfo("MESFCT", 0, 3, 132, 0, null, "Message function", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STD", 1, 1, "CHAR", "EDI4STD", "EDI_STD", "EDI standard, flag", null, false);
            meta.addInfo("STD", 0, 1, 135, 0, null, "EDI standard, flag", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STDVRS", 6, 6, "CHAR", "EDI4STDVRS", "EDI_STDVRS", "EDI standard, version and release", null, false);
            meta.addInfo("STDVRS", 0, 6, 136, 0, null, "EDI standard, version and release", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STDMES", 6, 6, "CHAR", "EDI4STDMES", "EDI_STDMES", "EDI message type", null, false);
            meta.addInfo("STDMES", 0, 6, 142, 0, null, "EDI message type", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPOR", 10, 10, "CHAR", "EDI4SNDPOR", "EDI_PORT", "Sender port (SAP System, external subsystem)", null, false);
            meta.addInfo("SNDPOR", 0, 10, 148, 0, null, "Sender port (SAP System, external subsystem)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPRT", 2, 2, "CHAR", "EDI4SNDPRT", "EDI_PARTYP", "Partner type of sender", null, false);
            meta.addInfo("SNDPRT", 0, 2, 158, 0, null, "Partner type of sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPFC", 2, 2, "CHAR", "EDI4SNDPFC", "EDI_PARVW", "Partner Function of Sender", null, false);
            meta.addInfo("SNDPFC", 0, 2, 160, 0, null, "Partner Function of Sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPRN", 10, 10, "CHAR", "EDI4SNDPRN", "EDI_PARNUM", "Partner number of sender", null, false);
            meta.addInfo("SNDPRN", 0, 10, 162, 0, null, "Partner number of sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDSAD", 21, 21, "CHAR", "EDI4SNDSAD", "CHAR21", "Sender address (SADR)", null, false);
            meta.addInfo("SNDSAD", 0, 21, 172, 0, null, "Sender address (SADR)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDLAD", 70, 70, "CHAR", "EDI4SNDLAD", "EDI_LOGADR", "Logical address of sender", null, false);
            meta.addInfo("SNDLAD", 0, 70, 193, 0, null, "Logical address of sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPOR", 10, 10, "CHAR", "EDI4RCVPOR", "EDI_PORT", "Receiver port", null, false);
            meta.addInfo("RCVPOR", 0, 10, 263, 0, null, "Receiver port", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPRT", 2, 2, "CHAR", "EDI4RCVPRT", "EDI_PARTYP", "Partner type of recipient", null, false);
            meta.addInfo("RCVPRT", 0, 2, 273, 0, null, "Partner type of recipient", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPFC", 2, 2, "CHAR", "EDI4RCVPFC", "EDI_PARVW", "Partner function of recipient", null, false);
            meta.addInfo("RCVPFC", 0, 2, 275, 0, null, "Partner function of recipient", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPRN", 10, 10, "CHAR", "EDI4RCVPRN", "EDI_PARNUM", "Partner number of recipient", null, false);
            meta.addInfo("RCVPRN", 0, 10, 277, 0, null, "Partner number of recipient", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVSAD", 21, 21, "CHAR", "EDI4RCVSAD", "CHAR21", "Recipient address (SADR)", null, false);
            meta.addInfo("RCVSAD", 0, 21, 287, 0, null, "Recipient address (SADR)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVLAD", 70, 70, "CHAR", "EDI4RCVLAD", "EDI_LOGADR", "Logical address of recipient", null, false);
            meta.addInfo("RCVLAD", 0, 70, 308, 0, null, "Logical address of recipient", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("CREDAT", 8, 8, "DATS", "EDI4CREDAT", "DATUM", "Created on", null, false);
            meta.addInfo("CREDAT", 1, 8, 378, 0, null, "Created on", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("CRETIM", 6, 6, "TIMS", "EDI4CRETIM", "UZEIT", "Time created", null, false);
            meta.addInfo("CRETIM", 3, 6, 386, 0, null, "Time created", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("REFINT", 14, 14, "CHAR", "EDI4REFINT", "EDI_REFNUM", "Transmission file (EDI Interchange)", null, false);
            meta.addInfo("REFINT", 0, 14, 392, 0, null, "Transmission file (EDI Interchange)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("REFGRP", 14, 14, "CHAR", "EDI4REFGRP", "EDI_REFNUM", "Message group (EDI Message Group)", null, false);
            meta.addInfo("REFGRP", 0, 14, 406, 0, null, "Message group (EDI Message Group)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("REFMES", 14, 14, "CHAR", "EDI4REFMES", "EDI_REFNUM", "Message (EDI Message)", null, false);
            meta.addInfo("REFMES", 0, 14, 420, 0, null, "Message (EDI Message)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("ARCKEY", 70, 70, "CHAR", "EDI4ARCKEY", "EDI_ARCKEY", "Key for external message archive", null, false);
            meta.addInfo("ARCKEY", 0, 70, 434, 0, null, "Key for external message archive", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SERIAL", 20, 20, "CHAR", "EDI4SERIAL", "CHAR20", "Serialization", null, false);
            meta.addInfo("SERIAL", 0, 20, 504, 0, null, "Serialization", 0, null, fieldMeta);
            meta.setTabLength(524);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("EDI_DD40");
            meta.addInfo("SEGNAM", 0, 30, 0, 0, null, "Segment (external name)", 0, null, null);
            meta.addInfo("MANDT", 0, 3, 30, 0, null, "Client", 0, null, null);
            meta.addInfo("DOCNUM", 0, 16, 33, 0, null, "IDoc number", 0, null, null);
            meta.addInfo("SEGNUM", 0, 6, 49, 0, null, "Segment number", 0, null, null);
            meta.addInfo("PSGNUM", 6, 6, 55, 0, null, "Number of superior parent segment", 0, null, null);
            meta.addInfo("HLEVEL", 0, 2, 61, 0, null, "Hierarchy level of SAP segment", 0, null, null);
            meta.addInfo("SDATA", 0, 1000, 63, 0, null, "Application data", 0, null, null);
            meta.setTabLength(1063);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("EDI_DD40_WITH_BINARY_DATA");
            meta.addInfo("SEGNAM", 0, 30, 0, 0, null, "Segment (external name)", 0, null, null);
            meta.addInfo("MANDT", 0, 3, 30, 0, null, "Client", 0, null, null);
            meta.addInfo("DOCNUM", 0, 16, 33, 0, null, "IDoc number", 0, null, null);
            meta.addInfo("SEGNUM", 0, 6, 49, 0, null, "Segment number", 0, null, null);
            meta.addInfo("PSGNUM", 6, 6, 55, 0, null, "Number of superior parent segment", 0, null, null);
            meta.addInfo("HLEVEL", 0, 2, 61, 0, null, "Hierarchy level of SAP segment", 0, null, null);
            meta.addInfo("SDATA", 4, 1000, 63, 0, null, "Application data", 0, null, null);
            meta.setTabLength(1063);
            this.addStructureDefinitionToCache(meta);
        }

        protected void add_IDOCTYPE_READ_COMPLETE() {
            JCO.MetaData meta = new JCO.MetaData("IDOCTYPE_READ_COMPLETE");
            meta.addInfo("PI_CIMTYP", 0, 30, 0, 0, null, "Extension", 5, null, null);
            meta.addInfo("PI_IDOCTYP", 0, 30, 30, 0, null, "Basic type", 1, null, null);
            meta.addInfo("PI_RELEASE", 0, 4, 60, 0, "SY-SAPRL", "Release", 5, null, null);
            meta.addInfo("PI_APPLREL", 0, 10, 64, 0, null, "IDoc Development: Application Release of Segment Definition", 5, null, null);
            meta.addInfo("PI_VERSION", 0, 1, 74, 0, "'3'", "Version of IDoc record types", 5, null, null);
            meta.addInfo("PE_HEADER", 17, 9, 0, 0, null, "Header data for IDoc type", 2, "EDI_IAPI10", null);
            meta.addInfo("PT_FIELDS", 99, 9, 0, 0, null, "Structure of segments for IDoc type (fields)", 0, "EDI_IAPI12", null);
            meta.addInfo("PT_FVALUES", 99, 10, 9, 0, null, "Permitted values for segment fields", 0, "EDI_IAPI14", null);
            meta.addInfo("PT_MESSAGES", 99, 11, 19, 0, null, "Linked logical messages", 0, "EDI_IAPI17", null);
            meta.addInfo("PT_SEGMENTS", 99, 11, 30, 0, null, "Structure of IDoc type (segments)", 0, "EDI_IAPI11", null);
            meta.addInfo("OBJECT_UNKNOWN", 98, 0, -1, 0, null, "Basic type or extension does not exist", 0, null, null);
            meta.addInfo("RELATION_NOT_FOUND", 98, 0, -1, 0, null, "Extension and basic type not assigned", 0, null, null);
            meta.addInfo("SEGMENT_UNKNOWN", 98, 0, -1, 0, null, "Segment could not be read", 0, null, null);
            this.addFunctionInterfaceToCache(meta);
            meta = new JCO.MetaData("EDI_IAPI10");
            meta.addInfo("IDOCTYP", 0, 30, 0, 0, null, "Basic type", 0, null, null);
            meta.addInfo("CIMTYP", 0, 30, 30, 0, null, "Extension", 0, null, null);
            meta.addInfo("STRUCTTYPE", 0, 1, 60, 0, null, "Development object type", 0, null, null);
            meta.addInfo("DESCRP", 0, 60, 61, 0, null, "Short description of object", 0, null, null);
            meta.addInfo("PRETYP", 0, 30, 121, 0, null, "Predecessor of basic type or extension", 0, null, null);
            meta.addInfo("RELEASED", 0, 4, 151, 0, null, "Released in", 0, null, null);
            meta.addInfo("PRESP", 0, 12, 155, 0, null, "Responsible person", 0, null, null);
            meta.addInfo("PWORK", 0, 12, 167, 0, null, "Processing person", 0, null, null);
            meta.addInfo("PLAST", 0, 12, 179, 0, null, "Last change: Person", 0, null, null);
            meta.addInfo("APPLREL", 0, 10, 191, 0, null, "Application Release in which Basic Type Was Released", 0, null, null);
            meta.setTabLength(201);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("EDI_IAPI12");
            meta.addInfo("SEGMENTTYP", 0, 30, 0, 0, null, "Segment type in 30-character format", 0, null, null);
            meta.addInfo("FIELDNAME", 0, 30, 30, 0, null, "Field name", 0, null, null);
            meta.addInfo("INTLEN", 6, 6, 60, 0, null, "Internal length in bytes", 0, null, null);
            meta.addInfo("EXTLEN", 6, 6, 66, 0, null, "Output length", 0, null, null);
            meta.addInfo("FIELD_POS", 6, 6, 72, 0, null, "Position number of field", 0, null, null);
            meta.addInfo("BYTE_FIRST", 6, 6, 78, 0, null, "Position of first byte", 0, null, null);
            meta.addInfo("BYTE_LAST", 6, 6, 84, 0, null, "Position of last byte", 0, null, null);
            meta.addInfo("ROLLNAME", 0, 30, 90, 0, null, "Data element (semantic domain)", 0, null, null);
            meta.addInfo("DOMNAME", 0, 30, 120, 0, null, "Domain name", 0, null, null);
            meta.addInfo("DATATYPE", 0, 4, 150, 0, null, "ABAP/4 Dictionary: Screen data type for Screen Painter", 0, null, null);
            meta.addInfo("DESCRP", 0, 60, 154, 0, null, "Short description of object", 0, null, null);
            meta.addInfo("ISOCODE", 0, 1, 214, 0, null, "IDOC development: ISO code ID in field", 0, null, null);
            meta.addInfo("VALUETAB", 0, 30, 215, 0, null, "Value table for IDoc segm. field", 0, null, null);
            meta.setTabLength(245);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("EDI_IAPI14");
            meta.addInfo("STRNAME", 0, 30, 0, 0, null, "Name of internal structure", 0, null, null);
            meta.addInfo("FIELDNAME", 0, 30, 30, 0, null, "Field name", 0, null, null);
            meta.addInfo("FLDVALUE_L", 0, 10, 60, 0, null, "Lower value/single value", 0, null, null);
            meta.addInfo("FLDVALUE_H", 0, 10, 70, 0, null, "Upper value", 0, null, null);
            meta.addInfo("DESCRP", 0, 60, 80, 0, null, "Explanatory short text", 0, null, null);
            meta.setTabLength(140);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("EDI_IAPI17");
            meta.addInfo("MESTYP", 0, 30, 0, 0, null, "Message type", 0, null, null);
            meta.addInfo("DESCRP", 0, 60, 30, 0, null, "Short description of object", 0, null, null);
            meta.addInfo("IDOCTYP", 0, 30, 90, 0, null, "Basic type", 0, null, null);
            meta.addInfo("CIMTYP", 0, 30, 120, 0, null, "Extension", 0, null, null);
            meta.addInfo("RELEASED", 0, 4, 150, 0, null, "Release for which message type assignment is valid", 0, null, null);
            meta.setTabLength(154);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("EDI_IAPI11");
            meta.addInfo("NR", 6, 4, 0, 0, null, "Sequential Number of SegmentImpl in IDoc Type", 0, null, null);
            meta.addInfo("SEGMENTTYP", 0, 30, 4, 0, null, "Segment type in 30-character format", 0, null, null);
            meta.addInfo("SEGMENTDEF", 0, 30, 34, 0, null, "IDoc Development : SegmentImpl definition", 0, null, null);
            meta.addInfo("QUALIFIER", 0, 1, 64, 0, null, "Flag: Qualified segment in IDoc", 0, null, null);
            meta.addInfo("SEGLEN", 6, 4, 65, 0, null, "Length of a field (number of positions)", 0, null, null);
            meta.addInfo("PARSEG", 0, 30, 69, 0, null, "Segment type in 30-character format", 0, null, null);
            meta.addInfo("PARPNO", 6, 4, 99, 0, null, "Sequential number of parent segment", 0, null, null);
            meta.addInfo("PARFLG", 0, 1, 103, 0, null, "Flag for parent segment: SegmentImpl is start of segment group", 0, null, null);
            meta.addInfo("MUSTFL", 0, 1, 104, 0, null, "Flag: Mandatory entry", 0, null, null);
            meta.addInfo("OCCMIN", 6, 10, 105, 0, null, "Minimum number of segments in sequence", 0, null, null);
            meta.addInfo("OCCMAX", 6, 10, 115, 0, null, "Maximum number of segments in sequence", 0, null, null);
            meta.addInfo("HLEVEL", 6, 2, 125, 0, null, "Hierarchy level of IDoc type segment", 0, null, null);
            meta.addInfo("DESCRP", 0, 60, 127, 0, null, "Short description of object", 0, null, null);
            meta.addInfo("GRP_MUSTFL", 0, 1, 187, 0, null, "Flag for groups: Mandatory", 0, null, null);
            meta.addInfo("GRP_OCCMIN", 6, 10, 188, 0, null, "Minimum number of groups in sequence", 0, null, null);
            meta.addInfo("GRP_OCCMAX", 6, 10, 198, 0, null, "Maximum number of groups in sequence", 0, null, null);
            meta.addInfo("REFSEGTYP", 0, 30, 208, 0, null, "Segment type in 30-character format", 0, null, null);
            meta.setTabLength(238);
            this.addStructureDefinitionToCache(meta);
        }

        protected void add_INBOUND_IDOC_PROCESS() {
            JCO.MetaData meta = new JCO.MetaData("INBOUND_IDOC_PROCESS");
            meta.addInfo("IDOC_CONTROL", 99, 12, 0, 0, null, "Control records for IDocs passed", 0, "EDI_DC", null);
            meta.addInfo("IDOC_DATA", 99, 9, 12, 0, null, "Data records for IDocs passed", 0, "EDI_DD", null);
            this.addFunctionInterfaceToCache(meta);
            meta = new JCO.MetaData("INBOUND_IDOC_PROCESS_WITH_BINARY_DATA");
            meta.addInfo("IDOC_CONTROL", 99, 12, 0, 0, null, "Control records for IDocs passed", 0, "EDI_DC", null);
            meta.addInfo("IDOC_DATA", 99, 9, 12, 0, null, "Data records for IDocs passed", 0, "EDI_DD_WITH_BINARY_DATA", null);
            this.addFunctionInterfaceToCache(meta);
            meta = new JCO.MetaData("EDI_DC");
            JCoFieldMetaData fieldMeta = new JCoFieldMetaData("TABNAM", 10, 10, "CHAR", "EDI_TABNA3", "CHAR10", "Name of external structure", null, false);
            meta.addInfo("TABNAM", 0, 10, 0, 0, null, "Name of external structure", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MANDT", 3, 3, "CHAR", "EDI_MANDT3", "CHAR3", "Client", null, false);
            meta.addInfo("MANDT", 0, 3, 10, 0, null, "Client", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("DOCNUM", 16, 16, "CHAR", "EDI_DOCNC3", "CHAR16", "IDoc number", null, false);
            meta.addInfo("DOCNUM", 0, 16, 13, 0, null, "IDoc number", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("DOCREL", 4, 4, "CHAR", "EDI_DOCRL3", "CHAR4", "SAP Release for IDoc", null, false);
            meta.addInfo("DOCREL", 0, 4, 29, 0, null, "SAP Release for IDoc", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STATUS", 2, 2, "CHAR", "EDI_STATU3", "CHAR2", "Status of IDoc", null, false);
            meta.addInfo("STATUS", 0, 2, 33, 0, null, "Status of IDoc", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("DOCTYP", 8, 8, "CHAR", "EDI_DOCTP3", "CHAR8", "IDoc type", null, false);
            meta.addInfo("DOCTYP", 0, 8, 35, 0, null, "IDoc type", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("DIRECT", 1, 1, "CHAR", "EDI_DIREC3", "CHAR1", "Direction for IDoc transmission", null, false);
            meta.addInfo("DIRECT", 0, 1, 43, 0, null, "Direction for IDoc transmission", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPOR", 10, 10, "CHAR", "EDI_RCVPO3", "CHAR10", "Receiver port (SAP System, EDI subsystem)", null, false);
            meta.addInfo("RCVPOR", 0, 10, 44, 0, null, "Receiver port (SAP System, EDI subsystem)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPRT", 2, 2, "CHAR", "EDI_RCVPT3", "CHAR2", "Partner type of recipient", null, false);
            meta.addInfo("RCVPRT", 0, 2, 54, 0, null, "Partner type of recipient", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPRN", 10, 10, "CHAR", "EDI_RCVPN3", "CHAR10", "Partner number of recipient", null, false);
            meta.addInfo("RCVPRN", 0, 10, 56, 0, null, "Partner number of recipient", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVSAD", 21, 21, "CHAR", "EDI_SADR3", "CHAR21", "IDoc: SADR fields in total", null, false);
            meta.addInfo("RCVSAD", 0, 21, 66, 0, null, "IDoc: SADR fields in total", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVLAD", 70, 70, "CHAR", "EDI_RCVLA3", "CHAR70", "Logical address of recipient", null, false);
            meta.addInfo("RCVLAD", 0, 70, 87, 0, null, "Logical address of recipient", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STD", 1, 1, "CHAR", "EDI_STAND3", "CHAR1", "EDI standard", null, false);
            meta.addInfo("STD", 0, 1, 157, 0, null, "EDI standard", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STDVRS", 6, 6, "CHAR", "EDI_STDVR3", "CHAR6", "Version of EDI standard", null, false);
            meta.addInfo("STDVRS", 0, 6, 158, 0, null, "Version of EDI standard", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STDMES", 6, 6, "CHAR", "EDI_STDME3", "CHAR6", "EDI message type", null, false);
            meta.addInfo("STDMES", 0, 6, 164, 0, null, "EDI message type", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MESCOD", 3, 3, "CHAR", "EDI_MESCO3", "CHAR3", "Logical message code", null, false);
            meta.addInfo("MESCOD", 0, 3, 170, 0, null, "Logical message code", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MESFCT", 3, 3, "CHAR", "EDI_MESFC3", "CHAR3", "Logical message function", null, false);
            meta.addInfo("MESFCT", 0, 3, 173, 0, null, "Logical message function", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("OUTMOD", 1, 1, "CHAR", "EDI_OUTMO3", "CHAR1", "Output mode", null, false);
            meta.addInfo("OUTMOD", 0, 1, 176, 0, null, "Output mode", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("TEST", 1, 1, "CHAR", "EDI_TEST3", "CHAR1", "Test flag", null, false);
            meta.addInfo("TEST", 0, 1, 177, 0, null, "Test flag", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPOR", 10, 10, "CHAR", "EDI_SNDPO3", "CHAR10", "Sender port (SAP System, EDI subsystem)", null, false);
            meta.addInfo("SNDPOR", 0, 10, 178, 0, null, "Sender port (SAP System, EDI subsystem)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPRT", 2, 2, "CHAR", "EDI_SNDPT3", "CHAR2", "Partner type of sender", null, false);
            meta.addInfo("SNDPRT", 0, 2, 188, 0, null, "Partner type of sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPRN", 10, 10, "CHAR", "EDI_SNDPN3", "CHAR10", "Partner number of sender", null, false);
            meta.addInfo("SNDPRN", 0, 10, 190, 0, null, "Partner number of sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDSAD", 21, 21, "CHAR", "EDI_SADR3", "CHAR21", "IDoc: SADR fields in total", null, false);
            meta.addInfo("SNDSAD", 0, 21, 200, 0, null, "IDoc: SADR fields in total", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDLAD", 70, 70, "CHAR", "EDI_SNDLA3", "CHAR70", "Logical address of sender", null, false);
            meta.addInfo("SNDLAD", 0, 70, 221, 0, null, "Logical address of sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("REFINT", 14, 14, "CHAR", "IDOCCRFIN3", "CHAR14", "Reference to interchange file", null, false);
            meta.addInfo("REFINT", 0, 14, 291, 0, null, "Reference to interchange file", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("REFGRP", 14, 14, "CHAR", "IDOCCRFGR3", "CHAR14", "Reference to message group", null, false);
            meta.addInfo("REFGRP", 0, 14, 305, 0, null, "Reference to message group", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("REFMES", 14, 14, "CHAR", "IDOCCRFME3", "CHAR14", "Reference to message", null, false);
            meta.addInfo("REFMES", 0, 14, 319, 0, null, "Reference to message", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("ARCKEY", 70, 70, "CHAR", "IDOCCARKY3", "CHAR70", "EDI archive key", null, false);
            meta.addInfo("ARCKEY", 0, 70, 333, 0, null, "EDI archive key", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("CREDAT", 8, 8, "DATS", "EDI_CCRDT3", "DATS", "IDoc creation date", null, false);
            meta.addInfo("CREDAT", 1, 8, 403, 0, null, "IDoc creation date", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("CRETIM", 6, 6, "TIMS", "EDI_CCRTI3", "UZEIT", "IDoc creation time", null, false);
            meta.addInfo("CRETIM", 3, 6, 411, 0, null, "IDoc creation time", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MESTYP", 6, 6, "CHAR", "EDI_MESTP3", "CHAR6", "Logical message type", null, false);
            meta.addInfo("MESTYP", 0, 6, 417, 0, null, "Logical message type", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("IDOCTYP", 8, 8, "CHAR", "EDI_IDCTP3", "CHAR8", "Name of basic type", null, false);
            meta.addInfo("IDOCTYP", 0, 8, 423, 0, null, "Name of basic type", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("CIMTYP", 8, 8, "CHAR", "EDI_CIMTP3", "CHAR8", "Extension", null, false);
            meta.addInfo("CIMTYP", 0, 8, 431, 0, null, "Extension", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPFC", 2, 2, "CHAR", "EDI_RCVPF3", "CHAR2", "Partner function of recipient", null, false);
            meta.addInfo("RCVPFC", 0, 2, 439, 0, null, "Partner function of recipient", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPFC", 2, 2, "CHAR", "EDI_SNDPF3", "CHAR2", "Partner function of sender", null, false);
            meta.addInfo("SNDPFC", 0, 2, 441, 0, null, "Partner function of sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SERIAL", 20, 20, "CHAR", "EDI_SERIA3", "CHAR20", "EDI/ALE: Serialization field", null, false);
            meta.addInfo("SERIAL", 0, 20, 443, 0, null, "EDI/ALE: Serialization field", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("EXPRSS", 1, 1, "CHAR", "EDI_EXPRS3", "CHAR1", "Overriding in inbound processing", null, false);
            meta.addInfo("EXPRSS", 0, 1, 463, 0, null, "Overriding in inbound processing", 0, null, fieldMeta);
            meta.setTabLength(464);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("EDI_DD");
            meta.addInfo("TABNAM", 0, 10, 0, 0, null, "Name of external structure", 0, null, null);
            meta.addInfo("MANDT", 0, 3, 10, 0, null, "Client", 0, null, null);
            meta.addInfo("DOCNUM", 0, 16, 13, 0, null, "IDoc number", 0, null, null);
            meta.addInfo("SEGNUM", 0, 6, 29, 0, null, "Number of SAP segment", 0, null, null);
            meta.addInfo("SEGNAM", 0, 10, 35, 0, null, "Name of SAP segment", 0, null, null);
            meta.addInfo("PSGNUM", 0, 6, 45, 0, null, "Number of the higher-level SAP segment", 0, null, null);
            meta.addInfo("HLEVEL", 0, 2, 51, 0, null, "Hierarchy level of SAP segment", 0, null, null);
            meta.addInfo("DTINT2", 0, 2, 53, 0, null, "Blank field for EDI_DD", 0, null, null);
            meta.addInfo("SDATA", 0, 1000, 55, 0, null, "Application data", 0, null, null);
            meta.setTabLength(1055);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("EDI_DD_WITH_BINARY_DATA");
            meta.addInfo("TABNAM", 0, 10, 0, 0, null, "Name of external structure", 0, null, null);
            meta.addInfo("MANDT", 0, 3, 10, 0, null, "Client", 0, null, null);
            meta.addInfo("DOCNUM", 0, 16, 13, 0, null, "IDoc number", 0, null, null);
            meta.addInfo("SEGNUM", 0, 6, 29, 0, null, "Number of SAP segment", 0, null, null);
            meta.addInfo("SEGNAM", 0, 10, 35, 0, null, "Name of SAP segment", 0, null, null);
            meta.addInfo("PSGNUM", 0, 6, 45, 0, null, "Number of the higher-level SAP segment", 0, null, null);
            meta.addInfo("HLEVEL", 0, 2, 51, 0, null, "Hierarchy level of SAP segment", 0, null, null);
            meta.addInfo("DTINT2", 0, 2, 53, 0, null, "Blank field for EDI_DD", 0, null, null);
            meta.addInfo("SDATA", 4, 1000, 55, 0, null, "Application data", 0, null, null);
            meta.setTabLength(1055);
            this.addStructureDefinitionToCache(meta);
        }

        protected void add_RFC_READ_TABLE() {
            JCO.MetaData meta = new JCO.MetaData("RFC_READ_TABLE");
            meta.addInfo("DELIMITER", 0, 1, 0, 0, "SPACE", "Sign for indicating field limits in DATA", 5, null, null);
            meta.addInfo("NO_DATA", 0, 1, 1, 0, "SPACE", "If <> SPACE, only FIELDS is filled", 5, null, null);
            meta.addInfo("QUERY_TABLE", 0, 30, 2, 0, null, "Table read", 1, null, null);
            meta.addInfo("ROWCOUNT", 8, 4, 32, 0, "0", null, 5, null, null);
            meta.addInfo("ROWSKIPS", 8, 4, 36, 0, "0", null, 5, null, null);
            meta.addInfo("DATA", 99, 4, 0, 0, null, "Data read (out)", 0, "TAB512", null);
            meta.addInfo("FIELDS", 99, 6, 4, 0, null, "Names (in) and structure (out) of fields read", 0, "RFC_DB_FLD", null);
            meta.addInfo("OPTIONS", 99, 7, 10, 0, null, "Selection entries, \"WHERE clauses\" (in)", 0, "RFC_DB_OPT", null);
            meta.addInfo("DATA_BUFFER_EXCEEDED", 98, 0, -1, 0, null, "Selected fields do not fit into structure DATA", 0, null, null);
            meta.addInfo("FIELD_NOT_VALID", 98, 0, -1, 0, null, "Field to be read not in table", 0, null, null);
            meta.addInfo("NOT_AUTHORIZED", 98, 0, -1, 0, null, "User not authorized to access QUERY_TABLE", 0, null, null);
            meta.addInfo("OPTION_NOT_VALID", 98, 0, -1, 0, null, "Selection entries (e.g. syntax) incorrect", 0, null, null);
            meta.addInfo("TABLE_NOT_AVAILABLE", 98, 0, -1, 0, null, "QUERY_TABLE not active in Dictionary", 0, null, null);
            meta.addInfo("TABLE_WITHOUT_DATA", 98, 0, -1, 0, null, "QUERY_TABLE is name of structure", 0, null, null);
            this.addFunctionInterfaceToCache(meta);
            meta = new JCO.MetaData("TAB512");
            meta.addInfo("WA", 0, 512, 0, 0, null, "Character field length 512", 0, null, null);
            meta.setTabLength(512);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("RFC_DB_FLD");
            meta.addInfo("FIELDNAME", 0, 30, 0, 0, null, "Field name", 0, null, null);
            meta.addInfo("OFFSET", 6, 6, 30, 0, null, "Offset of a field in work area", 0, null, null);
            meta.addInfo("LENGTH", 6, 6, 36, 0, null, "Length (no. of characters)", 0, null, null);
            meta.addInfo("TYPE", 0, 1, 42, 0, null, "ABAP data type (C,D,N,...)", 0, null, null);
            meta.addInfo("FIELDTEXT", 0, 60, 43, 0, null, "Short text describing R/3 Repository objects", 0, null, null);
            meta.setTabLength(103);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("RFC_DB_OPT");
            meta.addInfo("TEXT", 0, 72, 0, 0, null, "Text line of a message", 0, null, null);
            meta.setTabLength(72);
            this.addStructureDefinitionToCache(meta);
        }
    }

    private static class JCoStaticRepository31
    extends JCO.BasicRepository
    implements IRepository {
        protected JCoStaticRepository31() {
            this("JCoIDoc.JCoStaticRepository for SAP Release 3.1");
        }

        protected JCoStaticRepository31(String name) {
            super(name);
            this.add_DDIF_FIELDINFO_GET();
            this.add_EDI_IDOC_MERGE_WITH_EXTENSION();
            this.add_EDI_IDOC_SYNTAX_GET();
            this.add_EDI_SEGMENT_DESCRIPTION_GET();
            this.add_EDI_SEGTYP_GET();
            this.add_INBOUND_IDOC_PROCESS();
            this.add_RFC_READ_TABLE();
        }

        protected void add_DDIF_FIELDINFO_GET() {
            JCO.MetaData meta = new JCO.MetaData("DDIF_FIELDINFO_GET");
            meta.addInfo("FIELDNAME", 0, 10, 0, 0, "' '", "Name of field if info only from one field", 5, null, null);
            meta.addInfo("LANGU", 0, 1, 10, 0, "SY-LANGU", "Language of the texts", 5, null, null);
            meta.addInfo("TABNAME", 0, 10, 11, 0, null, "Name of the table for which information is requi", 1, null, null);
            meta.addInfo("X030L_WA", 17, 8, 0, 0, null, "Nametab header of the table", 2, "X030L", null);
            meta.addInfo("DFIES_TAB", 99, 9, 0, 0, null, "Required field information", 0, "DFIES", null);
            meta.addInfo("INTERNAL_ERROR", 98, 0, -1, 0, null, "Internal error occurred", 0, null, null);
            meta.addInfo("NOT_FOUND", 98, 0, -1, 0, null, "Table is not active", 0, null, null);
            this.addFunctionInterfaceToCache(meta);
            meta = new JCO.MetaData("X030L");
            meta.addInfo("TABNAME", 0, 10, 0, 0, null, "Table name", 0, null, null);
            meta.addInfo("CRSTAMP", 0, 14, 10, 0, null, "Time of nametab generation", 0, null, null);
            meta.addInfo("ABSTAMP", 0, 14, 24, 0, null, "ABAP time stamp", 0, null, null);
            meta.addInfo("DYSTAMP", 0, 14, 38, 0, null, "Screen time stamp", 0, null, null);
            meta.addInfo("FLDCNT", 4, 2, 52, 0, null, "Number of table fields", 0, null, null);
            meta.addInfo("TABLEN", 4, 2, 54, 0, null, "Table length in bytes", 0, null, null);
            meta.addInfo("KEYCNT", 4, 1, 56, 0, null, "Number of key fields in table", 0, null, null);
            meta.addInfo("KEYLEN", 4, 1, 57, 0, null, "Length of table key in bytes", 0, null, null);
            meta.addInfo("CLPOS", 4, 1, 58, 0, null, "Position number of the client field in the table", 0, null, null);
            meta.addInfo("TABTYPE", 0, 1, 59, 0, null, "Table type", 0, null, null);
            meta.addInfo("TABFORM", 0, 1, 60, 0, null, "Form in which the table is implemented in the database", 0, null, null);
            meta.addInfo("FLAGBYTE", 4, 1, 61, 0, null, "Flag of length 1 byte for table attributes", 0, null, null);
            meta.addInfo("REFNAME", 0, 10, 62, 0, null, "Name of physical table (for pool/cluster/view)", 0, null, null);
            meta.addInfo("EXROUT", 4, 1, 72, 0, null, "Flag if a table to be compressed", 0, null, null);
            meta.addInfo("BUFSTATE", 0, 1, 73, 0, null, "Buffering type of table", 0, null, null);
            meta.addInfo("BUFPARM", 4, 2, 74, 0, null, "Supplementary information in generic buffering", 0, null, null);
            meta.addInfo("ALIGN", 4, 1, 76, 0, null, "Table alignment", 0, null, null);
            meta.addInfo("DBASE", 0, 1, 77, 0, null, "Internal name for database", 0, null, null);
            meta.setTabLength(78);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("DFIES");
            meta.addInfo("TABNAME", 0, 10, 0, 0, null, "Table name", 0, null, null);
            meta.addInfo("FIELDNAME", 0, 10, 10, 0, null, "Local field name", 0, null, null);
            meta.addInfo("LANGU", 0, 1, 20, 0, null, "Language key", 0, null, null);
            meta.addInfo("POSITION", 6, 4, 21, 0, null, "Position of the field in the table", 0, null, null);
            meta.addInfo("OFFSET", 6, 6, 25, 0, null, "Offset of a field in work area", 0, null, null);
            meta.addInfo("DOMNAME", 0, 10, 31, 0, null, "Domain name", 0, null, null);
            meta.addInfo("ROLLNAME", 0, 10, 41, 0, null, "Data element (semantic domain)", 0, null, null);
            meta.addInfo("CHECKTABLE", 0, 10, 51, 0, null, "Table name", 0, null, null);
            meta.addInfo("LENG", 6, 6, 61, 0, null, "Field length (no. of characters)", 0, null, null);
            meta.addInfo("INTLEN", 6, 6, 67, 0, null, "Internal length in bytes", 0, null, null);
            meta.addInfo("OUTPUTLEN", 6, 6, 73, 0, null, "Output length if no template exists", 0, null, null);
            meta.addInfo("DECIMALS", 6, 6, 79, 0, null, "No. of decimal places", 0, null, null);
            meta.addInfo("DATATYPE", 0, 4, 85, 0, null, "ABAP/4 Dictionary: Screen data type for Screen Painter", 0, null, null);
            meta.addInfo("INTTYPE", 0, 1, 89, 0, null, "ABAP data type (C,D,N,...)", 0, null, null);
            meta.addInfo("REFTABLE", 0, 10, 90, 0, null, "Table for reference field", 0, null, null);
            meta.addInfo("REFFIELD", 0, 10, 100, 0, null, "Reference field for currency and qty fields", 0, null, null);
            meta.addInfo("PRECFIELD", 0, 10, 110, 0, null, "Accuracy field for UNIT fields", 0, null, null);
            meta.addInfo("AUTHORID", 0, 3, 120, 0, null, "Authorization class", 0, null, null);
            meta.addInfo("MEMORYID", 0, 3, 123, 0, null, "SET/GET parameter ID", 0, null, null);
            meta.addInfo("LOGFLAG", 0, 1, 126, 0, null, "Indicator for writing change documents", 0, null, null);
            meta.addInfo("MASK", 0, 20, 127, 0, null, "Template", 0, null, null);
            meta.addInfo("MASKLEN", 6, 4, 147, 0, null, "Template length", 0, null, null);
            meta.addInfo("CONVEXIT", 0, 5, 151, 0, null, "Conversion routine", 0, null, null);
            meta.addInfo("HEADLEN", 6, 2, 156, 0, null, "Maximum length of header", 0, null, null);
            meta.addInfo("SCRLEN1", 6, 2, 158, 0, null, "Max. length for short key word", 0, null, null);
            meta.addInfo("SCRLEN2", 6, 2, 160, 0, null, "Max. length for medium key word", 0, null, null);
            meta.addInfo("SCRLEN3", 6, 2, 162, 0, null, "Max. length for long key word", 0, null, null);
            meta.addInfo("FIELDTEXT", 0, 60, 164, 0, null, "Short text describing ABAP/4 Dictionary objects", 0, null, null);
            meta.addInfo("REPTEXT", 0, 55, 224, 0, null, "Report header", 0, null, null);
            meta.addInfo("SCRTEXT_S", 0, 10, 279, 0, null, "Short key word", 0, null, null);
            meta.addInfo("SCRTEXT_M", 0, 20, 289, 0, null, "Medium key word", 0, null, null);
            meta.addInfo("SCRTEXT_L", 0, 40, 309, 0, null, "Long key word", 0, null, null);
            meta.addInfo("KEYFLAG", 0, 1, 349, 0, null, "ID for a field belonging to the primary key", 0, null, null);
            meta.addInfo("LOWERCASE", 0, 1, 350, 0, null, "Lower case letters allowed/not allowed", 0, null, null);
            meta.addInfo("MAC", 0, 1, 351, 0, null, "Flag (X or blank)", 0, null, null);
            meta.addInfo("GENKEY", 0, 1, 352, 0, null, "Flag (X or blank)", 0, null, null);
            meta.addInfo("NOFORKEY", 0, 1, 353, 0, null, "Flag (X or blank)", 0, null, null);
            meta.addInfo("VALEXI", 0, 1, 354, 0, null, "Existence of fixed values", 0, null, null);
            meta.addInfo("NOAUTHCH", 0, 1, 355, 0, null, "Flag (X or blank)", 0, null, null);
            meta.addInfo("SIGN", 0, 1, 356, 0, null, "Flag for sign in numerical fields", 0, null, null);
            meta.addInfo("DYNPFLD", 0, 1, 357, 0, null, "Flag for screen field", 0, null, null);
            meta.setTabLength(358);
            this.addStructureDefinitionToCache(meta);
        }

        protected void add_EDI_IDOC_SYNTAX_GET() {
            JCO.MetaData meta = new JCO.MetaData("EDI_IDOC_SYNTAX_GET");
            meta.addInfo("DOCTYP", 0, 8, 0, 0, null, "(Basic) IDoc type", 1, null, null);
            meta.addInfo("SYNTAX_TABLE", 99, 12, 0, 0, null, "All entries from EDISYN for this IDoc type", 0, "EDISYN", null);
            meta.addInfo("SYNTAX_NOT_FOUND", 98, 0, -1, 0, null, "No entry in EDISYN found", 0, null, null);
            this.addFunctionInterfaceToCache(meta);
            meta = new JCO.MetaData("EDISYN");
            meta.addInfo("IDOCTYP", 0, 8, 0, 0, null, "Name of basic IDoc type", 0, null, null);
            meta.addInfo("CIMTYP", 0, 8, 8, 0, null, "Name of extension type", 0, null, null);
            meta.addInfo("POSNO", 6, 4, 16, 0, null, "Sequential number of segment in IDoc type", 0, null, null);
            meta.addInfo("SEGTYP", 0, 10, 20, 0, null, "Segment name in IDoc types", 0, null, null);
            meta.addInfo("PARSEG", 0, 10, 30, 0, null, "Name of parent segment", 0, null, null);
            meta.addInfo("PARPNO", 6, 4, 40, 0, null, "Sequential number of parent segment", 0, null, null);
            meta.addInfo("PARFLG", 0, 1, 44, 0, null, "Flag for parent segment: SegmentImpl is parent of a seg. group", 0, null, null);
            meta.addInfo("MUSTFL", 0, 1, 45, 0, null, "Flag: Mandatory", 0, null, null);
            meta.addInfo("OCCMIN", 6, 10, 46, 0, null, "Minimum number of segments in sequence", 0, null, null);
            meta.addInfo("OCCMAX", 6, 10, 56, 0, null, "Maximum number of segments in sequence", 0, null, null);
            meta.addInfo("HLEVEL", 6, 2, 66, 0, null, "Hierarchy level of IDoc type segment", 0, null, null);
            meta.addInfo("DOCTYP", 0, 8, 68, 0, null, "IDoc type", 0, null, null);
            meta.setTabLength(76);
            this.addStructureDefinitionToCache(meta);
        }

        protected void add_EDI_IDOC_MERGE_WITH_EXTENSION() {
            JCO.MetaData meta = new JCO.MetaData("EDI_IDOC_MERGE_WITH_EXTENSION");
            meta.addInfo("CIMTYP", 0, 8, 0, 0, null, "Name of extension type", 1, null, null);
            meta.addInfo("DOCTYP", 0, 8, 8, 0, null, "Name of new IDoc type (combination)", 1, null, null);
            meta.addInfo("IDOCTYP", 0, 8, 16, 0, null, "Basic IDoc type name", 1, null, null);
            meta.addInfo("INT_CIMSYN", 99, 10, 0, 0, null, "Int. table with extension type", 0, "CIMSYN", null);
            meta.addInfo("INT_EDISYN", 99, 10, 10, 0, null, "Combined form (basic IDoc + extension type)", 0, "EDISYN", null);
            meta.addInfo("INT_IDOCSYN", 99, 11, 20, 0, null, "Int. table with basic IDoc type", 0, "IDOCSYN", null);
            this.addFunctionInterfaceToCache(meta);
            meta = new JCO.MetaData("CIMSYN");
            meta.addInfo("CIMTYP", 0, 8, 0, 0, null, "Extension type (customer extension of a basic IDoc type)", 0, null, null);
            meta.addInfo("SEGTYP", 0, 10, 8, 0, null, "Release-independent name of segment in EDI IDoc type", 0, null, null);
            meta.addInfo("NR", 6, 4, 18, 0, null, "Sequential number of segment in IDoc type", 0, null, null);
            meta.addInfo("CIMSTP", 0, 10, 22, 0, null, "Name of segment in extension type", 0, null, null);
            meta.addInfo("PARSEG", 0, 10, 32, 0, null, "Name of parent segment", 0, null, null);
            meta.addInfo("PARPNO", 6, 4, 42, 0, null, "Sequential number of parent segment", 0, null, null);
            meta.addInfo("PARFLG", 0, 1, 46, 0, null, "Flag for parent segment: Segment is parent of a seg. group", 0, null, null);
            meta.addInfo("MUSTFL", 0, 1, 47, 0, null, "Flag: Mandatory", 0, null, null);
            meta.addInfo("OCCMIN", 6, 10, 48, 0, null, "Minimum number of segments in sequence", 0, null, null);
            meta.addInfo("OCCMAX", 6, 10, 58, 0, null, "Maximum number of segments in sequence", 0, null, null);
            meta.addInfo("HLEVEL", 6, 2, 68, 0, null, "Hierarchy level of IDoc type segment", 0, null, null);
            meta.addInfo("IN_SEQ", 0, 1, 70, 0, null, "EDI: Extension at same level or as child", 0, null, null);
            meta.setTabLength(71);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("EDISYN");
            meta.addInfo("IDOCTYP", 0, 8, 0, 0, null, "Name of basic IDoc type", 0, null, null);
            meta.addInfo("CIMTYP", 0, 8, 8, 0, null, "Name of extension type", 0, null, null);
            meta.addInfo("POSNO", 6, 4, 16, 0, null, "Sequential number of segment in IDoc type", 0, null, null);
            meta.addInfo("SEGTYP", 0, 10, 20, 0, null, "Segment name in IDoc types", 0, null, null);
            meta.addInfo("PARSEG", 0, 10, 30, 0, null, "Name of parent segment", 0, null, null);
            meta.addInfo("PARPNO", 6, 4, 40, 0, null, "Sequential number of parent segment", 0, null, null);
            meta.addInfo("PARFLG", 0, 1, 44, 0, null, "Flag for parent segment: SegmentImpl is parent of a seg. group", 0, null, null);
            meta.addInfo("MUSTFL", 0, 1, 45, 0, null, "Flag: Mandatory", 0, null, null);
            meta.addInfo("OCCMIN", 6, 10, 46, 0, null, "Minimum number of segments in sequence", 0, null, null);
            meta.addInfo("OCCMAX", 6, 10, 56, 0, null, "Maximum number of segments in sequence", 0, null, null);
            meta.addInfo("HLEVEL", 6, 2, 66, 0, null, "Hierarchy level of IDoc type segment", 0, null, null);
            meta.addInfo("DOCTYP", 0, 8, 68, 0, null, "IDoc type", 0, null, null);
            meta.setTabLength(76);
            meta = new JCO.MetaData("IDOCSYN");
            meta.addInfo("IDOCTYP", 0, 8, 0, 0, null, "Basic IDoc type", 0, null, null);
            meta.addInfo("NR", 6, 4, 8, 0, null, "Sequential number of segment in IDoc type", 0, null, null);
            meta.addInfo("SEGTYP", 0, 10, 12, 0, null, "Release-independent name of segment in EDI IDoc type", 0, null, null);
            meta.addInfo("PARSEG", 0, 10, 22, 0, null, "Name of parent segment", 0, null, null);
            meta.addInfo("PARPNO", 6, 4, 32, 0, null, "Sequential number of parent segment", 0, null, null);
            meta.addInfo("PARFLG", 0, 1, 36, 0, null, "Flag for parent segment: Segment is parent of a seg. group", 0, null, null);
            meta.addInfo("MUSTFL", 0, 1, 37, 0, null, "Flag: Mandatory", 0, null, null);
            meta.addInfo("OCCMIN", 6, 10, 38, 0, null, "Minimum number of segments in sequence", 0, null, null);
            meta.addInfo("OCCMAX", 6, 10, 48, 0, null, "Maximum number of segments in sequence", 0, null, null);
            meta.addInfo("HLEVEL", 6, 2, 58, 0, null, "Hierarchy level of IDoc type segment", 0, null, null);
            meta.setTabLength(60);
            this.addStructureDefinitionToCache(meta);
        }

        protected void add_EDI_SEGMENT_DESCRIPTION_GET() {
            JCO.MetaData meta = new JCO.MetaData("EDI_SEGMENT_DESCRIPTION_GET");
            meta.addInfo("SEGTYP", 0, 10, 0, 0, null, "Name of segment type", 1, null, null);
            meta.addInfo("LANGUA", 0, 1, 10, 0, "' '", "Description language, default: Logon language", 5, null, null);
            meta.addInfo("DESCRP", 0, 60, 0, 0, null, "Description of segment type", 2, null, null);
            meta.addInfo("NO_DESCRP_FOUND", 98, 0, -1, 0, null, null, 0, null, null);
            this.addFunctionInterfaceToCache(meta);
        }

        protected void add_EDI_SEGTYP_GET() {
            JCO.MetaData meta = new JCO.MetaData("EDI_SEGTYP_GET");
            meta.addInfo("REFRESH_BUFFER", 0, 1, 0, 0, "' '", "Refresh internal buffer", 5, null, null);
            meta.addInfo("RELEASED", 0, 4, 1, 0, "SY-SAPRL", "SAP Release of segment definition to be read", 5, null, null);
            meta.addInfo("SEGTYP", 0, 10, 5, 0, null, "Segment type to be read", 1, null, null);
            meta.addInfo("SEGLEN", 6, 4, 0, 0, null, "Length of segment definition for given version", 2, null, null);
            meta.addInfo("SEGNAM", 0, 10, 4, 0, null, "Name of segm.definition for specified version", 2, null, null);
            meta.addInfo("RELEASE_NOT_FOUND", 98, 0, -1, 0, null, "No segment definition for this SAP Release", 0, null, null);
            meta.addInfo("SEGNAM_EMPTY", 98, 0, -1, 0, null, "Segment name for this segment type is empty", 0, null, null);
            meta.addInfo("SEGTYP_NOT_FOUND", 98, 0, -1, 0, null, "Segment type does not exist", 0, null, null);
            this.addFunctionInterfaceToCache(meta);
        }

        protected void add_INBOUND_IDOC_PROCESS() {
            JCO.MetaData meta = new JCO.MetaData("INBOUND_IDOC_PROCESS");
            meta.addInfo("IDOC_CONTROL", 99, 12, 0, 0, null, "Control records for IDocs passed", 0, "EDI_DC", null);
            meta.addInfo("IDOC_DATA", 99, 9, 12, 0, null, "Data records of the IDoc passed", 0, "EDI_DD", null);
            this.addFunctionInterfaceToCache(meta);
            meta = new JCO.MetaData("INBOUND_IDOC_PROCESS_WITH_BINARY_DATA");
            meta.addInfo("IDOC_CONTROL", 99, 12, 0, 0, null, "Control records for IDocs passed", 0, "EDI_DC", null);
            meta.addInfo("IDOC_DATA", 99, 9, 12, 0, null, "Data records of the IDoc passed", 0, "EDI_DD_WITH_BINARY_DATA", null);
            this.addFunctionInterfaceToCache(meta);
            meta = new JCO.MetaData("EDI_DC");
            JCoFieldMetaData fieldMeta = new JCoFieldMetaData("TABNAM", 10, 10, "CHAR", "EDI_TABNAM", "EDI_DICOBJ", "Name of table structure", null, false);
            meta.addInfo("TABNAM", 0, 10, 0, 0, null, "Name of table structure", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MANDT", 3, 3, "CLNT", "MANDT", "MANDT", "Client", null, false);
            meta.addInfo("MANDT", 0, 3, 10, 0, null, "Client", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("DOCNUM", 16, 16, "CHAR", "EDI_DOCNUC", "EDI_CHAR16", "IDoc number", null, false);
            meta.addInfo("DOCNUM", 0, 16, 13, 0, null, "IDoc number", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("DOCREL", 4, 4, "CHAR", "EDI_DOCREL", "SAPRL", "SAP Release of IDoc", null, false);
            meta.addInfo("DOCREL", 0, 4, 29, 0, null, "SAP Release of IDoc", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STATUS", 2, 2, "CHAR", "EDI_STATUS", "EDI_STATUS", "Status of IDoc", null, false);
            meta.addInfo("STATUS", 0, 2, 33, 0, null, "Status of IDoc", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("DOCTYP", 8, 8, "CHAR", "EDI_DOCTYP", "EDI_DOCTYP", "IDoc type", null, false);
            meta.addInfo("DOCTYP", 0, 8, 35, 0, null, "IDoc type", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("DIRECT", 1, 1, "CHAR", "EDI_DIRECT", "EDI_DIRECT", "Direction", null, false);
            meta.addInfo("DIRECT", 0, 1, 43, 0, null, "Direction", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPOR", 10, 10, "CHAR", "EDI_RCVPOR", "EDI_PORT", "Receiver port (SAP System, EDI subsystem)", null, false);
            meta.addInfo("RCVPOR", 0, 10, 44, 0, null, "Receiver port (SAP System, EDI subsystem)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPRT", 2, 2, "CHAR", "EDI_RCVPRT", "EDI_PARTYP", "Partner type of receiver", null, false);
            meta.addInfo("RCVPRT", 0, 2, 54, 0, null, "Partner type of receiver", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPRN", 10, 10, "CHAR", "EDI_RCVPRN", "EDI_PARNUM", "Partner number of receiver", null, false);
            meta.addInfo("RCVPRN", 0, 10, 56, 0, null, "Partner number of receiver", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVSAD", 21, 21, "CHAR", "EDI_SADR", "CHAR21", "EDI: SADR fields in total", null, false);
            meta.addInfo("RCVSAD", 0, 21, 66, 0, null, "EDI: SADR fields in total", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVLAD", 70, 70, "CHAR", "EDI_RCVLAD", "EDI_LOGADR", "Logical address of receiver", null, false);
            meta.addInfo("RCVLAD", 0, 70, 87, 0, null, "Logical address of receiver", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STD", 1, 1, "CHAR", "EDI_STD", "EDI_STD", "EDI standard", null, false);
            meta.addInfo("STD", 0, 1, 157, 0, null, "EDI standard", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STDVRS", 6, 6, "CHAR", "EDI_STDVRS", "EDI_STDVRS", "Version of EDI standard", null, false);
            meta.addInfo("STDVRS", 0, 6, 158, 0, null, "Version of EDI standard", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("STDMES", 6, 6, "CHAR", "EDI_STDMES", "EDI_STDMES", "EDI message type", null, false);
            meta.addInfo("STDMES", 0, 6, 164, 0, null, "EDI message type", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MESCOD", 3, 3, "CHAR", "EDI_MESCOD", "EDI_MESCOD", "Logical message code", null, false);
            meta.addInfo("MESCOD", 0, 3, 170, 0, null, "Logical message code", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MESFCT", 3, 3, "CHAR", "EDI_MESFCT", "EDI_MESFCT", "Logical message function", null, false);
            meta.addInfo("MESFCT", 0, 3, 173, 0, null, "Logical message function", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("OUTMOD", 1, 1, "CHAR", "EDI_OUTMOD", "EDI_OUTMOD", "Output mode", null, false);
            meta.addInfo("OUTMOD", 0, 1, 176, 0, null, "Output mode", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("TEST", 1, 1, "CHAR", "EDI_TEST", "EDI_TEST", "Test flag", null, false);
            meta.addInfo("TEST", 0, 1, 177, 0, null, "Test flag", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPOR", 10, 10, "CHAR", "EDI_SNDPOR", "EDI_PORT", "Sender port (SAP System, EDI subsystem)", null, false);
            meta.addInfo("SNDPOR", 0, 10, 178, 0, null, "Sender port (SAP System, EDI subsystem)", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPRT", 2, 2, "CHAR", "EDI_SNDPRT", "EDI_PARTYP", "Partner type of sender", null, false);
            meta.addInfo("SNDPRT", 0, 2, 188, 0, null, "Partner type of sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPRN", 10, 10, "CHAR", "EDI_SNDPRN", "EDI_PARNUM", "Partner number of sender", null, false);
            meta.addInfo("SNDPRN", 0, 10, 190, 0, null, "Partner number of sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDSAD", 21, 21, "CHAR", "EDI_SADR", "CHAR21", "EDI: SADR fields in total", null, false);
            meta.addInfo("SNDSAD", 0, 21, 200, 0, null, "EDI: SADR fields in total", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDLAD", 70, 70, "CHAR", "EDI_SNDLAD", "EDI_LOGADR", "Logical address of sender", null, false);
            meta.addInfo("SNDLAD", 0, 70, 221, 0, null, "Logical address of sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("REFINT", 14, 14, "CHAR", "IDOCCRFINT", "EDI_REFNUM", "Reference to interchange file", null, false);
            meta.addInfo("REFINT", 0, 14, 291, 0, null, "Reference to interchange file", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("REFGRP", 14, 14, "CHAR", "IDOCCRFGRP", "EDI_REFNUM", "Reference to message group", null, false);
            meta.addInfo("REFGRP", 0, 14, 305, 0, null, "Reference to message group", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("REFMES", 14, 14, "CHAR", "IDOCCRFMES", "EDI_REFNUM", "Reference to message", null, false);
            meta.addInfo("REFMES", 0, 14, 319, 0, null, "Reference to message", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("ARCKEY", 70, 70, "CHAR", "IDOCCARKEY", "EDI_ARCKEY", "EDI archive key", null, false);
            meta.addInfo("ARCKEY", 0, 70, 333, 0, null, "EDI archive key", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("CREDAT", 8, 8, "DATS", "EDI_CCRDAT", "DATUM", "Date IDoc was created", null, false);
            meta.addInfo("CREDAT", 1, 8, 403, 0, null, "Date IDoc was created", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("CRETIM", 6, 6, "TIMS", "EDI_CCRTIM", "UZEIT", "Time IDoc was created", null, false);
            meta.addInfo("CRETIM", 3, 6, 411, 0, null, "Time IDoc was created", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("MESTYP", 6, 6, "CHAR", "EDI_MESTYP", "EDI_MESTYP", "Logical message type", null, false);
            meta.addInfo("MESTYP", 0, 6, 417, 0, null, "Logical message type", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("IDOCTYP", 8, 8, "CHAR", "EDI_IDOCTP", "EDI_DOCTYP", "Name of basic IDoc type", null, false);
            meta.addInfo("IDOCTYP", 0, 8, 423, 0, null, "Name of basic IDoc type", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("CIMTYP", 8, 8, "CHAR", "EDI_CIMTYP", "EDI_CIMTYP", "Name of extension type", null, false);
            meta.addInfo("CIMTYP", 0, 8, 431, 0, null, "Name of extension type", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("RCVPFC", 2, 2, "CHAR", "EDI_RCVPFC", "EDI_PARVW", "Partner function of receiver", null, false);
            meta.addInfo("RCVPFC", 0, 2, 439, 0, null, "Partner function of receiver", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SNDPFC", 2, 2, "CHAR", "EDI_SNDPFC", "EDI_PARVW", "Partner function of sender", null, false);
            meta.addInfo("SNDPFC", 0, 2, 441, 0, null, "Partner function of sender", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("SERIAL", 20, 20, "CHAR", "EDI_SERIAL", "CHAR20", "EDI/ALE: Serialization field", null, false);
            meta.addInfo("SERIAL", 0, 20, 443, 0, null, "EDI/ALE: Serialization field", 0, null, fieldMeta);
            fieldMeta = new JCoFieldMetaData("EXPRSS", 1, 1, "CHAR", "EDI_EXPRSS", "EDI_EXPRSS", "Overriding in inbound processing", null, false);
            meta.addInfo("EXPRSS", 0, 1, 463, 0, null, "Overriding in inbound processing", 0, null, fieldMeta);
            meta.setTabLength(464);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("EDI_DD");
            meta.addInfo("TABNAM", 0, 10, 0, 0, null, "Name of table structure", 0, null, null);
            meta.addInfo("MANDT", 0, 3, 10, 0, null, "Client", 0, null, null);
            meta.addInfo("DOCNUM", 0, 16, 13, 0, null, "IDoc number", 0, null, null);
            meta.addInfo("SEGNUM", 0, 6, 29, 0, null, "Number of SAP segment", 0, null, null);
            meta.addInfo("SEGNAM", 0, 10, 35, 0, null, "Name of SAP segment", 0, null, null);
            meta.addInfo("PSGNUM", 0, 6, 45, 0, null, "Number of the higher-level SAP segment", 0, null, null);
            meta.addInfo("HLEVEL", 0, 2, 51, 0, null, "Hierarchy level of SAP segment", 0, null, null);
            meta.addInfo("DTINT2", 0, 2, 53, 0, null, "Blank field for EDI_DD", 0, null, null);
            meta.addInfo("SDATA", 0, 1000, 55, 0, null, "Application data", 0, null, null);
            meta.setTabLength(1055);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("EDI_DD_WITH_BINARY_DATA");
            meta.addInfo("TABNAM", 0, 10, 0, 0, null, "Name of table structure", 0, null, null);
            meta.addInfo("MANDT", 0, 3, 10, 0, null, "Client", 0, null, null);
            meta.addInfo("DOCNUM", 0, 16, 13, 0, null, "IDoc number", 0, null, null);
            meta.addInfo("SEGNUM", 0, 6, 29, 0, null, "Number of SAP segment", 0, null, null);
            meta.addInfo("SEGNAM", 0, 10, 35, 0, null, "Name of SAP segment", 0, null, null);
            meta.addInfo("PSGNUM", 0, 6, 45, 0, null, "Number of the higher-level SAP segment", 0, null, null);
            meta.addInfo("HLEVEL", 0, 2, 51, 0, null, "Hierarchy level of SAP segment", 0, null, null);
            meta.addInfo("DTINT2", 0, 2, 53, 0, null, "Blank field for EDI_DD", 0, null, null);
            meta.addInfo("SDATA", 4, 1000, 55, 0, null, "Application data", 0, null, null);
            meta.setTabLength(1055);
            this.addStructureDefinitionToCache(meta);
        }

        protected void add_RFC_READ_TABLE() {
            JCO.MetaData meta = new JCO.MetaData("RFC_READ_TABLE");
            meta.addInfo("DELIMITER", 0, 1, 0, 0, "SPACE", "Sign for indicating field limits in DATA", 5, null, null);
            meta.addInfo("NO_DATA", 0, 1, 1, 0, "SPACE", "If <> SPACE, only FIELDS is filled", 5, null, null);
            meta.addInfo("QUERY_TABLE", 0, 10, 2, 0, null, "Table read", 1, null, null);
            meta.addInfo("ROWCOUNT", 8, 4, 12, 0, "0", null, 5, null, null);
            meta.addInfo("ROWSKIPS", 8, 4, 16, 0, "0", null, 5, null, null);
            meta.addInfo("DATA", 99, 4, 0, 0, null, "Data read (out)", 0, "TAB512", null);
            meta.addInfo("FIELDS", 99, 6, 4, 0, null, "Names (in) and structure (out) of fields read", 0, "RFC_DB_FLD", null);
            meta.addInfo("OPTIONS", 99, 7, 10, 0, null, "Selection entries, \"WHERE clauses\" (in)", 0, "RFC_DB_OPT", null);
            meta.addInfo("DATA_BUFFER_EXCEEDED", 98, 0, -1, 0, null, "Selected fields do not fit into structure DATA", 0, null, null);
            meta.addInfo("FIELD_NOT_VALID", 98, 0, -1, 0, null, "Field to be read not in table", 0, null, null);
            meta.addInfo("NOT_AUTHORIZED", 98, 0, -1, 0, null, "User not authorized to access QUERY_TABLE", 0, null, null);
            meta.addInfo("OPTION_NOT_VALID", 98, 0, -1, 0, null, "Selection entries (e.g. syntax) incorrect", 0, null, null);
            meta.addInfo("TABLE_NOT_AVAILABLE", 98, 0, -1, 0, null, "QUERY_TABLE not active in Dictionary", 0, null, null);
            meta.addInfo("TABLE_WITHOUT_DATA", 98, 0, -1, 0, null, "QUERY_TABLE is name of structure", 0, null, null);
            this.addFunctionInterfaceToCache(meta);
            meta = new JCO.MetaData("TAB512");
            meta.addInfo("WA", 0, 512, 0, 0, null, "Character field length 512", 0, null, null);
            meta.setTabLength(512);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("RFC_DB_FLD");
            meta.addInfo("FIELDNAME", 0, 10, 0, 0, null, "Field name", 0, null, null);
            meta.addInfo("OFFSET", 6, 6, 10, 0, null, "Offset of a field in work area", 0, null, null);
            meta.addInfo("LENGTH", 6, 6, 16, 0, null, "Length (no. of characters)", 0, null, null);
            meta.addInfo("TYPE", 0, 1, 22, 0, null, "ABAP data type (C,D,N,...)", 0, null, null);
            meta.addInfo("FIELDTEXT", 0, 60, 23, 0, null, "Short text describing R/3 Repository objects", 0, null, null);
            meta.setTabLength(83);
            this.addStructureDefinitionToCache(meta);
            meta = new JCO.MetaData("RFC_DB_OPT");
            meta.addInfo("TEXT", 0, 72, 0, 0, null, "Text line of a message", 0, null, null);
            meta.setTabLength(72);
            this.addStructureDefinitionToCache(meta);
        }
    }

    public static class JCoFieldMetaData
    extends IDoc.FieldMetaData
    implements IExtendedFieldMetaData {
        private static final long serialVersionUID = 1000L;

        public JCoFieldMetaData(String fieldName, int internalLength, int outputLength, String dataTypeName, String dataElementName, String domainName, String description, String checkTableName, boolean isISOCode) {
            super(fieldName, internalLength, outputLength, dataTypeName, dataElementName, domainName, description, checkTableName, isISOCode);
        }
    }

    public static class JCoDocumentList
    extends IDoc.BasicDocumentList
    implements JCO.IDocument {
        private static final long serialVersionUID = 1000L;
        protected IDoc.Repository m_repository = null;

        protected JCoDocumentList(IDoc.Repository repository) {
            if (repository == null) {
                throw new NullPointerException("repository == null");
            }
            this.m_repository = repository;
        }

        protected JCoDocumentList(IDoc.Repository repository, JCO.Table controlTable, JCO.Table dataTable, String binaryDataCharset) {
            if (repository == null) {
                throw new NullPointerException("repository == null");
            }
            this.m_repository = repository;
            if (controlTable == null || dataTable == null) {
                return;
            }
            int size = controlTable.getNumRows();
            this.m_list = new ObjectList(size, 20);
            JCoDocument document = null;
            int rowIndexDataTable = 0;
            int i = 0;
            while (i < size) {
                document = new JCoDocument(this.m_repository, controlTable, i, dataTable, rowIndexDataTable, binaryDataCharset);
                this.m_list.add(document);
                rowIndexDataTable += document.getNumSegments() - 1;
                ++i;
            }
        }

        public boolean add(IDoc.Document document) {
            if (document == null) {
                throw new NullPointerException("document == null");
            }
            if (this.m_repository != null) {
                IDoc.SegmentMetaData rootSegmentMetaData = document.getRootSegment().getSegmentMetaData();
                if (rootSegmentMetaData != null) {
                    IDoc.SegmentMetaData repSegmentMetaData = this.m_repository.getRootSegmentMetaData(rootSegmentMetaData.getIDocType(), rootSegmentMetaData.getIDocTypeExtension(), rootSegmentMetaData.getSystemRelease(), rootSegmentMetaData.getApplicationRelease());
                    if (!rootSegmentMetaData.equals(repSegmentMetaData)) {
                        throw new IDoc.Exception(3, "The document does not correspond to the associated repository.");
                    }
                } else {
                    throw new IDoc.Exception(3, "The document does not correspond to the associated repository.");
                }
            }
            return this.m_list.add(document);
        }

        public IDoc.Document addDocument(String iDocType) {
            JCoDocument document = new JCoDocument(this.m_repository, iDocType, null, null, null);
            this.m_list.add(document);
            return document;
        }

        public IDoc.Document addDocument(String iDocType, String iDocTypeExtension) {
            JCoDocument document = new JCoDocument(this.m_repository, iDocType, iDocTypeExtension, null, null);
            this.m_list.add(document);
            return document;
        }

        public IDoc.Document addDocument(String iDocType, String iDocTypeExtension, String systemRelease) {
            JCoDocument document = new JCoDocument(this.m_repository, iDocType, iDocTypeExtension, systemRelease, null);
            this.m_list.add(document);
            return document;
        }

        public IDoc.Document addDocument(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
            JCoDocument document = new JCoDocument(this.m_repository, iDocType, iDocTypeExtension, systemRelease, applicationRelease);
            this.m_list.add(document);
            return document;
        }

        protected IDoc.Document addDocument(String controlStructName, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
            JCoDocument document = new JCoDocument(controlStructName, this.m_repository, iDocType, iDocTypeExtension, systemRelease, applicationRelease);
            this.m_list.add(document);
            return document;
        }

        protected JCO.Function createJCoFunction(JCO.Client client, char iDocVersion, int options) {
            JCO.Function function = null;
            JCO.Attributes attributes = null;
            String systemRelease = null;
            boolean isUnicode = false;
            if (client != null) {
                attributes = client.getAttributes();
                systemRelease = attributes.getPartnerRelease();
                isUnicode = JCoIDoc.isPartnerSystemUnicode(attributes);
            }
            if (iDocVersion != '0' && iDocVersion != '2' && iDocVersion != '3') {
                iDocVersion = (char)48;
            }
            IRepository jcoStaticRepository = JCoIDoc.getJCoStaticRepository(systemRelease, isUnicode);
            if (!(systemRelease != null && systemRelease.length() != 0 && systemRelease.compareTo("4") < 0 || iDocVersion != '0' && iDocVersion != '3')) {
                JCoTable controlTable = null;
                JCoTable dataTable = null;
                String iDocNumber = null;
                String codepage = null;
                controlTable = new JCoTable(jcoStaticRepository.getStructureDefinition("EDI_DC40"));
                if (isUnicode || attributes == null || attributes.getOwnBytesPerChar() <= 1) {
                    dataTable = new JCoTable(jcoStaticRepository.getStructureDefinition("EDI_DD40"));
                } else {
                    codepage = attributes.getPartnerCodepage();
                    dataTable = new JCoTable(jcoStaticRepository.getStructureDefinition("EDI_DD40_WITH_BINARY_DATA"));
                }
                IDoc.Document[] documents = this.toArray();
                int i = 0;
                while (i < documents.length) {
                    if (documents[i].getNumSegments() > 1) {
                        iDocNumber = JCoDocument.createJCoIDocNumber(documents[i]);
                        if (documents[i] instanceof JCoDocument) {
                            ((JCoDocument)documents[i]).appendRowToJCoControlTable(controlTable, iDocNumber);
                        } else {
                            JCoDocument.appendRowToJCoControlTable(controlTable, documents[i], iDocNumber);
                        }
                        JCoDocument.appendRowsToJCoDataTable(dataTable, documents[i], iDocNumber, codepage);
                    }
                    ++i;
                }
                JCO.ParameterList tableParameterList = new JCO.ParameterList();
                tableParameterList.appendValue("IDOC_CONTROL_REC_40", controlTable);
                tableParameterList.appendValue("IDOC_DATA_REC_40", dataTable);
                function = new JCO.Function("IDOC_INBOUND_ASYNCHRONOUS", null, null, tableParameterList);
            } else {
                JCoTable controlTable = null;
                JCoTable dataTable = null;
                String iDocNumber = null;
                String codepage = null;
                controlTable = new JCoTable(jcoStaticRepository.getStructureDefinition("EDI_DC"));
                if (isUnicode || attributes == null || attributes.getOwnBytesPerChar() <= 1) {
                    dataTable = new JCoTable(jcoStaticRepository.getStructureDefinition("EDI_DD"));
                } else {
                    codepage = attributes.getPartnerCodepage();
                    dataTable = new JCoTable(jcoStaticRepository.getStructureDefinition("EDI_DD_WITH_BINARY_DATA"));
                }
                IDoc.Document[] documents = this.toArray();
                int i = 0;
                while (i < documents.length) {
                    if (documents[i].getNumSegments() > 1) {
                        iDocNumber = JCoDocument.createJCoIDocNumber(documents[i]);
                        if (documents[i] instanceof JCoDocument) {
                            ((JCoDocument)documents[i]).appendRowToJCoControlTable(controlTable, iDocNumber);
                        } else {
                            JCoDocument.appendRowToJCoControlTable(controlTable, documents[i], iDocNumber);
                        }
                        JCoDocument.appendRowsToJCoDataTable(dataTable, documents[i], iDocNumber, codepage);
                    }
                    ++i;
                }
                JCO.ParameterList tableParameterList = new JCO.ParameterList();
                tableParameterList.appendValue("IDOC_CONTROL", controlTable);
                tableParameterList.appendValue("IDOC_DATA", dataTable);
                function = new JCO.Function("INBOUND_IDOC_PROCESS", null, null, tableParameterList);
            }
            return function;
        }

        public IDoc.Repository getRepository() {
            return this.m_repository;
        }

        public void send(JCO.Client client, String tid, String queueName, int queuePos, char iDocVersion, int options) {
            client.execute(this.createJCoFunction(client, iDocVersion, options), tid, queueName, queuePos);
        }

        public String toXML() {
            return JCoRecord.XMLWriter.createXMLDocument(this, null);
        }

        public String toXML(String release) {
            return JCoRecord.XMLWriter.createXMLDocument(this, release);
        }

        public void writeXML(OutputStreamWriter writer) {
            PrintWriter os = null;
            os = new PrintWriter(writer);
            os.print("<?xml version=\"1.0\" ");
            String encoding = CharacterEncoding.mapJavaToXMLEncoding(writer.getEncoding());
            if (encoding != null) {
                if (!(encoding.equals("UTF-8") || encoding.equals("UTF-16") || encoding.equals("US-ASCII"))) {
                    os.print("encoding=\"" + encoding + "\" ");
                }
            } else {
                encoding = writer.getEncoding().toLowerCase(Locale.ENGLISH);
                if (!(encoding.startsWith("utf") && (encoding.endsWith("8") || encoding.endsWith("16")) || encoding.indexOf("ascii") >= 0)) {
                    os.print("encoding=\"" + writer.getEncoding() + "\" ");
                }
            }
            os.println("?>");
            os.println(this.toXML());
            os.flush();
            os.close();
        }
    }

    public static class JCoDocument
    extends JCoRecord
    implements IDoc.Document,
    JCO.IDocument {
        private static final long serialVersionUID = 1000L;
        private int m_controlStructVersion = 0;
        protected JCoSegment m_rootSegment = null;
        protected String m_iDocCompoundType = null;
        protected static transient Int m_greatestJCoIDocNumber = new Int(0);

        protected JCoDocument(IDoc.Repository repository, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
            this(systemRelease != null && systemRelease.length() > 0 ? (JCoIDoc.access$001(systemRelease).compareTo("4") >= 0 ? "EDI_DC40" : "EDI_DC") : "EDI_DC40", repository, iDocType, iDocTypeExtension, systemRelease, applicationRelease);
        }

        protected JCoDocument(String controlStructName, IDoc.Repository repository, String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
            super(JCoIDoc.getJCoStaticRepository(systemRelease, false).getStructureDefinition(controlStructName));
            if ("EDI_DC40".equals(controlStructName)) {
                this.m_controlStructVersion = 40;
                this.setTableStructureName("EDI_DC40");
            } else if ("EDI_DC".equals(controlStructName)) {
                this.m_controlStructVersion = 31;
                this.setTableStructureName("EDI_DC");
            }
            IDoc.SegmentMetaData rootSegmentMetaData = repository.getRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
            if (rootSegmentMetaData == null) {
                throw new IDoc.Exception(2, "The meta data for the IDoc type \"" + iDocType + "\" " + (iDocTypeExtension != null && iDocTypeExtension.length() > 0 ? "with extension \"" + iDocTypeExtension + "\" " : "") + (systemRelease != null && systemRelease.length() > 0 ? "for system release \"" + systemRelease + "\" " : "") + (applicationRelease != null && applicationRelease.length() > 0 ? "and application release \"" + applicationRelease + "\" " : "") + "is unavailable.");
            }
            this.m_rootSegment = new JCoSegment(this, rootSegmentMetaData, false);
            iDocType = rootSegmentMetaData.getIDocType();
            iDocTypeExtension = rootSegmentMetaData.getIDocTypeExtension();
            this.setIDocType(iDocType);
            this.setIDocTypeExtension(iDocTypeExtension);
            if ((this.m_controlStructVersion == 31 || systemRelease != null && systemRelease.compareTo("4") < 0) && repository instanceof SAPRepository) {
                this.setIDocCompoundType(((SAPRepository)repository).getIDocCompoundType(iDocType, iDocTypeExtension, null));
            }
            Date timestamp = new Date();
            this.setCreationDate(timestamp);
            this.setCreationTime(timestamp);
        }

        protected JCoDocument(IDoc.Repository repository, JCO.Table tabControl, int idxTabControl, JCO.Table tabData, int idxTabData, String binaryDataCharset) {
            super(tabControl, idxTabControl);
            if ("EDI_DC40".equals(this.getName())) {
                this.m_controlStructVersion = 40;
            } else if ("EDI_DC".equals(this.getName())) {
                this.m_controlStructVersion = 31;
            }
            String dataStructName = tabData.getName();
            int dataStructVersion = 0;
            if ("EDI_DD40".equals(dataStructName) || "EDI_DD40_WITH_BINARY_DATA".equals(dataStructName)) {
                dataStructVersion = 40;
            } else if ("EDI_DD".equals(dataStructName) || "EDI_DD_WITH_BINARY_DATA".equals(dataStructName)) {
                dataStructVersion = 31;
            }
            IDoc.SegmentMetaData rootSegmentMetaData = repository.getRootSegmentMetaData(this.getIDocType(), this.getIDocTypeExtension(), null, null);
            if (rootSegmentMetaData == null) {
                throw new IDoc.Exception(2, "The meta data for the IDoc type \"" + this.getIDocType() + "\" " + (this.getIDocTypeExtension().length() > 0 ? "with extension \"" + this.getIDocTypeExtension() + "\" " : "") + "is unavailable.");
            }
            this.m_rootSegment = new JCoSegment(this, rootSegmentMetaData, false);
            JCO.Table table = tabData;
            synchronized (table) {
                tabData.setRow(idxTabData);
                String iDocNumber = this.getIDocNumber();
                String segmentIDocNumber = null;
                switch (dataStructVersion) {
                    case 40: {
                        segmentIDocNumber = tabData.getString(2);
                        break;
                    }
                    case 31: {
                        segmentIDocNumber = tabData.getString(2);
                        break;
                    }
                    default: {
                        segmentIDocNumber = tabData.getString("DOCNUM");
                    }
                }
                if (!iDocNumber.equals(segmentIDocNumber)) {
                    throw new IDoc.Exception(0, "IDoc no. " + iDocNumber + " of control table row " + idxTabControl + " does not match " + "IDoc no. " + segmentIDocNumber + " of data table row " + idxTabData + ".");
                }
                JCoSegment segment = null;
                JCoSegment parentSegment = null;
                IDoc.SegmentMetaData segmentMetaData = null;
                Hashtable<String, JCoSegment> segments = new Hashtable<String, JCoSegment>(101);
                segments.put("000000", this.m_rootSegment);
                String segmentName = null;
                String segmentNumber = null;
                String parentSegmentNumber = null;
                String segmentDataString = null;
                byte[] segmentDataByteArray = null;
                do {
                    switch (dataStructVersion) {
                        case 40: {
                            segmentName = tabData.getString(0);
                            segmentNumber = tabData.getString(3);
                            parentSegmentNumber = tabData.getString(4);
                            if (tabData.getType(6) == 4) {
                                segmentDataByteArray = tabData.getByteArray(6);
                                break;
                            }
                            segmentDataString = tabData.getString(6);
                            break;
                        }
                        case 31: {
                            segmentName = tabData.getString(4);
                            segmentNumber = tabData.getString(3);
                            parentSegmentNumber = tabData.getString(5);
                            if (tabData.getType(8) == 4) {
                                segmentDataByteArray = tabData.getByteArray(8);
                                break;
                            }
                            segmentDataString = tabData.getString(8);
                            break;
                        }
                        default: {
                            segmentName = tabData.getString("SEGNAM");
                            segmentNumber = tabData.getString("SEGNUM");
                            parentSegmentNumber = tabData.getString("PSGNUM");
                            if (tabData.getType("SDATA") == 4) {
                                segmentDataByteArray = tabData.getByteArray("SDATA");
                                break;
                            }
                            segmentDataString = tabData.getString("SDATA");
                        }
                    }
                    parentSegment = (JCoSegment)segments.get(parentSegmentNumber);
                    segmentMetaData = parentSegment.getSegmentMetaData().getChildMatchingDefinition(segmentName);
                    if (segmentMetaData == null) {
                        throw new IDoc.Exception(2, "Matching meta data for segment definition \"" + segmentName + "\" not found " + "when processing IDoc no. " + iDocNumber + " of type \"" + this.getIDocType() + "\" " + (this.getIDocTypeExtension().length() > 0 ? "with extension \"" + this.getIDocTypeExtension() + "\"." : "."));
                    }
                    segment = segmentDataString != null ? new JCoSegment(this, segmentMetaData, false, segmentDataString) : new JCoSegment(this, segmentMetaData, false, segmentDataByteArray, binaryDataCharset);
                    segments.put(segmentNumber, segment);
                    parentSegment.addChild(segment);
                    if (tabData.nextRow()) {
                        switch (dataStructVersion) {
                            case 40: {
                                segmentIDocNumber = tabData.getString(2);
                                break;
                            }
                            case 31: {
                                segmentIDocNumber = tabData.getString(2);
                                break;
                            }
                            default: {
                                segmentIDocNumber = tabData.getString("DOCNUM");
                                break;
                            }
                        }
                        continue;
                    }
                    segmentIDocNumber = null;
                } while (iDocNumber.equals(segmentIDocNumber));
            }
        }

        private static int appendChildRowsToJCoDataTable31(JCoTable table, String client, String iDocNumber, IDoc.Segment parent, int parentSegmentNumber, String binaryDataCharset) {
            IDoc.Segment segment = null;
            int segmentNumber = parentSegmentNumber;
            int numChilds = parent.getNumChildren();
            String str = null;
            StringBuffer strBuf = new StringBuffer(6);
            int i = 0;
            while (i < numChilds) {
                segment = parent.getChild(i);
                table.appendRow();
                table.setValue("EDI_DD", 0);
                table.setValue(client, 1);
                table.setValue(iDocNumber, 2);
                str = Integer.toString(++segmentNumber);
                strBuf.append(ZERO_CHARARRAY, 0, 6 - str.length());
                strBuf.append(str);
                table.setValue(strBuf.toString(), 3);
                strBuf.setLength(0);
                table.setValue(segment.getName(), 4);
                str = Integer.toString(parentSegmentNumber);
                strBuf.append(ZERO_CHARARRAY, 0, 6 - str.length());
                strBuf.append(str);
                table.setValue(strBuf.toString(), 5);
                strBuf.setLength(0);
                str = Integer.toString(segment.getHierarchyLevel());
                strBuf.append(ZERO_CHARARRAY, 0, 2 - str.length());
                strBuf.append(str);
                table.setValue(strBuf.toString(), 6);
                strBuf.setLength(0);
                table.setValue("", 7);
                if (segment instanceof JCoSegment) {
                    if (table.getType(8) == 4) {
                        ((JCoSegment)segment).copyDataToByteArray(table.getDataBuffer(), table.getDataBufferOffset(8), table.getDataBufferLength(8), binaryDataCharset);
                    } else {
                        ((JCoSegment)segment).copyDataToCharArray(table.getDataBuffer(), table.getDataBufferOffset(8), table.getDataBufferLength(8));
                    }
                } else if (table.getType(8) == 4) {
                    JCoIDoc.copySegmentDataToByteArray(segment, table.getDataBuffer(), table.getDataBufferOffset(8), table.getDataBufferLength(8), binaryDataCharset);
                } else {
                    JCoIDoc.access$301(segment, table.getDataBuffer(), table.getDataBufferOffset(8), table.getDataBufferLength(8));
                }
                if (segment.getNumChildren() > 0) {
                    segmentNumber = JCoDocument.appendChildRowsToJCoDataTable31(table, client, iDocNumber, segment, segmentNumber, binaryDataCharset);
                }
                ++i;
            }
            return segmentNumber;
        }

        private static int appendChildRowsToJCoDataTable40(JCoTable table, String client, String iDocNumber, IDoc.Segment parent, int parentSegmentNumber, String binaryDataCharset) {
            IDoc.Segment segment = null;
            int segmentNumber = parentSegmentNumber;
            int numChilds = parent.getNumChildren();
            String str = null;
            StringBuffer strBuf = new StringBuffer(6);
            int i = 0;
            while (i < numChilds) {
                segment = parent.getChild(i);
                table.appendRow();
                table.setValue(segment.getName(), 0);
                table.setValue(client, 1);
                table.setValue(iDocNumber, 2);
                str = Integer.toString(++segmentNumber);
                strBuf.append(ZERO_CHARARRAY, 0, 6 - str.length());
                strBuf.append(str);
                table.setValue(strBuf.toString(), 3);
                strBuf.setLength(0);
                table.setValue(parentSegmentNumber, 4);
                str = Integer.toString(segment.getHierarchyLevel());
                strBuf.append(ZERO_CHARARRAY, 0, 2 - str.length());
                strBuf.append(str);
                table.setValue(strBuf.toString(), 5);
                strBuf.setLength(0);
                if (segment instanceof JCoSegment) {
                    if (table.getType(6) == 4) {
                        ((JCoSegment)segment).copyDataToByteArray(table.getDataBuffer(), table.getDataBufferOffset(6), table.getDataBufferLength(6), binaryDataCharset);
                    } else {
                        ((JCoSegment)segment).copyDataToCharArray(table.getDataBuffer(), table.getDataBufferOffset(6), table.getDataBufferLength(6));
                    }
                } else if (table.getType(6) == 4) {
                    JCoIDoc.copySegmentDataToByteArray(segment, table.getDataBuffer(), table.getDataBufferOffset(6), table.getDataBufferLength(6), binaryDataCharset);
                } else {
                    JCoIDoc.access$401(segment, table.getDataBuffer(), table.getDataBufferOffset(6), table.getDataBufferLength(6));
                }
                if (segment.getNumChildren() > 0) {
                    segmentNumber = JCoDocument.appendChildRowsToJCoDataTable40(table, client, iDocNumber, segment, segmentNumber, binaryDataCharset);
                }
                ++i;
            }
            return segmentNumber;
        }

        protected static boolean appendRowsToJCoDataTable(JCoTable table, IDoc.Document document, String iDocNumber, String binaryDataCharset) {
            String tableName = table.getName();
            IDoc.Segment rootSegment = document.getRootSegment();
            boolean retSuccess = false;
            if ("EDI_DD40".equals(tableName) || "EDI_DD40_WITH_BINARY_DATA".equals(tableName)) {
                if (rootSegment != null && rootSegment.getNumChildren() > 0) {
                    StringBuffer strBuf;
                    String client = document.getClient();
                    if (client.length() > 0 && client.length() < 3) {
                        strBuf = new StringBuffer(3);
                        strBuf.append(ZERO_CHARARRAY, 0, 3 - client.length());
                        strBuf.append(client);
                        client = strBuf.toString();
                    }
                    if (iDocNumber.length() < 16) {
                        strBuf = new StringBuffer(16);
                        strBuf.append(ZERO_CHARARRAY, 0, 16 - iDocNumber.length());
                        strBuf.append(iDocNumber);
                        iDocNumber = strBuf.toString();
                    }
                    JCoDocument.appendChildRowsToJCoDataTable40(table, client, iDocNumber, rootSegment, 0, binaryDataCharset);
                }
                retSuccess = true;
            } else if ("EDI_DD".equals(tableName) || "EDI_DD_WITH_BINARY_DATA".equals(tableName)) {
                if (rootSegment != null && rootSegment.getNumChildren() > 0) {
                    StringBuffer strBuf;
                    String client = document.getClient();
                    if (client.length() > 0 && client.length() < 3) {
                        strBuf = new StringBuffer(3);
                        strBuf.append(ZERO_CHARARRAY, 0, 3 - client.length());
                        strBuf.append(client);
                        client = strBuf.toString();
                    }
                    if (iDocNumber.length() < 16) {
                        strBuf = new StringBuffer(16);
                        strBuf.append(ZERO_CHARARRAY, 0, 16 - iDocNumber.length());
                        strBuf.append(iDocNumber);
                        iDocNumber = strBuf.toString();
                    }
                    JCoDocument.appendChildRowsToJCoDataTable31(table, client, iDocNumber, rootSegment, 0, binaryDataCharset);
                }
                retSuccess = true;
            }
            return retSuccess;
        }

        protected static boolean appendRowToJCoControlTable(JCO.Table table, IDoc.Document document, String iDocNumber) {
            String client;
            String tableName = table.getName();
            boolean retSuccess = false;
            if (iDocNumber.length() < 16) {
                StringBuffer strBuf = new StringBuffer(16);
                strBuf.append(ZERO_CHARARRAY, 0, 16 - iDocNumber.length());
                strBuf.append(iDocNumber);
                iDocNumber = strBuf.toString();
            }
            if ("EDI_DC".equals(tableName)) {
                table.appendRow();
                client = document.getClient();
                if (client.length() > 0 && client.length() < 3) {
                    StringBuffer strBuf = new StringBuffer(3);
                    strBuf.append(ZERO_CHARARRAY, 0, 3 - client.length());
                    strBuf.append(client);
                    client = strBuf.toString();
                }
                table.setValue("EDI_DC", 0);
                table.setValue(client, 1);
                table.setValue(iDocNumber, 2);
                table.setValue(document.getIDocSAPRelease(), 3);
                table.setValue(document.getStatus(), 4);
                table.setValue(document.getIDocCompoundType(), 5);
                table.setValue(document.getDirection(), 6);
                table.setValue(document.getRecipientPort(), 7);
                table.setValue(document.getRecipientPartnerType(), 8);
                table.setValue(document.getRecipientPartnerNumber(), 9);
                table.setValue(document.getRecipientAddress(), 10);
                table.setValue(document.getRecipientLogicalAddress(), 11);
                table.setValue(document.getEDIStandardFlag(), 12);
                table.setValue(document.getEDIStandardVersion(), 13);
                table.setValue(document.getEDIMessageType(), 14);
                table.setValue(document.getMessageCode(), 15);
                table.setValue(document.getMessageFunction(), 16);
                table.setValue(document.getOutputMode(), 17);
                table.setValue(document.getTestFlag(), 18);
                table.setValue(document.getSenderPort(), 19);
                table.setValue(document.getSenderPartnerType(), 20);
                table.setValue(document.getSenderPartnerNumber(), 21);
                table.setValue(document.getSenderAddress(), 22);
                table.setValue(document.getSenderLogicalAddress(), 23);
                table.setValue(document.getEDITransmissionFile(), 24);
                table.setValue(document.getEDIMessageGroup(), 25);
                table.setValue(document.getEDIMessage(), 26);
                table.setValue(document.getArchiveKey(), 27);
                table.setValue(document.getCreationDateAsString(), 28);
                table.setValue(document.getCreationTimeAsString(), 29);
                table.setValue(document.getMessageType(), 30);
                table.setValue(document.getIDocType(), 31);
                table.setValue(document.getIDocTypeExtension(), 32);
                table.setValue(document.getRecipientPartnerFunction(), 33);
                table.setValue(document.getSenderPartnerFunction(), 34);
                table.setValue(document.getSerialization(), 35);
                table.setValue(document.getExpressFlag(), 36);
                retSuccess = true;
            } else if ("EDI_DC40".equals(tableName)) {
                table.appendRow();
                client = document.getClient();
                if (client.length() > 0 && client.length() < 3) {
                    StringBuffer strBuf = new StringBuffer(3);
                    strBuf.append(ZERO_CHARARRAY, 0, 3 - client.length());
                    strBuf.append(client);
                    client = strBuf.toString();
                }
                table.setValue("EDI_DC40", 0);
                table.setValue(client, 1);
                table.setValue(iDocNumber, 2);
                table.setValue(document.getIDocSAPRelease(), 3);
                table.setValue(document.getStatus(), 4);
                table.setValue(document.getDirection(), 5);
                table.setValue(document.getOutputMode(), 6);
                table.setValue(document.getExpressFlag(), 7);
                table.setValue(document.getTestFlag(), 8);
                table.setValue(document.getIDocType(), 9);
                table.setValue(document.getIDocTypeExtension(), 10);
                table.setValue(document.getMessageType(), 11);
                table.setValue(document.getMessageCode(), 12);
                table.setValue(document.getMessageFunction(), 13);
                table.setValue(document.getEDIStandardFlag(), 14);
                table.setValue(document.getEDIStandardVersion(), 15);
                table.setValue(document.getEDIMessageType(), 16);
                table.setValue(document.getSenderPort(), 17);
                table.setValue(document.getSenderPartnerType(), 18);
                table.setValue(document.getSenderPartnerFunction(), 19);
                table.setValue(document.getSenderPartnerNumber(), 20);
                table.setValue(document.getSenderAddress(), 21);
                table.setValue(document.getSenderLogicalAddress(), 22);
                table.setValue(document.getRecipientPort(), 23);
                table.setValue(document.getRecipientPartnerType(), 24);
                table.setValue(document.getRecipientPartnerFunction(), 25);
                table.setValue(document.getRecipientPartnerNumber(), 26);
                table.setValue(document.getRecipientAddress(), 27);
                table.setValue(document.getRecipientLogicalAddress(), 28);
                table.setValue(document.getCreationDateAsString(), 29);
                table.setValue(document.getCreationTimeAsString(), 30);
                table.setValue(document.getEDITransmissionFile(), 31);
                table.setValue(document.getEDIMessageGroup(), 32);
                table.setValue(document.getEDIMessage(), 33);
                table.setValue(document.getArchiveKey(), 34);
                table.setValue(document.getSerialization(), 35);
                retSuccess = true;
            }
            return retSuccess;
        }

        protected boolean appendRowToJCoControlTable(JCoTable table, String iDocNumber) {
            boolean retSuccess = false;
            if (this.getName() != null && this.getName().equals(table.getName())) {
                table.appendRow(this.getDataBuffer());
                if (iDocNumber.length() < 16) {
                    StringBuffer strBuf = new StringBuffer(16);
                    strBuf.append(ZERO_CHARARRAY, 0, 16 - iDocNumber.length());
                    strBuf.append(iDocNumber);
                    iDocNumber = strBuf.toString();
                }
                switch (this.m_controlStructVersion) {
                    case 40: {
                        table.setValue(iDocNumber, 2);
                        break;
                    }
                    case 31: {
                        table.setValue(iDocNumber, 2);
                        break;
                    }
                    default: {
                        table.setValue(iDocNumber, "DOCNUM");
                    }
                }
                String client = this.getClient();
                if (client.length() > 0 && client.length() < 3) {
                    StringBuffer strBuf = new StringBuffer(3);
                    strBuf.append(ZERO_CHARARRAY, 0, 3 - client.length());
                    strBuf.append(client);
                    client = strBuf.toString();
                    switch (this.m_controlStructVersion) {
                        case 40: {
                            table.setValue(client, 1);
                            break;
                        }
                        case 31: {
                            table.setValue(client, 1);
                            break;
                        }
                        default: {
                            table.setValue(client, "MANDT");
                        }
                    }
                }
                retSuccess = true;
            } else {
                retSuccess = JCoDocument.appendRowToJCoControlTable(table, this, iDocNumber);
            }
            return retSuccess;
        }

        public void checkMandatoryFields() {
            String value = this.getMessageType();
            if (value == null || value.length() == 0) {
                throw new IDoc.SyntaxException(this, "MESTYP", "Missing mandatory field: MessageType (MESTYP)");
            }
            value = this.getIDocType();
            if (value == null || value.length() == 0) {
                throw new IDoc.SyntaxException(this, "IDOCTYP", "Missing mandatory field: IDocType (IDOCTYP)");
            }
            value = this.getRecipientPartnerType();
            if (value == null || value.length() == 0) {
                throw new IDoc.SyntaxException(this, "RCVPRT", "Missing mandatory field: RecipientPartnerType (RCVPRT)");
            }
            value = this.getRecipientPartnerNumber();
            if (value == null || value.length() == 0) {
                throw new IDoc.SyntaxException(this, "RCVPRN", "Missing mandatory field: RecipientPartnerNumber (RCVPRN)");
            }
            value = this.getSenderPort();
            if (value == null || value.length() == 0) {
                throw new IDoc.SyntaxException(this, "SNDPOR", "Missing mandatory field: SenderPort (SNDPOR)");
            }
            value = this.getSenderPartnerType();
            if (value == null || value.length() == 0) {
                throw new IDoc.SyntaxException(this, "SNDPRT", "Missing mandatory field: SenderPartnerType (SNDPRT)");
            }
            value = this.getSenderPartnerNumber();
            if (value == null || value.length() == 0) {
                throw new IDoc.SyntaxException(this, "SNDPRN", "Missing mandatory field: SenderPartnerNumber (SNDPRN)");
            }
        }

        public void checkSyntax() {
            this.checkSyntax(527);
        }

        public void checkSyntax(int options) {
            if ((options & 1) != 0) {
                this.checkMandatoryFields();
            }
            this.m_rootSegment.checkSyntax(options &= 0xFFFEFFFF);
        }

        protected static String createJCoIDocNumber(IDoc.Document document) {
            String iDocNumber = document.getIDocNumber();
            if (iDocNumber == null || iDocNumber.length() == 0) {
                Int intVal = m_greatestJCoIDocNumber;
                synchronized (intVal) {
                    m_greatestJCoIDocNumber.increment();
                    iDocNumber = m_greatestJCoIDocNumber.toString();
                }
            }
            return iDocNumber;
        }

        protected JCO.Function createJCoFunction(JCO.Client client, char iDocVersion, int options) {
            JCO.Function function = null;
            JCO.Attributes attributes = null;
            String systemRelease = null;
            boolean isUnicode = false;
            if (client != null) {
                attributes = client.getAttributes();
                systemRelease = attributes.getPartnerRelease();
                isUnicode = JCoIDoc.isPartnerSystemUnicode(attributes);
            }
            if (iDocVersion != '0' && iDocVersion != '2' && iDocVersion != '3') {
                iDocVersion = (char)48;
            }
            IRepository jcoStaticRepository = JCoIDoc.getJCoStaticRepository(systemRelease, isUnicode);
            if (!(systemRelease != null && systemRelease.length() != 0 && systemRelease.compareTo("4") < 0 || iDocVersion != '0' && iDocVersion != '3')) {
                JCoTable controlTable = null;
                JCoTable dataTable = null;
                String codepage = null;
                controlTable = new JCoTable(jcoStaticRepository.getStructureDefinition("EDI_DC40"));
                if (isUnicode || attributes == null || attributes.getOwnBytesPerChar() <= 1) {
                    dataTable = new JCoTable(jcoStaticRepository.getStructureDefinition("EDI_DD40"));
                } else {
                    codepage = attributes.getPartnerCodepage();
                    dataTable = new JCoTable(jcoStaticRepository.getStructureDefinition("EDI_DD40_WITH_BINARY_DATA"));
                }
                if (this.getNumSegments() > 1) {
                    String iDocNumber = JCoDocument.createJCoIDocNumber(this);
                    this.appendRowToJCoControlTable(controlTable, iDocNumber);
                    JCoDocument.appendRowsToJCoDataTable(dataTable, this, iDocNumber, codepage);
                }
                JCO.ParameterList tableParameterList = new JCO.ParameterList();
                tableParameterList.appendValue("IDOC_CONTROL_REC_40", controlTable);
                tableParameterList.appendValue("IDOC_DATA_REC_40", dataTable);
                function = new JCO.Function("IDOC_INBOUND_ASYNCHRONOUS", null, null, tableParameterList);
            } else {
                JCoTable controlTable = null;
                JCoTable dataTable = null;
                String codepage = null;
                controlTable = new JCoTable(jcoStaticRepository.getStructureDefinition("EDI_DC"));
                if (isUnicode || attributes == null || attributes.getOwnBytesPerChar() <= 1) {
                    dataTable = new JCoTable(jcoStaticRepository.getStructureDefinition("EDI_DD"));
                } else {
                    codepage = attributes.getPartnerCodepage();
                    dataTable = new JCoTable(jcoStaticRepository.getStructureDefinition("EDI_DD_WITH_BINARY_DATA"));
                }
                if (this.getNumSegments() > 1) {
                    String iDocNumber = JCoDocument.createJCoIDocNumber(this);
                    this.appendRowToJCoControlTable(controlTable, iDocNumber);
                    JCoDocument.appendRowsToJCoDataTable(dataTable, this, iDocNumber, codepage);
                }
                JCO.ParameterList tableParameterList = new JCO.ParameterList();
                tableParameterList.appendValue("IDOC_CONTROL", controlTable);
                tableParameterList.appendValue("IDOC_DATA", dataTable);
                function = new JCO.Function("INBOUND_IDOC_PROCESS", null, null, tableParameterList);
            }
            return function;
        }

        public void disableFieldValueChecking() {
            this.disableFieldValueChecking(true);
        }

        public void disableFieldValueChecking(boolean applyToSegments) {
            this.m_checkFieldValuesOnSet = false;
            if (applyToSegments) {
                this.m_rootSegment.disableFieldValueChecking(true);
            }
        }

        public void enableFieldValueChecking() {
            this.enableFieldValueChecking(true);
        }

        public void enableFieldValueChecking(boolean applyToSegments) {
            this.m_checkFieldValuesOnSet = true;
            if (applyToSegments) {
                this.m_rootSegment.enableFieldValueChecking(true);
            }
        }

        public int getNumSegments() {
            return this.m_rootSegment.getNumDescendants() + 1;
        }

        public int getNumSegments(String segmentType) {
            if (this.m_rootSegment.getType().equals(segmentType)) {
                return 1;
            }
            return this.m_rootSegment.getNumDescendants(segmentType);
        }

        public IDoc.Segment getRootSegment() {
            return this.m_rootSegment;
        }

        public String getArchiveKey() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(34);
                }
                case 31: {
                    return this.getString(27);
                }
            }
            return this.getString("ARCKEY");
        }

        public String getClient() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(1);
                }
                case 31: {
                    return this.getString(1);
                }
            }
            return this.getString("MANDT");
        }

        public Date getCreationDate() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getDate(29);
                }
                case 31: {
                    return this.getDate(28);
                }
            }
            return this.getDate("CREDAT");
        }

        public String getCreationDateAsString() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(29);
                }
                case 31: {
                    return this.getString(28);
                }
            }
            return this.getString("CREDAT");
        }

        public Date getCreationTime() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getTime(30);
                }
                case 31: {
                    return this.getTime(29);
                }
            }
            return this.getTime("CRETIM");
        }

        public String getCreationTimeAsString() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(30);
                }
                case 31: {
                    return this.getString(29);
                }
            }
            return this.getString("CRETIM");
        }

        public String getDirection() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(5);
                }
                case 31: {
                    return this.getString(6);
                }
            }
            return this.getString("DIRECT");
        }

        public String getEDIMessage() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(33);
                }
                case 31: {
                    return this.getString(26);
                }
            }
            return this.getString("REFMES");
        }

        public String getEDIMessageGroup() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(32);
                }
                case 31: {
                    return this.getString(25);
                }
            }
            return this.getString("REFGRP");
        }

        public String getEDIMessageType() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(16);
                }
                case 31: {
                    return this.getString(14);
                }
            }
            return this.getString("STDMES");
        }

        public String getEDIStandardFlag() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(14);
                }
                case 31: {
                    return this.getString(12);
                }
            }
            return this.getString("STD");
        }

        public String getEDIStandardVersion() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(15);
                }
                case 31: {
                    return this.getString(13);
                }
            }
            return this.getString("STDVRS");
        }

        public String getEDITransmissionFile() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(31);
                }
                case 31: {
                    return this.getString(24);
                }
            }
            return this.getString("REFINT");
        }

        public String getExpressFlag() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(7);
                }
                case 31: {
                    return this.getString(36);
                }
            }
            return this.getString("EXPRSS");
        }

        public String getIDocNumber() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(2);
                }
                case 31: {
                    return this.getString(2);
                }
            }
            return this.getString("DOCNUM");
        }

        public String getIDocSAPRelease() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(3);
                }
                case 31: {
                    return this.getString(3);
                }
            }
            return this.getString("DOCREL");
        }

        public String getIDocCompoundType() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.m_iDocCompoundType;
                }
                case 31: {
                    return this.getString(5);
                }
            }
            if (this.m_iDocCompoundType != null) {
                return this.m_iDocCompoundType;
            }
            return this.getString("DOCTYP");
        }

        public String getIDocType() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(9);
                }
                case 31: {
                    return this.getString(31);
                }
            }
            return this.getString("IDOCTYP");
        }

        public String getIDocTypeExtension() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(10);
                }
                case 31: {
                    return this.getString(32);
                }
            }
            return this.getString("CIMTYP");
        }

        public String getMessageCode() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(12);
                }
                case 31: {
                    return this.getString(15);
                }
            }
            return this.getString("MESCOD");
        }

        public String getMessageFunction() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(13);
                }
                case 31: {
                    return this.getString(16);
                }
            }
            return this.getString("MESFCT");
        }

        public String getMessageType() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(11);
                }
                case 31: {
                    return this.getString(30);
                }
            }
            return this.getString("MESTYP");
        }

        public String getOutputMode() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(6);
                }
                case 31: {
                    return this.getString(17);
                }
            }
            return this.getString("OUTMOD");
        }

        public String getRecipientAddress() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(27);
                }
                case 31: {
                    return this.getString(10);
                }
            }
            return this.getString("RCVSAD");
        }

        public String getRecipientLogicalAddress() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(28);
                }
                case 31: {
                    return this.getString(11);
                }
            }
            return this.getString("RCVLAD");
        }

        public String getRecipientPartnerFunction() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(25);
                }
                case 31: {
                    return this.getString(33);
                }
            }
            return this.getString("RCVPFC");
        }

        public String getRecipientPartnerNumber() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(26);
                }
                case 31: {
                    return this.getString(9);
                }
            }
            return this.getString("RCVPRN");
        }

        public String getRecipientPartnerType() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(24);
                }
                case 31: {
                    return this.getString(8);
                }
            }
            return this.getString("RCVPRT");
        }

        public String getRecipientPort() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(23);
                }
                case 31: {
                    return this.getString(7);
                }
            }
            return this.getString("RCVPOR");
        }

        public String getSenderAddress() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(21);
                }
                case 31: {
                    return this.getString(22);
                }
            }
            return this.getString("SNDSAD");
        }

        public String getSenderLogicalAddress() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(22);
                }
                case 31: {
                    return this.getString(23);
                }
            }
            return this.getString("SNDLAD");
        }

        public String getSenderPartnerFunction() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(19);
                }
                case 31: {
                    return this.getString(34);
                }
            }
            return this.getString("SNDPFC");
        }

        public String getSenderPartnerNumber() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(20);
                }
                case 31: {
                    return this.getString(21);
                }
            }
            return this.getString("SNDPRN");
        }

        public String getSenderPartnerType() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(18);
                }
                case 31: {
                    return this.getString(20);
                }
            }
            return this.getString("SNDPRT");
        }

        public String getSenderPort() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(17);
                }
                case 31: {
                    return this.getString(19);
                }
            }
            return this.getString("SNDPOR");
        }

        public String getSerialization() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(35);
                }
                case 31: {
                    return this.getString(35);
                }
            }
            return this.getString("SERIAL");
        }

        public String getStatus() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(4);
                }
                case 31: {
                    return this.getString(4);
                }
            }
            return this.getString("STATUS");
        }

        public String getTableStructureName() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(0);
                }
                case 31: {
                    return this.getString(0);
                }
            }
            return this.getString("TABNAM");
        }

        public String getTestFlag() {
            switch (this.m_controlStructVersion) {
                case 40: {
                    return this.getString(8);
                }
                case 31: {
                    return this.getString(18);
                }
            }
            return this.getString("TEST");
        }

        public void setArchiveKey(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(34, value);
                    break;
                }
                case 31: {
                    this.setField(27, value);
                    break;
                }
                default: {
                    this.setField("ARCKEY", value);
                }
            }
        }

        public void setClient(String value) {
            if (value != null && value.length() > 0 && value.length() < 3) {
                StringBuffer strBuf = new StringBuffer(3);
                strBuf.append(ZERO_CHARARRAY, 0, 3 - value.length());
                strBuf.append(value);
                value = strBuf.toString();
            }
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(1, value);
                    break;
                }
                case 31: {
                    this.setField(1, value);
                    break;
                }
                default: {
                    this.setField("MANDT", value);
                }
            }
        }

        public void setCreationDate(Date value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(29, (Object)value);
                    break;
                }
                case 31: {
                    this.setField(28, (Object)value);
                    break;
                }
                default: {
                    this.setField("CREDAT", (Object)value);
                }
            }
        }

        public void setCreationDate(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(29, value);
                    break;
                }
                case 31: {
                    this.setField(28, value);
                    break;
                }
                default: {
                    this.setField("CREDAT", value);
                }
            }
        }

        public void setCreationTime(Date value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(30, (Object)value);
                    break;
                }
                case 31: {
                    this.setField(29, (Object)value);
                    break;
                }
                default: {
                    this.setField("CRETIM", (Object)value);
                }
            }
        }

        public void setCreationTime(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(30, value);
                    break;
                }
                case 31: {
                    this.setField(29, value);
                    break;
                }
                default: {
                    this.setField("CRETIM", value);
                }
            }
        }

        public void setDirection(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(5, value);
                    break;
                }
                case 31: {
                    this.setField(6, value);
                    break;
                }
                default: {
                    this.setField("DIRECT", value);
                }
            }
        }

        public void setEDIMessage(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(33, value);
                    break;
                }
                case 31: {
                    this.setField(26, value);
                    break;
                }
                default: {
                    this.setField("REFMES", value);
                }
            }
        }

        public void setEDIMessageGroup(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(32, value);
                    break;
                }
                case 31: {
                    this.setField(25, value);
                    break;
                }
                default: {
                    this.setField("REFGRP", value);
                }
            }
        }

        public void setEDIMessageType(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(16, value);
                    break;
                }
                case 31: {
                    this.setField(14, value);
                    break;
                }
                default: {
                    this.setField("STDMES", value);
                }
            }
        }

        public void setEDIStandardFlag(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(14, value);
                    break;
                }
                case 31: {
                    this.setField(12, value);
                    break;
                }
                default: {
                    this.setField("STD", value);
                }
            }
        }

        public void setEDIStandardVersion(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(15, value);
                    break;
                }
                case 31: {
                    this.setField(13, value);
                    break;
                }
                default: {
                    this.setField("STDVRS", value);
                }
            }
        }

        public void setEDITransmissionFile(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(31, value);
                    break;
                }
                case 31: {
                    this.setField(24, value);
                    break;
                }
                default: {
                    this.setField("REFINT", value);
                }
            }
        }

        public void setExpressFlag(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(7, value);
                    break;
                }
                case 31: {
                    this.setField(36, value);
                    break;
                }
                default: {
                    this.setField("EXPRSS", value);
                }
            }
        }

        public void setIDocNumber(String value) {
            if (value != null && value.length() > 0 && value.length() < 16) {
                StringBuffer strBuf = new StringBuffer(16);
                strBuf.append(ZERO_CHARARRAY, 0, 16 - value.length());
                strBuf.append(value);
                value = strBuf.toString();
            }
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(2, value);
                    break;
                }
                case 31: {
                    this.setField(2, value);
                    break;
                }
                default: {
                    this.setField("DOCNUM", value);
                }
            }
        }

        public void setIDocSAPRelease(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(3, value);
                    break;
                }
                case 31: {
                    this.setField(3, value);
                    break;
                }
                default: {
                    this.setField("DOCREL", value);
                }
            }
        }

        public void setIDocCompoundType(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    if (value == null || value.length() <= 8) {
                        this.m_iDocCompoundType = value;
                        break;
                    }
                    this.m_iDocCompoundType = value.substring(0, 8);
                    break;
                }
                case 31: {
                    this.setField(5, value);
                    break;
                }
                default: {
                    try {
                        this.setField("DOCTYP", value);
                        break;
                    }
                    catch (JCO.Exception ex) {
                        this.m_iDocCompoundType = value == null || value.length() <= 8 ? value : value.substring(0, 8);
                    }
                }
            }
        }

        public void setIDocType(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(9, value);
                    break;
                }
                case 31: {
                    this.setField(31, value);
                    break;
                }
                default: {
                    this.setField("IDOCTYP", value);
                }
            }
        }

        public void setIDocTypeExtension(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(10, value);
                    break;
                }
                case 31: {
                    this.setField(32, value);
                    break;
                }
                default: {
                    this.setField("CIMTYP", value);
                }
            }
        }

        public void setMessageCode(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(12, value);
                    break;
                }
                case 31: {
                    this.setField(15, value);
                    break;
                }
                default: {
                    this.setField("MESCOD", value);
                }
            }
        }

        public void setMessageFunction(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(13, value);
                    break;
                }
                case 31: {
                    this.setField(16, value);
                    break;
                }
                default: {
                    this.setField("MESFCT", value);
                }
            }
        }

        public void setMessageType(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(11, value);
                    break;
                }
                case 31: {
                    this.setField(30, value);
                    break;
                }
                default: {
                    this.setField("MESTYP", value);
                }
            }
        }

        public void setOutputMode(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(6, value);
                    break;
                }
                case 31: {
                    this.setField(17, value);
                    break;
                }
                default: {
                    this.setField("OUTMOD", value);
                }
            }
        }

        public void setRecipientAddress(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(27, value);
                    break;
                }
                case 31: {
                    this.setField(10, value);
                    break;
                }
                default: {
                    this.setField("RCVSAD", value);
                }
            }
        }

        public void setRecipientLogicalAddress(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(28, value);
                    break;
                }
                case 31: {
                    this.setField(11, value);
                    break;
                }
                default: {
                    this.setField("RCVLAD", value);
                }
            }
        }

        public void setRecipientPartnerFunction(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(25, value);
                    break;
                }
                case 31: {
                    this.setField(33, value);
                    break;
                }
                default: {
                    this.setField("RCVPFC", value);
                }
            }
        }

        public void setRecipientPartnerNumber(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(26, value);
                    break;
                }
                case 31: {
                    this.setField(9, value);
                    break;
                }
                default: {
                    this.setField("RCVPRN", value);
                }
            }
        }

        public void setRecipientPartnerType(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(24, value);
                    break;
                }
                case 31: {
                    this.setField(8, value);
                    break;
                }
                default: {
                    this.setField("RCVPRT", value);
                }
            }
        }

        public void setRecipientPort(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(23, value);
                    break;
                }
                case 31: {
                    this.setField(7, value);
                    break;
                }
                default: {
                    this.setField("RCVPOR", value);
                }
            }
        }

        public void setSenderAddress(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(21, value);
                    break;
                }
                case 31: {
                    this.setField(22, value);
                    break;
                }
                default: {
                    this.setField("SNDSAD", value);
                }
            }
        }

        public void setSenderLogicalAddress(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(22, value);
                    break;
                }
                case 31: {
                    this.setField(23, value);
                    break;
                }
                default: {
                    this.setField("SNDLAD", value);
                }
            }
        }

        public void setSenderPartnerFunction(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(19, value);
                    break;
                }
                case 31: {
                    this.setField(34, value);
                    break;
                }
                default: {
                    this.setField("SNDPFC", value);
                }
            }
        }

        public void setSenderPartnerNumber(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(20, value);
                    break;
                }
                case 31: {
                    this.setField(21, value);
                    break;
                }
                default: {
                    this.setField("SNDPRN", value);
                }
            }
        }

        public void setSenderPartnerType(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(18, value);
                    break;
                }
                case 31: {
                    this.setField(20, value);
                    break;
                }
                default: {
                    this.setField("SNDPRT", value);
                }
            }
        }

        public void setSenderPort(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(17, value);
                    break;
                }
                case 31: {
                    this.setField(19, value);
                    break;
                }
                default: {
                    this.setField("SNDPOR", value);
                }
            }
        }

        public void setSerialization(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(35, value);
                    break;
                }
                case 31: {
                    this.setField(35, value);
                    break;
                }
                default: {
                    this.setField("SERIAL", value);
                }
            }
        }

        public void setStatus(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(4, value);
                    break;
                }
                case 31: {
                    this.setField(4, value);
                    break;
                }
                default: {
                    this.setField("STATUS", value);
                }
            }
        }

        protected void setTableStructureName(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(0, value);
                    break;
                }
                case 31: {
                    this.setField(0, value);
                    break;
                }
                default: {
                    this.setField("TABNAM", value);
                }
            }
        }

        public void setTestFlag(String value) {
            switch (this.m_controlStructVersion) {
                case 40: {
                    this.setField(8, value);
                    break;
                }
                case 31: {
                    this.setField(18, value);
                    break;
                }
                default: {
                    this.setField("TEST", value);
                }
            }
        }

        public void send(JCO.Client client, String tid, String queueName, int queuePos, char iDocVersion, int options) {
            client.execute(this.createJCoFunction(client, iDocVersion, options), tid, queueName, queuePos);
        }

        public String toString() {
            StringBuffer strBuf = new StringBuffer(1000);
            strBuf.append("ArchiveKey = ");
            strBuf.append(this.getArchiveKey());
            strBuf.append("  [ARCKEY = ");
            strBuf.append(this.getString("ARCKEY"));
            strBuf.append("]\n");
            strBuf.append("Client = ");
            strBuf.append(this.getClient());
            strBuf.append("  [MANDT = ");
            strBuf.append(this.getString("MANDT"));
            strBuf.append("]\n");
            strBuf.append("CreationDate = ");
            strBuf.append(this.getCreationDateAsString());
            strBuf.append("  [CREDAT = ");
            strBuf.append(this.getString("CREDAT"));
            strBuf.append("]\n");
            strBuf.append("CreationTime = ");
            strBuf.append(this.getCreationTimeAsString());
            strBuf.append("  [CRETIM = ");
            strBuf.append(this.getString("CRETIM"));
            strBuf.append("]\n");
            strBuf.append("Direction = ");
            strBuf.append(this.getDirection());
            strBuf.append("  [DIRECT = ");
            strBuf.append(this.getString("DIRECT"));
            strBuf.append("]\n");
            strBuf.append("EDIMessage = ");
            strBuf.append(this.getEDIMessage());
            strBuf.append("  [REFMES = ");
            strBuf.append(this.getString("REFMES"));
            strBuf.append("]\n");
            strBuf.append("EDIMessageGroup = ");
            strBuf.append(this.getEDIMessageGroup());
            strBuf.append("  [REFGRP = ");
            strBuf.append(this.getString("REFGRP"));
            strBuf.append("]\n");
            strBuf.append("EDIMessageType = ");
            strBuf.append(this.getEDIMessageType());
            strBuf.append("  [STDMES = ");
            strBuf.append(this.getString("STDMES"));
            strBuf.append("]\n");
            strBuf.append("EDIStandardFlag = ");
            strBuf.append(this.getEDIStandardFlag());
            strBuf.append("  [STD = ");
            strBuf.append(this.getString("STD"));
            strBuf.append("]\n");
            strBuf.append("EDIStandardVersion = ");
            strBuf.append(this.getEDIStandardVersion());
            strBuf.append("  [STDVRS = ");
            strBuf.append(this.getString("STDVRS"));
            strBuf.append("]\n");
            strBuf.append("EDITransmissionFile = ");
            strBuf.append(this.getEDITransmissionFile());
            strBuf.append("  [REFINT = ");
            strBuf.append(this.getString("REFINT"));
            strBuf.append("]\n");
            strBuf.append("ExpressFlag = ");
            strBuf.append(this.getExpressFlag());
            strBuf.append("  [EXPRSS = ");
            strBuf.append(this.getString("EXPRSS"));
            strBuf.append("]\n");
            strBuf.append("IDocNumber = ");
            strBuf.append(this.getIDocNumber());
            strBuf.append("  [DOCNUM = ");
            strBuf.append(this.getString("DOCNUM"));
            strBuf.append("]\n");
            strBuf.append("IDocSAPRelease = ");
            strBuf.append(this.getIDocSAPRelease());
            strBuf.append("  [DOCREL = ");
            strBuf.append(this.getString("DOCREL"));
            strBuf.append("]\n");
            strBuf.append("IDocCompoundType = ");
            strBuf.append(this.getIDocCompoundType());
            strBuf.append("  [DOCTYP = ");
            try {
                strBuf.append(this.getString("DOCTYP"));
            }
            catch (JCO.Exception exc) {
                strBuf.append("NOT FOUND");
            }
            strBuf.append("]\n");
            strBuf.append("IDocType = ");
            strBuf.append(this.getIDocType());
            strBuf.append("  [IDOCTYP = ");
            strBuf.append(this.getString("IDOCTYP"));
            strBuf.append("]\n");
            strBuf.append("IDocTypeExtension = ");
            strBuf.append(this.getIDocTypeExtension());
            strBuf.append("  [CIMTYP = ");
            strBuf.append(this.getString("CIMTYP"));
            strBuf.append("]\n");
            strBuf.append("MessageCode = ");
            strBuf.append(this.getMessageCode());
            strBuf.append("  [MESCOD = ");
            strBuf.append(this.getString("MESCOD"));
            strBuf.append("]\n");
            strBuf.append("MessageFunction = ");
            strBuf.append(this.getMessageFunction());
            strBuf.append("  [MESFCT = ");
            strBuf.append(this.getString("MESFCT"));
            strBuf.append("]\n");
            strBuf.append("MessageType = ");
            strBuf.append(this.getMessageType());
            strBuf.append("  [MESTYP = ");
            strBuf.append(this.getString("MESTYP"));
            strBuf.append("]\n");
            strBuf.append("OutputMode = ");
            strBuf.append(this.getOutputMode());
            strBuf.append("  [OUTMOD = ");
            strBuf.append(this.getString("OUTMOD"));
            strBuf.append("]\n");
            strBuf.append("SenderAddress = ");
            strBuf.append(this.getSenderAddress());
            strBuf.append("  [SNDSAD = ");
            strBuf.append(this.getString("SNDSAD"));
            strBuf.append("]\n");
            strBuf.append("SenderLogicalAddress = ");
            strBuf.append(this.getSenderLogicalAddress());
            strBuf.append("  [SNDLAD = ");
            strBuf.append(this.getString("SNDLAD"));
            strBuf.append("]\n");
            strBuf.append("SenderPartnerFunction = ");
            strBuf.append(this.getSenderPartnerFunction());
            strBuf.append("  [SNDPFC = ");
            strBuf.append(this.getString("SNDPFC"));
            strBuf.append("]\n");
            strBuf.append("SenderPartnerNumber = ");
            strBuf.append(this.getSenderPartnerNumber());
            strBuf.append("  [SNDPRN = ");
            strBuf.append(this.getString("SNDPRN"));
            strBuf.append("]\n");
            strBuf.append("SenderPartnerType = ");
            strBuf.append(this.getSenderPartnerType());
            strBuf.append("  [SNDPRT = ");
            strBuf.append(this.getString("SNDPRT"));
            strBuf.append("]\n");
            strBuf.append("SenderPort = ");
            strBuf.append(this.getSenderPort());
            strBuf.append("  [SNDPOR = ");
            strBuf.append(this.getString("SNDPOR"));
            strBuf.append("]\n");
            strBuf.append("Serialization = ");
            strBuf.append(this.getSerialization());
            strBuf.append("  [SERIAL = ");
            strBuf.append(this.getString("SERIAL"));
            strBuf.append("]\n");
            strBuf.append("RecipientAddress = ");
            strBuf.append(this.getRecipientAddress());
            strBuf.append("  [RCVSAD = ");
            strBuf.append(this.getString("RCVSAD"));
            strBuf.append("]\n");
            strBuf.append("RecipientLogicalAddress = ");
            strBuf.append(this.getRecipientLogicalAddress());
            strBuf.append("  [RCVLAD = ");
            strBuf.append(this.getString("RCVLAD"));
            strBuf.append("]\n");
            strBuf.append("RecipientPartnerFunction = ");
            strBuf.append(this.getRecipientPartnerFunction());
            strBuf.append("  [RCVPFC = ");
            strBuf.append(this.getString("RCVPFC"));
            strBuf.append("]\n");
            strBuf.append("RecipientPartnerNumber = ");
            strBuf.append(this.getRecipientPartnerNumber());
            strBuf.append("  [RCVPRN = ");
            strBuf.append(this.getString("RCVPRN"));
            strBuf.append("]\n");
            strBuf.append("RecipientPartnerType = ");
            strBuf.append(this.getRecipientPartnerType());
            strBuf.append("  [RCVPRT = ");
            strBuf.append(this.getString("RCVPRT"));
            strBuf.append("]\n");
            strBuf.append("RecipientPort = ");
            strBuf.append(this.getRecipientPort());
            strBuf.append("  [RCVPOR = ");
            strBuf.append(this.getString("RCVPOR"));
            strBuf.append("]\n");
            strBuf.append("Status = ");
            strBuf.append(this.getStatus());
            strBuf.append("  [STATUS = ");
            strBuf.append(this.getString("STATUS"));
            strBuf.append("]\n");
            strBuf.append("TestFlag = ");
            strBuf.append(this.getTestFlag());
            strBuf.append("  [TEST = ");
            strBuf.append(this.getString("TEST"));
            strBuf.append("]\n");
            IDoc.Segment segment = this.m_rootSegment;
            int[] tree = new int[100];
            int rootlevel = segment.getHierarchyLevel();
            int hlevel = 0;
            tree[1] = segment.getNumChildren();
            strBuf.append("\n");
            strBuf.append(segment.getName());
            strBuf.append(" (Type: ");
            strBuf.append(segment.getType());
            strBuf.append(")\n");
            segment = segment.getNext();
            while (segment != null) {
                hlevel = segment.getHierarchyLevel();
                tree[hlevel - rootlevel + 1] = segment.getNumChildren();
                int i = 1;
                while (i < hlevel - rootlevel) {
                    if (tree[i] > 0) {
                        strBuf.append("!   ");
                    } else {
                        strBuf.append("    ");
                    }
                    ++i;
                }
                strBuf.append("!\n");
                int i2 = 1;
                while (i2 < hlevel - rootlevel) {
                    if (tree[i2] > 0) {
                        strBuf.append("!   ");
                    } else {
                        strBuf.append("    ");
                    }
                    ++i2;
                }
                strBuf.append("+-- ");
                strBuf.append(segment.getName());
                strBuf.append(" (Type: ");
                strBuf.append(segment.getType());
                strBuf.append(")\n");
                int n = hlevel - rootlevel;
                tree[n] = tree[n] - 1;
                segment = segment.getNext();
            }
            return strBuf.toString();
        }

        public String toXML() {
            return JCoRecord.XMLWriter.createXMLDocument(this, null);
        }

        public String toXML(String release) {
            return JCoRecord.XMLWriter.createXMLDocument(this, release);
        }

        public void writeHTML(String filename) {
            try {
                this.writeHTML(new FileWriter(filename));
            }
            catch (IOException ex) {
                throw new IDoc.NestedException(5, "java.lang.IOException occurred while writing IDoc.Document " + this.getName() + " to HTML file '" + filename + "'.", ex);
            }
        }

        public void writeHTML(Writer writer) {
            PrintWriter os = null;
            String bg = JCO.getProperty(JCoIDoc.JCO_HTML_TABLE_HEADER_BACKGROUND1);
            String th = JCO.getProperty(JCoIDoc.JCO_HTML_TABLE_HEADER_BACKGROUND2);
            String hc = JCO.getProperty(JCoIDoc.JCO_HTML_TABLE_HEADER_BACKGROUND3);
            String fg = JCO.getProperty(JCoIDoc.JCO_HTML_TABLE_HEADER_FOREGROUND1);
            String rc = JCO.getProperty(JCoIDoc.JCO_HTML_TABLE_ROW_BACKGROUND1);
            String bdr = JCO.getProperty(JCoIDoc.JCO_HTML_TABLE_BORDER);
            String fface = JCO.getProperty(JCoIDoc.JCO_HTML_FONT_FACE);
            String fsize = JCO.getProperty(JCoIDoc.JCO_HTML_FONT_SIZE);
            os = new PrintWriter(writer);
            os.println("<html><head></head>");
            os.println("<body bgcolor='" + JCO.getProperty(JCoIDoc.JCO_HTML_BACKGROUND) + "' link='#0063A4' alink='#0000FF' vlink='#000000'>");
            os.println("<font face='" + fface + "' size='" + fsize + "'>");
            os.println("<table width='100%' border='1' bgcolor='" + bg + "'>");
            os.println("<tr align='left'><td><b><font color='" + fg + "'>IDoc.Document&nbsp;No.&nbsp;" + this.getIDocNumber() + "&nbsp;&nbsp;&nbsp;Date: " + new Date() + "</font></b></td></tr>");
            os.println("<tr align='left'><td><b><font color='" + fg + "'>Control Record</font></b></td></td>");
            os.println("<tr align='left'><td>");
            this.printHTML(os, (String)null, 0, JCO.MetaData.PRINT_HEADER_NAME | JCO.MetaData.PRINT_HEADER_TYPE | JCO.MetaData.PRINT_HEADER_LENGTH);
            os.println("</td></tr>");
            os.println("<tr align='left'><td>");
            os.println("<tr align='left'><td><b><font color='" + fg + "'>Segment Tree</font></b></td></td>");
            os.println("<tr bgcolor='" + bg + "' align='left'><td>");
            os.println("<table border='" + bdr + "' bgcolor='" + th + "'>");
            os.println("<tr align='left' bgcolor='" + hc + "'>");
            os.println("<th align='left'>Segment Name</th>");
            os.println("</tr>");
            os.println("<tr align='left' bgcolor='" + rc + "'>");
            os.println("<td align='left'>");
            JCoSegment seg = (JCoSegment)this.getRootSegment();
            int countSeg = 0;
            int[] tree = new int[100];
            int rootlevel = seg.getHierarchyLevel();
            int hlevel = 0;
            tree[1] = seg.getNumChildren();
            os.println("<a href='#Segment_" + ++countSeg + "'>" + seg.getName() + "</a><br>");
            seg = (JCoSegment)seg.getNext();
            while (seg != null) {
                hlevel = seg.getHierarchyLevel();
                tree[hlevel - rootlevel + 1] = seg.getNumChildren();
                int i = 1;
                while (i < hlevel - rootlevel) {
                    if (tree[i] > 0) {
                        os.print("&#x2503;&nbsp;&nbsp;&nbsp;&nbsp;");
                    } else {
                        os.print("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                    }
                    ++i;
                }
                if (tree[hlevel - rootlevel] > 1) {
                    os.print(JCoIDoc.HTML_CHAR_VERTICAL_AND_RIGHT);
                } else {
                    os.print(JCoIDoc.HTML_CHAR_UP_AND_RIGHT);
                }
                os.print("&#x2501;&#x2501;&nbsp;");
                os.println("<a href='#Segment_" + ++countSeg + "'>" + seg.getName() + "</a><br>");
                int n = hlevel - rootlevel;
                tree[n] = tree[n] - 1;
                seg = (JCoSegment)seg.getNext();
            }
            os.println("</td></tr></table>");
            os.println("<tr align='left'><td><b><font color='" + fg + "'>Segment Data</font></b></td></td>");
            os.println("<tr align='left'><td>");
            seg = (JCoSegment)this.getRootSegment();
            countSeg = 0;
            while (seg != null) {
                os.println("<tr align='left'><td>");
                os.println("<a name='Segment_" + ++countSeg + "'>");
                seg.printHTML(os);
                os.println("</td></tr>");
                seg = (JCoSegment)seg.getNext();
            }
            os.println("</table></font></body></html>");
            os.flush();
            os.close();
        }

        public void writeXML(OutputStreamWriter writer) {
            PrintWriter os = null;
            os = new PrintWriter(writer);
            os.print("<?xml version=\"1.0\" ");
            String encoding = CharacterEncoding.mapJavaToXMLEncoding(writer.getEncoding());
            if (encoding != null) {
                if (!(encoding.equals("UTF-8") || encoding.equals("UTF-16") || encoding.equals("US-ASCII"))) {
                    os.print("encoding=\"" + encoding + "\" ");
                }
            } else {
                encoding = writer.getEncoding().toLowerCase(Locale.ENGLISH);
                if (!(encoding.startsWith("utf") && (encoding.endsWith("8") || encoding.endsWith("16")) || encoding.indexOf("ascii") >= 0)) {
                    os.print("encoding=\"" + writer.getEncoding() + "\" ");
                }
            }
            os.println("?>");
            os.println(this.toXML());
            os.flush();
            os.close();
        }

        public void writeXML(String filename) {
            this.writeXML(filename, "UTF-8");
        }

        public void writeXML(String filename, String charEncoding) {
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(filename);
                this.writeXML(new OutputStreamWriter((OutputStream)os, charEncoding));
                os.close();
            }
            catch (IOException ex) {
                throw new IDoc.NestedException(5, "java.lang.IOException occurred while writing IDoc.Document " + this.getName() + " to XML file '" + filename + "'.", ex);
            }
        }

        public void writeXML(Writer writer) {
            PrintWriter os = null;
            os = new PrintWriter(writer);
            os.println("<?xml version=\"1.0\" ?>");
            os.println(this.toXML());
            os.flush();
            os.close();
        }
    }
}

