/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import java.util.Stack;

public final class ReturnCountCheck
extends AbstractFormatCheck {
    private static final int DEFAULT_MAX = 2;
    private final Stack mContextStack = new Stack();
    private int mMax;
    private Context mContext;

    public ReturnCountCheck() {
        super("^equals$");
        this.setMax(2);
    }

    public int[] getDefaultTokens() {
        return new int[]{8, 9, 88};
    }

    public int[] getRequiredTokens() {
        return new int[]{8, 9};
    }

    public int getMax() {
        return this.mMax;
    }

    public void setMax(int aMax) {
        this.mMax = aMax;
    }

    public void beginTree(DetailAST aRootAST) {
        this.mContext = null;
        this.mContextStack.clear();
    }

    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 8: 
            case 9: {
                this.visitMethodDef(aAST);
                break;
            }
            case 88: {
                this.mContext.visitLiteralReturn();
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    public void leaveToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 8: 
            case 9: {
                this.leaveMethodDef(aAST);
                break;
            }
            case 88: {
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    private void visitMethodDef(DetailAST aAST) {
        this.mContextStack.push(this.mContext);
        DetailAST methodNameAST = aAST.findFirstToken(58);
        this.mContext = new Context(!this.getRegexp().matcher(methodNameAST.getText()).find());
    }

    private void leaveMethodDef(DetailAST aAST) {
        this.mContext.checkCount(aAST);
        this.mContext = (Context)this.mContextStack.pop();
    }

    private class Context {
        private final boolean mChecking;
        private int mCount;

        public Context(boolean aChecking) {
            this.mChecking = aChecking;
            this.mCount = 0;
        }

        public void visitLiteralReturn() {
            ++this.mCount;
        }

        public void checkCount(DetailAST aAST) {
            if (this.mChecking && this.mCount > ReturnCountCheck.this.getMax()) {
                ReturnCountCheck.this.log(aAST.getLineNo(), aAST.getColumnNo(), "return.count", new Integer(this.mCount), new Integer(ReturnCountCheck.this.getMax()));
            }
        }
    }
}

