/*
 * Decompiled with CFR 0.152.
 */
package com4j;

public final class GUID {
    final long[] v;
    private static final char[] digits = "0123456789ABCDEF".toCharArray();

    GUID(long[] values) {
        this.v = values;
    }

    public GUID(String str) {
        if (str.length() == 36) {
            str = '{' + str + '}';
        }
        if (str.length() != 38) {
            throw new IllegalArgumentException("not a GUID: " + str);
        }
        this.v = new long[2];
        this.v[0] = this.parse(str, 1, 8) | this.parse(str, 10, 4) << 32 | this.parse(str, 15, 4) << 48;
        this.v[1] = this.parse(str, 20, 2) | this.parse(str, 22, 2) << 8 | this.parse(str, 25, 2) << 16 | this.parse(str, 27, 2) << 24 | this.parse(str, 29, 2) << 32 | this.parse(str, 31, 2) << 40 | this.parse(str, 33, 2) << 48 | this.parse(str, 35, 2) << 56;
    }

    private long parse(String s, int idx, int len) {
        return Long.parseLong(s.substring(idx, idx + len), 16);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GUID)) {
            return false;
        }
        GUID guid = (GUID)o;
        if (this.v[0] != guid.v[0]) {
            return false;
        }
        return this.v[1] == guid.v[1];
    }

    public int hashCode() {
        int result = (int)(this.v[0] ^ this.v[0] >>> 32);
        result = 29 * result + (int)(this.v[1] ^ this.v[1] >>> 32);
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(38);
        buf.append('{');
        this.toHex(buf, this.v[0] & 0xFFFFFFFFL, 8);
        buf.append('-');
        this.toHex(buf, (this.v[0] & 0xFFFF00000000L) >> 32, 4);
        buf.append('-');
        this.toHex(buf, (this.v[0] & 0xFFFF000000000000L) >> 48, 4);
        buf.append('-');
        this.toHex(buf, this.v[1] & 0xFFL, 2);
        this.toHex(buf, (this.v[1] & 0xFF00L) >> 8, 2);
        buf.append('-');
        this.toHex(buf, (this.v[1] & 0xFF0000L) >> 16, 2);
        this.toHex(buf, (this.v[1] & 0xFF000000L) >> 24, 2);
        this.toHex(buf, (this.v[1] & 0xFF00000000L) >> 32, 2);
        this.toHex(buf, (this.v[1] & 0xFF0000000000L) >> 40, 2);
        this.toHex(buf, (this.v[1] & 0xFF000000000000L) >> 48, 2);
        this.toHex(buf, (this.v[1] & 0xFF00000000000000L) >> 56, 2);
        buf.append('}');
        return buf.toString();
    }

    private void toHex(StringBuffer buf, long n, int len) {
        for (int i = len - 1; i >= 0; --i) {
            buf.append(digits[(int)(n >> i * 4) & 0xF]);
        }
    }
}

