/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.JGoActionObject;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoControl;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentEvent;
import com.nwoods.jgo.JGoDocumentListener;
import com.nwoods.jgo.JGoDrawable;
import com.nwoods.jgo.JGoGlobal;
import com.nwoods.jgo.JGoHandle;
import com.nwoods.jgo.JGoImage;
import com.nwoods.jgo.JGoLayer;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObjList;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectCollection;
import com.nwoods.jgo.JGoObjectSimpleCollection;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoPrintPreview;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoStroke;
import com.nwoods.jgo.JGoSubGraph;
import com.nwoods.jgo.JGoTextEdit;
import com.nwoods.jgo.JGoViewEvent;
import com.nwoods.jgo.JGoViewListener;
import java.applet.Applet;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class JGoView
extends JComponent
implements JGoObjectCollection,
Printable,
ClipboardOwner,
Autoscroll,
DragGestureListener,
DragSourceListener,
DropTargetListener,
JGoDocumentListener,
KeyListener {
    public static final int MouseStateNone = 0;
    public static final int MouseStateSelection = 1;
    public static final int MouseStateMove = 2;
    public static final int MouseStateCreateLink = 3;
    public static final int MouseStateCreateLinkFrom = 4;
    public static final int MouseStateResize = 5;
    public static final int MouseStateDragBoxSelection = 6;
    public static final int MouseStateAction = 7;
    public static final int MouseStateLast = 100;
    public static final int EventMouseDown = 1;
    public static final int EventMouseMove = 2;
    public static final int EventMouseUp = 3;
    public static final int DebugEvents = 1;
    public static final int GridInvisible = 0;
    public static final int GridDot = 1;
    public static final int GridCross = 2;
    public static final int GridLine = 3;
    public static final int NoSnap = 0;
    public static final int SnapJump = 1;
    public static final int SnapAfter = 2;
    public static final int ChangedDimensions = 0;
    public static final int ChangedStyle = 1;
    public static final int ChangedSpot = 2;
    public static final int ChangedSnapMove = 3;
    public static final int ChangedSnapResize = 4;
    public static final int ChangedPen = 5;
    public static final int ChangedOrigin = 6;
    static final int Key_PAGE_UP = 33;
    static final int Key_PAGE_DOWN = 34;
    static final int Key_ENTER = 10;
    static final int Key_ESCAPE = 27;
    static final int Input_SHIFT_MASK = 1;
    static final int Input_CTRL_MASK = 2;
    static final int Input_BUTTON1_MASK = 16;
    static final int DnD_ACTION_NONE = 0;
    static final int DnD_ACTION_COPY = 1;
    static final int DnD_ACTION_MOVE = 2;
    static final int DnD_ACTION_COPY_OR_MOVE = 3;
    static final int DnD_ACTION_LINK = 0x40000000;
    static final int Cursor_DEFAULT = 0;
    static final int Cursor_HAND = 12;
    static final int Cursor_WAIT = 3;
    static final int Cursor_SW_RESIZE = 4;
    static final int Cursor_SE_RESIZE = 5;
    static final int Cursor_NW_RESIZE = 6;
    static final int Cursor_NE_RESIZE = 7;
    static final int Cursor_N_RESIZE = 8;
    static final int Cursor_S_RESIZE = 9;
    static final int Cursor_W_RESIZE = 10;
    static final int Cursor_E_RESIZE = 11;
    static final int Printing_NO_SUCH_PAGE = 1;
    static final int Printing_PAGE_EXISTS = 0;
    private static Color myDefaultPrimarySelectionColor = JGoBrush.ColorGreen;
    private static Color myDefaultSecondarySelectionColor = JGoBrush.ColorCyan;
    private static int myDefaultPortGravity = 100;
    private Image myBackgroundImage = null;
    private JGoViewCanvas myCanvas;
    private JScrollBar myVertScroll;
    private JScrollBar myHorizScroll;
    private JComponent myCornerBox;
    private JGoDocument myDocument;
    private JGoObjList myObjects = new JGoObjList(true);
    private Point myOrigin = new Point(0, 0);
    private double myHorizScale = 1.0;
    private double myVertScale = 1.0;
    private boolean myIncludingNegativeCoords = false;
    private boolean myHidingDisabledScrollbars = false;
    private Insets myAutoscrollInsets = new Insets(12, 12, 12, 12);
    private boolean myUpdatingScrollbars = false;
    private boolean myMouseEnabled = false;
    private boolean myIgnoreNextMouseDown = false;
    private transient int myMouseState;
    private transient Point myMouseDownPoint;
    private transient Point myMoveOffset;
    private transient MouseEvent myMouseEvent;
    private transient Point myMouseDocPoint;
    private transient int myHandleHit;
    private transient JGoObject myCurrentObject;
    private int myMouseActions = 3;
    private boolean myDragsSelectionImage = true;
    private transient JGoSelection myDragSelection;
    private transient JGoObject myDragSelectionOrigObj;
    private boolean myDragEnabled = false;
    private boolean myDropEnabled = false;
    private boolean myDragsRealtime = true;
    private transient boolean myInternalDragStarted;
    private transient boolean myInternalDragDrop;
    private transient DragSource myDragSource;
    private transient DropTarget myDropTarget;
    private transient DragGestureRecognizer myDragGestureRecognizer;
    private transient BufferedImage myDragImage;
    private transient Point myDropDocPoint;
    private transient ArrayList myMoveArrayList;
    private boolean myKeyEnabled = false;
    private JGoSelection mySelection;
    private Color myPrimarySelectionColor = null;
    private Color mySecondarySelectionColor = null;
    private boolean myHideSelectionOnMouse = true;
    private Cursor myDefaultCursor = null;
    private transient JGoPort myTempStartPort;
    private transient JGoPort myTempEndPort;
    private transient JGoLink myTempLink;
    private transient JGoPort myOrigEndPort;
    private boolean myDrawsXorMode = false;
    private transient Rectangle myPrevXORRect;
    private transient boolean myPrevXORRectValid;
    private transient JGoRectangle myMarquee;
    private transient Rectangle myOrigResizeRect;
    private transient Point myOrigResizePoint;
    private transient Point myAnchorPoint;
    private transient JGoTextEdit myTextEdit;
    private transient ArrayList myControls;
    private transient boolean myPrintBegun;
    private transient Dimension myPrintDocSize;
    private transient Point myPrintDocTopLeft;
    private transient Rectangle2D.Double myPrintPageRect;
    private transient int myPrintNumPagesAcross;
    private transient int myPrintNumPagesDown;
    private transient double myPrintHorizScale;
    private transient double myPrintVertScale;
    private transient boolean myIsPrinting;
    private transient ArrayList myViewListeners;
    private transient JGoViewEvent myViewEvent;
    private transient FontRenderContext myFontRenderContext;
    private transient int[][] myTempArraysX;
    private transient int[][] myTempArraysY;
    private transient Point myTempPoint;
    private transient Dimension myTempDimension;
    private transient Rectangle myTempRectangle;
    private int myDebugFlags = 0;
    private transient String myLastEventMsg;
    private transient String myLastHandlerMsg;
    private int myGridWidth = 50;
    private int myGridHeight = 50;
    private int myGridStyle = 0;
    private int mySpotNumber = 1;
    private Point myGridOrigin = new Point(0, 0);
    private JGoPen myGridPen = JGoPen.lightGray;
    private int mySnapMove = 0;
    private int mySnapResize = 0;

    public JGoView() {
        this.init(this.createDefaultModel());
    }

    public JGoView(JGoDocument doc) {
        this.init(doc);
    }

    private final void init(JGoDocument doc) {
        this.myMouseState = 0;
        this.myMouseDownPoint = new Point(0, 0);
        this.myMoveOffset = new Point(0, 0);
        this.myMouseEvent = null;
        this.myMouseDocPoint = new Point(0, 0);
        this.myHandleHit = 0;
        this.myCurrentObject = null;
        this.myDragSelection = null;
        this.myDragSelectionOrigObj = null;
        this.myInternalDragStarted = false;
        this.myInternalDragDrop = false;
        this.myDragSource = null;
        this.myDropTarget = null;
        this.myDragGestureRecognizer = null;
        this.myDragImage = null;
        this.myDropDocPoint = new Point(0, 0);
        this.myMoveArrayList = new ArrayList();
        this.myTempStartPort = null;
        this.myTempEndPort = null;
        this.myTempLink = null;
        this.myOrigEndPort = null;
        this.myPrevXORRect = new Rectangle(0, 0, 0, 0);
        this.myPrevXORRectValid = false;
        this.myMarquee = null;
        this.myOrigResizeRect = new Rectangle(0, 0, 0, 0);
        this.myOrigResizePoint = new Point(0, 0);
        this.myAnchorPoint = new Point(0, 0);
        this.myTextEdit = null;
        this.myControls = new ArrayList();
        this.myPrintBegun = false;
        this.myPrintDocSize = new Dimension();
        this.myPrintDocTopLeft = new Point(0, 0);
        this.myPrintPageRect = new Rectangle2D.Double();
        this.myPrintNumPagesAcross = 1;
        this.myPrintNumPagesDown = 1;
        this.myPrintHorizScale = 1.0;
        this.myPrintVertScale = 1.0;
        this.myIsPrinting = false;
        this.myViewListeners = null;
        this.myViewEvent = null;
        this.myFontRenderContext = null;
        this.myTempArraysX = new int[0][];
        this.myTempArraysY = new int[0][];
        this.myTempPoint = new Point(0, 0);
        this.myTempDimension = new Dimension();
        this.myTempRectangle = new Rectangle(0, 0, 0, 0);
        JGoGlobal.setComponent(this);
        this.mySelection = this.createDefaultSelection();
        this.setLayout(null);
        this.myBackgroundImage = null;
        this.myCanvas = new JGoViewCanvas(this);
        this.add(this.myCanvas);
        this.setBackground(Color.white);
        JScrollBar vsbar = new JScrollBar(1);
        vsbar.setSize(vsbar.getPreferredSize());
        vsbar.setUnitIncrement(this.getGridHeight());
        this.setVerticalScrollBar(vsbar);
        JScrollBar hsbar = new JScrollBar(0);
        hsbar.setSize(hsbar.getPreferredSize());
        hsbar.setUnitIncrement(this.getGridWidth());
        this.setHorizontalScrollBar(hsbar);
        JPanel corner = new JPanel();
        corner.setSize(vsbar.getWidth(), hsbar.getHeight());
        this.setCorner(corner);
        this.setPreferredSize(new Dimension(400, 400));
        this.validate();
        this.setDocument(doc);
        this.setKeyEnabled(true);
        this.initializeMouseHandling();
    }

    public Frame getFrame() {
        Container parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof Applet) && !(parent instanceof Frame); parent = parent.getParent()) {
        }
        if (parent != null) {
            JGoGlobal.setComponent(parent);
            if (parent instanceof Frame) {
                return (Frame)parent;
            }
        }
        return null;
    }

    public void addNotify() {
        super.addNotify();
        Frame frame = this.getFrame();
        if (frame != null) {
            this.initializeDragDropHandling();
        }
    }

    public JGoViewCanvas getCanvas() {
        return this.myCanvas;
    }

    public JScrollBar getVerticalScrollBar() {
        return this.myVertScroll;
    }

    public void setVerticalScrollBar(JScrollBar bar) {
        if (this.myVertScroll != bar) {
            if (this.myVertScroll != null) {
                this.remove(this.myVertScroll);
            }
            this.myVertScroll = bar;
            if (this.myVertScroll != null) {
                this.add(this.myVertScroll);
                JGoViewHelper helper = new JGoViewHelper(this);
                this.myVertScroll.addMouseListener(helper);
                this.myVertScroll.addAdjustmentListener(helper);
            }
            this.validate();
        }
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.myHorizScroll;
    }

    public void setHorizontalScrollBar(JScrollBar bar) {
        if (this.myHorizScroll != bar) {
            if (this.myHorizScroll != null) {
                this.remove(this.myHorizScroll);
            }
            this.myHorizScroll = bar;
            if (this.myHorizScroll != null) {
                this.add(this.myHorizScroll);
                JGoViewHelper helper = new JGoViewHelper(this);
                this.myHorizScroll.addMouseListener(helper);
                this.myHorizScroll.addAdjustmentListener(helper);
            }
            this.validate();
        }
    }

    public JComponent getCorner() {
        return this.myCornerBox;
    }

    public void setCorner(JComponent box) {
        if (this.myCornerBox != box) {
            if (this.myCornerBox != null) {
                this.remove(this.myCornerBox);
            }
            this.myCornerBox = box;
            if (this.myCornerBox != null) {
                this.add(this.myCornerBox);
            }
            this.validate();
        }
    }

    public Image getBackgroundImage() {
        return this.myBackgroundImage;
    }

    public void setBackgroundImage(Image img) {
        Image oldImg = this.myBackgroundImage;
        if (oldImg != img) {
            this.myBackgroundImage = img;
            this.fireUpdate(112, 0, oldImg);
        }
    }

    Color getEffectiveBackgroundColor() {
        Color c = null;
        if (this.getDocument() != null) {
            c = this.getDocument().getPaperColor();
        }
        if (c == null) {
            c = this.getBackground();
        }
        if (c == null) {
            c = JGoBrush.ColorWhite;
        }
        return c;
    }

    public JGoDocument createDefaultModel() {
        return new JGoDocument();
    }

    public JGoDocument getDocument() {
        return this.myDocument;
    }

    public void setDocument(JGoDocument doc) {
        if (doc == null) {
            return;
        }
        JGoDocument oldDoc = this.myDocument;
        if (doc != oldDoc) {
            if (oldDoc != null) {
                this.doCancelMouse();
                this.doEndEdit();
                this.getSelection().clearSelection();
                JGoListPosition pos = this.getFirstObjectPos();
                while (pos != null) {
                    JGoObject obj = this.getObjectAtPos(pos);
                    this.removeObjectAtPos(pos);
                    pos = this.getFirstObjectPos();
                }
                for (int i = 0; i < this.myControls.size(); ++i) {
                    JGoControl c = (JGoControl)this.myControls.get(i);
                    JComponent comp = c.getComponent(this);
                    if (comp == null) continue;
                    Rectangle r = comp.getBounds();
                    this.getCanvas().remove(comp);
                    this.getCanvas().repaint(r.x, r.y, r.width, r.height);
                }
                this.myControls.clear();
                this.setViewPosition(0, 0);
                oldDoc.removeDocumentListener(this);
            }
            this.myDocument = doc;
            doc.addDocumentListener(this);
            this.fireUpdate(1, 0, oldDoc);
        }
    }

    public Dimension getDocumentSize() {
        JGoDocument doc = this.getDocument();
        if (doc != null) {
            Dimension docSize = doc.getDocumentSize();
            int docSizeWidth = docSize.width;
            int docSizeHeight = docSize.height;
            if (!this.isIncludingNegativeCoords()) {
                Point docpnt = doc.getDocumentTopLeft();
                if (docpnt.x < 0) {
                    docSizeWidth += docpnt.x;
                }
                if (docpnt.y < 0) {
                    docSizeHeight += docpnt.y;
                }
            }
            return new Dimension(docSizeWidth + JGoHandle.getDefaultHandleWidth(), docSizeHeight + JGoHandle.getDefaultHandleHeight());
        }
        return new Dimension();
    }

    public Point getDocumentTopLeft() {
        JGoDocument doc = this.getDocument();
        if (doc != null && this.isIncludingNegativeCoords()) {
            return doc.getDocumentTopLeft();
        }
        return new Point(0, 0);
    }

    public boolean isIncludingNegativeCoords() {
        return this.myIncludingNegativeCoords;
    }

    public void setIncludingNegativeCoords(boolean b) {
        if (this.myIncludingNegativeCoords != b) {
            this.myIncludingNegativeCoords = b;
            this.fireUpdate(114, b ? 0 : 1, null);
        }
    }

    public boolean isHidingDisabledScrollbars() {
        return this.myHidingDisabledScrollbars;
    }

    public void setHidingDisabledScrollbars(boolean b) {
        if (this.myHidingDisabledScrollbars != b) {
            this.myHidingDisabledScrollbars = b;
            this.fireUpdate(113, b ? 0 : 1, null);
            this.invalidate();
        }
    }

    public void convertViewToDoc(Point p) {
        Point pos = this.getViewPosition();
        p.x = (int)((double)p.x / this.getHorizScale()) + pos.x;
        p.y = (int)((double)p.y / this.getVertScale()) + pos.y;
    }

    public void convertViewToDoc(Dimension d) {
        d.width = (int)Math.ceil((double)d.width / this.getHorizScale());
        d.height = (int)Math.ceil((double)d.height / this.getVertScale());
    }

    public void convertViewToDoc(Rectangle r) {
        Point pos = this.getViewPosition();
        r.x = (int)((double)r.x / this.getHorizScale()) + pos.x;
        r.y = (int)((double)r.y / this.getVertScale()) + pos.y;
        r.width = (int)Math.ceil((double)r.width / this.getHorizScale());
        r.height = (int)Math.ceil((double)r.height / this.getVertScale());
    }

    public final Point viewToDocCoords(Point v) {
        Point p = new Point(v.x, v.y);
        this.convertViewToDoc(p);
        return p;
    }

    public final Dimension viewToDocCoords(Dimension v) {
        Dimension d = new Dimension(v);
        this.convertViewToDoc(d);
        return d;
    }

    public final Rectangle viewToDocCoords(Rectangle v) {
        Rectangle r = new Rectangle(v.x, v.y, v.width, v.height);
        this.convertViewToDoc(r);
        return r;
    }

    public final Rectangle viewToDocCoords(Point p, Dimension d) {
        Rectangle r = new Rectangle(p.x, p.y, d.width, d.height);
        this.convertViewToDoc(r);
        return r;
    }

    public final Rectangle viewToDocCoords(int x, int y, int w, int h) {
        Rectangle r = new Rectangle(x, y, w, h);
        this.convertViewToDoc(r);
        return r;
    }

    public void convertDocToView(Point p) {
        Point pos = this.getViewPosition();
        p.x = (int)((double)(p.x - pos.x) * this.getHorizScale());
        p.y = (int)((double)(p.y - pos.y) * this.getVertScale());
    }

    public void convertDocToView(Dimension d) {
        d.width = (int)Math.ceil((double)d.width * this.getHorizScale());
        d.height = (int)Math.ceil((double)d.height * this.getVertScale());
    }

    public void convertDocToView(Rectangle r) {
        Point pos = this.getViewPosition();
        r.x = (int)((double)(r.x - pos.x) * this.getHorizScale());
        r.y = (int)((double)(r.y - pos.y) * this.getVertScale());
        r.width = (int)Math.ceil((double)r.width * this.getHorizScale());
        r.height = (int)Math.ceil((double)r.height * this.getVertScale());
    }

    public final Point docToViewCoords(Point d) {
        Point p = new Point(d.x, d.y);
        this.convertDocToView(p);
        return p;
    }

    public final Dimension docToViewCoords(Dimension d) {
        Dimension dim = new Dimension(d);
        this.convertDocToView(dim);
        return dim;
    }

    public final Rectangle docToViewCoords(Rectangle d) {
        Rectangle r = new Rectangle(d.x, d.y, d.width, d.height);
        this.convertDocToView(r);
        return r;
    }

    public final Rectangle docToViewCoords(Point p, Dimension d) {
        Rectangle r = new Rectangle(p.x, p.y, d.width, d.height);
        this.convertDocToView(r);
        return r;
    }

    public final Rectangle docToViewCoords(int x, int y, int w, int h) {
        Rectangle r = new Rectangle(x, y, w, h);
        this.convertDocToView(r);
        return r;
    }

    public final void setViewPosition(Point p) {
        this.setViewPosition(p.x, p.y);
    }

    public void setViewPosition(int x, int y) {
        Point oldOrig = this.myOrigin;
        if (!this.isIncludingNegativeCoords()) {
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
        }
        if (oldOrig.x != x || oldOrig.y != y) {
            Point oldViewPos = new Point(oldOrig.x, oldOrig.y);
            this.myOrigin.x = x;
            this.myOrigin.y = y;
            this.fireUpdate(107, 0, oldViewPos);
        }
    }

    public Point getViewPosition() {
        return this.myOrigin;
    }

    public Dimension getExtentSize() {
        int w = this.getCanvas().getWidth();
        int h = this.getCanvas().getHeight();
        return new Dimension((int)((double)w / this.getHorizScale()), (int)((double)h / this.getVertScale()));
    }

    public Rectangle getViewRect() {
        Point p = this.getViewPosition();
        Dimension d = this.getExtentSize();
        return new Rectangle(p.x, p.y, d.width, d.height);
    }

    public void scrollRectToVisible(Rectangle contentRect) {
        Rectangle viewRect = this.getViewRect();
        if (this.containsRect(viewRect, contentRect)) {
            return;
        }
        Dimension size = this.getExtentSize();
        int newx = contentRect.width < size.width ? contentRect.x + contentRect.width / 2 - size.width / 2 : contentRect.x;
        int newy = contentRect.height < size.height ? contentRect.y + contentRect.height / 2 - size.height / 2 : contentRect.y;
        this.setViewPosition(newx, newy);
    }

    public void setScale(double scale) {
        double s = this.limitScale(scale);
        if (this.myHorizScale != s || this.myVertScale != s) {
            double oldScale = this.myHorizScale;
            this.myHorizScale = s;
            this.myVertScale = s;
            this.fireUpdate(108, 0, new Double(oldScale));
        }
    }

    public double getScale() {
        return this.myHorizScale;
    }

    public double limitScale(double s) {
        if (s < 0.05) {
            s = 0.05;
        }
        if (s > 10.0) {
            s = 10.0;
        }
        return s;
    }

    private final double getHorizScale() {
        return this.myHorizScale;
    }

    private final double getVertScale() {
        return this.myVertScale;
    }

    public JGoObject pickDocObject(Point pointToCheck, boolean selectableOnly) {
        JGoLayer layer = this.getLastLayer();
        while (layer != null) {
            JGoObject obj = layer.pickObject(pointToCheck, selectableOnly);
            if (obj != null) {
                return obj;
            }
            layer = this.getPrevLayer(layer);
        }
        return null;
    }

    public JGoObject pickObject(Point pointToCheck, boolean selectableOnly) {
        JGoListPosition pos = this.getLastObjectPos();
        while (pos != null) {
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getPrevObjectPos(pos);
            JGoObject picked = obj.pick(pointToCheck, selectableOnly);
            if (picked == null) continue;
            return picked;
        }
        return null;
    }

    public int getNumObjects() {
        return this.myObjects.getNumObjects();
    }

    public boolean isEmpty() {
        return this.myObjects.isEmpty();
    }

    public JGoListPosition addObjectAtHead(JGoObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getParent() != null) {
            return null;
        }
        if (obj.getLayer() != null) {
            return null;
        }
        if (obj.getView() != null) {
            if (obj.getView() != this) {
                return null;
            }
            this.myObjects.removeObject(obj);
            JGoListPosition objpos = this.myObjects.addObjectAtHead(obj);
            obj.update(10, 0, null);
            return objpos;
        }
        JGoListPosition objpos = this.myObjects.addObjectAtHead(obj);
        obj.setView(this, obj);
        return objpos;
    }

    public JGoListPosition addObjectAtTail(JGoObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getParent() != null) {
            return null;
        }
        if (obj.getLayer() != null) {
            return null;
        }
        if (obj.getView() != null) {
            if (obj.getView() != this) {
                return null;
            }
            this.myObjects.removeObject(obj);
            JGoListPosition objpos = this.myObjects.addObjectAtTail(obj);
            obj.update(10, 0, null);
            return objpos;
        }
        JGoListPosition objpos = this.myObjects.addObjectAtTail(obj);
        obj.setView(this, obj);
        return objpos;
    }

    public JGoListPosition insertObjectBefore(JGoListPosition pos, JGoObject obj) {
        if (pos == null || obj == null) {
            return null;
        }
        if (obj.getParent() != null) {
            return null;
        }
        if (obj.getLayer() != null) {
            return null;
        }
        if (obj.getView() != null) {
            if (obj.getView() != this) {
                return null;
            }
            JGoListPosition oldpos = this.myObjects.findObject(obj);
            if (oldpos != null) {
                this.myObjects.removeObjectAtPos(oldpos);
                JGoListPosition objpos = this.myObjects.insertObjectBefore(pos, obj);
                obj.update(10, 0, null);
                return objpos;
            }
        }
        JGoListPosition objpos = this.myObjects.insertObjectBefore(pos, obj);
        obj.setView(this, obj);
        return objpos;
    }

    public JGoListPosition insertObjectAfter(JGoListPosition pos, JGoObject obj) {
        if (pos == null || obj == null) {
            return null;
        }
        if (obj.getParent() != null) {
            return null;
        }
        if (obj.getLayer() != null) {
            return null;
        }
        if (obj.getView() != null) {
            if (obj.getView() != this) {
                return null;
            }
            JGoListPosition oldpos = this.myObjects.findObject(obj);
            if (oldpos != null) {
                this.myObjects.removeObjectAtPos(oldpos);
                JGoListPosition objpos = this.myObjects.insertObjectAfter(pos, obj);
                obj.update(10, 0, null);
                return objpos;
            }
        }
        JGoListPosition objpos = this.myObjects.insertObjectAfter(pos, obj);
        obj.setView(this, obj);
        return objpos;
    }

    public void bringObjectToFront(JGoObject obj) {
        this.addObjectAtTail(obj);
    }

    public void sendObjectToBack(JGoObject obj) {
        this.addObjectAtHead(obj);
    }

    public void removeObject(JGoObject obj) {
        if (obj == null) {
            return;
        }
        if (obj.getView() != this) {
            return;
        }
        JGoArea area = obj.getParent();
        if (area != null) {
            area.removeObject(obj);
        } else {
            JGoListPosition pos = this.findObject(obj);
            if (pos != null) {
                this.removeObjectAtPos(pos);
            }
        }
    }

    public JGoObject removeObjectAtPos(JGoListPosition pos) {
        JGoObject obj = this.myObjects.removeObjectAtPos(pos);
        if (obj != null) {
            obj.setView(null, obj);
        }
        return obj;
    }

    public JGoListPosition getFirstObjectPos() {
        return this.myObjects.getFirstObjectPos();
    }

    public JGoListPosition getLastObjectPos() {
        return this.myObjects.getLastObjectPos();
    }

    public JGoListPosition getNextObjectPos(JGoListPosition pos) {
        JGoObjectCollection area;
        if (pos == null) {
            return null;
        }
        JGoObject obj = pos.obj;
        if (obj instanceof JGoObjectCollection && !(area = (JGoObjectCollection)((Object)obj)).isEmpty()) {
            return area.getFirstObjectPos();
        }
        pos = pos.next;
        while (pos == null) {
            JGoArea parent = obj.getParent();
            if (parent == null) {
                return null;
            }
            JGoListPosition parentpos = parent.getCurrentListPosition();
            obj = parent;
            pos = parentpos.next;
        }
        return pos;
    }

    public JGoListPosition getNextObjectPosAtTop(JGoListPosition pos) {
        if (pos == null) {
            return null;
        }
        JGoObject obj = pos.obj;
        while (obj.getParent() != null) {
            pos = obj.getParent().getCurrentListPosition();
            obj = obj.getParent();
        }
        return pos.next;
    }

    public JGoListPosition getPrevObjectPos(JGoListPosition pos) {
        return this.myObjects.getPrevObjectPos(pos);
    }

    public JGoObject getObjectAtPos(JGoListPosition pos) {
        return this.myObjects.getObjectAtPos(pos);
    }

    public JGoListPosition findObject(JGoObject obj) {
        if (obj.getView() == this) {
            return this.myObjects.findObject(obj);
        }
        return null;
    }

    public JGoSelection createDefaultSelection() {
        return new JGoSelection(this);
    }

    public JGoSelection getSelection() {
        return this.mySelection;
    }

    public JGoObject selectObject(JGoObject obj) {
        return this.getSelection().selectObject(obj);
    }

    public void selectAll() {
        JGoSelection selection = this.getSelection();
        JGoLayer layer = this.getFirstLayer();
        while (layer != null) {
            if (layer.isVisible()) {
                JGoListPosition pos = layer.getFirstObjectPos();
                while (pos != null) {
                    JGoObject obj = layer.getObjectAtPos(pos);
                    pos = layer.getNextObjectPosAtTop(pos);
                    if (!obj.isVisible() || !obj.isSelectable() && obj.redirectSelection() == obj) continue;
                    this.getSelection().extendSelection(obj);
                }
            }
            layer = this.getNextLayer(layer);
        }
    }

    private boolean containsRect(Rectangle rect, Rectangle obj) {
        int width = rect.width;
        int height = rect.height;
        int W = obj.width;
        int H = obj.height;
        if (width <= 0 || height <= 0 || W < 0 || H < 0) {
            return false;
        }
        int x = rect.x;
        int y = rect.y;
        int X = obj.x;
        int Y = obj.y;
        return X >= x && Y >= y && X + W <= x + width && Y + H <= y + height;
    }

    public void selectInBox(Rectangle rect) {
        JGoObject obj;
        ArrayList coll = new ArrayList();
        JGoLayer layer = this.getFirstLayer();
        while (layer != null) {
            if (layer.isVisible()) {
                JGoListPosition pos = layer.getFirstObjectPos();
                while (pos != null) {
                    obj = layer.getObjectAtPos(pos);
                    pos = layer.getNextObjectPosAtTop(pos);
                    this.selectObjectInBox(obj, rect, coll);
                }
            }
            layer = this.getNextLayer(layer);
        }
        for (int i = 0; i < coll.size(); ++i) {
            obj = (JGoObject)coll.get(i);
            this.getSelection().extendSelection(obj);
        }
    }

    private void selectObjectInBox(JGoObject obj, Rectangle rect, ArrayList coll) {
        if (!obj.isVisible()) {
            return;
        }
        if (obj.isSelectable() && obj.redirectSelection() != null && this.containsRect(rect, obj.redirectSelection().getBoundingRect())) {
            coll.add(obj);
        } else if (obj instanceof JGoArea) {
            JGoArea a = (JGoArea)obj;
            JGoListPosition pos = a.getFirstObjectPos();
            while (pos != null) {
                JGoObject o = a.getObjectAtPos(pos);
                pos = a.getNextObjectPosAtTop(pos);
                this.selectObjectInBox(o, rect, coll);
            }
        }
    }

    public Color getPrimarySelectionColor() {
        if (this.myPrimarySelectionColor == null) {
            return JGoView.getDefaultPrimarySelectionColor();
        }
        return this.myPrimarySelectionColor;
    }

    public void setPrimarySelectionColor(Color newcolor) {
        Color oldColor = this.getPrimarySelectionColor();
        if (newcolor == null || !oldColor.equals(newcolor)) {
            this.myPrimarySelectionColor = newcolor;
            this.fireUpdate(109, 0, oldColor);
        }
    }

    public Color getSecondarySelectionColor() {
        if (this.mySecondarySelectionColor == null) {
            return JGoView.getDefaultSecondarySelectionColor();
        }
        return this.mySecondarySelectionColor;
    }

    public void setSecondarySelectionColor(Color newcolor) {
        Color oldColor = this.getSecondarySelectionColor();
        if (newcolor == null || !oldColor.equals(newcolor)) {
            this.mySecondarySelectionColor = newcolor;
            this.fireUpdate(109, 1, oldColor);
        }
    }

    protected void onPaintComponent(Graphics g) {
        try {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform oldtrans = g2.getTransform();
            Rectangle clipRect = new Rectangle(0, 0, 0, 0);
            g2.getClipBounds(clipRect);
            this.convertViewToDoc(clipRect);
            g2.scale(this.getHorizScale(), this.getVertScale());
            Point viewLoc = this.getViewPosition();
            g2.translate(-viewLoc.x, -viewLoc.y);
            this.paintView(g2, clipRect);
            g2.setTransform(oldtrans);
        }
        catch (ClassCastException ex) {
            Dimension canvassize = this.getCanvas().getSize();
            BufferedImage img = new BufferedImage(canvassize.width, canvassize.height, 1);
            Graphics2D g2 = img.createGraphics();
            g2.scale(this.getHorizScale(), this.getVertScale());
            Point viewLoc = this.getViewPosition();
            g2.translate(-viewLoc.x, -viewLoc.y);
            this.paintView(g2, this.getViewRect());
            g2.dispose();
            g.drawImage(img, 0, 0, this.getCanvas());
        }
    }

    public void applyRenderingHints(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        if (JGoGlobal.isAtLeastJavaVersion(1.4)) {
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
    }

    protected void paintView(Graphics2D g2, Rectangle clipRect) {
        this.applyRenderingHints(g2);
        this.paintPaperColor(g2, clipRect);
        this.paintBackgroundDecoration(g2, clipRect);
        this.paintDocumentObjects(g2, clipRect);
        this.paintViewObjects(g2, clipRect);
    }

    protected void paintPaperColor(Graphics2D g2, Rectangle clipRect) {
        g2.setColor(this.getEffectiveBackgroundColor());
        g2.fillRect(clipRect.x, clipRect.y, clipRect.width + 5, clipRect.height + 5);
    }

    protected void paintBackgroundDecoration(Graphics2D g2, Rectangle clipRect) {
        Image img = this.getBackgroundImage();
        if (img != null) {
            g2.drawImage(img, 0, 0, this);
        }
        switch (this.getGridStyle()) {
            case 0: {
                break;
            }
            case 3: {
                this.drawGridLines(g2, clipRect);
                break;
            }
            case 1: {
                this.drawGridCrosses(g2, 1, 1, clipRect);
                break;
            }
            case 2: {
                this.drawGridCrosses(g2, 6, 6, clipRect);
            }
        }
    }

    protected void paintDocumentObjects(Graphics2D g2, Rectangle clipRect) {
        float transp = 1.0f;
        JGoLayer layer = this.getFirstLayer();
        while (layer != null) {
            if (layer.isVisible()) {
                if (layer.getTransparency() != transp) {
                    transp = layer.getTransparency();
                    AlphaComposite comp = AlphaComposite.getInstance(3, transp);
                    g2.setComposite(comp);
                }
                this.myFontRenderContext = g2.getFontRenderContext();
                layer.paint(g2, this, clipRect);
            }
            layer = this.getNextLayer(layer);
        }
        if (transp != 1.0f) {
            g2.setComposite(AlphaComposite.SrcOver);
        }
    }

    protected void paintViewObjects(Graphics2D g2, Rectangle clipRect) {
        this.myFontRenderContext = g2.getFontRenderContext();
        Rectangle objRect = new Rectangle(0, 0, 0, 0);
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPosAtTop(pos);
            if (!obj.isVisible()) continue;
            Rectangle b = obj.getBoundingRect();
            objRect.x = b.x;
            objRect.y = b.y;
            objRect.width = b.width;
            objRect.height = b.height;
            obj.expandRectByPenWidth(objRect);
            if (!objRect.intersects(clipRect)) continue;
            obj.paint(g2, this);
        }
        for (int i = 0; i < this.myControls.size(); ++i) {
            JGoControl c = (JGoControl)this.myControls.get(i);
            c.paint(g2, this);
        }
    }

    FontRenderContext getFontRenderContext() {
        return this.myFontRenderContext;
    }

    public void updateScrollbars() {
        boolean needhbar;
        JScrollBar hscroll = this.getHorizontalScrollBar();
        JScrollBar vscroll = this.getVerticalScrollBar();
        if (hscroll == null && vscroll == null) {
            return;
        }
        Dimension maxDim = this.getDocumentSize();
        Point minPnt = this.getDocumentTopLeft();
        Point viewLoc = this.getViewPosition();
        Insets insets = this.getInsets();
        int scrollHeight = this.getHeight() - insets.top - insets.bottom;
        int scrollWidth = this.getWidth() - insets.left - insets.right;
        int docHeight = (int)((double)scrollHeight / this.getVertScale());
        int docWidth = (int)((double)scrollWidth / this.getHorizScale());
        boolean needvbar = docHeight < maxDim.height || viewLoc.y > minPnt.y || viewLoc.y + docHeight < minPnt.y + maxDim.height;
        boolean bl = needhbar = docWidth < maxDim.width || viewLoc.x > minPnt.x || viewLoc.x + docWidth < minPnt.x + maxDim.width;
        if (hscroll != null && (this.isScrollbarVisible(hscroll) || needhbar)) {
            docHeight = (int)((double)(scrollHeight -= this.getScrollbarHeight(hscroll)) / this.getVertScale());
        }
        if (vscroll != null && (this.isScrollbarVisible(vscroll) || needvbar)) {
            docWidth = (int)((double)(scrollWidth -= this.getScrollbarWidth(vscroll)) / this.getHorizScale());
        }
        needvbar = docHeight < maxDim.height || viewLoc.y > minPnt.y || viewLoc.y + docHeight < minPnt.y + maxDim.height;
        needhbar = docWidth < maxDim.width || viewLoc.x > minPnt.x || viewLoc.x + docWidth < minPnt.x + maxDim.width;
        this.myUpdatingScrollbars = true;
        boolean needvalidate = false;
        if (vscroll != null) {
            vscroll.setValues(viewLoc.y, docHeight, minPnt.y, minPnt.y + maxDim.height);
            vscroll.setEnabled(needvbar);
            if (needvbar && !this.isScrollbarVisible(vscroll)) {
                vscroll.setVisible(true);
                needvalidate = true;
            } else if (!needvbar && this.isHidingDisabledScrollbars() && this.isScrollbarVisible(vscroll)) {
                vscroll.setVisible(false);
                needvalidate = true;
            }
        }
        if (hscroll != null) {
            hscroll.setValues(viewLoc.x, docWidth, minPnt.x, minPnt.x + maxDim.width);
            hscroll.setEnabled(needhbar);
            if (needhbar && !this.isScrollbarVisible(hscroll)) {
                hscroll.setVisible(true);
                needvalidate = true;
            } else if (!needhbar && this.isHidingDisabledScrollbars() && this.isScrollbarVisible(hscroll)) {
                hscroll.setVisible(false);
                needvalidate = true;
            }
        }
        if (needvalidate) {
            this.validate();
        }
        this.myUpdatingScrollbars = false;
    }

    public void updateView(Rectangle viewRect) {
        JGoViewCanvas canvas = this.getCanvas();
        if (viewRect.x < canvas.getWidth() && viewRect.y < canvas.getHeight() && viewRect.x + viewRect.width >= 0 && viewRect.y + viewRect.height >= 0) {
            canvas.repaint(viewRect);
        }
    }

    public void updateView() {
        Rectangle wholeCanvas = new Rectangle(0, 0, this.getCanvas().getWidth(), this.getCanvas().getHeight());
        this.updateView(wholeCanvas);
        this.updateScrollbars();
    }

    public void addViewListener(JGoViewListener l) {
        if (this.myViewListeners == null) {
            this.myViewListeners = new ArrayList();
        }
        if (!this.myViewListeners.contains(l)) {
            this.myViewListeners.add(l);
        }
    }

    public void removeViewListener(JGoViewListener l) {
        if (this.myViewListeners != null) {
            this.myViewListeners.remove(l);
        }
    }

    public JGoViewListener[] getViewListeners() {
        if (this.myViewListeners == null) {
            return null;
        }
        Object[] objListeners = this.myViewListeners.toArray();
        JGoViewListener[] jgoviewListeners = new JGoViewListener[objListeners.length];
        for (int i = 0; i < objListeners.length; ++i) {
            jgoviewListeners[i] = (JGoViewListener)objListeners[i];
        }
        return jgoviewListeners;
    }

    public void addDocumentListener(JGoDocumentListener l) {
        if (this.getDocument() != null) {
            this.getDocument().addDocumentListener(l);
        }
    }

    public void removeDocumentListener(JGoDocumentListener l) {
        if (this.getDocument() != null) {
            this.getDocument().removeDocumentListener(l);
        }
    }

    public JGoDocumentListener[] getDocumentListeners() {
        return this.getDocument().getDocumentListeners();
    }

    public final void fireUpdate(int hint, int flags, Object x) {
        this.fireUpdate(hint, flags, x, null, null, 0);
    }

    public void fireUpdate(int hint, int flags, Object x, Point vc, Point dc, int modifiers) {
        switch (hint) {
            case 1: {
                this.updateView();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                JGoObject obj = (JGoObject)x;
                Rectangle b = obj.getBoundingRect();
                Rectangle repaintRect = new Rectangle(b.x, b.y, b.width, b.height);
                obj.expandRectByPenWidth(repaintRect);
                this.convertDocToView(repaintRect);
                --repaintRect.x;
                --repaintRect.y;
                repaintRect.width += 2;
                repaintRect.height += 2;
                this.updateView(repaintRect);
                break;
            }
            case 107: {
                this.updateView();
                break;
            }
            case 108: {
                this.updateView();
                break;
            }
            case 109: {
                this.updateView();
                break;
            }
            case 112: {
                this.updateView();
                break;
            }
            case 124: {
                this.updateView();
            }
        }
        if (this.myViewListeners != null && this.myViewListeners.size() > 0) {
            if (this.myViewEvent == null) {
                this.myViewEvent = new JGoViewEvent(this, hint, flags, x, vc, dc, modifiers);
            } else {
                this.myViewEvent.setHint(hint);
                this.myViewEvent.setFlags(flags);
                this.myViewEvent.setObject(x);
                this.myViewEvent.setPointViewCoords(vc);
                this.myViewEvent.setPointDocCoords(dc);
                this.myViewEvent.setModifiers(modifiers);
                this.myViewEvent.setConsumed(false);
            }
            JGoViewEvent e = this.myViewEvent;
            this.myViewEvent = null;
            this.invokeViewListeners(e);
            this.myViewEvent = e;
            this.myViewEvent.setObject(null);
        }
    }

    void invokeViewListeners(JGoViewEvent e) {
        if (this.myViewListeners != null) {
            for (int i = 0; i < this.myViewListeners.size(); ++i) {
                JGoViewListener l = (JGoViewListener)this.myViewListeners.get(i);
                l.viewChanged(e);
            }
        }
    }

    public void documentChanged(JGoDocumentEvent evt) {
        JGoObject obj = evt.getJGoObject();
        if (evt.isBeforeChanging()) {
            if (evt.getHint() == 203) {
                Rectangle repaintRect = evt.getTempRectangle();
                Rectangle b = obj.getBoundingRect();
                repaintRect.x = b.x;
                repaintRect.y = b.y;
                repaintRect.width = b.width;
                repaintRect.height = b.height;
                obj.expandRectByPenWidth(repaintRect);
                this.convertDocToView(repaintRect);
                --repaintRect.x;
                --repaintRect.y;
                repaintRect.width += 2;
                repaintRect.height += 2;
                this.updateView(repaintRect);
            }
            return;
        }
        switch (evt.getHint()) {
            case 203: {
                JGoSelection sel;
                Rectangle repaintRect = evt.getTempRectangle();
                Rectangle b = obj.getBoundingRect();
                repaintRect.x = b.x;
                repaintRect.y = b.y;
                repaintRect.width = b.width;
                repaintRect.height = b.height;
                obj.expandRectByPenWidth(repaintRect);
                this.convertDocToView(repaintRect);
                --repaintRect.x;
                --repaintRect.y;
                repaintRect.width += 2;
                repaintRect.height += 2;
                this.updateView(repaintRect);
                if (evt.getFlags() == 1) {
                    b = (Rectangle)evt.getPreviousValue();
                    repaintRect.x = b.x;
                    repaintRect.y = b.y;
                    repaintRect.width = b.width;
                    repaintRect.height = b.height;
                    obj.expandRectByPenWidth(repaintRect);
                    this.convertDocToView(repaintRect);
                    --repaintRect.x;
                    --repaintRect.y;
                    repaintRect.width += 2;
                    repaintRect.height += 2;
                    this.updateView(repaintRect);
                    JGoSelection sel2 = this.getSelection();
                    if (sel2.getNumHandles(obj) <= 0) break;
                    if (obj.isVisible()) {
                        obj.showSelectionHandles(sel2);
                        break;
                    }
                    obj.hideSelectionHandles(sel2);
                    break;
                }
                if (evt.getFlags() != 2 || !(sel = this.getSelection()).isSelected(obj)) break;
                if (obj.isVisible()) {
                    obj.showSelectionHandles(sel);
                    break;
                }
                obj.hideSelectionHandles(sel);
                break;
            }
            case 202: {
                Rectangle repaintRect = evt.getTempRectangle();
                Rectangle b = obj.getBoundingRect();
                repaintRect.x = b.x;
                repaintRect.y = b.y;
                repaintRect.width = b.width;
                repaintRect.height = b.height;
                obj.expandRectByPenWidth(repaintRect);
                this.convertDocToView(repaintRect);
                --repaintRect.x;
                --repaintRect.y;
                repaintRect.width += 2;
                repaintRect.height += 2;
                this.updateView(repaintRect);
                break;
            }
            case 204: {
                this.getSelection().clearSelection(obj);
                Rectangle repaintRect = evt.getTempRectangle();
                Rectangle b = obj.getBoundingRect();
                repaintRect.x = b.x;
                repaintRect.y = b.y;
                repaintRect.width = b.width;
                repaintRect.height = b.height;
                obj.expandRectByPenWidth(repaintRect);
                this.convertDocToView(repaintRect);
                --repaintRect.x;
                --repaintRect.y;
                repaintRect.width += 2;
                repaintRect.height += 2;
                this.updateView(repaintRect);
                break;
            }
            case 205: {
                this.updateScrollbars();
                break;
            }
            case 209: {
                this.updateScrollbars();
                break;
            }
            case 100: 
            case 108: 
            case 110: 
            case 206: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 215: 
            case 218: {
                this.getSelection().restoreSelectionHandles(null);
                this.updateView();
                break;
            }
        }
    }

    public void print() {
        this.getTopLevelAncestor().setEnabled(false);
        this.getCanvas().setEnabled(false);
        PrinterJob pj = PrinterJob.getPrinterJob();
        Thread t = new Thread(new JGoViewHelper(this, pj));
        t.start();
    }

    private void internalPrint(PrinterJob pj) {
        PageFormat defaultpf = pj.validatePage(pj.defaultPage());
        PageFormat pf = pj.pageDialog(defaultpf);
        if (pf != defaultpf) {
            int pageCount = this.calculatePageCount(pf);
            Book book = new Book();
            book.append(this, pf, pageCount);
            pj.setPageable(book);
            if (pj.printDialog()) {
                boolean wasDblBuff = this.isDoubleBuffered();
                try {
                    this.setDoubleBuffered(false);
                    pj.print();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.setDoubleBuffered(wasDblBuff);
            }
        }
        this.getTopLevelAncestor().setEnabled(true);
    }

    protected void printBegin(Graphics2D g2, PageFormat pf) {
        if (!this.myPrintBegun) {
            this.myPrintBegun = true;
            this.myPrintDocSize = this.getPrintDocumentSize();
            this.myPrintDocTopLeft = this.getPrintDocumentTopLeft();
            int docWidth = this.myPrintDocSize.width;
            int docHeight = this.myPrintDocSize.height;
            this.myPrintPageRect = this.getPrintPageRect(g2, pf);
            double pageWidth = this.myPrintPageRect.width;
            double pageHeight = this.myPrintPageRect.height;
            this.myPrintVertScale = this.myPrintHorizScale = this.getPrintScale(g2, pf);
            this.myPrintNumPagesAcross = (int)Math.ceil((double)docWidth * this.myPrintHorizScale / pageWidth);
            this.myPrintNumPagesDown = (int)Math.ceil((double)docHeight * this.myPrintVertScale / pageHeight);
        }
    }

    public Dimension getPrintDocumentSize() {
        JGoDocument doc = this.getDocument();
        Dimension maxDim = new Dimension(1, 1);
        if (doc == null) {
            return maxDim;
        }
        int minx = 0;
        int miny = 0;
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        JGoListPosition pos = doc.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = doc.getObjectAtPos(pos);
            pos = doc.getNextObjectPosAtTop(pos);
            Rectangle b = obj.getBoundingRect();
            bounds.x = b.x;
            bounds.y = b.y;
            bounds.width = b.width;
            bounds.height = b.height;
            obj.expandRectByPenWidth(bounds);
            if (bounds.x < minx) {
                minx = bounds.x;
            }
            if (bounds.y < miny) {
                miny = bounds.y;
            }
            if (bounds.x + bounds.width > maxDim.width) {
                maxDim.width = bounds.x + bounds.width;
            }
            if (bounds.y + bounds.height <= maxDim.height) continue;
            maxDim.height = bounds.y + bounds.height;
        }
        if (this.isIncludingNegativeCoords()) {
            if (minx < 0) {
                maxDim.width -= minx;
            }
            if (miny < 0) {
                maxDim.height -= miny;
            }
        }
        return maxDim;
    }

    public Point getPrintDocumentTopLeft() {
        Point minPnt = new Point(0, 0);
        if (this.isIncludingNegativeCoords()) {
            JGoDocument doc = this.getDocument();
            if (doc == null) {
                return minPnt;
            }
            int minx = minPnt.x;
            int miny = minPnt.y;
            Rectangle bounds = new Rectangle(0, 0, 0, 0);
            JGoListPosition pos = doc.getFirstObjectPos();
            while (pos != null) {
                JGoObject obj = doc.getObjectAtPos(pos);
                pos = doc.getNextObjectPosAtTop(pos);
                Rectangle b = obj.getBoundingRect();
                bounds.x = b.x;
                bounds.y = b.y;
                bounds.width = b.width;
                bounds.height = b.height;
                obj.expandRectByPenWidth(bounds);
                if (bounds.x < minx) {
                    minx = bounds.x;
                }
                if (bounds.y >= miny) continue;
                miny = bounds.y;
            }
            minPnt.x = minx;
            minPnt.y = miny;
        }
        return minPnt;
    }

    protected Rectangle2D.Double getPrintPageRect(Graphics2D g2, PageFormat pf) {
        return new Rectangle2D.Double(pf.getImageableX(), pf.getImageableY(), pf.getImageableWidth(), pf.getImageableHeight());
    }

    protected double getPrintScale(Graphics2D g2, PageFormat pf) {
        return 1.0;
    }

    protected void printEnd(Graphics2D g2, PageFormat pf) {
        this.myPrintBegun = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int print(Graphics g, PageFormat pf, int pnum) {
        Graphics2D g2 = (Graphics2D)g;
        this.printBegin(g2, pf);
        double pageX = this.myPrintPageRect.x;
        double pageY = this.myPrintPageRect.y;
        double pageWidth = this.myPrintPageRect.width;
        double pageHeight = this.myPrintPageRect.height;
        if (pnum >= this.myPrintNumPagesAcross * this.myPrintNumPagesDown) {
            this.printEnd(g2, pf);
            return 1;
        }
        int hpnum = pnum % this.myPrintNumPagesAcross;
        int vpnum = pnum / this.myPrintNumPagesAcross;
        this.printDecoration(g2, pf, hpnum, vpnum);
        Point oldorigin = this.getViewPosition();
        double oldhscale = this.getHorizScale();
        double oldvscale = this.getVertScale();
        try {
            this.myOrigin = new Point((int)((double)this.myPrintDocTopLeft.x + (double)hpnum * (pageWidth / this.myPrintHorizScale)), (int)((double)this.myPrintDocTopLeft.y + (double)vpnum * (pageHeight / this.myPrintVertScale)));
            this.myHorizScale = this.myPrintHorizScale;
            this.myVertScale = this.myPrintVertScale;
            g2.clip(this.myPrintPageRect);
            Rectangle clipRect = new Rectangle(0, 0, 0, 0);
            g2.getClipBounds(clipRect);
            clipRect.x -= (int)pageX;
            clipRect.y -= (int)pageY;
            this.convertViewToDoc(clipRect);
            g2.translate(pageX, pageY);
            g2.scale(this.getHorizScale(), this.getVertScale());
            Point viewLoc = this.getViewPosition();
            g2.translate(-viewLoc.x, -viewLoc.y);
            this.myIsPrinting = true;
            this.printView(g2, clipRect);
        }
        finally {
            this.myIsPrinting = false;
            this.myOrigin = oldorigin;
            this.myHorizScale = oldhscale;
            this.myVertScale = oldvscale;
        }
        return 0;
    }

    private int calculatePageCount(PageFormat pf) {
        Rectangle2D.Double pageRect = new Rectangle2D.Double(pf.getImageableX(), pf.getImageableY(), pf.getImageableWidth(), pf.getImageableHeight());
        Dimension docSize = this.getPrintDocumentSize();
        int docWidth = docSize.width;
        int docHeight = docSize.height;
        double pageWidth = pageRect.width;
        double pageHeight = pageRect.height;
        int pagesAcross = (int)Math.ceil((double)docWidth * this.myPrintHorizScale / pageWidth);
        int pagesDown = (int)Math.ceil((double)docHeight * this.myPrintVertScale / pageHeight);
        return pagesAcross * pagesDown;
    }

    public boolean isPrinting() {
        return this.myIsPrinting;
    }

    protected void printDecoration(Graphics2D g2, PageFormat pf, int hpnum, int vpnum) {
        double pageX = this.myPrintPageRect.x;
        double pageY = this.myPrintPageRect.y;
        double pageWidth = this.myPrintPageRect.width;
        double pageHeight = this.myPrintPageRect.height;
        double pageR = pageX + pageWidth;
        double pageB = pageY + pageHeight;
        Paint oldpaint = g2.getPaint();
        g2.setPaint(Color.black);
        Stroke oldstroke = g2.getStroke();
        g2.setStroke(new BasicStroke(0.7f));
        g2.draw(new Line2D.Double(pageX, pageY, pageX + 10.0, pageY));
        g2.draw(new Line2D.Double(pageX, pageY, pageX, pageY + 10.0));
        g2.draw(new Line2D.Double(pageR, pageY, pageR - 10.0, pageY));
        g2.draw(new Line2D.Double(pageR, pageY, pageR, pageY + 10.0));
        g2.draw(new Line2D.Double(pageX, pageB, pageX + 10.0, pageB));
        g2.draw(new Line2D.Double(pageX, pageB, pageX, pageB - 10.0));
        g2.draw(new Line2D.Double(pageR, pageB, pageR - 10.0, pageB));
        g2.draw(new Line2D.Double(pageR, pageB, pageR, pageB - 10.0));
        g2.setPaint(oldpaint);
        g2.setStroke(oldstroke);
    }

    protected void printView(Graphics2D g2, Rectangle clipRect) {
        this.applyRenderingHints(g2);
        this.paintBackgroundDecoration(g2, clipRect);
        this.paintDocumentObjects(g2, clipRect);
    }

    public void printPreview() {
        PrinterJob prnJob = PrinterJob.getPrinterJob();
        PageFormat pf = prnJob.defaultPage();
        this.printPreview("Print Preview", pf);
    }

    public void printPreview(String title, PageFormat pf) {
        int pageCount = this.calculatePageCount(pf);
        JGoPrintPreview pp = new JGoPrintPreview(this, title, pf, pageCount);
        pp.show();
    }

    boolean isScrollbarVisible(JScrollBar b) {
        return b.isVisible();
    }

    int getScrollbarWidth(JScrollBar b) {
        return b.getWidth();
    }

    int getScrollbarHeight(JScrollBar b) {
        return b.getHeight();
    }

    public void doLayout() {
        int blockincr;
        int unitincr;
        super.doLayout();
        JComponent corner = this.getCorner();
        JScrollBar hscroll = this.getHorizontalScrollBar();
        JScrollBar vscroll = this.getVerticalScrollBar();
        int width = this.getWidth();
        int height = this.getHeight();
        Insets insets = this.getInsets();
        int canvasX = insets.left;
        int canvasY = insets.top;
        int cornerW = 0;
        int cornerH = 0;
        if (hscroll != null && this.isScrollbarVisible(hscroll)) {
            cornerH = hscroll.getHeight();
        }
        if (vscroll != null && this.isScrollbarVisible(vscroll)) {
            cornerW = vscroll.getWidth();
        }
        int cornerX = width - cornerW - insets.right;
        int cornerY = height - cornerH - insets.bottom;
        int canvasW = cornerX - canvasX;
        int canvasH = cornerY - canvasY;
        this.getCanvas().setBounds(canvasX, canvasY, canvasW, canvasH);
        if (hscroll != null && this.isScrollbarVisible(hscroll)) {
            hscroll.setBounds(canvasX, cornerY, canvasW, cornerH);
            unitincr = hscroll.getUnitIncrement();
            int canvasWdoc = (int)((double)canvasW / this.getHorizScale());
            blockincr = Math.max(unitincr, canvasWdoc - unitincr);
            hscroll.setBlockIncrement(blockincr);
        }
        if (vscroll != null && this.isScrollbarVisible(vscroll)) {
            vscroll.setBounds(cornerX, canvasY, cornerW, canvasH);
            unitincr = vscroll.getUnitIncrement();
            int canvasHdoc = (int)((double)canvasH / this.getVertScale());
            blockincr = Math.max(unitincr, canvasHdoc - unitincr);
            vscroll.setBlockIncrement(blockincr);
        }
        if (corner != null) {
            if (cornerW != 0 && cornerH != 0) {
                corner.setBounds(cornerX, cornerY, cornerW, cornerH);
                corner.setVisible(true);
            } else {
                corner.setVisible(false);
            }
        }
        this.updateScrollbars();
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.validate();
    }

    public final void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.validate();
    }

    public final void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension size = this.getDocumentSize();
        Dimension prefsize = new Dimension(size);
        this.convertDocToView(prefsize);
        Dimension minsize = this.getMinimumSize();
        prefsize.width = Math.max(prefsize.width, minsize.width);
        prefsize.height = Math.max(prefsize.height, minsize.height);
        return prefsize;
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        return new Dimension(50, 50);
    }

    protected void onScrollEvent(AdjustmentEvent evt) {
        JScrollBar vscroll;
        if (this.myUpdatingScrollbars) {
            return;
        }
        Point viewLoc = this.getViewPosition();
        int newx = viewLoc.x;
        int newy = viewLoc.y;
        JScrollBar hscroll = this.getHorizontalScrollBar();
        if (hscroll != null) {
            newx = hscroll.getValue();
        }
        if ((vscroll = this.getVerticalScrollBar()) != null) {
            newy = vscroll.getValue();
        }
        this.setViewPosition(newx, newy);
    }

    public void setKeyEnabled(boolean m) {
        if (m && !this.myKeyEnabled) {
            this.myKeyEnabled = true;
            this.addKeyListener(this);
            this.fireUpdate(115, 0, null);
        } else if (!m && this.myKeyEnabled) {
            this.myKeyEnabled = false;
            this.removeKeyListener(this);
            this.fireUpdate(115, 1, null);
        }
    }

    public boolean isKeyEnabled() {
        return this.myKeyEnabled;
    }

    public void keyPressed(KeyEvent evt) {
        if (!this.isKeyEnabled()) {
            return;
        }
        this.onKeyEvent(evt);
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void onKeyEvent(KeyEvent evt) {
        int t = evt.getKeyCode();
        if (t == 33 || t == 34) {
            int bound;
            int direction;
            JScrollBar bar = evt.isControlDown() ? this.getHorizontalScrollBar() : this.getVerticalScrollBar();
            if (bar == null) {
                return;
            }
            if (t == 33) {
                direction = -1;
                bound = bar.getMaximum();
            } else {
                direction = 1;
                bound = bar.getMinimum();
            }
            int v = bar.getValue();
            int step = bar.getBlockIncrement(direction);
            int newv = v + direction * step;
            newv = direction == 1 ? Math.max(newv, bound) : Math.min(newv, bound);
            bar.setValue(newv);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isIgnoreNextMouseDown() {
        return this.myIgnoreNextMouseDown;
    }

    public void setIgnoreNextMouseDown(boolean bFlag) {
        this.myIgnoreNextMouseDown = bFlag;
    }

    protected boolean keyToggleSelection(int modifiers) {
        return (modifiers & 2) != 0;
    }

    protected boolean keyExtendSelection(int modifiers) {
        return (modifiers & 1) != 0;
    }

    protected boolean keySingleSelection(int modifiers) {
        return true;
    }

    protected final boolean keyMultipleSelect(int modifiers) {
        return this.keyExtendSelection(modifiers);
    }

    protected boolean keyClearSelection(int modifiers) {
        boolean shifted = (modifiers & 1) != 0;
        boolean control = (modifiers & 2) != 0;
        return !shifted && !control;
    }

    protected void initializeMouseHandling() {
        this.getCanvas().setToolTipText("");
        this.addMouseListener(new JGoViewHelper(this));
        this.setMouseEnabled(true);
    }

    public void setMouseEnabled(boolean m) {
        if (m && !this.myMouseEnabled) {
            this.myMouseEnabled = true;
            this.getCanvas().addMouseListener(this.getCanvas());
            this.getCanvas().addMouseMotionListener(this.getCanvas());
            this.fireUpdate(116, 0, null);
        } else if (!m && this.myMouseEnabled) {
            this.myMouseEnabled = false;
            this.getCanvas().removeMouseListener(this.getCanvas());
            this.getCanvas().removeMouseMotionListener(this.getCanvas());
            this.fireUpdate(116, 1, null);
        }
    }

    public boolean isMouseEnabled() {
        return this.myMouseEnabled;
    }

    protected final MouseEvent getCurrentMouseEvent() {
        return this.myMouseEvent;
    }

    Point getMouseEventPoint(MouseEvent evt) {
        return evt.getPoint();
    }

    int getMouseEventModifiers(MouseEvent evt) {
        return evt.getModifiers();
    }

    protected void onMousePressed(MouseEvent evt) {
        if (!this.isMouseEnabled()) {
            return;
        }
        this.TRACE("onMouse Pressed", evt);
        boolean hadfocus = this.hasFocus();
        if (!hadfocus) {
            JInternalFrame internalFrame = null;
            for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof JInternalFrame)) continue;
                internalFrame = (JInternalFrame)parent;
                break;
            }
            if (internalFrame != null && JGoGlobal.isAtLeastJavaVersion(1.3) && !JGoGlobal.isAtLeastJavaVersion(1.4)) {
                try {
                    internalFrame.setSelected(false);
                    internalFrame.setSelected(true);
                }
                catch (Exception x) {
                    // empty catch block
                }
            }
            this.requestFocus();
            if (internalFrame != null && !JGoGlobal.isAtLeastJavaVersion(1.22)) {
                this.setIgnoreNextMouseDown(false);
                return;
            }
        }
        boolean ignoredown = this.isIgnoreNextMouseDown();
        this.setIgnoreNextMouseDown(false);
        if (!hadfocus && ignoredown) {
            return;
        }
        this.myMouseEvent = evt;
        Point viewCoords = this.getMouseEventPoint(evt);
        this.myMouseDocPoint.x = viewCoords.x;
        this.myMouseDocPoint.y = viewCoords.y;
        this.convertViewToDoc(this.myMouseDocPoint);
        if (evt.getClickCount() == 1) {
            this.doMouseDown(this.getMouseEventModifiers(evt), this.myMouseDocPoint, viewCoords);
        }
        this.myMouseEvent = null;
    }

    protected void onMouseReleased(MouseEvent evt) {
        if (!this.isMouseEnabled()) {
            return;
        }
        this.TRACE("onMouse Released", evt);
        this.myInternalDragStarted = false;
        if (!this.hasFocus() && !JGoGlobal.isAtLeastJavaVersion(1.22)) {
            if (this.getState() != 0) {
                this.doCancelMouse();
            }
            return;
        }
        this.myMouseEvent = evt;
        Point viewCoords = this.getMouseEventPoint(evt);
        this.myMouseDocPoint.x = viewCoords.x;
        this.myMouseDocPoint.y = viewCoords.y;
        this.convertViewToDoc(this.myMouseDocPoint);
        if (evt.getClickCount() <= 1) {
            if (this.doMouseUp(this.getMouseEventModifiers(evt), this.myMouseDocPoint, viewCoords)) {
                this.setState(0);
            }
        } else {
            this.TRACE("onMouse Double Click", evt);
            this.doMouseDblClick(this.getMouseEventModifiers(evt), this.myMouseDocPoint, viewCoords);
        }
        this.myMouseEvent = null;
    }

    protected void onMouseMoved(MouseEvent evt) {
        if (!this.isMouseEnabled()) {
            return;
        }
        this.TRACE("onMouse Moved", evt);
        this.myInternalDragStarted = false;
        if (!this.hasFocus() && !JGoGlobal.isAtLeastJavaVersion(1.22)) {
            if (this.getState() != 0) {
                this.doCancelMouse();
            }
            this.setIgnoreNextMouseDown(true);
            return;
        }
        this.myMouseEvent = evt;
        Point viewCoords = this.getMouseEventPoint(evt);
        this.myMouseDocPoint.x = viewCoords.x;
        this.myMouseDocPoint.y = viewCoords.y;
        this.convertViewToDoc(this.myMouseDocPoint);
        this.doMouseMove(this.getMouseEventModifiers(evt), this.myMouseDocPoint, viewCoords);
        this.myMouseEvent = null;
    }

    protected void onMouseDragged(MouseEvent evt) {
        if (!this.isMouseEnabled()) {
            return;
        }
        this.TRACE("onMouse Dragged", evt);
        if (!this.hasFocus() && !JGoGlobal.isAtLeastJavaVersion(1.22)) {
            if (this.getState() != 0) {
                this.doCancelMouse();
            }
            return;
        }
        if (!this.isDragEnabled() || this.myInternalDragStarted) {
            this.myMouseEvent = evt;
            Point viewCoords = this.getMouseEventPoint(evt);
            this.myMouseDocPoint.x = viewCoords.x;
            this.myMouseDocPoint.y = viewCoords.y;
            this.convertViewToDoc(this.myMouseDocPoint);
            this.doMouseMove(this.getMouseEventModifiers(evt), this.myMouseDocPoint, viewCoords);
            this.myMouseEvent = null;
        } else {
            this.myInternalDragStarted = true;
        }
    }

    public boolean doMouseDown(int modifiers, Point dc, Point vc) {
        this.TRACE("  doMouse  Down");
        this.myMouseDownPoint.x = dc.x;
        this.myMouseDownPoint.y = dc.y;
        JGoActionObject actionobj = this.pickActionObject(dc);
        if (actionobj != null && this.startActionObject(actionobj, modifiers, dc, vc)) {
            return true;
        }
        if ((modifiers & 0x10) != 0 && this.getDocument() != null && this.getDocument().isModifiable()) {
            JGoHandle handle = this.pickHandle(dc);
            if (handle != null && this.startResizing(handle, dc, vc)) {
                return true;
            }
            JGoPort port = this.pickPort(dc);
            if (port != null && this.startNewLink(port, dc)) {
                return true;
            }
        }
        this.setCurrentObject(this.pickDocObject(dc, true));
        if (this.getCurrentObject() != null) {
            this.setState(1);
        } else {
            this.startDragBoxSelection(modifiers, dc, vc);
        }
        return true;
    }

    public boolean doMouseMove(int modifiers, Point dc, Point vc) {
        this.TRACE("  doMouse  Move");
        switch (this.getState()) {
            case 0: {
                this.doUncapturedMouseMove(modifiers, dc, vc);
                break;
            }
            case 1: {
                if (this.getCurrentObject() == null) {
                    this.startDragBoxSelection(modifiers, dc, vc);
                    break;
                }
                this.startMoveSelection(modifiers, dc, vc);
                break;
            }
            case 2: {
                int offsetx = dc.x - this.getCurrentObject().getLeft() - this.myMoveOffset.x;
                int offsety = dc.y - this.getCurrentObject().getTop() - this.myMoveOffset.y;
                this.doMoveSelection(modifiers, offsetx, offsety, 2);
                break;
            }
            case 6: {
                Graphics2D g = this.getJGoGraphics();
                this.myAnchorPoint.x = this.myMouseDownPoint.x;
                this.myAnchorPoint.y = this.myMouseDownPoint.y;
                this.convertDocToView(this.myAnchorPoint);
                this.drawXORBox(g, this.myAnchorPoint.x, this.myAnchorPoint.y, vc.x, vc.y, 2);
                this.disposeJGoGraphics(g);
                break;
            }
            case 5: {
                Graphics2D g = this.getJGoGraphics();
                this.handleResizing(g, vc, dc, 2);
                this.disposeJGoGraphics(g);
                break;
            }
            case 3: {
                JGoPort port = this.pickNearestPort(dc);
                if (port != null) {
                    Point pt = port.getToLinkPoint(this.myAnchorPoint);
                    this.myTempEndPort.setLocation(pt);
                    break;
                }
                this.myTempEndPort.setLocation(dc);
                break;
            }
            case 4: {
                JGoPort port = this.pickNearestPort(dc);
                if (port != null) {
                    Point pt = port.getFromLinkPoint(this.myAnchorPoint);
                    this.myTempEndPort.setLocation(pt);
                    break;
                }
                this.myTempEndPort.setLocation(dc);
                break;
            }
            case 7: {
                this.handleActionObject(modifiers, dc, vc, 2);
            }
        }
        return true;
    }

    public boolean doMouseUp(int modifiers, Point dc, Point vc) {
        this.TRACE("  doMouse  Up");
        switch (this.getState()) {
            case 1: {
                if (this.getCurrentObject() != null) {
                    if (this.keyExtendSelection(modifiers)) {
                        this.setCurrentObject(this.getSelection().extendSelection(this.getCurrentObject()));
                    } else if (this.keyToggleSelection(modifiers)) {
                        this.setCurrentObject(this.getSelection().toggleSelection(this.getCurrentObject()));
                    } else if (this.keySingleSelection(modifiers)) {
                        this.setCurrentObject(this.selectObject(this.getCurrentObject()));
                    }
                } else if (this.keyClearSelection(modifiers)) {
                    this.getSelection().clearSelection();
                }
                this.doMouseClick(modifiers, dc, vc);
                break;
            }
            case 2: {
                int offsetx = dc.x - this.getCurrentObject().getLeft() - this.myMoveOffset.x;
                int offsety = dc.y - this.getCurrentObject().getTop() - this.myMoveOffset.y;
                this.doMoveSelection(modifiers, offsetx, offsety, 3);
                if (!this.myHideSelectionOnMouse) break;
                this.getSelection().restoreSelectionHandles(null);
                break;
            }
            case 6: {
                Graphics2D g = this.getJGoGraphics();
                this.myAnchorPoint.x = this.myMouseDownPoint.x;
                this.myAnchorPoint.y = this.myMouseDownPoint.y;
                this.convertDocToView(this.myAnchorPoint);
                this.drawXORBox(g, this.myAnchorPoint.x, this.myAnchorPoint.y, vc.x, vc.y, 3);
                this.disposeJGoGraphics(g);
                if (Math.abs(vc.x - this.myAnchorPoint.x) < 3 && Math.abs(vc.y - this.myAnchorPoint.y) < 3) {
                    this.doBackgroundClick(modifiers, dc, vc);
                    break;
                }
                Rectangle rect = this.viewToDocCoords(this.myPrevXORRect);
                this.selectInBox(rect);
                break;
            }
            case 5: {
                Graphics2D g = this.getJGoGraphics();
                this.handleResizing(g, vc, dc, 3);
                if (this.myHideSelectionOnMouse) {
                    this.getSelection().restoreSelectionHandles(this.getCurrentObject());
                }
                this.disposeJGoGraphics(g);
                break;
            }
            case 3: {
                JGoPort port = this.pickNearestPort(dc);
                if (port != null) {
                    if (this.myTempLink == null || this.myTempLink.getLayer() == null) {
                        this.removeObject(this.myTempLink);
                        this.newLink(this.myTempStartPort, port);
                    } else {
                        this.reLink(this.myTempLink, this.myTempStartPort, port);
                        if (this.myHideSelectionOnMouse) {
                            this.getSelection().restoreSelectionHandles(this.myTempLink);
                        }
                    }
                } else {
                    JGoPort invalidPort = this.pickPort(dc);
                    if (this.myTempLink == null || this.myTempLink.getLayer() == null) {
                        this.removeObject(this.myTempLink);
                        this.noNewLink(this.myTempStartPort, invalidPort);
                    } else {
                        this.noReLink(this.myTempLink, this.myTempStartPort, invalidPort);
                    }
                }
                this.myTempLink = null;
                this.myTempStartPort = null;
                this.myTempEndPort = null;
                this.myOrigEndPort = null;
                break;
            }
            case 4: {
                JGoPort port = this.pickNearestPort(dc);
                if (port != null) {
                    if (this.myTempLink == null || this.myTempLink.getLayer() == null) {
                        this.removeObject(this.myTempLink);
                        this.newLink(port, this.myTempStartPort);
                    } else {
                        this.reLink(this.myTempLink, port, this.myTempStartPort);
                        if (this.myHideSelectionOnMouse) {
                            this.getSelection().restoreSelectionHandles(this.myTempLink);
                        }
                    }
                } else {
                    JGoPort invalidPort = this.pickPort(dc);
                    if (this.myTempLink == null || this.myTempLink.getLayer() == null) {
                        this.removeObject(this.myTempLink);
                        this.noNewLink(invalidPort, this.myTempStartPort);
                    } else {
                        this.noReLink(this.myTempLink, invalidPort, this.myTempStartPort);
                    }
                }
                this.myTempLink = null;
                this.myTempStartPort = null;
                this.myTempEndPort = null;
                this.myOrigEndPort = null;
                break;
            }
            case 7: {
                this.handleActionObject(modifiers, dc, vc, 3);
                break;
            }
        }
        this.setState(0);
        return true;
    }

    public boolean doMouseClick(int modifiers, Point dc, Point vc) {
        JGoObject obj = this.pickDocObject(dc, false);
        if (obj != null) {
            this.fireUpdate(22, 0, obj, vc, dc, modifiers);
            while (obj != null) {
                if (obj.doMouseClick(modifiers, dc, vc, this)) {
                    return true;
                }
                obj = obj.getParent();
            }
        } else {
            this.doBackgroundClick(modifiers, dc, vc);
        }
        return false;
    }

    public boolean doMouseDblClick(int modifiers, Point dc, Point vc) {
        JGoObject obj = this.pickDocObject(dc, false);
        if (obj != null) {
            this.fireUpdate(23, 0, obj, vc, dc, modifiers);
            while (obj != null) {
                if (obj.doMouseDblClick(modifiers, dc, vc, this)) {
                    return true;
                }
                obj = obj.getParent();
            }
        } else {
            this.fireUpdate(25, 0, null, vc, dc, modifiers);
        }
        return false;
    }

    public void doCancelMouse() {
        this.TRACE("mouse Cancelled");
        if (!JGoGlobal.isAtLeastJavaVersion(1.4)) {
            this.setIgnoreNextMouseDown(true);
        }
        switch (this.getState()) {
            case 2: {
                this.doCancelMoveSelection(this.myMoveOffset);
                if (!this.myHideSelectionOnMouse) break;
                this.getSelection().restoreSelectionHandles(null);
                break;
            }
            case 6: {
                Graphics2D g = this.getJGoGraphics();
                this.drawXORBox(g, 0, 0, 0, 0, 3);
                this.disposeJGoGraphics(g);
                break;
            }
            case 5: {
                this.doCancelResize(this.myOrigResizeRect);
                if (this.getCurrentObject() == null || !this.myHideSelectionOnMouse) break;
                this.getSelection().restoreSelectionHandles(this.getCurrentObject());
                break;
            }
            case 3: {
                if (this.myTempLink == null || this.myTempLink.getLayer() == null) {
                    this.removeObject(this.myTempLink);
                    this.noNewLink(this.myTempStartPort, null);
                } else if (this.myOrigEndPort == null) {
                    this.noReLink(this.myTempLink, this.myTempStartPort, null);
                } else {
                    this.myTempLink.setToPort(this.myOrigEndPort);
                    if (this.myHideSelectionOnMouse) {
                        this.getSelection().restoreSelectionHandles(this.myTempLink);
                    }
                    if (this.getDocument() != null) {
                        this.getDocument().endTransaction(false);
                    }
                }
                this.myTempLink = null;
                this.myTempStartPort = null;
                this.myTempEndPort = null;
                this.myOrigEndPort = null;
                break;
            }
            case 4: {
                if (this.myTempLink == null || this.myTempLink.getLayer() == null) {
                    this.removeObject(this.myTempLink);
                    this.noNewLink(null, this.myTempStartPort);
                } else if (this.myOrigEndPort == null) {
                    this.noReLink(this.myTempLink, null, this.myTempStartPort);
                } else {
                    this.myTempLink.setFromPort(this.myOrigEndPort);
                    if (this.myHideSelectionOnMouse) {
                        this.getSelection().restoreSelectionHandles(this.myTempLink);
                    }
                    if (this.getDocument() != null) {
                        this.getDocument().endTransaction(false);
                    }
                }
                this.myTempLink = null;
                this.myTempStartPort = null;
                this.myTempEndPort = null;
                this.myOrigEndPort = null;
                break;
            }
            case 7: {
                if (!(this.getCurrentObject() instanceof JGoActionObject)) break;
                JGoActionObject actionobj = (JGoActionObject)((Object)this.getCurrentObject());
                actionobj.onActionCancelled(this);
                actionobj.setActionActivated(false);
            }
        }
        this.setState(0);
        this.setCursor(this.getDefaultCursor());
    }

    public final int getState() {
        return this.myMouseState;
    }

    public void setState(int s) {
        this.myMouseState = s;
    }

    public final JGoObject getCurrentObject() {
        return this.myCurrentObject;
    }

    public void setCurrentObject(JGoObject obj) {
        this.myCurrentObject = obj;
    }

    public void doUncapturedMouseMove(int modifiers, Point dc, Point vc) {
        JGoObject obj = this.pickObject(dc, false);
        if (obj != null && obj.doUncapturedMouseMove(modifiers, dc, vc, this)) {
            return;
        }
        for (obj = this.pickDocObject(dc, false); obj != null; obj = obj.getParent()) {
            if (!obj.doUncapturedMouseMove(modifiers, dc, vc, this)) continue;
            return;
        }
        this.setCursor(this.getDefaultCursor());
    }

    public void setCursor(Cursor cur) {
        if (this.getCursor() == cur) {
            return;
        }
        if (JGoGlobal.isAtLeastJavaVersion(1.3)) {
            this.setCursorImmediately(cur);
        } else {
            Thread t = new Thread(new JGoViewHelper(new JGoViewHelper(this, cur)));
            t.start();
        }
    }

    public void setCursorImmediately(Cursor cur) {
        super.setCursor(cur);
    }

    void setCursorType(int cursortype) {
        this.setCursor(Cursor.getPredefinedCursor(cursortype));
    }

    public Cursor getDefaultCursor() {
        if (this.myDefaultCursor == null) {
            this.myDefaultCursor = Cursor.getPredefinedCursor(0);
        }
        return this.myDefaultCursor;
    }

    public void setDefaultCursor(Cursor cursor) {
        Cursor oldCursor = this.myDefaultCursor;
        if (oldCursor != cursor) {
            this.myDefaultCursor = cursor;
            this.fireUpdate(119, 0, oldCursor);
        }
    }

    public void doBackgroundClick(int modifiers, Point dc, Point vc) {
        this.fireUpdate(24, 0, null, vc, dc, modifiers);
    }

    public void doMoveSelection(int modifiers, int offsetx, int offsety, int event) {
        JGoDocument doc = this.getDocument();
        if (doc != null && doc.isModifiable()) {
            int copymods;
            if (event == 1) {
                doc.startTransaction();
            }
            boolean control = (modifiers & (copymods = this.convertActionToModifiers(1))) == copymods;
            int action = this.getInternalMouseActions();
            boolean copyallowed = (action & 1) != 0;
            boolean copyrequired = action == 1;
            boolean copying = copyrequired | copyallowed & control;
            if (event != 3) {
                if (copying || !this.isDragsRealtime()) {
                    this.makeDragSelection();
                    this.moveSelection(this.getDragSelection(), modifiers, offsetx, offsety, event);
                } else {
                    this.clearDragSelection();
                    boolean oldskip = doc.isSkipsUndoManager();
                    if (event == 1 && this.isDragsRealtime()) {
                        this.moveSelection(this.getSelection(), modifiers, 10, 10, event);
                        doc.setSkipsUndoManager(true);
                        this.moveSelection(this.getSelection(), modifiers, -10, -10, event);
                        doc.setSkipsUndoManager(oldskip);
                    } else {
                        if (event == 2) {
                            doc.setSkipsUndoManager(true);
                        }
                        this.moveSelection(this.getSelection(), modifiers, offsetx, offsety, event);
                        if (event == 2) {
                            doc.setSkipsUndoManager(oldskip);
                        }
                    }
                }
            } else {
                Point docOffset = new Point(0, 0);
                if (this.myDragSelection != null) {
                    docOffset.x = this.getCurrentObject().getLeft() - this.myDragSelectionOrigObj.getLeft();
                    docOffset.y = this.getCurrentObject().getTop() - this.myDragSelectionOrigObj.getTop();
                } else {
                    docOffset.x = offsetx;
                    docOffset.y = offsety;
                }
                this.clearDragSelection();
                JGoSelection sel = this.getSelection();
                if (copying) {
                    this.copySelection(sel, modifiers, docOffset.x, docOffset.y, event);
                } else if (docOffset.x == 0 && docOffset.y == 0 && this.isDragsRealtime()) {
                    boolean oldskip = doc.isSkipsUndoManager();
                    doc.setSkipsUndoManager(true);
                    this.moveSelection(sel, modifiers, 10, 10, event);
                    doc.setSkipsUndoManager(oldskip);
                    this.moveSelection(sel, modifiers, -10, -10, event);
                } else {
                    this.moveSelection(sel, modifiers, docOffset.x, docOffset.y, event);
                }
            }
            if (event == 3) {
                if (copying) {
                    this.fireUpdate(27, 0, null);
                    doc.endTransaction(this.getEditPresentationName(2));
                } else {
                    this.fireUpdate(26, 0, null);
                    doc.endTransaction(this.getEditPresentationName(1));
                }
            }
        }
    }

    public boolean isDragsRealtime() {
        return this.myDragsRealtime;
    }

    public void setDragsRealtime(boolean bFlag) {
        boolean old = this.myDragsRealtime;
        if (old != bFlag) {
            this.myDragsRealtime = bFlag;
            this.fireUpdate(120, old ? 1 : 0, null);
        }
    }

    public int getInternalMouseActions() {
        return this.myMouseActions;
    }

    public void setInternalMouseActions(int m) {
        int old = this.myMouseActions;
        if (old != m) {
            this.myMouseActions = m;
            this.fireUpdate(121, old, null);
        }
    }

    public boolean isDragsSelectionImage() {
        return this.myDragsSelectionImage;
    }

    public void setDragsSelectionImage(boolean bFlag) {
        boolean old = this.myDragsSelectionImage;
        if (old != bFlag) {
            this.myDragsSelectionImage = bFlag;
            this.fireUpdate(122, old ? 1 : 0, null);
        }
    }

    JGoSelection getDragSelection() {
        return this.myDragSelection;
    }

    JGoSelection createDragSelection() {
        if (this.getCurrentObject() == null) {
            return null;
        }
        JGoSelection dropSel = new JGoSelection(this);
        if (this.isDragsSelectionImage()) {
            DragRectangle currob = new DragRectangle(this.getCurrentObject().getBoundingRect());
            currob.setVisible(false);
            this.addObjectAtTail(currob);
            dropSel.extendSelection(currob);
            this.setCurrentObject(currob);
            JGoSelection sel = this.getSelection();
            Rectangle bounds = JGoDocument.computeBounds(sel);
            int w = Math.max(1, (int)Math.ceil(bounds.width));
            int h = Math.max(1, (int)Math.ceil(bounds.height));
            Rectangle objRect = new Rectangle(0, 0, 0, 0);
            float transp = 1.0f;
            BufferedImage myDragBuffer = new BufferedImage(w, h, 2);
            Graphics2D g2 = myDragBuffer.createGraphics();
            g2.translate(-bounds.x, -bounds.y);
            this.applyRenderingHints(g2);
            JGoListPosition pos = sel.getFirstObjectPos();
            while (pos != null) {
                JGoLayer layer;
                JGoObject obj = sel.getObjectAtPos(pos);
                pos = sel.getNextObjectPosAtTop(pos);
                if (!(obj = obj.getDraggingObject()).isVisible() || (layer = obj.getLayer()) == null || !layer.isVisible()) continue;
                if (layer.getTransparency() != transp) {
                    transp = layer.getTransparency();
                    AlphaComposite comp = AlphaComposite.getInstance(3, transp);
                    g2.setComposite(comp);
                }
                this.myFontRenderContext = g2.getFontRenderContext();
                Rectangle b = obj.getBoundingRect();
                objRect.x = b.x;
                objRect.y = b.y;
                objRect.width = b.width;
                objRect.height = b.height;
                obj.expandRectByPenWidth(objRect);
                if (!objRect.intersects(bounds)) continue;
                obj.paint(g2, this);
            }
            g2.dispose();
            DragImage img = new DragImage(bounds);
            img.setImage(myDragBuffer);
            myDragBuffer.flush();
            this.addObjectAtTail(img);
            dropSel.extendSelection(img);
        } else {
            JGoSelection sel = this.getSelection();
            JGoListPosition pos = sel.getFirstObjectPos();
            while (pos != null) {
                JGoDrawable ghost;
                JGoObject obj = sel.getObjectAtPos(pos);
                pos = sel.getNextObjectPosAtTop(pos);
                if (obj instanceof JGoLink) {
                    DragStroke newstroke = new DragStroke();
                    JGoStroke oldstroke = (JGoStroke)obj;
                    for (int i = 0; i < oldstroke.getNumPoints(); ++i) {
                        Point oldpoint = oldstroke.getPoint(i);
                        newstroke.addPoint(oldpoint);
                    }
                    ghost = newstroke;
                } else {
                    ghost = new DragRectangle(obj.getBoundingRect());
                }
                this.addObjectAtTail(ghost);
                dropSel.extendSelection(ghost);
                if (this.getCurrentObject() != obj) continue;
                this.setCurrentObject(ghost);
            }
        }
        return dropSel;
    }

    void makeDragSelection() {
        if (this.myDragSelection == null) {
            this.myDragSelectionOrigObj = this.getCurrentObject();
            this.myDragSelection = this.createDragSelection();
            if (this.myDragSelection.isEmpty()) {
                this.myDragSelectionOrigObj = null;
                this.myDragSelection = null;
                return;
            }
            this.moveSelection(this.getSelection(), 0, this.myMouseDownPoint.x - this.myMoveOffset.x - this.myDragSelectionOrigObj.getLeft(), this.myMouseDownPoint.y - this.myMoveOffset.y - this.myDragSelectionOrigObj.getTop(), 2);
            if (this.getCurrentObject().getView() != this) {
                this.setCurrentObject(this.myDragSelection.getObjectAtPos(this.myDragSelection.getFirstObjectPos()));
            }
        }
    }

    void clearDragSelection() {
        if (this.myDragSelection != null) {
            JGoListPosition pos = this.myDragSelection.getFirstObjectPos();
            while (pos != null) {
                JGoObject obj = this.myDragSelection.getObjectAtPos(pos);
                this.removeObject(obj);
                pos = this.myDragSelection.getNextObjectPosAtTop(pos);
            }
            this.myDragSelection = null;
            this.setCurrentObject(this.myDragSelectionOrigObj);
            this.myDragSelectionOrigObj = null;
        }
    }

    public void moveSelection(JGoSelection sel, int modifiers, int offsetx, int offsety, int event) {
        int j;
        if (sel == null) {
            sel = this.getSelection();
        }
        if (sel.isEmpty()) {
            return;
        }
        boolean grid = false;
        int snapmove = this.getSnapMove();
        if (snapmove == 1 || snapmove == 2 && event == 3) {
            grid = true;
        }
        ArrayList safecoll = this.computeEffectiveSelection(sel);
        Point temp = new Point(0, 0);
        int spotNumber = this.getGridSpot();
        JGoObject firstnonlink = null;
        for (int j2 = 0; j2 < safecoll.size(); ++j2) {
            JGoObject obj = (JGoObject)safecoll.get(j2);
            if (obj instanceof JGoLink) continue;
            firstnonlink = obj;
            break;
        }
        int realoffsetx = offsetx;
        int realoffsety = offsety;
        if (firstnonlink != null && grid) {
            Point spot = firstnonlink.getSpotLocation(spotNumber, temp);
            int oldspotx = spot.x;
            int oldspoty = spot.y;
            this.findNearestGridPoint(oldspotx + offsetx, oldspoty + offsety, temp);
            int newspotx = temp.x;
            int newspoty = temp.y;
            realoffsetx = newspotx - oldspotx;
            realoffsety = newspoty - oldspoty;
        }
        for (j = 0; j < safecoll.size(); ++j) {
            JGoObject draggable = (JGoObject)safecoll.get(j);
            if (!(draggable instanceof JGoLink)) continue;
            int left = draggable.getLeft();
            int top = draggable.getTop();
            draggable.handleMove(this, modifiers, event, 1, left, top, left + realoffsetx, top + realoffsety);
        }
        for (j = 0; j < safecoll.size(); ++j) {
            JGoObject draggable = (JGoObject)safecoll.get(j);
            if (draggable instanceof JGoLink) continue;
            temp = draggable.getSpotLocation(spotNumber, temp);
            int oldx = temp.x;
            int oldy = temp.y;
            int newx = oldx + offsetx;
            int newy = oldy + offsety;
            if (grid) {
                temp = this.findNearestGridPoint(newx, newy, temp);
                newx = temp.x;
                newy = temp.y;
            }
            draggable.handleMove(this, modifiers, event, spotNumber, oldx, oldy, newx, newy);
        }
    }

    public ArrayList computeEffectiveSelection(JGoObjectSimpleCollection coll) {
        HashMap<JGoObject, JGoObject> moveds = new HashMap<JGoObject, JGoObject>();
        ArrayList<JGoObject> children = null;
        ArrayList<JGoObject> safecoll = new ArrayList<JGoObject>();
        JGoListPosition pos = coll.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = coll.getObjectAtPos(pos);
            pos = coll.getNextObjectPosAtTop(pos);
            JGoObject draggable = obj.getDraggingObject();
            if (draggable == null || !draggable.isDraggable() || this.alreadyMoved(moveds, draggable)) continue;
            if (children != null && draggable instanceof JGoArea) {
                int i = 0;
                while (i < children.size()) {
                    JGoObject child = (JGoObject)children.get(i);
                    if (child.isChildOf(draggable)) {
                        moveds.remove(child);
                        children.remove(i);
                        safecoll.remove(child);
                        continue;
                    }
                    ++i;
                }
            }
            moveds.put(draggable, draggable);
            if (!draggable.isTopLevel()) {
                if (children == null) {
                    children = new ArrayList<JGoObject>();
                }
                children.add(draggable);
            }
            safecoll.add(draggable);
        }
        int safelen = safecoll.size();
        for (int j = 0; j < safelen; ++j) {
            JGoObject draggable = (JGoObject)safecoll.get(j);
            if (!(draggable instanceof JGoArea)) continue;
            JGoArea n = (JGoArea)draggable;
            pos = n.getFirstObjectPos();
            while (pos != null) {
                JGoObject obj = n.getObjectAtPos(pos);
                pos = n.getNextObjectPos(pos);
                if (!(obj instanceof JGoPort)) continue;
                JGoPort p = (JGoPort)obj;
                JGoListPosition lpos = p.getFirstLinkPos();
                while (lpos != null) {
                    JGoLink l = p.getLinkAtPos(lpos);
                    lpos = p.getNextLinkPos(lpos);
                    JGoPort otherp = l.getOtherPort(p);
                    if (!this.alreadyMoved(moveds, otherp) || this.alreadyMoved(moveds, l)) continue;
                    moveds.put(l, l);
                    safecoll.add(l);
                }
            }
        }
        return safecoll;
    }

    private boolean alreadyMoved(HashMap moveds, JGoObject o) {
        for (JGoObject p = o; p != null; p = p.getParent()) {
            if (!moveds.containsKey(p)) continue;
            return true;
        }
        return false;
    }

    public void doCancelMoveSelection(Point offset) {
        JGoDocument doc;
        this.clearDragSelection();
        if (this.getCurrentObject() != null) {
            this.moveSelection(this.getSelection(), 0, this.myMouseDownPoint.x - offset.x - this.getCurrentObject().getLeft(), this.myMouseDownPoint.y - offset.y - this.getCurrentObject().getTop(), 3);
        }
        if ((doc = this.getDocument()) != null) {
            doc.endTransaction(false);
        }
    }

    public void copySelection(JGoSelection sel, int modifiers, int offsetx, int offsety, int event) {
        if (sel == null) {
            sel = this.getSelection();
        }
        if (sel.isEmpty()) {
            return;
        }
        boolean grid = false;
        int snapmove = this.getSnapMove();
        if (snapmove == 1 || snapmove == 2 && event == 3) {
            grid = true;
        }
        JGoDocument doc = this.getDocument();
        Point temp = new Point(offsetx, offsety);
        JGoCopyEnvironment env = doc.createDefaultCopyEnvironment();
        doc.copyFromCollection(sel, temp, env);
        ArrayList tlos = this.myMoveArrayList;
        tlos.clear();
        Iterator i = env.entrySet().iterator();
        while (i.hasNext()) {
            JGoObject o;
            Map.Entry entry = i.next();
            if (!(entry.getKey() instanceof JGoObject) || !sel.isSelected(o = (JGoObject)entry.getKey()) || !(entry.getValue() instanceof JGoObject)) continue;
            JGoObject n = (JGoObject)entry.getValue();
            tlos.add(n);
        }
        sel.clearSelection();
        for (int j = 0; j < tlos.size(); ++j) {
            sel.extendSelection((JGoObject)tlos.get(j));
        }
        tlos.clear();
    }

    protected boolean startMoveSelection(int modifiers, Point dc, Point vc) {
        if (!this.getSelection().isInSelection(this.getCurrentObject())) {
            this.setCurrentObject(this.selectObject(this.getCurrentObject()));
        }
        if (this.getCurrentObject() == null) {
            return false;
        }
        if (!this.getCurrentObject().isDraggable()) {
            return false;
        }
        if (this.getCurrentObject().getLayer() != null && !this.getCurrentObject().getLayer().isModifiable()) {
            return false;
        }
        if ((this.getInternalMouseActions() & 3) == 0) {
            return false;
        }
        if (this.myHideSelectionOnMouse) {
            this.getSelection().clearSelectionHandles(null);
        }
        this.myMoveOffset.x = this.myMouseDownPoint.x - this.getCurrentObject().getLeft();
        this.myMoveOffset.y = this.myMouseDownPoint.y - this.getCurrentObject().getTop();
        this.doMoveSelection(modifiers, 1, 1, 1);
        this.setState(2);
        return true;
    }

    protected boolean startDragBoxSelection(int modifiers, Point dc, Point vc) {
        if (this.keyClearSelection(modifiers)) {
            this.getSelection().clearSelection();
        }
        this.setState(6);
        Graphics2D g = this.getJGoGraphics();
        this.drawXORBox(g, vc.x, vc.y, vc.x, vc.y, 1);
        this.disposeJGoGraphics(g);
        return true;
    }

    protected boolean startResizing(JGoHandle handle, Point dc, Point vc) {
        if (handle == null || handle.getHandleType() == -1) {
            return false;
        }
        JGoObject obj = handle.getHandleFor();
        if (obj.getLayer() == null || obj.getLayer().isModifiable()) {
            if (this.getDocument() != null) {
                this.getDocument().startTransaction();
            }
            this.setCurrentObject(obj);
            this.myHandleHit = handle.getHandleType();
            if (this.myHideSelectionOnMouse) {
                this.getSelection().clearSelectionHandles(this.getCurrentObject());
            }
            this.setState(5);
            Graphics2D g = this.getJGoGraphics();
            this.handleResizing(g, vc, dc, 1);
            this.disposeJGoGraphics(g);
            return true;
        }
        return false;
    }

    protected void handleResizing(Graphics2D g, Point vc, Point dc, int event) {
        Rectangle newRect;
        Point newpoint;
        int snapresize = this.getSnapResize();
        if (snapresize == 1 || snapresize == 2 && event == 3) {
            newpoint = this.findNearestGridPoint(dc.x, dc.y, null);
            Point newvc = this.docToViewCoords(newpoint);
        } else {
            newpoint = dc;
            Point newvc = vc;
        }
        if (this.getCurrentObject() == null || !this.getCurrentObject().isResizable()) {
            return;
        }
        Rectangle origRect = null;
        if (event == 1) {
            Rectangle b = this.getCurrentObject().getBoundingRect();
            this.myOrigResizeRect.x = b.x;
            this.myOrigResizeRect.y = b.y;
            this.myOrigResizeRect.width = b.width;
            this.myOrigResizeRect.height = b.height;
            this.myOrigResizePoint.x = newpoint.x;
            this.myOrigResizePoint.y = newpoint.y;
            origRect = new Rectangle(this.myOrigResizeRect.x, this.myOrigResizeRect.y, this.myOrigResizeRect.width, this.myOrigResizeRect.height);
        }
        if ((newRect = this.getCurrentObject().handleResize(g, this, this.myOrigResizeRect, newpoint, this.myHandleHit, event, 0, 0)) != null) {
            if (origRect != null) {
                this.convertDocToView(origRect);
                this.drawXORBox(g, origRect.x, origRect.y, origRect.x + origRect.width, origRect.y + origRect.height, 1);
            } else {
                this.convertDocToView(newRect);
                this.drawXORBox(g, newRect.x, newRect.y, newRect.x + newRect.width, newRect.y + newRect.height, event);
            }
        }
        if (event == 3 && this.getState() == 5) {
            this.fireUpdate(30, 0, this.getCurrentObject());
        }
        if ((event == 3 || this.getState() != 5) && this.getDocument() != null) {
            this.getDocument().endTransaction(this.getEditPresentationName(3));
        }
    }

    public void doCancelResize(Rectangle orig) {
        JGoDocument doc;
        Graphics2D g = this.getJGoGraphics();
        if (this.getCurrentObject() != null) {
            this.getCurrentObject().handleResize(g, this, orig, this.myOrigResizePoint, this.myHandleHit, 2, 0, 0);
        }
        this.drawXORBox(g, 0, 0, 0, 0, 3);
        this.disposeJGoGraphics(g);
        if (this.getCurrentObject() != null) {
            this.getCurrentObject().setBoundingRect(orig);
        }
        if ((doc = this.getDocument()) != null) {
            doc.endTransaction(false);
        }
    }

    public JGoActionObject pickActionObject(Point dc) {
        for (JGoObject obj = this.pickDocObject(dc, false); obj != null; obj = obj.getParent()) {
            JGoActionObject actionobj;
            if (!(obj instanceof JGoActionObject) || !(actionobj = (JGoActionObject)((Object)obj)).isActionEnabled()) continue;
            return actionobj;
        }
        return null;
    }

    public boolean startActionObject(JGoActionObject actionobj, int modifiers, Point dc, Point vc) {
        this.setCurrentObject((JGoObject)((Object)actionobj));
        actionobj.setActionActivated(true);
        this.setState(7);
        this.handleActionObject(modifiers, dc, vc, 1);
        return true;
    }

    public void handleActionObject(int modifiers, Point dc, Point vc, int event) {
        if (this.getCurrentObject() instanceof JGoActionObject) {
            JGoActionObject actionobj = (JGoActionObject)((Object)this.getCurrentObject());
            actionobj.onActionAdjusted(this, modifiers, dc, vc, event);
            if (event == 3) {
                actionobj.onAction(this, modifiers, dc, vc);
                actionobj.setActionActivated(false);
            }
        }
    }

    public String getToolTipText(MouseEvent evt) {
        if (!this.isMouseEnabled()) {
            return null;
        }
        Point p = this.getMouseEventPoint(evt);
        this.myMouseDocPoint.x = p.x;
        this.myMouseDocPoint.y = p.y;
        this.convertViewToDoc(this.myMouseDocPoint);
        for (JGoObject obj = this.pickDocObject(this.myMouseDocPoint, false); obj != null; obj = obj.getParent()) {
            String tip = obj.getToolTipText();
            if (tip == null) continue;
            return tip;
        }
        return null;
    }

    public void setEditControl(JGoTextEdit edit) {
        JGoTextEdit old = this.myTextEdit;
        if (old != edit) {
            if (old != null) {
                this.removeObject(old);
            }
            this.myTextEdit = edit;
            if (edit != null) {
                this.addObjectAtTail(edit);
            }
        }
    }

    public JGoTextEdit getEditControl() {
        return this.myTextEdit;
    }

    public boolean isEditingTextControl() {
        return this.getEditControl() != null;
    }

    public void doEndEdit() {
        if (this.isEditingTextControl()) {
            this.getEditControl().doEndEdit();
        }
    }

    void internalFinishedEdit(JGoObject obj) {
        this.fireUpdate(33, 0, obj);
        if (this.getDocument() != null) {
            this.getDocument().endTransaction(this.getEditPresentationName(7));
        }
    }

    void addControl(JGoControl go, JComponent comp) {
        if (!this.myControls.contains(go)) {
            this.myControls.add(go);
            this.getCanvas().add(comp);
        }
    }

    void removeControl(JGoControl go, JComponent comp) {
        this.myControls.remove(go);
        Rectangle r = comp.getBounds();
        this.getCanvas().remove(comp);
        this.getCanvas().repaint(r.x, r.y, r.width, r.height);
    }

    protected void drawXORRect(Graphics2D g, int x, int y, int w, int h) {
        if (g == null) {
            return;
        }
        g.setXORMode(JGoBrush.ColorWhite);
        JGoDrawable.drawRect(g, JGoPen.darkGray, null, x, y, w, h);
        g.setPaintMode();
    }

    public boolean isDrawsXorMode() {
        return this.myDrawsXorMode;
    }

    public void setDrawsXorMode(boolean d) {
        this.myDrawsXorMode = d;
    }

    protected void drawXORBox(Graphics2D g, int corner1x, int corner1y, int corner2x, int corner2y, int event) {
        if (this.myPrevXORRectValid) {
            this.myPrevXORRectValid = false;
            if (this.myPrevXORRect.width != 0 || this.myPrevXORRect.height != 0) {
                this.drawXORRect(g, this.myPrevXORRect.x, this.myPrevXORRect.y, this.myPrevXORRect.width, this.myPrevXORRect.height);
            }
        }
        if (event != 3) {
            this.myPrevXORRect.x = Math.min(corner1x, corner2x);
            this.myPrevXORRect.y = Math.min(corner1y, corner2y);
            this.myPrevXORRect.width = Math.abs(corner1x - corner2x);
            this.myPrevXORRect.height = Math.abs(corner1y - corner2y);
            if (this.isDrawsXorMode()) {
                if (this.myPrevXORRect.width != 0 || this.myPrevXORRect.height != 0) {
                    this.drawXORRect(g, this.myPrevXORRect.x, this.myPrevXORRect.y, this.myPrevXORRect.width, this.myPrevXORRect.height);
                }
                this.myPrevXORRectValid = true;
            } else {
                if (this.myMarquee == null) {
                    this.myMarquee = new JGoRectangle();
                }
                if (this.myMarquee.getPen() != null) {
                    this.myMarquee.setBrush(null);
                    JGoPen p = new JGoPen(2, 2, JGoBrush.ColorDarkGray);
                    this.myMarquee.setPen(p);
                }
                this.myMarquee.setBoundingRect(this.viewToDocCoords(this.myPrevXORRect));
                this.addObjectAtTail(this.myMarquee);
            }
        } else if (this.myMarquee != null) {
            this.removeObject(this.myMarquee);
        }
    }

    public Graphics2D getJGoGraphics() {
        return (Graphics2D)this.getCanvas().getGraphics();
    }

    public void disposeJGoGraphics(Graphics2D g) {
        if (g != null) {
            g.dispose();
        }
    }

    protected JGoHandle pickHandle(Point point) {
        JGoObject obj = this.pickObject(point, true);
        if (obj instanceof JGoHandle) {
            return (JGoHandle)obj;
        }
        return null;
    }

    public void newLink(JGoPort from, JGoPort to) {
        JGoDocument doc = this.getDocument();
        if (doc == null) {
            return;
        }
        JGoLink link = new JGoLink(from, to);
        JGoSubGraph.reparentToCommonSubGraph(link, from, to, true, doc.getDefaultLayer());
        this.fireUpdate(31, 0, link);
        doc.endTransaction(this.getEditPresentationName(4));
    }

    protected void noNewLink(JGoPort from, JGoPort to) {
        if (this.getDocument() != null) {
            this.getDocument().endTransaction(false);
        }
    }

    public void reLink(JGoLink oldlink, JGoPort from, JGoPort to) {
        oldlink.setFromPort(from);
        oldlink.setToPort(to);
        JGoLayer layer = oldlink.getLayer();
        if (layer == null && this.getDocument() != null) {
            layer = this.getDocument().getDefaultLayer();
        }
        if (layer != null) {
            JGoSubGraph.reparentToCommonSubGraph(oldlink, from, to, true, layer);
        }
        this.fireUpdate(32, 0, oldlink);
        if (this.getDocument() != null) {
            this.getDocument().endTransaction(this.getEditPresentationName(5));
        }
    }

    protected void noReLink(JGoLink oldlink, JGoPort from, JGoPort to) {
        if (oldlink.getLayer() != null) {
            JGoViewEvent event = new JGoViewEvent(this, 28, 0, oldlink, null, null, 0);
            this.invokeViewListeners(event);
            if (event.isConsumed()) {
                this.doCancelMouse();
                return;
            }
            oldlink.getLayer().removeObject(oldlink);
            this.fireUpdate(29, 0, oldlink);
        }
        if (this.getDocument() != null) {
            this.getDocument().endTransaction(this.getEditPresentationName(13));
        }
    }

    private void cacheValidLinks(boolean isSource) {
        JGoLayer layer = this.getFirstLayer();
        while (layer != null) {
            if (layer.isVisible()) {
                JGoListPosition pos = layer.getFirstObjectPos();
                while (pos != null) {
                    JGoObject obj = layer.getObjectAtPos(pos);
                    pos = layer.getNextObjectPos(pos);
                    if (!(obj instanceof JGoPort)) continue;
                    JGoPort port = (JGoPort)obj;
                    if (isSource) {
                        port.setValidLink(this.validLink(this.myTempStartPort, port));
                        continue;
                    }
                    port.setValidLink(this.validLink(port, this.myTempStartPort));
                }
            }
            layer = this.getNextLayer(layer);
        }
    }

    public boolean validLink(JGoPort from, JGoPort to) {
        return from.getLayer() != null && from.getLayer().isModifiable() && to.getLayer() != null && to.getLayer().isModifiable() && from.validLink(to);
    }

    public boolean validSourcePort(JGoPort from) {
        return from.getLayer() != null && from.getLayer().isModifiable() && from.isValidSource();
    }

    public boolean validDestinationPort(JGoPort to) {
        return to.getLayer() != null && to.getLayer().isModifiable() && to.isValidDestination();
    }

    public int getPortGravity() {
        return JGoView.getDefaultPortGravity();
    }

    public JGoPort pickNearestPort(Point dc) {
        JGoPort currentBestPort = null;
        double currentMaxDist = this.getPortGravity();
        currentMaxDist *= currentMaxDist;
        JGoLayer layer = this.getFirstLayer();
        while (layer != null) {
            if (layer.isVisible()) {
                JGoListPosition pos = layer.getFirstObjectPos();
                Point toPoint = new Point(0, 0);
                while (pos != null) {
                    JGoPort port;
                    JGoObject obj = layer.getObjectAtPos(pos);
                    pos = layer.getNextObjectPos(pos);
                    if (!(obj instanceof JGoPort) || !(port = (JGoPort)obj).isValidLink()) continue;
                    toPoint = port.getLinkPoint(0, toPoint);
                    double dx = dc.x - toPoint.x;
                    double dy = dc.y - toPoint.y;
                    double dist = dx * dx + dy * dy;
                    if (!(dist <= currentMaxDist)) continue;
                    currentBestPort = port;
                    currentMaxDist = dist;
                }
            }
            layer = this.getNextLayer(layer);
        }
        return currentBestPort;
    }

    protected JGoPort pickPort(Point dc) {
        JGoObject obj = this.pickDocObject(dc, false);
        if (obj == null) {
            return null;
        }
        if (obj instanceof JGoPort) {
            return (JGoPort)obj;
        }
        return null;
    }

    public boolean startNewLink(JGoPort port, Point dc) {
        boolean validSource = this.validSourcePort(port);
        boolean validDest = this.validDestinationPort(port);
        if (validSource || validDest) {
            if (this.getDocument() != null) {
                this.getDocument().startTransaction();
            }
            this.setCursorType(12);
            this.myTempStartPort = port;
            this.myTempEndPort = this.createTemporaryPortForNewLink(port, dc);
            if (validSource) {
                this.setState(3);
                this.myTempLink = this.createTemporaryLinkForNewLink(this.myTempStartPort, this.myTempEndPort);
                this.cacheValidLinks(true);
            } else {
                this.setState(4);
                this.myTempLink = this.createTemporaryLinkForNewLink(this.myTempEndPort, this.myTempStartPort);
                this.cacheValidLinks(false);
            }
            this.addObjectAtTail(this.myTempLink);
            return true;
        }
        return false;
    }

    public boolean startReLink(JGoLink oldlink, JGoPort oldport, Point dc) {
        if (oldlink == null || oldlink.getLayer() == null || oldport != null && (oldport.getLayer() == null || oldlink.getDocument() != oldport.getDocument())) {
            return false;
        }
        if (oldlink.getToPort() == null) {
            this.myTempStartPort = oldlink.getFromPort();
        } else if (oldlink.getFromPort() == null) {
            this.myTempStartPort = oldlink.getToPort();
        } else {
            return false;
        }
        if (this.getDocument() != null) {
            this.getDocument().startTransaction();
        }
        this.setCursorType(12);
        this.myTempLink = oldlink;
        this.myOrigEndPort = oldport;
        this.myTempEndPort = this.createTemporaryPortForNewLink(this.myTempStartPort, dc);
        if (oldlink.getToPort() == null) {
            this.setState(3);
            oldlink.setToPort(this.myTempEndPort);
            this.cacheValidLinks(true);
        } else if (oldlink.getFromPort() == null) {
            this.setState(4);
            oldlink.setFromPort(this.myTempEndPort);
            this.cacheValidLinks(false);
        }
        return true;
    }

    protected JGoPort createTemporaryPortForNewLink(JGoPort port, Point dc) {
        JGoPort tempPort = new JGoPort();
        tempPort.setLocation(dc);
        tempPort.setToSpot(-1);
        tempPort.setFromSpot(-1);
        return tempPort;
    }

    protected JGoLink createTemporaryLinkForNewLink(JGoPort from, JGoPort to) {
        return new JGoLink(from, to);
    }

    public void lostOwnership(Clipboard c, Transferable t) {
    }

    public void copy() {
        Toolkit toolkit;
        JGoDocument doc = this.getDocument();
        if (doc != null) {
            doc.startTransaction();
        }
        if ((toolkit = this.getToolkit()) == null) {
            toolkit = JGoGlobal.getToolkit();
        }
        this.copyToClipboard(toolkit.getSystemClipboard());
        this.fireUpdate(36, 0, null);
        if (doc != null) {
            doc.endTransaction(this.getEditPresentationName(8));
        }
    }

    public void copyToClipboard(Clipboard clipboard) {
        JGoDocument thisdoc = this.getDocument();
        if (thisdoc != null) {
            try {
                Class<?> docclass = thisdoc.getClass();
                JGoDocument clipdoc = (JGoDocument)docclass.newInstance();
                clipdoc.copyLayersFrom(thisdoc);
                clipdoc.copyFromCollection(this.getSelection());
                clipboard.setContents(clipdoc, this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void cut() {
        Toolkit toolkit;
        JGoDocument doc = this.getDocument();
        if (doc != null) {
            doc.startTransaction();
        }
        if ((toolkit = this.getToolkit()) == null) {
            toolkit = JGoGlobal.getToolkit();
        }
        this.copyToClipboard(toolkit.getSystemClipboard());
        this.deleteSelection();
        this.fireUpdate(36, 0, null);
        if (doc != null) {
            doc.endTransaction(this.getEditPresentationName(9));
        }
    }

    public void deleteSelection() {
        JGoDocument doc = this.getDocument();
        if (doc != null) {
            doc.startTransaction();
        }
        JGoSelection sel = this.getSelection();
        JGoViewEvent event = new JGoViewEvent(this, 28, 0, null, null, null, 0);
        this.invokeViewListeners(event);
        if (event.isConsumed()) {
            if (doc != null) {
                doc.endTransaction(false);
            }
            return;
        }
        JGoListPosition pos = sel.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = sel.getObjectAtPos(pos);
            if (obj.getLayer() != null && !obj.getLayer().isModifiable()) {
                pos = sel.getNextObjectPos(pos);
                continue;
            }
            sel.clearSelection(obj);
            obj = obj.getDraggingObject();
            if (obj.getParent() != null) {
                obj.getParent().removeObject(obj);
            } else if (obj.getLayer() != null) {
                obj.getLayer().removeObject(obj);
            } else if (obj.getView() != null) {
                obj.getView().removeObject(obj);
            }
            pos = sel.getFirstObjectPos();
        }
        this.fireUpdate(29, 0, null);
        if (doc != null) {
            doc.endTransaction(this.getEditPresentationName(11));
        }
    }

    public void paste() {
        JGoCopyEnvironment map;
        Toolkit toolkit;
        JGoDocument doc = this.getDocument();
        if (doc != null) {
            doc.startTransaction();
        }
        if ((toolkit = this.getToolkit()) == null) {
            toolkit = JGoGlobal.getToolkit();
        }
        if ((map = this.pasteFromClipboard(toolkit.getSystemClipboard())) != null) {
            Iterator i = map.values().iterator();
            boolean any = false;
            JGoSelection sel = this.getSelection();
            while (i.hasNext()) {
                JGoObject obj;
                Object o = i.next();
                if (!(o instanceof JGoObject) || !(obj = (JGoObject)o).isTopLevel() || obj.getDocument() != doc) continue;
                if (!any) {
                    any = true;
                    sel.clearSelection();
                }
                sel.extendSelection(obj);
            }
        }
        this.fireUpdate(34, 0, null);
        if (doc != null) {
            doc.endTransaction(this.getEditPresentationName(10));
        }
    }

    public boolean canPaste() {
        JGoDocument doc = this.getDocument();
        if (doc == null) {
            return false;
        }
        if (!doc.getDefaultLayer().isModifiable()) {
            return false;
        }
        Toolkit toolkit = this.getToolkit();
        if (toolkit == null) {
            toolkit = JGoGlobal.getToolkit();
        }
        Clipboard clipboard = toolkit.getSystemClipboard();
        Transferable contents = clipboard.getContents(this);
        DataFlavor jgoflavor = JGoDocument.getStandardDataFlavor();
        return contents != null && contents.isDataFlavorSupported(jgoflavor);
    }

    public JGoCopyEnvironment pasteFromClipboard(Clipboard clipboard) {
        Transferable contents = clipboard.getContents(this);
        DataFlavor jgoflavor = JGoDocument.getStandardDataFlavor();
        if (contents != null && contents.isDataFlavorSupported(jgoflavor)) {
            try {
                JGoDocument doc = this.getDocument();
                if (doc != null) {
                    JGoObjectSimpleCollection sel = (JGoObjectSimpleCollection)contents.getTransferData(jgoflavor);
                    return doc.copyFromCollection(sel);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void initializeDragDropHandling() {
        this.myInternalDragDrop = false;
        this.myInternalDragStarted = false;
        this.setDragDropEnabled(true);
    }

    public void setDragDropEnabled(boolean m) {
        this.setDragEnabled(m);
        this.setDropEnabled(m);
    }

    public void setDragEnabled(boolean m) {
        if (m && !this.myDragEnabled) {
            this.myDragEnabled = true;
            try {
                if (this.myDragGestureRecognizer == null) {
                    this.myDragSource = DragSource.getDefaultDragSource();
                    this.myDragGestureRecognizer = this.myDragSource.createDefaultDragGestureRecognizer(this.getCanvas(), 3, this.getCanvas());
                } else {
                    this.myDragGestureRecognizer.addDragGestureListener(this.getCanvas());
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            this.fireUpdate(117, 0, null);
        } else if (!m && this.myDragEnabled) {
            this.myDragEnabled = false;
            if (this.myDragGestureRecognizer != null) {
                this.myDragGestureRecognizer.removeDragGestureListener(this.getCanvas());
            }
            this.fireUpdate(117, 1, null);
        }
    }

    public void setDropEnabled(boolean m) {
        if (m && !this.myDropEnabled) {
            this.myDropEnabled = true;
            try {
                if (this.myDropTarget == null) {
                    this.myDropTarget = new DropTarget(this.getCanvas(), 3, this.getCanvas());
                } else {
                    this.myDropTarget.addDropTargetListener(this.getCanvas());
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            this.fireUpdate(118, 0, null);
        } else if (!m && this.myDropEnabled) {
            this.myDropEnabled = false;
            if (this.myDropTarget != null) {
                this.myDropTarget.removeDropTargetListener(this.getCanvas());
            }
            this.fireUpdate(118, 1, null);
        }
    }

    public boolean isDragDropEnabled() {
        return this.isDragEnabled() && this.isDropEnabled();
    }

    public boolean isDragEnabled() {
        return this.myDragEnabled;
    }

    public boolean isDropEnabled() {
        return this.myDropEnabled;
    }

    public boolean isInternalDragDrop() {
        return this.myInternalDragDrop;
    }

    public void onDragGestureRecognized(DragGestureEvent e) {
        if (!this.isDragEnabled()) {
            return;
        }
        this.TRACE("dragGestureRecognized", e);
        this.myInternalDragStarted = false;
        this.myInternalDragDrop = true;
        if (!this.isDropEnabled()) {
            Point viewPoint = e.getDragOrigin();
            this.myDropDocPoint.x = viewPoint.x;
            this.myDropDocPoint.y = viewPoint.y;
            this.convertViewToDoc(this.myDropDocPoint);
            this.doMouseMove(this.convertActionToModifiers(e.getDragAction()), this.myDropDocPoint, viewPoint);
        }
        this.dragGestureRecognized(e);
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        try {
            Cursor cursor = DragSource.DefaultMoveDrop;
            if (this.getState() == 5 || this.getState() == 3 || this.getState() == 4) {
                cursor = this.getCursor();
            }
            if (DragSource.isDragImageSupported()) {
                if (this.myDragImage == null) {
                    this.myDragImage = new BufferedImage(1, 1, 1);
                }
                e.startDrag(cursor, this.myDragImage, new Point(0, 0), this.getSelection(), this.getCanvas());
            } else {
                e.startDrag(cursor, this.getSelection(), this.getCanvas());
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void onDragEnter(DragSourceDragEvent e) {
        if (!this.isDragEnabled()) {
            return;
        }
        this.dragEnter(e);
    }

    public void onDragOver(DragSourceDragEvent e) {
        if (!this.isDragEnabled()) {
            return;
        }
        this.dragOver(e);
    }

    public void onDropActionChanged(DragSourceDragEvent e) {
        if (!this.isDragEnabled()) {
            return;
        }
        this.TRACE("dropActionChanged Source", e);
        this.dropActionChanged(e);
    }

    public void onDragExit(DragSourceEvent e) {
        if (!this.isDragEnabled()) {
            return;
        }
        this.dragExit(e);
    }

    public void onDragDropEnd(DragSourceDropEvent e) {
        if (!this.isDragEnabled()) {
            return;
        }
        this.TRACE("dragDropEnd Source", e);
        if (this.isInternalDragDrop()) {
            this.myInternalDragDrop = false;
            this.doCancelMouse();
        } else {
            this.dragDropEnd(e);
        }
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragDropEnd(DragSourceDropEvent e) {
    }

    public int convertActionToModifiers(int action) {
        int modifiers = 16;
        switch (action) {
            case 2: {
                modifiers |= 1;
                break;
            }
            case 1: {
                modifiers |= 2;
                break;
            }
            default: {
                break;
            }
            case 0x40000000: {
                modifiers |= 3;
            }
            case 0: 
        }
        return modifiers;
    }

    public void onDragEnter(DropTargetDragEvent e) {
        if (!this.isDropEnabled()) {
            return;
        }
        this.TRACE("dragEnter Target", e);
        if (this.isInternalDragDrop()) {
            Point viewPoint = e.getLocation();
            this.myDropDocPoint.x = viewPoint.x;
            this.myDropDocPoint.y = viewPoint.y;
            this.convertViewToDoc(this.myDropDocPoint);
            this.doMouseMove(this.convertActionToModifiers(e.getDropAction()), this.myDropDocPoint, viewPoint);
        } else {
            this.dragEnter(e);
        }
    }

    public void onDragOver(DropTargetDragEvent e) {
        if (!this.isDropEnabled()) {
            return;
        }
        this.TRACE("dragOver Target", e);
        if (this.isInternalDragDrop()) {
            Point viewPoint = e.getLocation();
            this.myDropDocPoint.x = viewPoint.x;
            this.myDropDocPoint.y = viewPoint.y;
            this.convertViewToDoc(this.myDropDocPoint);
            this.doMouseMove(this.convertActionToModifiers(e.getDropAction()), this.myDropDocPoint, viewPoint);
        } else {
            this.dragOver(e);
        }
    }

    public void onDropActionChanged(DropTargetDragEvent e) {
        if (!this.isDropEnabled()) {
            return;
        }
        this.TRACE("dropActionChanged Target", e);
        if (!this.isInternalDragDrop()) {
            this.dropActionChanged(e);
        }
    }

    public void onDragExit(DropTargetEvent e) {
        if (!this.isDropEnabled()) {
            return;
        }
        this.TRACE("dragExit Target", e);
        if (!this.isInternalDragDrop()) {
            this.dragExit(e);
        }
    }

    public void onDrop(DropTargetDropEvent e) {
        if (!this.isDropEnabled()) {
            e.rejectDrop();
            return;
        }
        this.TRACE("drop Target", e);
        if (this.isInternalDragDrop()) {
            this.myInternalDragDrop = false;
            Point viewPoint = e.getLocation();
            this.myDropDocPoint.x = viewPoint.x;
            this.myDropDocPoint.y = viewPoint.y;
            this.convertViewToDoc(this.myDropDocPoint);
            if (this.doMouseUp(this.convertActionToModifiers(e.getDropAction()), this.myDropDocPoint, viewPoint)) {
                e.acceptDrop(e.getDropAction());
                this.setState(0);
                this.completeDrop(e, true);
            } else {
                e.rejectDrop();
            }
        } else {
            if (JGoGlobal.isAtLeastJavaVersion(1.4)) {
                this.dragExit(e);
            }
            this.drop(e);
        }
    }

    public void dragEnter(DropTargetDragEvent e) {
        if (!this.isDropFlavorAcceptable(e)) {
            e.rejectDrag();
            return;
        }
        int action = this.computeAcceptableDrop(e);
        if (action == 0) {
            e.rejectDrag();
        } else {
            e.acceptDrag(action);
        }
    }

    public void dragOver(DropTargetDragEvent e) {
        if (!this.isDropFlavorAcceptable(e)) {
            e.rejectDrag();
            return;
        }
        int action = this.computeAcceptableDrop(e);
        if (action == 0) {
            e.rejectDrag();
        } else {
            e.acceptDrag(action);
        }
    }

    public void dropActionChanged(DropTargetDragEvent e) {
        if (!this.isDropFlavorAcceptable(e)) {
            e.rejectDrag();
            return;
        }
        int action = this.computeAcceptableDrop(e);
        if (action == 0) {
            e.rejectDrag();
        } else {
            e.acceptDrag(action);
        }
    }

    public void dragExit(DropTargetEvent e) {
    }

    public void drop(DropTargetDropEvent e) {
        JGoDocument doc = this.getDocument();
        if (doc != null && doc.getDefaultLayer().isModifiable()) {
            doc.startTransaction();
            if (this.doDrop(e, null)) {
                this.fireUpdate(35, 0, null);
                doc.endTransaction(this.getEditPresentationName(6));
            } else {
                e.rejectDrop();
                doc.endTransaction(false);
            }
        } else {
            e.rejectDrop();
        }
    }

    public boolean isDropFlavorAcceptable(DropTargetDragEvent e) {
        DataFlavor jgoflavor = JGoDocument.getStandardDataFlavor();
        return e.isDataFlavorSupported(jgoflavor);
    }

    public int computeAcceptableDrop(DropTargetDragEvent e) {
        if (this.getDocument() == null || !this.getDocument().getDefaultLayer().isModifiable()) {
            return 0;
        }
        if ((e.getDropAction() & 3) != 0) {
            return e.getDropAction();
        }
        return 0;
    }

    public boolean doDrop(DropTargetDropEvent e, JGoCopyEnvironment copyenv) {
        try {
            DataFlavor jgoflavor = JGoDocument.getStandardDataFlavor();
            if (e.isDataFlavorSupported(jgoflavor) && (e.getDropAction() & 3) != 0) {
                e.acceptDrop(e.getDropAction());
                Transferable tr = e.getTransferable();
                Object data = tr.getTransferData(jgoflavor);
                JGoObjectSimpleCollection sel = (JGoObjectSimpleCollection)data;
                Point selLoc = null;
                JGoListPosition pos = sel.getFirstObjectPos();
                if (pos == null) {
                    this.completeDrop(e, true);
                    return true;
                }
                JGoObject firstobj = sel.getObjectAtPos(pos);
                selLoc = firstobj.getLocation();
                Point viewCoord = e.getLocation();
                Point docCoord = this.viewToDocCoords(viewCoord);
                Point offset = new Point(docCoord.x - selLoc.x, docCoord.y - selLoc.y);
                JGoDocument doc = this.getDocument();
                if (doc != null) {
                    JGoCopyEnvironment copieds = doc.copyFromCollection(sel, offset, copyenv);
                    JGoSelection viewsel = this.getSelection();
                    viewsel.clearSelection();
                    Iterator i = copieds.values().iterator();
                    while (i.hasNext()) {
                        JGoObject obj;
                        Object o = i.next();
                        if (!(o instanceof JGoObject) || !(obj = (JGoObject)o).isTopLevel()) continue;
                        viewsel.extendSelection(obj);
                    }
                }
                this.completeDrop(e, true);
                return true;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return false;
    }

    public void completeDrop(DropTargetDropEvent e, boolean success) {
        if (JGoGlobal.isAtLeastJavaVersion(1.3)) {
            e.dropComplete(success);
        } else {
            Thread t = new Thread(new JGoViewHelper(new JGoViewHelper(e, success)));
            t.start();
        }
    }

    public Insets getAutoscrollInsets() {
        return this.myAutoscrollInsets;
    }

    public void setAutoscrollInsets(Insets insets) {
        Insets old = this.myAutoscrollInsets;
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (!old.equals(insets)) {
            this.myAutoscrollInsets.top = insets.top;
            this.myAutoscrollInsets.left = insets.left;
            this.myAutoscrollInsets.bottom = insets.bottom;
            this.myAutoscrollInsets.right = insets.right;
            this.fireUpdate(123, 0, old);
        }
    }

    public void autoscroll(Point location) {
        JScrollBar vscroll;
        Graphics2D g = null;
        JScrollBar hscroll = this.getHorizontalScrollBar();
        Dimension size = this.getCanvas().getSize();
        Insets insets = this.getAutoscrollInsets();
        int oldx = 0;
        int newx = 0;
        int oldy = 0;
        int newy = 0;
        if (hscroll != null) {
            newx = oldx = hscroll.getValue();
            if (location.x <= insets.left) {
                newx = oldx - hscroll.getUnitIncrement();
                newx = Math.max(newx, hscroll.getMinimum());
            } else if (location.x >= size.width - insets.right) {
                newx = oldx + hscroll.getUnitIncrement();
                newx = Math.min(newx, hscroll.getMaximum());
            }
            switch (this.getState()) {
                case 6: {
                    if (this.isDrawsXorMode()) {
                        g = this.getJGoGraphics();
                        this.drawXORBox(g, 0, 0, 0, 0, 3);
                        this.disposeJGoGraphics(g);
                    }
                    hscroll.setValue(newx);
                    break;
                }
                case 5: {
                    if (this.isDrawsXorMode()) {
                        g = this.getJGoGraphics();
                        this.drawXORBox(g, 0, 0, 0, 0, 3);
                        this.disposeJGoGraphics(g);
                    }
                    hscroll.setValue(newx);
                    break;
                }
                default: {
                    hscroll.setValue(newx);
                }
            }
        }
        if ((vscroll = this.getVerticalScrollBar()) != null) {
            newy = oldy = vscroll.getValue();
            if (location.y <= insets.top) {
                newy = oldy - vscroll.getUnitIncrement();
                newy = Math.max(newy, vscroll.getMinimum());
            } else if (location.y >= size.height - insets.bottom) {
                newy = oldy + vscroll.getUnitIncrement();
                newy = Math.min(newy, vscroll.getMaximum());
            }
            switch (this.getState()) {
                case 6: {
                    if (this.isDrawsXorMode()) {
                        g = this.getJGoGraphics();
                        this.drawXORBox(g, 0, 0, 0, 0, 3);
                        this.disposeJGoGraphics(g);
                    }
                    vscroll.setValue(newy);
                    break;
                }
                case 5: {
                    if (this.isDrawsXorMode()) {
                        g = this.getJGoGraphics();
                        this.drawXORBox(g, 0, 0, 0, 0, 3);
                        this.disposeJGoGraphics(g);
                    }
                    vscroll.setValue(newy);
                    break;
                }
                default: {
                    vscroll.setValue(newy);
                }
            }
        }
    }

    public JGoLayer getFirstLayer() {
        JGoDocument doc = this.getDocument();
        if (doc == null) {
            return null;
        }
        return doc.getFirstLayer();
    }

    public JGoLayer getLastLayer() {
        JGoDocument doc = this.getDocument();
        if (doc == null) {
            return null;
        }
        return doc.getLastLayer();
    }

    public JGoLayer getNextLayer(JGoLayer layer) {
        if (layer == null) {
            return null;
        }
        return layer.getNextLayer();
    }

    public JGoLayer getPrevLayer(JGoLayer layer) {
        if (layer == null) {
            return null;
        }
        return layer.getPrevLayer();
    }

    public String getEditPresentationName(int act) {
        JGoDocument doc = this.getDocument();
        if (doc != null && doc.getUndoManager() != null) {
            return doc.getUndoManager().getViewEditPresentationName(act);
        }
        return null;
    }

    public int getDebugFlags() {
        return this.myDebugFlags;
    }

    public void setDebugFlags(int f) {
        this.myDebugFlags = f;
    }

    void TRACE(String msg, EventObject e) {
        if ((this.myDebugFlags & 1) != 0) {
            String info = Integer.toString(this.getState());
            info = info + (this.hasFocus() ? " has focus" : " NO FOCUS");
            info = info + (this.isDragEnabled() ? "" : " DRAG DISABLED");
            info = info + (this.isDropEnabled() ? "" : " DROP DISABLED");
            info = info + (this.isInternalDragDrop() ? " internal drag" : "");
            info = info + (this.myInternalDragStarted ? " started" : "");
            msg = Integer.toString(this.myDebugFlags) + " " + msg + " " + info;
            if (!msg.equals(this.myLastEventMsg)) {
                this.myLastEventMsg = msg;
                this.myLastHandlerMsg = null;
                JGoGlobal.TRACE(msg);
            }
        }
    }

    void TRACE(String msg) {
        if ((this.myDebugFlags & 1) != 0) {
            String info = Integer.toString(this.getState());
            info = info + (this.hasFocus() ? " has focus" : " NO FOCUS");
            info = info + (this.isDragEnabled() ? "" : " DRAG DISABLED");
            info = info + (this.isDropEnabled() ? "" : " DROP DISABLED");
            info = info + (this.isInternalDragDrop() ? " internal drag" : "");
            info = info + (this.myInternalDragStarted ? " started" : "");
            msg = Integer.toString(this.myDebugFlags) + " " + msg + " " + info;
            if (!msg.equals(this.myLastHandlerMsg)) {
                this.myLastHandlerMsg = msg;
                JGoGlobal.TRACE(msg);
            }
        }
    }

    int[] getTempXs(int size) {
        int[] a;
        if (size >= this.myTempArraysX.length) {
            this.myTempArraysX = new int[size + 1][];
        }
        if ((a = this.myTempArraysX[size]) == null) {
            a = new int[size];
            this.myTempArraysX[size] = a;
        }
        return a;
    }

    int[] getTempYs(int size) {
        int[] a;
        if (size >= this.myTempArraysY.length) {
            this.myTempArraysY = new int[size + 1][];
        }
        if ((a = this.myTempArraysY[size]) == null) {
            a = new int[size];
            this.myTempArraysY[size] = a;
        }
        return a;
    }

    Point getTempPoint() {
        return this.myTempPoint;
    }

    Dimension getTempDimension() {
        return this.myTempDimension;
    }

    Rectangle getTempRectangle() {
        return this.myTempRectangle;
    }

    public static Color getDefaultPrimarySelectionColor() {
        return myDefaultPrimarySelectionColor;
    }

    public static void setDefaultPrimarySelectionColor(Color c) {
        myDefaultPrimarySelectionColor = c;
    }

    public static Color getDefaultSecondarySelectionColor() {
        return myDefaultSecondarySelectionColor;
    }

    public static void setDefaultSecondarySelectionColor(Color c) {
        myDefaultSecondarySelectionColor = c;
    }

    public static int getDefaultPortGravity() {
        return myDefaultPortGravity;
    }

    public static void setDefaultPortGravity(int gravity) {
        myDefaultPortGravity = gravity;
    }

    public void setGridWidth(int width) {
        if (width != this.myGridWidth) {
            this.myGridWidth = width;
            if (this.getHorizontalScrollBar() != null) {
                this.getHorizontalScrollBar().setUnitIncrement(this.getGridWidth());
            }
            this.onGridChange(0);
        }
    }

    public int getGridWidth() {
        return this.myGridWidth;
    }

    public void setGridHeight(int height) {
        if (height != this.myGridHeight) {
            this.myGridHeight = height;
            if (this.getVerticalScrollBar() != null) {
                this.getVerticalScrollBar().setUnitIncrement(this.getGridHeight());
            }
            this.onGridChange(0);
        }
    }

    public int getGridHeight() {
        return this.myGridHeight;
    }

    public void setGridStyle(int style) {
        if (style != this.myGridStyle) {
            this.myGridStyle = style;
            this.onGridChange(1);
        }
    }

    public int getGridStyle() {
        return this.myGridStyle;
    }

    public void setGridOrigin(Point point) {
        if (!point.equals(this.myGridOrigin)) {
            this.myGridOrigin.x = point.x;
            this.myGridOrigin.y = point.y;
            this.onGridChange(6);
        }
    }

    public Point getGridOrigin() {
        return this.myGridOrigin;
    }

    public void setGridSpot(int spot) {
        if (spot != this.mySpotNumber) {
            this.mySpotNumber = spot;
            this.onGridChange(2);
        }
    }

    public int getGridSpot() {
        return this.mySpotNumber;
    }

    public void setGridPen(JGoPen pen) {
        if (this.myGridPen != pen) {
            this.myGridPen = pen;
            this.onGridChange(5);
        }
    }

    public JGoPen getGridPen() {
        return this.myGridPen;
    }

    public int getSnapMove() {
        return this.mySnapMove;
    }

    public void setSnapMove(int snap) {
        if (this.mySnapMove != snap) {
            this.mySnapMove = snap;
            this.onGridChange(3);
        }
    }

    public int getSnapResize() {
        return this.mySnapResize;
    }

    public void setSnapResize(int snap) {
        if (this.mySnapResize != snap) {
            this.mySnapResize = snap;
            this.onGridChange(4);
        }
    }

    public void onGridChange(int what) {
        this.fireUpdate(124, what, null);
    }

    protected void drawGridLines(Graphics2D g, Rectangle clipRect) {
        int gridW = this.getGridWidth();
        int gridH = this.getGridHeight();
        JGoPen pen = this.getGridPen();
        int grownLeft = clipRect.x - gridW;
        int grownTop = clipRect.y - gridH;
        int grownRight = clipRect.x + clipRect.width + gridW;
        int grownBottom = clipRect.y + clipRect.height + gridH;
        Point topleft = this.findNearestGridPoint(grownLeft, grownTop, null);
        Point bottomright = this.findNearestGridPoint(grownRight, grownBottom, null);
        for (int col = topleft.x; col < bottomright.x; col += gridW) {
            JGoDrawable.drawLine(g, pen, col, clipRect.y, col, clipRect.y + clipRect.height);
        }
        for (int row = topleft.y; row < bottomright.y; row += gridH) {
            JGoDrawable.drawLine(g, pen, clipRect.x, row, clipRect.x + clipRect.width, row);
        }
    }

    protected void drawGridCrosses(Graphics2D g, int crossHeight, int crossWidth, Rectangle clipRect) {
        int gridW = this.getGridWidth();
        int gridH = this.getGridHeight();
        JGoPen pen = this.getGridPen();
        int grownLeft = clipRect.x - gridW;
        int grownTop = clipRect.y - gridH;
        int grownRight = clipRect.x + clipRect.width + gridW;
        int grownBottom = clipRect.y + clipRect.height + gridH;
        Point topleft = this.findNearestGridPoint(grownLeft, grownTop, null);
        Point bottomright = this.findNearestGridPoint(grownRight, grownBottom, null);
        if (crossHeight < 2 && crossWidth < 2) {
            double scale = this.getScale();
            int len = 1;
            if (scale < 1.0) {
                len = (int)Math.round(1.0 / scale) + 1;
            }
            for (int col = topleft.x; col < bottomright.x; col += gridW) {
                for (int row = topleft.y; row < bottomright.y; row += gridH) {
                    JGoDrawable.drawLine(g, pen, col, row, col + len, row);
                }
            }
        } else {
            for (int col = topleft.x; col < bottomright.x; col += gridW) {
                for (int row = topleft.y; row < bottomright.y; row += gridH) {
                    JGoDrawable.drawLine(g, pen, col, row - crossHeight / 2, col, row + crossHeight / 2);
                    JGoDrawable.drawLine(g, pen, col - crossWidth / 2, row, col + crossWidth / 2, row);
                }
            }
        }
    }

    public void snapObject(JGoObject object) {
        this.snapObject(object, this.getGridSpot());
    }

    public void snapObject(JGoObject object, int spotNumber) {
        Point spot = object.getSpotLocation(spotNumber);
        Point pos = this.findNearestGridPoint(spot.x, spot.y, spot);
        object.setSpotLocation(spotNumber, pos);
    }

    public void snapAllObjects() {
        this.snapAllObjects(this.getGridSpot());
    }

    public void snapAllObjects(int spotNumber) {
        JGoDocument doc = this.getDocument();
        JGoListPosition pos = doc.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = doc.getObjectAtPos(pos);
            pos = doc.getNextObjectPosAtTop(pos);
            if (obj instanceof JGoLink) continue;
            this.snapObject(obj, spotNumber);
        }
    }

    public Point findNearestGridPoint(int x, int y, Point result) {
        int dy;
        int dx;
        int dd;
        int cy;
        int cx;
        int cd;
        Point origin = this.getGridOrigin();
        int originX = origin.x;
        int originY = origin.y;
        int gridW = this.getGridWidth();
        int gridH = this.getGridHeight();
        int ax = x - originX;
        if (ax < 0) {
            ax -= gridW;
        }
        ax = ax / gridW * gridW + originX;
        int ay = y - originY;
        if (ay < 0) {
            ay -= gridH;
        }
        ay = ay / gridH * gridH + originY;
        int bestdist = (x - ax) * (x - ax) + (y - ay) * (y - ay);
        int bestx = ax;
        int besty = ay;
        int bx = ax + gridW;
        int by = ay;
        int bd = (x - bx) * (x - bx) + (y - by) * (y - by);
        if (bd < bestdist) {
            bestdist = bd;
            bestx = bx;
            besty = by;
        }
        if ((cd = (x - (cx = ax)) * (x - cx) + (y - (cy = ay + gridH)) * (y - cy)) < bestdist) {
            bestdist = cd;
            bestx = cx;
            besty = cy;
        }
        if ((dd = (x - (dx = bx)) * (x - dx) + (y - (dy = cy)) * (y - dy)) < bestdist) {
            bestx = dx;
            besty = dy;
        }
        if (result == null) {
            return new Point(bestx, besty);
        }
        result.x = bestx;
        result.y = besty;
        return result;
    }

    class DragImage
    extends JGoImage {
        public DragImage() {
        }

        public DragImage(Rectangle r) {
            super(r);
        }

        protected void gainedSelection(JGoSelection selection) {
        }

        protected void lostSelection(JGoSelection selection) {
        }
    }

    class DragRectangle
    extends JGoRectangle {
        public DragRectangle() {
        }

        public DragRectangle(Rectangle r) {
            super(r);
        }

        protected void gainedSelection(JGoSelection selection) {
        }

        protected void lostSelection(JGoSelection selection) {
        }
    }

    class DragStroke
    extends JGoStroke {
        protected void gainedSelection(JGoSelection selection) {
        }

        protected void lostSelection(JGoSelection selection) {
        }
    }

    static class JGoViewHelper
    implements MouseListener,
    AdjustmentListener,
    Runnable,
    FocusListener {
        int myKind;
        Runnable myRunLater;
        JGoView myView;
        Cursor myCursor;
        DropTargetDropEvent mydtde;
        boolean mySucc;
        PrinterJob myPrinterJob;
        JGoObject myObject;

        JGoViewHelper(JGoView v) {
            this.myKind = 0;
            this.myView = v;
        }

        JGoViewHelper(Runnable r) {
            this.myKind = 1;
            this.myRunLater = r;
        }

        JGoViewHelper(JGoView v, Cursor c) {
            this.myKind = 2;
            this.myView = v;
            this.myCursor = c;
        }

        JGoViewHelper(DropTargetDropEvent e, boolean b) {
            this.myKind = 3;
            this.mydtde = e;
            this.mySucc = b;
        }

        JGoViewHelper(JGoView v, PrinterJob pj) {
            this.myKind = 4;
            this.myView = v;
            this.myPrinterJob = pj;
        }

        JGoViewHelper(JGoView v, JGoObject obj) {
            this.myKind = 5;
            this.myView = v;
            this.myObject = obj;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent evt) {
            if (!this.myView.isMouseEnabled()) {
                return;
            }
            if (!this.myView.hasFocus()) {
                this.myView.requestFocus();
            }
        }

        public void adjustmentValueChanged(AdjustmentEvent evt) {
            this.myView.onScrollEvent(evt);
        }

        public void run() {
            switch (this.myKind) {
                case 0: {
                    return;
                }
                case 1: {
                    SwingUtilities.invokeLater(this.myRunLater);
                    return;
                }
                case 2: {
                    this.myView.setCursorImmediately(this.myCursor);
                    return;
                }
                case 3: {
                    this.mydtde.dropComplete(this.mySucc);
                    return;
                }
                case 4: {
                    this.myView.internalPrint(this.myPrinterJob);
                    return;
                }
            }
        }

        public void focusGained(FocusEvent e) {
            this.myView.internalFinishedEdit(this.myObject);
            this.myView.removeFocusListener(this);
        }

        public void focusLost(FocusEvent e) {
        }
    }

    public class JGoViewCanvas
    extends JComponent
    implements Autoscroll,
    MouseListener,
    MouseMotionListener,
    DragGestureListener,
    DragSourceListener,
    DropTargetListener {
        public JGoView myView;
        private int myNumControls = 0;

        public JGoViewCanvas(JGoView view) {
            this.setOpaque(true);
            this.setBackground(null);
            this.myView = view;
        }

        public void setBorder(Border border) {
        }

        protected void paintComponent(Graphics g) {
            this.myView.onPaintComponent(g);
        }

        protected void paintBorder(Graphics g) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.myView.onMousePressed(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.myView.onMouseReleased(e);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            this.myView.onMouseMoved(e);
        }

        public void mouseDragged(MouseEvent e) {
            this.myView.onMouseDragged(e);
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            this.myView.onDragGestureRecognized(e);
        }

        public void dragEnter(DragSourceDragEvent e) {
            this.myView.onDragEnter(e);
        }

        public void dragOver(DragSourceDragEvent e) {
            this.myView.onDragOver(e);
        }

        public void dropActionChanged(DragSourceDragEvent e) {
            this.myView.onDropActionChanged(e);
        }

        public void dragExit(DragSourceEvent e) {
            this.myView.onDragExit(e);
        }

        public void dragDropEnd(DragSourceDropEvent e) {
            this.myView.onDragDropEnd(e);
        }

        public void dragEnter(DropTargetDragEvent e) {
            this.myView.onDragEnter(e);
        }

        public void dragOver(DropTargetDragEvent e) {
            this.myView.onDragOver(e);
        }

        public void dropActionChanged(DropTargetDragEvent e) {
            this.myView.onDropActionChanged(e);
        }

        public void dragExit(DropTargetEvent e) {
            this.myView.onDragExit(e);
        }

        public void drop(DropTargetDropEvent e) {
            this.myView.onDrop(e);
        }

        public Cursor getCursor() {
            return this.myView.getCursor();
        }

        public Insets getAutoscrollInsets() {
            return this.myView.getAutoscrollInsets();
        }

        public void autoscroll(Point location) {
            this.myView.autoscroll(location);
        }

        public JToolTip createToolTip() {
            return this.myView.createToolTip();
        }

        public String getToolTipText(MouseEvent e) {
            return this.myView.getToolTipText(e);
        }

        public boolean isOptimizedDrawingEnabled() {
            return this.myNumControls == 0;
        }

        protected void addImpl(Component comp, Object constraints, int index) {
            super.addImpl(comp, constraints, index);
            ++this.myNumControls;
        }

        public void remove(int index) {
            --this.myNumControls;
            super.remove(index);
        }

        public void remove(Component comp) {
            --this.myNumControls;
            super.remove(comp);
        }

        public void removeAll() {
            this.myNumControls = 0;
            super.removeAll();
        }
    }
}

