/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import proguard.ClassSpecification;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.AllAttrInfoVisitor;
import proguard.classfile.instruction.AllInstructionVisitor;
import proguard.classfile.util.ClassFileClassForNameReferenceInitializer;
import proguard.classfile.util.ClassFileHierarchyInitializer;
import proguard.classfile.util.ClassFileReferenceInitializer;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassFileHierarchyTraveler;
import proguard.classfile.visitor.ClassFileVersionCounter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.LibraryClassFileFilter;
import proguard.classfile.visitor.ReferencedClassFileVisitor;
import proguard.util.ClassNameListMatcher;

public class Initializer {
    private Configuration configuration;

    public Initializer(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool classPool, ClassPool classPool2) throws IOException {
        int n;
        int n2 = classPool2.size();
        WarningPrinter warningPrinter = this.configuration.warn ? new WarningPrinter(System.err) : null;
        classPool.classFilesAccept(new ClassFileHierarchyInitializer(classPool, classPool2, warningPrinter));
        classPool2.classFilesAccept(new ClassFileHierarchyInitializer(classPool, classPool2, null));
        WarningPrinter warningPrinter2 = this.configuration.note ? new WarningPrinter(System.out) : null;
        classPool.classFilesAccept(new AllMethodVisitor(new AllAttrInfoVisitor(new AllInstructionVisitor(new ClassFileClassForNameReferenceInitializer(classPool, classPool2, warningPrinter2, this.createNoteExceptionMatcher(this.configuration.keep))))));
        WarningPrinter warningPrinter3 = this.configuration.warn ? new WarningPrinter(System.err) : null;
        classPool.classFilesAccept(new ClassFileReferenceInitializer(classPool, classPool2, warningPrinter3));
        if (!this.configuration.useUniqueClassMemberNames) {
            classPool2.clear();
            classPool.classFilesAccept(new ReferencedClassFileVisitor(new LibraryClassFileFilter(new ClassFileHierarchyTraveler(true, true, true, false, new LibraryClassFileFilter(new ClassPoolFiller(classPool2))))));
        }
        classPool2.classFilesAccept(new ClassFileReferenceInitializer(classPool, classPool2, null));
        if (this.configuration.note) {
            n = warningPrinter2.getWarningCount();
            if (n > 0) {
                System.err.println("Note: there were " + n + " class casts of dynamically created class instances.");
                System.err.println("      You might consider explicitly keeping the mentioned classes and/or");
                System.err.println("      their implementations (using '-keep').");
            }
            if (this.configuration.optimize || this.configuration.obfuscate) {
                ClassFileVersionCounter classFileVersionCounter = new ClassFileVersionCounter(50, 0);
                classPool.classFilesAccept(classFileVersionCounter);
                int n3 = classFileVersionCounter.getCount();
                if (n3 > 0) {
                    System.err.println("Note: there were " + n3 + " Java 6 program classes.");
                    System.err.println("      In order to obtain all of the improved start-up performance of Java 6,");
                    System.err.println("      they should be preverified after having been optimized or obfuscated.");
                    System.err.println("      Keep any eye on ProGuard version 4.0 for preverification support,");
                    System.err.println("      at http://proguard.sourceforge.net/");
                }
            }
        }
        if (this.configuration.warn) {
            int n4;
            n = warningPrinter.getWarningCount();
            if (n > 0) {
                System.err.println("Warning: there were " + n + " unresolved references to superclasses or interfaces.");
                System.err.println("         You may need to specify additional library jars (using '-libraryjars'),");
                System.err.println("         or perhaps the '-dontskipnonpubliclibraryclasses' option.");
            }
            if ((n4 = warningPrinter3.getWarningCount()) > 0) {
                System.err.println("Warning: there were " + n4 + " unresolved references to program class members.");
                System.err.println("         Your input classes appear to be inconsistent.");
                System.err.println("         You may need to recompile them and try again.");
                System.err.println("         Alternatively, you may have to specify the options ");
                System.err.println("         '-dontskipnonpubliclibraryclasses' and/or");
                System.err.println("         '-dontskipnonpubliclibraryclassmembers'.");
            }
            if (!(n <= 0 && n4 <= 0 || this.configuration.ignoreWarnings)) {
                System.err.println("         If you are sure the mentioned classes are not used anyway,");
                System.err.println("         you could try your luck using the '-ignorewarnings' option.");
                throw new IOException("Please correct the above warnings first.");
            }
        }
        if (this.configuration.verbose) {
            System.out.println("Ignoring unused library classes...");
            System.out.println("  Original number of library classes: " + n2);
            System.out.println("  Final number of library classes:    " + classPool2.size());
        }
    }

    private ClassNameListMatcher createNoteExceptionMatcher(List list) {
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                String string;
                ClassSpecification classSpecification = (ClassSpecification)list.get(i);
                if (!classSpecification.markClassFiles) continue;
                String string2 = classSpecification.className;
                if (string2 != null) {
                    arrayList.add(string2);
                }
                if ((string = classSpecification.extendsClassName) == null) continue;
                arrayList.add(string);
            }
            if (arrayList.size() > 0) {
                return new ClassNameListMatcher(arrayList);
            }
        }
        return null;
    }
}

